// util.c -- Misc utility functions
// Copyright 1995 Dean Troyer (troyer@indirect.com)
// All rights reserved.
//
// See fingerd.txt for license information
//
// This is a collection of general-use utility functions.
//
// This module is compiled with Unicode turned on to support
// the Win32 APIs that require Unicode
//
// 0.5  04Feb95     dlt     Create util.c
//      11Oct95     dlt     Add Domain2DC

#define UNICODE
#define _UNICODE
#include <windows.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <time.h>
#include <tchar.h>
#include <lm.h>
#include "config.h"
#include "service.h"
#include "util.h"

// Global data
DWORD dwErr = 0;


// UnicodeToANSI - Convert a Unicode string to ANSI
//
// Parameters:
//   lpInputString    - pointer to the input buffer
//   lpszOutputString - pointer to the output buffer
//   nOutStringLen    - size of output buffer (in chars)
// Return value:
//   TRUE if translated, FALSE if not supported
//
// Taken from Ralph Davis' "Windows NT Network Programming"
//   \NTNET\CODE\WNETMISC.CPP

BOOL WINAPI UnicodeToANSI(LPTSTR lpInputString, 
                          LPSTR lpszOutputString, 
                          int nOutStringLen)
{         
#ifndef WIN32S
   CPINFO CodePageInfo;

   GetCPInfo(CP_ACP, &CodePageInfo);

   if (CodePageInfo.MaxCharSize > 1)
      // Only supporting non-Unicode strings
      return FALSE; 
   else if (((LPBYTE) lpInputString)[1] == '\0')
      {
      // Looks like unicode, better translate it
      WideCharToMultiByte(CP_ACP, 0, (LPCWSTR) lpInputString, -1,
         lpszOutputString, nOutStringLen, NULL, NULL);
      }
   else
      lstrcpyA(lpszOutputString, (LPSTR) lpInputString);
#else
      lstrcpy(lpszOutputString, (LPSTR) lpInputString);
#endif
   return TRUE;
}  // UnicodeToANSI


// ANSIToUnicode - Convert a ANSI string to Unicode
//
// Parameters:
//   lpInputString    - pointer to the input buffer
//   lpszOutputString - pointer to the output buffer
//   nOutStringLen    - size of output buffer (in chars)
// Return value:
//   TRUE if translated, FALSE if not supported
//
// Taken from Ralph Davis' "Windows NT Network Programming"
//   \NTNET\CODE\WNETMISC.CPP

VOID WINAPI ANSIToUnicode(LPSTR  lpInputString, 
                          LPTSTR lpszOutputString, 
                          int nOutStringLen)
{         

#ifndef WIN32S
   CPINFO CodePageInfo;

   lstrcpy(lpszOutputString, (LPTSTR) lpInputString);

   GetCPInfo(CP_ACP, &CodePageInfo);

   if (CodePageInfo.MaxCharSize > 1)
      // It must already be a Unicode string
      return;
   else if (((LPBYTE) lpInputString)[1] != '\0')
      {
      // Looks like ANSI, better translate it
      MultiByteToWideChar(CP_ACP, 0, (LPCSTR) lpInputString, -1,
         (LPWSTR) lpszOutputString, nOutStringLen);
      }
else
   lstrcpy(lpszOutputString, (LPTSTR) lpInputString);
#endif
}  // ANSIToUnicode



// LogEvent - Write an event to the event log
//
// Parameters:
//   EventCat - the event category
//   EventID  - the event is to pass to ReportEvent()
//   MsgStr   - message text
//
// Return value:
//   none
//
// Comments:
//   Appropriated from AddToMessageLog() in Microsoft's SERVICE.C sample 
//   program and hacked a bit

VOID LogEvent(WORD EventCat, DWORD EventID, LPTSTR MsgStr)
{
    TCHAR   szMsg[256];
    HANDLE  hEventSource;
    LPTSTR  lpszStrings[2];

    dwErr = GetLastError();

    // Use event logging to log the error.
    hEventSource = RegisterEventSource(NULL, TEXT(SZSERVICENAME));

    _stprintf(szMsg, TEXT("%s error: %d"), TEXT(SZSERVICENAME), dwErr);
    lpszStrings[0] = szMsg;
    lpszStrings[1] = MsgStr;

    if (hEventSource != NULL) {
        ReportEvent(hEventSource,           // handle of event source
                    EVENTLOG_ERROR_TYPE,    // event type
                    EventCat,               // event category
                    EventID,                // event ID
                    NULL,                   // current user's SID
                    2,                      // strings in lpszStrings
                    0,                      // no bytes of raw data
                    lpszStrings,            // array of error strings
                    NULL);                  // no raw data

        (VOID) DeregisterEventSource(hEventSource);
    }
}  // LogEvent


// LogMessage - write a message to the event log
//
// Parameters:
//   MsgStr - message text
//
// Return value:
//   none
//
// Comments:
//   Simply a wrapper around LogEvent with event category and ID of 0

VOID LogMessage(LPTSTR MsgStr)
{
    LogEvent(0, 0, MsgStr);        // Log an event with ID 0
}  // LogMessage


// Domain2DC -- Get a Domain Controller name from a Domain name
//
// Parameters:
//   Domain - A Domain name in ANSI
//   Buf - pointer to the return buffer
//   BufLen - length of return buffer
//   RetUnicode - TRUE to return Unicode, FALSE to return ANSI
//
// Returns:
//   A Domain Controller name, or NULL if not found

LPSTR Domain2DC(LPSTR Domain, LPSTR Buf, DWORD BufLen, BOOL RetUnicode)
{
    WCHAR Dom[DNLEN+1];
    LPWSTR lpDom;
    NET_API_STATUS dwRetCode;
    BOOL FreeBuf = FALSE;
    
    if ((Domain != NULL) && (strlen(Domain) > 1)) {
        // Convert ANSI domain string to Unicode
        ANSIToUnicode(Domain, Dom, sizeof(Dom)-1);
        // See if it's a domain name or machine name
        if (Domain[0] == '\\' && Domain[1] == '\\') { 
            // Assume it's a machine name
            lpDom = (LPWSTR)&Dom;
        } else {
            // Try to find a DC for the domain
            if ((dwRetCode = NetGetDCName(NULL, (LPWSTR)&Dom, (LPBYTE *)&lpDom))
                 != NERR_Success) {
                // Can't find a domain controller, fail
                    lpDom = NULL;
            } else {
                FreeBuf = TRUE;     // Need to free the lpDom buffer
            }
        }
    } else {
        // No domain or machine specified
        lpDom = NULL;
    }
    if (lpDom == NULL) {
        Buf[0] = '\0';
    } else {
        if (RetUnicode)
            wcsncpy((LPWSTR)Buf, lpDom, BufLen / 2);
        else
            UnicodeToANSI(lpDom, Buf, BufLen);
    }
    if (FreeBuf)
        NetApiBufferFree(lpDom);
    return(Buf);
}  // Domain2DC

