// service.h - Common headers for interface to service.c
// Copyright 1995 Dean Troyer (troyer@indirect.com)
// All rights reserved.
//
// This file is derived from service.h as found in the 'SAMPLES\SERVICE'
// directory in Microsoft's Win32 SDK.  The Microsoft notice follows:

   // THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
   // ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
   // THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
   // PARTICULAR PURPOSE.
   //
   // Copyright (C) 1993, 1994  Microsoft Corporation.  All Rights Reserved.
   //
   // MODULE: service.h
   //
   // AUTHOR: Craig Link

#ifndef _SERVICE_H
#define _SERVICE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "config.h"

// Get this information from config.h...

// name of the executable
#define SZAPPNAME            PROGRAM_NAME

// internal name of the service
#define SZSERVICENAME        INTERNAL_NAME

// displayed name of the service
#define SZSERVICEDISPLAYNAME DISPLAY_NAME

// displayed copyright notice
#define SZCOPYRIGHT          COPYRIGHT

// list of service dependencies - "dep1\0dep2\0\0"
#define SZDEPENDENCIES       ""

// some public version number
#define SZVERSION            VERSION

// ---------- Interface to Service ----------
//
// The following routines are called by the code in service.c and must be
// implemented in the rest of the service.

// ServiceInstall() is called during the installation process.  It will 
// usually perform tasks such as initializing registry entries.

VOID ServiceInstall();

// ServiceRemove() is called during the removal process.  It should clean 
// up after itself.

VOID ServiceRemove();

// ServiceStart() must use ReportStatusToSCMgr to indicate progress during
// startup, and to report to the SCM when the service is running.

VOID ServiceStart(DWORD dwArgc, LPTSTR *lpszArgv);

// ServiceStop() is called to shut down the service.  If ServiceStop 
// is going to take longer than 3 seconds to execute, it should spawn a 
// thread to execute the stop code, and return.  Otherwise, the 
// ServiceControlManager will believe that the service has stopped 
// responding.

VOID ServiceStop();

// ServicePause() is called to pause the service.

VOID ServicePause();

// ServiceContinue() is called to continue the service after being paused.

VOID ServiceContinue();

//////////////////////////////////////////////////////////////////////////////
//// The following are procedures which
//// may be useful to call within the above procedures,
//// but require no implementation by the user.
//// They are implemented in service.c

//
//  FUNCTION: ReportStatusToSCMgr()
//
//  PURPOSE: Sets the current status of the service and
//           reports it to the Service Control Manager
//
//  PARAMETERS:
//    dwCurrentState - the state of the service
//    dwWin32ExitCode - error code to report
//    dwWaitHint - worst case estimate to next checkpoint
//
//  RETURN VALUE:
//    TRUE  - success 
//    FALSE - failure
//
BOOL ReportStatusToSCMgr(DWORD dwCurrentState, DWORD dwWin32ExitCode, DWORD dwWaitHint);


//
//  FUNCTION: AddToMessageLog(LPTSTR lpszMsg)
//
//  PURPOSE: Allows any thread to log an error message
//
//  PARAMETERS:
//    lpszMsg - text for message
//
//  RETURN VALUE:
//    none
//
void AddToMessageLog(LPTSTR lpszMsg);
//////////////////////////////////////////////////////////////////////////////


#ifdef __cplusplus
}
#endif

#endif
