// perf.h - Windows NT Performance Data Declarations
// Copyright 1995 Dean Troyer (troyer@indirect.com)
// All rights reserved.
//
// See fingerd.txt for license information
//
// Taken from an article posted to comp.os.windows-nt.misc by 
// Dimitris Staikos (dstaikos@theseas.ntua.gr)
//
// Interrogate NT's performance data for process information
//
// This module is compiled with Unicode turned on to support
// the Win32 APIs that require Unicode
//
// 0.5  04Feb95      dlt     Create module

// Define HELPER_MACROS to use the macro implementation of the helper functions
#undef HELPER_MACROS

#ifdef HELPER_MACROS

#define FirstObject(pPerfData) ((PPERF_OBJECT_TYPE) ((PBYTE) pPerfData + pPerfData->HeaderLength))
#define NextObject(pObject) ((PPERF_OBJECT_TYPE) ((PBYTE) pObject + pObject->TotalByteLength))
#define FirstCounter(pObjectDef) (PPERF_COUNTER_DEFINITION)((PCHAR) pObjectDef + pObjectDef->HeaderLength)
#define NextCounter(pCounterDef) (PPERF_COUNTER_DEFINITION)((PCHAR) pCounterDef + pCounterDef->ByteLength)
#define FirstInstance(pObject) (PPERF_INSTANCE_DEFINITION)((PBYTE) pObject + pObject->DefinitionLength)

#else // !HELPER_MACROS

// Helper Functions to walk the performance data structures

PPERF_OBJECT_TYPE FirstObject(PPERF_DATA_BLOCK pPerfData);
PPERF_OBJECT_TYPE NextObject (PPERF_OBJECT_TYPE pObject);
PPERF_COUNTER_DEFINITION FirstCounter(PPERF_OBJECT_TYPE pObjectDef);
PPERF_COUNTER_DEFINITION NextCounter(PPERF_COUNTER_DEFINITION pCounterDef);
PPERF_INSTANCE_DEFINITION FirstInstance (PPERF_OBJECT_TYPE pObject);

#endif // !HELPER_MACROS

PPERF_INSTANCE_DEFINITION NextInstance (PPERF_INSTANCE_DEFINITION pInstance);

DWORD PerformanceKeyRetrieve(LPTSTR szName, LPVOID *pMemory);

