// fingerd.h -- Headers for fingerd
// Copyright 1994 Dean Troyer (troyer@indirect.com)
// All rights reserved.
//
// See fingerd.txt for license information
//
// 0.4  28Dec94     dlt     Initial release
// 0.5  03Mar95     dlt     Fold in process.h
//      11Oct95     dlt     Add BC++ conditionals

#ifndef _FINGERD_H
#define _FINGERD_H

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#ifndef BCC
#include <tchar.h>
#endif
#include <time.h>
#include "service.h"
#include "config.h"


// Function prototypes


// From fingerd.c

void ListenThreadProc();
BOOL SetupListen();
DWORD ProcessThreadProc(LPDWORD lpdwParam);
BOOL ReceiveRequest(SOCKET *skOutput, LPSTR ReqStr);
BOOL SendReply(SOCKET *skOutput);
void ParseRequest(SOCKET *skOutput, LPSTR ReqStr);


// From process.c

void SendID(SOCKET skOut);
void SendFinger(SOCKET skOut, LPSTR UserID);
void SendFingerAll(SOCKET skOut);
BOOL SendPF(SOCKET skOut, LPSTR HomeDir, LPSTR PP);
BOOL SendFile(SOCKET *skOutput, LPSTR FileName);
void SendFilePrim(FILE *infile, SOCKET skOutput);
int SendLine(SOCKET skOut, LPSTR fmtstr, ...);
int SendLineW(SOCKET skOut, LPTSTR fmtstr, ...);
void SendError(SOCKET skOutput, char *errstr);
void LogWSError(void);
char *WSErrorString(UINT err);

void SendProcess(SOCKET skOut);


#endif  // !_FINGERD_H

