;***********************************************************************
;*                                                                     *
;* PCBOARD.ASP  (C) 1990 DATASTORM TECHNOLOGIES, INC.                  *
;*                                                                     *
;* An ASPECT script for logging on to a PCBOARD BBS.                   *
;*                                                                     *
;***********************************************************************
;
;***********************************************************************
; The following four defines should be customized with the dialing     *
; directory entry for the PCBOARD you're calling, your first name,     *
; your last name, and your password on the BBS.  The rest of the       *
; script should need no modification for recent versions of PCBOARD.   *
;***********************************************************************
;
define PCBOARD_ENTRY "1"         ; make sure entry is N81, full duplex, ANSI
define F_NAME "joe"              ; your first name
define L_NAME "blow"             ; your last name
define PASSWORD "abc"            ; your password on the BBS BBS

proc main
   clear
   locate 0 0
   box 0 0 4 26 14
   atsay 2 2 14 "Logging onto PCBOARD..."
   locate 6 0

   if not fromddir
      dial PCBOARD_ENTRY        ; set to your dial dir entry for PCBOARD
   endif
   emulate ANSI                 ; make sure we're an ANSI terminal
   pause 1                      ; wait a second
   transmit "Y^M"               ; tell it you want graphics
                                ; change to "N^M" for no graphics
   waitfor "first name? "       ; wait for first name prompt
   transmit F_NAME              ; send your first name
   transmit "^M"                ; followed by a carriage return
   waitfor "last name? "        ; wait for last name prompt
   transmit L_NAME              ; send your last name
   transmit "^M"                ; followed by a carriage return
   waitfor "will echo)? "       ; wait for password prompt
   transmit PASSWORD            ; send your password
   transmit "^M"                ; followed by a carriage return
   alarm 2                      ; inform user logon is complete
endproc
