/*****************************************************************************
 * File:	utils.h
 *
 * Author:	Rhett "Jonzy" Jones
 *		jonzy@cc.utah.edu
 *
 * Date:	March 6, 1993
 *
 * Modifed:	March 28, 1993, by Rhett "Jonzy" Jones.
 *		Added ifdef sun then don't use prototypes.
 *
 *		March 30, 1993, by Rhett "Jonzy" Jones.
 *		Added the use of USEPROTOTYPES and added the
 *		delcaration for Mysprint().
 *
 *		Added the declaration and prototype for NumberOfLines().
 *
 * Description:	Header file for use with "utils.c".
 *
 * Bugs:	No known bugs.
 *
 * Copyright:	Copyright 1993, 1994, University of Utah Computer Center.
 *		JUGHEAD (TM) is a trademark of Archie Comic Publications, Inc.
 *		and is used pursuant to license.  This source may be used and
 *		freely distributed as long as this copyright notice remains
 *		intact, and is in no way used for any monetary gain, by any
 *		institution, business, person, or persons.
 *
 ****************************************************************************/

#ifdef USEPROTOTYPES
	extern long	NumberOfLines(char *fileName);
	extern char	*StrToLower(char *str);
	extern long	GetLong(FILE *fp);
	extern int	GetInt(FILE *fp);
	extern char	*GetStr(FILE *fp,char *str,int limit);
	extern int	Str2Int(char *s);
	extern char	*Reverse(char *s, char *r);
	extern short	StrRcmp(char *s1, char *s2);
	extern char	*Mysprint(char *format,...);
	extern int	DoSystemCall(char *command);
	extern char	*MyStrTok(char *str,char delimeter);
	extern char	*OnlyDigits(char *s);
	extern char	*RemoveCRLF(char *line);
#else
	extern long	NumberOfLines();
	extern char	*StrToLower();
	extern long	GetLong();
	extern int	GetInt();
	extern char	*GetStr();
	extern int	Str2Int();
	extern char	*Reverse();
	extern short	StrRcmp();
	extern char	*Mysprint();
	extern int	DoSystemCall();
	extern char	*MyStrTok();
	extern char	*OnlyDigits();
	extern char	*RemoveCRLF();
#endif

