#
#  File selection box
#

package provide mpTk 0.6.15

namespace eval mpTk {
    namespace eval Fs {
	namespace import ::mpTk::Msg::msgbox ::mpTk::Msg::errmsg
	namespace import ::mpTk::Misc::centerwin
    }
}


proc mpTk::Fs::RefreshList {l mode} {
    variable fsel

    if {[catch {eval exec ls -FAb {$fsel(dir)}} res]} {
	errmsg $res
	return 0
    }

    if {[pwd] != "/"} {
	set res [linsert $res 0 "../"]
    }

    set dirs {}
    set files {}
    foreach i $res {
	set si [string trim $i " *@"]
	if {[file isdirectory $si]} {
	    lappend dirs " $i"
	} else {
	    if {[regexp $fsel(filtreg) $si]} {
		lappend files " $i"
	    }
	}
    }

    $l delete 0 end
    eval $l insert end [set all [concat $dirs $files]]

    switch $mode {
	2 {
	    set i [lsearch -exact $dirs " [file tail $fsel(old_dir)]/"]
	    $l activate $i
	    $l selection set $i $i
	    $l see $i
	}
	1 {
	    $l activate 0
	    $l selection set 0 0
	}
	0 {
	    if {[info exists fsel(old_fname)] && $fsel(old_fname) != ""} {
		set i [lsearch -exact $all " $fsel(old_fname)"]
		$l activate $i
		$l selection set $i $i
		$l see $i
	    } else {
		$l activate 0
		$l selection set 0 0
	    }
	}
    }
    return 1
}


proc mpTk::Fs::BuildFiltReg {extension} {
    variable fsel

    if {$extension == "*"} {
	set fsel(filtreg) ".*"
	return
    }

    set fsel(filtreg) {\.(}
    append fsel(filtreg) [lindex $extension 0]
    foreach i [lrange $extension 1 end] {
	append fsel(filtreg) "|"
	append fsel(filtreg) $i
    }
    append fsel(filtreg) {)$}
}


proc mpTk::Fs::Filter {l} {
    variable fsel

    set fsel(fOldFocus) [focus]
    set w .filesel.filter
    toplevel $w -class Filter
    wm resizable $w false false
    wm title $w "File Types"

    listbox $w.list -width 40 -height 10 -highlightthickness 0 -setgrid 1
    pack $w.list -side top -padx 2m -pady 2m -expand yes -fill both
 
    centerwin $w

    proc ExitFilter {l save} {
	variable fsel
	if {$save} {
	    set fsel(extension) [lindex $fsel(extensions) \
		    [$l index active]]
	}
        focus $fsel(fOldFocus)
	destroy [winfo toplevel $l]
    }

    bind $w.list <Double-ButtonRelease-1> {mpTk::Fs::ExitFilter %W 1; break}

    bind $w.list <Return> {mpTk::Fs::ExitFilter %W 1; break}

    bind $w.list <Escape> {mpTk::Fs::ExitFilter %W 0; break}

    foreach i $fsel(types) {
	$w.list insert end [format "%s  (%s)" \
		[lindex $i 0] [lindex $i 1]]
    }
	
    set i [lsearch -exact $fsel(extensions) $fsel(extension)]
    $w.list activate $i
    $w.list selection set $i $i
    $w.list see $i
    focus $w.list
    tkwait window $w
    update
    BuildFiltReg $fsel(extension)
    RefreshList $l 0
}


proc mpTk::Fs::Process {l cd} {
    variable fsel

    set f [string trim [$l get active] " *@"]
    if {[file isdirectory $f]} {
	if {$cd} {
	    set mode 1
	    if {[string match "../" $f]} {
		set mode 2
	    }
	    set fsel(old_dir) $fsel(dir)
	    if {[catch {cd $f} res]} {
		errmsg $res
	    } else {
		set fsel(dir) [pwd]
		if {! [RefreshList $l $mode]} {
		    cd $fsel(old_dir)
		    set fsel(dir) $fsel(old_dir)
		}
	    }
	}
	return {}
    } else {
	return $f
    }
}


proc mpTk::Fs::CheckOverwrite {f} {
    variable fsel

    if {[file exists $f]} {
	set r [msgbox -icon info -font {Helvetica 13 bold} \
	    -default no -type yesno \
	    -message "File exists, overwrite?"]
	if {$r != "yes"} {
	    return 0
	}
    }
    return 1
}


proc mpTk::Fs::DoList {l} {
    variable fsel

    if {[set f [Process $l 1]] != ""} {
	set fsel(fname) $f
	if {! $fsel(mode)} {
	    focus $fsel(oldFocus)
	    destroy [winfo toplevel $l]
	}
    }
}


proc mpTk::Fs::Exit {l cancel} {
    variable fsel

    if {$cancel} {
	set fsel(fname) {}
    } else {
 	if {$fsel(mode)} {
	    if {! [CheckOverwrite $fsel(fname)]} return
	} else {
	    DoList $l
	    return
	}
    }
    focus $fsel(oldFocus)
    destroy [winfo toplevel $l]
}


proc mpTk::Fs::filesel {types mode} {
    variable fsel

    set fsel(titles) {{Open File} {Save File}}
    set fsel(mode) $mode
    set fsel(oldFocus) [focus]

    set w .filesel
    catch {destroy $w}
    toplevel $w -class FileSel
    wm resizable $w false false

    set width [option get $w width FileSel]
    if {$width == ""} {
	set width 45
    }
    set height [option get $w height FileSel]
    if {$height == ""} {
	set height 10
    }

    set fsel(types) $types
    set fsel(extensions) {}
    foreach i $fsel(types) {
	lappend fsel(extensions) [lindex $i 1]
    }
    set fsel(extension) [lindex $fsel(extensions) 0]

    wm title $w "[lindex $fsel(titles) $fsel(mode)]  ($fsel(extension))" 

    frame $w.spacer -height 3m
    pack $w.spacer -side top

    label $w.label -width 1 -textvariable mpTk::Fs::fsel(dir) -anchor w
    pack $w.label -side top -padx 3m -fill x

    set f $w.fileList
    frame $f -borderwidth 2m
    pack $f -side top -expand yes -fill both
 
    scrollbar $f.yscroll -width 10 -orient vertical \
	    -takefocus 0 -command "$f.list yview" \
	    -highlightthickness 0
    scrollbar $f.xscroll -width 10 -orient horizontal \
	    -takefocus 0 -command "$f.list xview" \
	    -highlightthickness 0
    listbox $f.list -yscroll "$f.yscroll set" \
	    -xscroll "$f.xscroll set" -width $width -height $height \
	    -setgrid 1

    pack $f.yscroll -side right -fill y
    pack $f.xscroll -side bottom -fill x
    pack $f.list -side left -expand yes -fill both

    if {$fsel(mode)} {
	set f $w.saveName
	frame $f
	pack $f -side top
	label $f.label -text "Save As:"
	entry $f.entry -width 30 -font variable \
		-textvariable mpTk::Fs::fsel(fname)
	pack $f.label $f.entry -side left -padx 2m -pady 3m
	bind $f.entry <Return> [list mpTk::Fs::Exit $w.fileList.list 0]
	bind $f.entry <FocusIn> \
		{.filesel.buttons.doit configure -default active}
    }

    set f $w.buttons
    frame $f
    pack $f -side top
    button $f.filter -width 5 -text "Filter" -takefocus 0 -command {
	mpTk::Fs::Filter .filesel.fileList.list
	set title "[lindex $mpTk::Fs::fsel(titles) $mpTk::Fs::fsel(mode)]  "
	append title "($mpTk::Fs::fsel(extension))"
	wm title .filesel $title
    }
    button $f.doit -width 5 -text [lindex {Open Save} $fsel(mode)] \
	    -default active -takefocus 0 \
	    -command [list mpTk::Fs::Exit $w.fileList.list 0]
    button $f.cancel -width 5 -text "Cancel" -takefocus 0 \
	    -command [list mpTk::Fs::Exit $w.fileList.list 1]
    pack $f.filter $f.doit $f.cancel -side left -padx 2.5m -pady 2m

    bindtags $w.fileList.list \
	    [linsert [bindtags $w.fileList.list] 1 FileList]

    bind FileList <FocusIn> {
	%W selection set active active
	if $::mpTk::Fs::fsel(mode) {
	    .filesel.buttons.doit configure -default normal
	}
	break
    }

    bind FileList <Double-ButtonRelease-1> {mpTk::Fs::DoList %W; break}
    bind FileList <Return> {mpTk::Fs::DoList %W; break}

    bind FileList <Home> {
	%W activate 0
	%W see 0
	%W selection clear 0 end
	%W selection set 0
	break
    }

    bind FileList <End> {
	%W activate end
	%W see end
	%W selection clear 0 end
	%W selection set end
	break
    }

    bind FileList <Alt-Key-f> {
	mpTk::Fs::Filter %W
	set title "[lindex $mpTk::Fs::fsel(titles) $mpTk::Fs::fsel(mode)]  "
	append title "($mpTk::Fs::fsel(extension))"
	wm title .filesel $title
	break
    }
    
    bind FileList <KeyPress> {
	if {! [string length %A]} {
	    continue
	}
	switch %A {
	    \$ {
		cd [set mpTk::Fs::fsel(dir) $env(HOME)]
		set mpTk::Fs::fsel(old_dir) $mpTk::Fs::fsel(dir)
		mpTk::Fs::RefreshList %W 1
		break
	    }
	    / {
		cd [set mpTk::Fs::fsel(dir) /]
		set mpTk::Fs::fsel(old_dir) $mpTk::Fs::fsel(dir)
		mpTk::Fs::RefreshList %W 1
		break
	    }
	    default {
		if {[set i [lsearch -regexp [%W get 0 end] "^ %A"]] != -1} {
		    %W activate $i
		    %W see $i
		    %W selection clear 0 end
		    %W selection set $i
		    break
		}
	    }
	}
    }

    bind $w <Escape> {mpTk::Fs::Exit .filesel.fileList.list 1; break}

    set fsel(dir) [pwd]
    set fsel(old_dir) $fsel(dir)
    BuildFiltReg $fsel(extension)
    RefreshList $w.fileList.list 0

    centerwin $w

    if {$fsel(mode)} {
	$w.saveName.entry selection range 0 end
	focus $w.saveName.entry
    } else {
	focus $w.fileList.list
    }
    tkwait window $w
    update
    if {$fsel(fname) != ""} {
	set fsel(old_fname) $fsel(fname)
    }
    return $fsel(fname)
}
