package PGopherLib::Init;

use strict;
use warnings;
use Encode ();
use PGopherLib::Globals qw/$PAGER $BROWSER $PDFVIEW $IMGVIEW $SNDPLAY
	$MOVPLAY $PH $TELNET $TN3270 $BOOKMARKS $PROMPT $TEXTENC $TERMSIZE
	@pageropt $user $cwd $sigint $sigpipe $utf8/;
use PGopherLib::Term qw/initterm oldtty/;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(quit init);


sub quit {
    print "\n";
    oldtty;
    exit;
}

sub init {
    $| = 1;

    grep(/^utf8$/, PerlIO::get_layers(STDIN)) and $utf8++;

    my $RCFILE = $ENV{'HOME'} . "/.pgopherrc";
    -f $RCFILE and do {
	unless (defined(my $r = do $RCFILE)) {
	    die "Couldn't do $RCFILE: $!\n" if $!;
	    die "Couldn't parse $RCFILE: $@\n" if $@;
	}
    };

    $PAGER eq "less" and do {
	@pageropt = ('-X');
	$utf8 and $ENV{'LESSCHARSET'} = "utf-8";
    };

    $PH =~ /%HOST%/ && $PH =~ /%PORT%/ or
	    die "Invalid format of \$PH string\n";
    $TELNET =~ /%HOST%/ && $TELNET =~ /%PORT%/ or
	    die "Invalid format of \$TELNET string\n";
    $TN3270 =~ /%HOST%/ && $TN3270 =~ /%PORT%/ or
	    die "Invalid format of \$TN3270 string\n";

    $utf8 and do {
	grep(/^${TEXTENC}$/, Encode->encodings(":all")) or
		die "Unsupported encoding `$TEXTENC'\n";
    };

    $SIG{'HUP'} = \&quit;
    $SIG{'INT'} = sub { $sigint++ };
    $SIG{'PIPE'} = sub { $sigpipe++ };
    $SIG{'TERM'} = \&quit;
    $SIG{'TSTP'} = 'IGNORE';

    $user = getpwuid($<);
    chomp ($cwd = `pwd`);

    initterm;
}

1;
