package PGopherLib::Globals;

use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw($HOST $PAGER $BROWSER $PDFVIEW $IMGVIEW $SNDPLAY $MOVPLAY
	$PH $TELNET $TN3270 $BOOKMARKS $PROMPT $TEXTENC $TERMSIZE @pageropt
	@history @menu $user $cwd $rows $cols $sigint $sigpipe $utf8);

our $HOST = "gopher.sm5sxl.net";
our $PAGER = "less";
our $BROWSER = "lynx";
our $PDFVIEW = "acroread";
our $IMGVIEW = "xv";
our $SNDPLAY = "xmms";
our $MOVPLAY = "mplayer";
our $PH = "ph -s %HOST% -p %PORT%";
our $TELNET = "telnet -l %LOGIN% %HOST% %PORT%";
our $TN3270 = "tn3270 %HOST% %PORT%";
our $BOOKMARKS = $ENV{'HOME'} . "/.pgopher_bookmarks";
our $PROMPT = "pgopher> ";
our $TEXTENC = "iso-8859-1";
our $TERMSIZE;

our @pageropt = ();
our @history = ();
our @menu = ();
our $user;
our $cwd;
our ($rows, $cols);
our ($sigint, $sigpipe);
our $utf8 = 0;

1;
