import javax.sound.midi.*;
import java.io.File;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.BufferedInputStream;
import java.util.Arrays;
import java.util.Vector;


/**
 * A JukeBox for midi and rmf files.
 */

public class JukeCon implements MetaEventListener {
    static final String version = "0.1";
    Vector files = new Vector();
    Sequencer sequencer;
    boolean midiEOM;
    

    public JukeCon(String [] args) {
	try {
	    sequencer = MidiSystem.getSequencer();
	} catch (Exception ex) { ex.printStackTrace(); return; }
	sequencer.addMetaEventListener(this);

	for (int i = 0; i < args.length; i++) {
	    loadJuke(args[i]);
	}
    }

    
    private void loadJuke(String name) {
	try {
	    File file = new File(name);
	    if (file != null && file.isDirectory()) {
		String files[] = file.list();
		Arrays.sort(files);
		for (int i = 0; i < files.length; i++) {
		    File leafFile = new File(file.getAbsolutePath(), files[i]);
		    if (leafFile.isDirectory()) {
			loadJuke(leafFile.getAbsolutePath());
		    } else {
			addFile(leafFile);
		    }
		}
	    } else if (file != null && file.exists()) {
		addFile(file);
	    }
	} catch (SecurityException ex) {
	    System.out.println(ex.toString());
	} catch (Exception ex) {
	    System.out.println(ex.toString());
	}
    }

    
    private void addFile(File file) {
	String s = file.getName().toLowerCase();
	if (s.endsWith(".mid") || s.endsWith(".midi") ||
		s.endsWith(".smf") || s.endsWith(".mff") ||
		s.endsWith(".rmf"))
	    files.add(file);
    }

    
    private boolean loadFile(File file) {
	BufferedInputStream stream;
	
	System.out.println(file.getName());

	try { 
	    FileInputStream is = new FileInputStream(file);
	    stream = new BufferedInputStream(is, 1024);
	} catch (Exception e3) { 
	    e3.printStackTrace(); 
	    return false;
	}

	try {
	    sequencer.open();
	    sequencer.setSequence(stream);
	} catch (InvalidMidiDataException imde) { 
	    System.out.println("Unsupported audio file.");
	    return false;
	} catch (Exception ex) {
	    ex.printStackTrace();
	    return false;
	}
	
	return true;
    }

    
    private void playFile() {
        midiEOM = false;
	sequencer.start();
	while (! midiEOM) {
	    try {
		Thread.sleep(99);
	    } catch (Exception e) {break;}
	}
	sequencer.stop();
	sequencer.close();
    }


    public void meta(MetaMessage message) {
	if (message.getType() == 47) {  // 47 is end of track
	    midiEOM = true;
	}
    }


    public void start() {
	do {
	    for (int num = 0; num < files.size(); num++) {
		if(loadFile((File)files.get(num)) == true)
		    playFile();
                // take a little break between files
		try {Thread.sleep(222);} catch (Exception e) {break;}
	    }
	} while (true);
    }
            

    public static void main(String args[]) {
	if (args.length == 0) {
	    System.out.println("JukeCon v" + version);
	    System.out.println("usage: jukecon <file|directory ...>");
	    System.exit(0);
	}
	final JukeCon juke = new JukeCon(args);
	juke.start();
    }
} 
