/*			HANDIN PROGRAM
			John Goerzen
			jgoerzen@complete.org

			CS697L
			   Assignment 2

Modified for WSU CS Dept. handin
			   
This module contains functions to start the copying process -- checking
for insecure filenames, checking whether a directory or a filename, etc.

Functions for copying directories are in copydir.c; functions for copying
files are in copyfile.c.

$Id: copy.c,v 1.11 2002/04/24 19:19:05 jgoerzen Exp $

*/
#define __JG_COPY_C__

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "handin.h"

void badsecuritymsg(char *name);

/* Main function called for each file/dir to hand in. */

void handitin(char *file)
{
struct stat sbuf;
char filename[MAXFILENAME];

  mkfilename(filename, file, "");
  safestat(filename, &sbuf);
  
  /* If it's a directory, treat it differently. */
  
  if (S_ISDIR(sbuf.st_mode)) {
    printf("!!! %s is a directory; not handed in.\n", file);
    reject++;
    logerror("Attempt to handin a directory %s", filename);
  } else if (!(S_ISREG(sbuf.st_mode))) {
    printf("!!! %s is not a regular file; not handed in.\n", file);
    reject++;
    logerror("Attempt to hand in a non-regular file %s", filename);
  }
  else
    copyfile(file);
}

/* Somebody may try to fool with us by putting things like ../ at the
   beginning of the filename.  Unless this type of thing is checked for,
   one person would theoretically be able to submit a file into another
   person's handin directory -- definately not what we want.  Check for
   this and other devious tricks.
   */

void badsecuritymsg(char *name)
{
  printf("\a!!! Handin rejected for %s\n", name);
  printf("!!! Filename must not:\n");
  printf("!!!  * Contain spaces or slashes\n");
  printf("!!!  * Be the name of a directory\n\n");
  reject++;
  logerror("Handin rejected for %s\n", name);
}

int checksecurity(char *name)
{
int result = TRUE;
  if (strstr(name, "/")) result = FALSE; /* Disallow subdirectories */
  if (strstr(name, "~")) result  = FALSE; /* Disallow tildes */
  if (strcmp(name, ".") == 0) result = FALSE;
  if (strcmp(name, "..") == 0) result = FALSE;
  if (!result) badsecuritymsg(name);
  return result;
}

/* Take a file and a directory and build a string containing both. */

void mkfilename(char *filename, char *file, char *dir)
{
  snprintf(filename, MAXFILENAME, "%s%s%s",
  	dir,
	(strlen(dir)) ? "/" : "",
	file);
}
