	ORG	100H
	JMP	FREE
;
GREET:	DB	'8080 MUMPS   VERSION 2.62',0
ENDIN:	DW	FREE+STRLN+1+STRLN+STKLN+SYNLN+PTRLN
PATSZ:	DW	4096	;PARTITION SIZE
NGBUF:	DB	6	;NUMBER OF GLOBAL BUFFERS
ERFCB:	DB	0,'ERRORS  DAT',0,0,0,0
	DS	20
GLFCB:	DB	0,'GLOBALS DAT',0,0,0,0
	DS	20
AUTO:	DB	0
RLENG:	DS	1	;LENGTH OF DATA READ IN
BDATA:	DS	255	;DATA READ IN
	DS	1	;ROOM FOR <CR>
;
MUMPS:		
	LXI	H,FREE	;INITIALIZE LBUFF
	SHLD	LBUFF
	LXI	D,STRLN+1
	DAD	D
	SHLD	DRBUF
	LXI	D,STRLN
	DAD	D
	SHLD	XSTK
	SHLD	TOS	;INITIALIZE TOS
	LXI	D,STKLN
	DAD	D
	LXI	D,SYNLN
	DAD	D
	SHLD	PTR
	SHLD	SSTK	;INITIALIZE SSTK
;*
;* SET UP GLOBAL BUFFERS
;*
	SHLD	GLBTA
	LDA	NGBUF
	STA	IT
	SHLD	PTR1
MMPA:	LHLD	PTR1	;MOVE PTR1 PAST THE GLOBAL TABLE
	LXI	D,GBTSZ
	DAD	D
	SHLD	PTR1
	LXI	H,IT
	DCR	M
	LDA	IT
	ORA	A
	JNZ	MMPA
	LDA	NGBUF
	STA	IT
MMPB:	LXI	H,IT
	DCR	M
	LHLD	PTR	;INITIALLY A NIL POINTER
	LXI	D,NIL
	CALL	SETD
	LHLD	PTR	;MOVE PTR TO BUFFER AGE
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	LDA	IT
	MOV	M,A
	INX	H	;MOVE PTR TO DIRTY FLAG
	MVI	M,0
	INX	H	;MOVE PTR TO BUFFER POINTER
	SHLD	PTR  
	LHLD	PTR1
	XCHG	
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR	;PTR TO NEXT TABLE ENTRY
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LHLD	PTR1	;PTR1 TO NEXT BUFFER
	LXI	D,BLKSZ
	DAD	D
	SHLD	PTR1
	ORA	A
	JNZ	MMPB
;*
	LXI	D,PTRLN
	DAD	D
	SHLD	PRGAD
	SHLD	PRGPT
	SHLD	PRGEN	;SET PRGEN
	LHLD	PRGPT
	MVI	M,EOR
	LHLD	PRGEN	;INITIALIZE PTEND
	SHLD	PTEND
	LHLD	PATSZ
	XCHG	
	LHLD	PTEND
	DAD	D
	SHLD	PTEND
	SHLD	SYMPT
	SHLD	SYMEN
	LXI	H,NREF
	SHLD	NLAST
	LHLD	SYMPT	;NULL SYMBOL TABLE
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	SSTK
	SPHL
	CALL	SSCHK
	XRA	A
	STA	IT
	CALL	SETDE	;MAKE TERMINAL CURRENT DEVICE
	CALL	CKCHR	;SEE IF GETTING OUT OF AUTO-MODE
	LDA	RESUL
	CPI	FALSE
	JZ	MMPD
	LDA	CHR
	CPI	CTRLC
	JNZ	MMPD
	XRA	A
	STA	AUTO
MMPD:	LDA	AUTO
	CPI	1
	JZ	MMPC
	LXI	H,GREET	;WRITE GREETING
	CALL	MSG
	CALL	CRLF
MMPC:	LXI	H,0
	SHLD	INDX
	XRA	A
	STA	FLG1
	STA	GLBDR
	STA	RTDRV
	STA	XTDRV
	STA	GLOPN
	STA	DMF
	STA	COLD
MMP0:	MVI	A,NAMLN
	STA	IT
	LXI	H,PRG
	SHLD	PTR
MMP1:	LHLD	PTR	;BLANK OUT ROUTINE NAME
	MVI	M,BLANK
	INX	H
	SHLD	PTR
	LXI	H,IT
	DCR	M
	LDA	IT
	ORA	A
	JNZ	MMP1
MMP1A:	XRA	A
	STA	RESUL
	STA	CASE
	STA	ACTFL
	STA	TOKEN
	STA	SETF
	STA	INDFL
	STA	INDSW
	STA	DOSW
	STA	FORSW
	STA	FLAG
	MVI	A,1
	STA	MODE
	XRA	A
	STA	IODVC
	MVI	A,2
	STA	SWIF
	XRA	A
	STA	LEVEL
	STA	DJ
	STA	KILF
	STA	PF
	STA	GLB
	MVI	A,FALSE
	STA	SETSW
	STA	GOTOF
MMP2:	CALL	INPUT	;GET NEXT LINE
	LDA	AUTO	;AUTO-MODE HAS PASSED INPUT
	ORI	2
	STA	AUTO
	LDA	FLAG
	CPI	4
	JNZ	MMP5
	XRA	A
	STA	FLAG
	LDA	INDSW
	ORA	A
	JZ	MMP3
	CALL	XECRE
	RET	
MMP3:	LDA	DOSW
	ORA	A
	JC	$+6
	JNZ	MMP4
	MVI	A,1
	STA	MODE
	JMP	MMP2
MMP4:	CALL	DORET
	RET	
MMP5:	LDA	ACTFL	;RESET LINACT
	MOV	B,A
	MVI	A,2
	CMA	
	ANA	B
	STA	ACTFL
MMP55:	XRA	A
	STA	FORSW
	LDA	ACTFL	;RESET COMACT
	MOV	B,A
	MVI	A,1
	CMA	
	ANA	B
	STA	ACTFL
	XRA	A
	STA	INDFL
MMP6:	LDA	TOKEN
	CPI	38
	JZ	MMP10
MMP7:	LDA	TOKEN
	CPI	29
	JNZ	MMP9
MMP8:	CALL	GTOKN	;GET FIRST TOKEN
	LDA	TOKEN
	CPI	38
	JZ	MMP10
	CPI	36
	JC	$+6
	JNZ	E18
	JMP	MMP8
MMP9:	LDA	ACTFL	;RESET COMACT
	MOV	B,A
	MVI	A,1
	CMA	
	ANA	B
	STA	ACTFL
	XRA	A
	STA	FNC
	STA	FLAG
	CALL	GTCOM
	LDA	FLAG
	CPI	1
	JZ	MMP7
MMP10:	XRA	A	;RESET LINACT AND COMACT
	STA	ACTFL
	LDA	FORSW
	ORA	A
	JZ	MMP2
	RET	
;*
;*
;*
INPUT:			;GET INPUT LINE FROM TERMINAL
	CALL	SSCHK
	LDA	GOTOF
	CPI	TRUE
	JZ	INP0
	LDA	INDSW
	ORA	A
	JNZ	INP10
	LDA	AUTO
	CPI	1
	JZ	INP3
INP0:	LDA	MODE
	ORA	A
	JZ	INP7
	LDA	AUTO
	CPI	3
	JZ	A0551
INP1:	CALL	CRLF
	MVI	A,PROMT	;DIRECT MODE--WRITE PROMPT
	CALL	TRMOT
	LDA	COLD	;SEE IF NEED TO INITIALIZE RANDOM SEED
	CPI	1
	JZ	INP2
	CALL	RDSEE
	MVI	A,1
	STA	COLD
INP2:	CALL	TRMIN	;READ COMMAND LINE
	CALL	CRLF
	LDA	RLENG
	ORA	A
	JZ	INP1
INP3:	LXI	H,BDATA	;MOVE LINE TO LINE EXECUTION BUFFER
	XCHG	
	LHLD	LBUFF
	LDA	RLENG
	MOV	B,A
	CALL	MOVE
	LXI	H,BDATA	;SAVE LINE IN DIRECT MODE BUFFER
	XCHG	
	LHLD	DRBUF
	LDA	RLENG
	MOV	B,A
	CALL	MOVE
	LDA	RLENG	;SAVE LENGTH
	STA	DRLNG
	LHLD	LBUFF
	SHLD	PTR
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	TPP
	MVI	M,EOL	;SET EOL
	LHLD	PTR
	DCX	H
	SHLD	INDX
	CALL	CKLS 	;CHECK FOR LS
	LDA	RESUL
	ORA	A
	JZ	INP85
	CALL	LININ	;INSERT LINE
	JMP	INP1 	;GET NEXT LINE SINCE THIS WAS STORED
INP7:	LHLD	PRGPT
	MOV	A,M
	CPI	EOR
	JZ	INP10
	SHLD	PRGLS
	MOV	A,M	;GET LINE LENGTH
	STA	SLENG
	INX	H
	MOV	A,M	;GET LABEL LENGTH
	STA	NLENG
	INX	H
	SHLD	PRGPT
	XCHG	
	LHLD	LBUFF
	LDA	SLENG
	MOV	B,A
	CALL	MOVE
	LHLD	PRGPT
	LDA	SLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PRGPT
	LHLD	LBUFF
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR
	MVI	M,EOL
	LHLD	LBUFF	;INITIALIZE INDX PAST LS
	LDA	NLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	INDX
INP85:	CALL	GTOKN
	LHLD	INDX
	MOV	A,M
	CPI	EOL
	JZ	INP9
	RET	
INP9:	MVI	A,2
	STA	FLAG
	RET	
INP10:	MVI	A,4	;END OF ROUTINE
	STA	FLAG
	RET	
;*
;********************     COMMAND TABLE     ********************
;*
;*
;*****  STANDARD COMMANDS  *****
;*
;** BREAK COMMAND
BREAK:	CALL	POSTC	;BEGINNING OF BREAK COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C1C
	CPI	1
	JNZ	C1A
C1:	CALL	STREX	;BREAK WITH ARGUMENTS
	CALL	COMEN
C1A:	LDA	FLAG
	ORI	1
	STA	FLAG
	LDA	ACTFL	;SAVE LOCATION; BREAK TO DIRECT MODE
	ORA	A
	CZ	AC48 
	LDA	CASE
	CPI	1
	JNZ	C1D
	LDA	RESUL
	CPI	1
	JNZ	C1
	JMP	C1D
C1C:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C1
C1D:	RET	
;*
;** CLOSE COMMAND
CLOSE:	CALL	POSTC	;BEGINNING OF CLOSE COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C4
	CPI	1
	JNZ	E14
C2:	CALL	EXPR 	;CHECK FOR CLOSE DEVICE EXPRESSION
	LDA	ACTFL	;SAVE DEVICE NUMBER
	ORA	A
	CZ	AC117
	LDA	TOKEN	;LOOK FOR COLON
	CPI	22
	JNZ	C3
	CALL	GTOKN
	CALL	PARAM	;CHECK FOR DEVICE PARAMETERS
C3:	LDA	ACTFL	;CLOSE DEVICE LISTED
	ORA	A
	CZ	AC77 
C4:	CALL	COMEN
	LDA	RESUL
	ORA	A
	JZ	C2
	LDA	FLAG	;END OF CLOSE COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** DO COMMAND
DO:	CALL	POSTC	;BEGINNING OF DO COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C6
	CPI	1
	JNZ	E14
C5:	CALL	TRANS	;CHECK FOR DO-ABLE BRANCH POINT
	LDA	CASE
	ORA	A
	JZ	C6
	LDA	ACTFL	;STACK DO INFORMATION; DO TRANSPT
	ORA	A
	CZ	AC73 
C6:	CALL	COMEN
	LDA	RESUL
	ORA	A
	JZ	C5
	LDA	FLAG	;END OF DO COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** ELSE COMMAND
ELSE:	CALL	ARGUM	;BEGINNING OF ELSE COMMAND
	LDA	CASE	;ELSE AT END OF LINE; NO ACTION
	CPI	2
	JZ	C7
	CPI	3
	JNZ	E14
	LDA	ACTFL	;INTERROGATE IFSWITCH; SET LINACT
	ORA	A
	CZ	AC59 
C7:	LDA	FLAG	;END OF ELSE COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** FOR COMMAND
FOR:	LDA	TOKEN	;BEGINNING OF FOR COMMAND
	CPI	31
	JNZ	E14
	CALL	GTOKN
	CALL	LVN  	;CHECK FOR LOCAL VARIABLE
	LDA	RESUL
	ORA	A
	JZ	E23
	LHLD	TOS
	SHLD	VPTR
	LDA	ACTFL	;INCREMENT FORSW; SCAN TO B-O-S
	ORA	A
	CZ	AC99 
	LDA	TOKEN
	CPI	17
	JNZ	E27
	CALL	GTOKN
C8:	CALL	EXPR 	;CHECK FOR NEXT VALUE IN FOR LIST
	LDA	TOKEN	;LOOK FOR COLON
	CPI	22
	JZ	C9
	LDA	ACTFL	;SET VARIABLE TO VALUE; ZERO T-O-S
	ORA	A
	CZ	AC51 
	LDA	ACTFL	;EXECUTE SCOPE (EOL HANDLES RETURN)
	ORA	A
	CZ	AC82 
	JMP	C13
C9:	CALL	GTOKN
	LDA	ACTFL	;SAVE VALUE IN FREAL
	ORA	A
	CZ	AC79 
	LHLD	TOS
	SHLD	IPTR
	CALL	NUMEX	;CHECK FOR NUMERIC INCREMENT
	LDA	TOKEN	;LOOK FOR SECOND COLON
	CPI	22
	JZ	C11
	MVI	A,1
	STA	FCASE
	LDA	ACTFL	;SET FOR VARIABLE TO VALUE
	ORA	A
	CZ	AC124
C10:	LDA	ACTFL	;EXECUTE SCOPE (EOL HANDLES RETURN)
	ORA	A
	CZ	AC82 
	MVI	A,4
	STA	CASE
	LDA	ACTFL	;SETRIEVE B-O-S; INCREMENT FOR VAR;
	ORA	A
	CZ	AC83 
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C13
	JMP	C10
C11:	CALL	GTOKN
	LHLD	TOS
	SHLD	FPTR
	CALL	NUMEX	;CHECK FOR (NUMERIC) FINAL VALUE
	MVI	A,2
	STA	FCASE
	LDA	ACTFL	;SET FOR VARIABLE TO VALUE
	ORA	A
	CZ	AC124
	MVI	A,4
	STA	CASE
	LDA	ACTFL	;TEST LVN AGAINST FINAL VALUE;
	ORA	A
	CZ	AC87 
	LDA	CASE	;FINISHED WITH THIS LOOP
	CPI	1
	JNZ	C13
C12:	LDA	ACTFL	;EXECUTE SCOPE (EOL HANDLES RETURN)
	ORA	A
	CZ	AC82 
	MVI	A,4
	STA	CASE
	LDA	ACTFL	;RETRIEVE VALUES, DO TEST; X OR Y
	ORA	A
	CZ	AC88 
	LDA	CASE
	CPI	1
	JZ	C12
C13:	LDA	ACTFL	;RETRIEVE POSITION; CLEAN OFF STACK
	ORA	A
	CZ	AC89 
	LDA	TOKEN	;LOOK FOR COMMA
	CPI	21
	JNZ	C135
	CALL	GTOKN
	JMP	C8
C135:	LDA	ACTFL	;CLEAN LVN OFF STACK; DECREMENT FORSW
	ORA	A
	CZ	AC90 
	CALL	FOREN	;SCAN OFF SPACE OR EOL
	LDA	FLAG	;END OF FOR COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** GOTO COMMAND
GOTO:	CALL	POSTC	;BEGINNING OF GOTO COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C15
	CPI	1
	JNZ	E14
C14:	CALL	TRANS	;CHECK FOR FIRST TRUE BRANCH POINT
	LDA	CASE
	ORA	A
	JZ	C15
	LDA	ACTFL	;BRANCH TO TRANSPT (SETS EOL)
	ORA	A
	CZ	AC72 
C15:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C14
	LDA	FLAG	;END OF GOTO COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** HALT COMMAND
HALT:	CALL	POSTC	;BEGINNING OF HALT COMMAND
	LDA	CASE	;HALT AT END OF LINE
	CPI	2
	JZ	C16
	CPI	3
	JNZ	E14
C16:	LDA	ACTFL	;TERMINATE EXECUTION;DIRECT MODE
	ORA	A
	CZ	AC55 
	LDA	FLAG	;END OF HALT COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** HANG COMMAND
HANG:	CALL	POSTC	;BEGINNING OF HANG COMMAND
HENTR:	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C18
	CPI	1
	JNZ	E14
C17:	CALL	INTEX	;CHECK FOR INTEGER HANG EXPRESSION
	LDA	ACTFL	;SUSPEND EXECUTION FOR EXPR SECONDS
	ORA	A
	CZ	AC60 
C18:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C17
	LDA	FLAG	;END OF HANG COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** IF COMMAND
FI:	CALL	ARGUM	;BEGINNING OF IF COMMAND
	LDA	CASE	;IF AT END OF LINE; NO ACTION
	CPI	2
	JZ	C22
	CPI	4	;SYNTAX CHECKING ONLY
	JZ	C21
	CPI	1	;ARGUMENTS PRESENT
	JZ	C19
	LDA	ACTFL	;NO CONDITIONS; CHECK IFSWITCH; LINACT
	ORA	A
	CZ	AC58 
	JMP	C22
C19:	LDA	ACTFL	;SET DIF ON
	ORA	A
	CZ	AC57 
C20:	CALL	TVEXP	;CHECK FOR BOOLEAN EXPRESSION
	LDA	CASE	;CONDITION TRUE; CONTINUE
	CPI	1
	JZ	C21
	LDA	ACTFL	;CONDITION FALSE; IFSWITCH OFF, LINACT
	ORA	A
	CZ	AC56 
C21:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C20
C22:	LDA	DIF
	STA	SWIF
	LDA	FLAG	;END OF IF COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** KILL COMMAND
KILL:	CALL	POSTC	;BEGINNING OF KILL COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C28
	CPI	1	;ARGUMENTS PRESENT
	JZ	C23
	LDA	ACTFL	;KILL ALL LOCAL VARIABLES
	ORA	A
	CZ	AC61 
	JMP	C29
C23:	LDA	TOKEN	;LOOK FOR LEFT PARENTHESIS
	CPI	25
	JNZ	C27
	XRA	A
	STA	FNDF
C235:	CALL	GTOKN
C24:	CALL	LVN  	;CHECK FOR LOCAL VARIABLE
	LDA	RESUL
	CPI	1
	JZ	C25
	LDA	ACTFL	;UNMARK SYMBOL TABLE
	ORA	A
	CZ	AC76 
	JMP	E23
C25:	LDA	ACTFL	;MARK VARIABLE IN SYMBOL TABLE
	ORA	A
	CZ	AC62 
	LDA	TOKEN	;LOOK FOR COMMA
	CPI	21
	JZ	C235
	CPI	26	;LOOK FOR RIGHT PARENTHESIS
	JZ	C26
	LDA	ACTFL	;UNMARK SYMBOL TABLE
	ORA	A
	CZ	AC76 
	JMP	E12
C26:	CALL	GTOKN
	LDA	ACTFL	;KILL EXCLUSIVE OF MARKED LVN'S
	ORA	A
	CZ	AC63 
	JMP	C28
C27:	CALL	GLVN 	;CHECK FOR VARIABLE
	LDA	ACTFL	;KILL VARIABLE
	ORA	A
	CZ	AC64 
C28:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C23
C29:	LDA	FLAG	;END OF KILL COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** LOCK COMMAND
LOCK:	CALL	POSTC	;BEGINNING OF LOCK COMMAND
	MVI	A,1
	STA	LOCKS
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C31
	CPI	1	;ARGUMENTS PRESENT
	JZ	C30
	LDA	ACTFL	;RELEASE ALL LOCKED RESOURCES
	ORA	A
	CZ	AC102
	JMP	C32
C30:	CALL	VARLI	;CHECK FOR ONE VARIABLE OR A LIST
	CALL	TIMEO	;CHECK FOR TIMEOUT EXPRESSION
	LDA	ACTFL	;LOCK RESOURCES
	ORA	A
	CZ	AC101
C31:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C30
C32:	XRA	A
	STA	LOCKS
	LDA	FLAG	;END OF LOCK COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** OPEN COMMAND
OPEN:	CALL	POSTC	;BEGINNING OF OPEN COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C35
	CPI	1
	JNZ	E14
C33:	CALL	EXPR 	;CHECK FOR OPEN DEVICE EXPRESSION
	LDA	ACTFL	;SAVE DEVICE NUMBER
	ORA	A
	CZ	AC117
	LDA	TOKEN	;LOOK FOR COLON
	CPI	22
	JNZ	C34
	CALL	GTOKN
	CALL	TIMEO	;CHECK FOR TIMEOUT EXPRESSION
	LDA	RESUL
	CPI	1
	JZ	C34
	CALL	PARAM	;CHECK FOR DEVICE PARAMETERS
	CALL	TIMEO	;CHECK FOR TIMEOUT EXPRESSION
C34:	LDA	ACTFL	;PERFORM OPEN ON NAMED DEVICE
	ORA	A
	CZ	AC78 
C35:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C33
	LDA	FLAG	;END OF OPEN COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** QUIT COMMAND
QUIT:	CALL	POSTC	;BEGINNING OF QUIT COMMAND
	LDA	CASE	;QUIT AT END OF LINE
	CPI	2
	JZ	C36
	CPI	3
	JNZ	E14
C36:	LDA	ACTFL	;EXECUTE QUIT
	ORA	A
	CZ	AC75 
	LDA	FLAG	;END OF QUIT COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** READ COMMAND
READ:	CALL	POSTC	;BEGINNING OF READ COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C40
	CPI	1
	JNZ	E14
C37:	LDA	TOKEN	;LOOK FOR ASTERISK (DEVICE SPECIFIC )
	CPI	7
	JNZ	C38
	CALL	GTOKN
	CALL	LVN  	;CHECK FOR LOCAL VARIABLE
	LDA	RESUL
	CPI	1
	JNZ	E23
	XRA	A
	STA	TIMF
	CALL	TIMEO	;CHECK FOR TIMEOUT EXPRESSION
	LDA	ACTFL	;GET INPUT VARIABLE AS ONE DEVICE-SPECIFIC CODE
	ORA	A
	CZ	AC66 
	JMP	C40
C38:	CALL	FORMA	;CHECK FOR FORMAT EXPRESSION
	LDA	RESUL
	CPI	1
	JZ	C40
	CALL	AC6  	;TEST FOR STRING LITERAL
	LDA	RESUL
	CPI	1
	JNZ	C39
	LDA	ACTFL	;OUTPUT STRING LITERAL
	ORA	A
	CZ	AC67 
	JMP	C40
C39:	CALL	LVN  	;CHECK FOR LOCAL VARIABLE
	LDA	RESUL
	CPI	1
	JNZ	E18
	MVI	A,1
	STA	TIMF
	CALL	TIMEO	;CHECK FOR TIMEOUT EXPRESSION
	LDA	ACTFL	;GET INPUT VARIABLE AS STRING
	ORA	A
	CZ	AC68 
C40:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C37
	LDA	FLAG	;END OF READ COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** SET COMMAND
TES:	CALL	POSTC	;BEGINNING OF SET COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C42
	CPI	1
	JNZ	E14
C41:	CALL	VARLI	;CHECK FOR ONE VARIABLE OR A PARENTHESIZED LIST
	LDA	TOKEN	;LOOK FOR EQUAL SIGN
	CPI	17
	JNZ	E27
	CALL	GTOKN
	CALL	EXPR 	;CHECK FOR ASSIGNMENT EXPRESSION
	LDA	ACTFL	;SET LOCAL,GLOBAL VARIABLES(S) TO VALUE
	ORA	A
	CZ	AC47 
C42:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C41
	LDA	FLAG	;END OF SET COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;** USE COMMAND
USE:	CALL	POSTC	;BEGINNING OF USE COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C45
	CPI	1
	JNZ	E14
C43:	CALL	EXPR 	;CHECK FOR USE DEVICE EXPRESSION
	LDA	ACTFL	;SAVE DEVICE NUMBER
	ORA	A
	CZ	AC117
	LDA	TOKEN	;LOOK FOR COLON
	CPI	22
	JNZ	C44
	CALL	GTOKN
	CALL	PARAM	;CHECK FOR DEVICE PARAMETERS
C44:	LDA	ACTFL	;MAKE DEVICE LISTED THE 'CURRENT' DEVICE
	ORA	A
	CZ	AC65 
C45:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C43
	LDA	FLAG
	ORI	1
	STA	FLAG
	RET		;END OF USE COMMAND
;*
;** VIEW COMMAND
VIEWS:	CALL	POSTC	;BEGINNING OF VIEW COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C45B
	CPI	1	;NO ARGUMENTS--LOCALS ONLY
	JZ	C45A
	XRA	A
	STA	VF
	LDA	ACTFL
	ORA	A
	CZ	AC37
	JMP	C45C
C45A:	CALL	INTEX	;ARGUMENTS TO EVALUATE
	LDA	ACTFL	;WRITE OUT VALUES
	ORA	A
	CZ	AC39 
C45B:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C45A
C45C:	LDA	FLAG
	ORI	1
	STA	FLAG
	RET	
;*
;** WRITE COMMAND
WRITE:	CALL	POSTC	;BEGINNING OF WRITE COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C48
	CPI	1
	JNZ	E14
C46:	LDA	TOKEN	;LOOK FOR DEVICE-SPECIFIC WRITE
	CPI	7
	JNZ	C47
	CALL	GTOKN
	CALL	INTEX	;CHECK FOR INTEGER OUTPUT CODE
	LDA	ACTFL	;OUTPUT DEVICE-SPECIFIC CODE
	ORA	A
	CZ	AC53 
	JMP	C48
C47:	CALL	FORMA	;CHECK FOR FORMAT EXPRESSION
	LDA	RESUL
	CPI	1
	JZ	C48
	CALL	EXPR 	;CHECK FOR GENERAL OUTPUT EXPRESSION
	LDA	ACTFL	;OUTPUT VALUE
	ORA	A
	CZ	AC54 
C48:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C46
	LDA	FLAG
	ORI	1
	STA	FLAG
	RET		;END OF WRITE COMMAND
;*
;** XECUTE COMMAND
XECUT:	CALL	POSTC	;BEGINNING OF XECUTE COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	C51
	CPI	1
	JNZ	E14
C49:	CALL	STREX	;CHECK FOR INDIRECT STRING
	CALL	ARGCO	;CHECK FOR ARGUMENT CONDITIONAL
	LDA	CASE
	CPI	1
	JZ	C50
	LDA	ACTFL	;REMOVE STRING FROM STACK
	ORA	A
	CZ	AC26 
	JMP	C51
C50:	LDA	ACTFL	;INCREMENT INDSW,STACK XECUTE INFO; EXECUTE STACK
	ORA	A
	CZ	AC103
C51:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	C49
	LDA	FLAG
	ORI	1
	STA	FLAG
	RET		;END OF XECUTECOMMAND
;*
;** Z (ESCAPE COMMANDS)
;*
ZARG:	CALL	POSTC	;BEGINNING OF ZARG COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	ZA2
	CPI	1
	JNZ	E14
ZA1:	CALL	STREX	;CHECK FOR STRING PARAMETER
	LDA	ACTFL	;SET STRING PARAMETER
	ORA	A
	CZ	AC121
ZA2:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	ZA1
	LDA	FLAG	;END OF ZARG COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;*
ZCALL:	CALL	POSTC	;BEGINNING OF ZCALL COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	ZCA1
	CPI	1
	JZ	E14
	LDA	ACTFL	;TRANSFER CONTROL TO ROUTINE
	ORA	A
	CZ	AC120
ZCA1:	LDA	FLAG	;END OF ZCALL COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;*
ZDELE:	CALL	POSTC
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	ZR2
	CPI	1
	JNZ	E14
ZR1:	CALL	ROUTI	;CHECK FOR ROUTINE NAME
	LDA	ACTFL	;REMOVE NAMED ROUTINE
	ORA	A
	CZ	AC111
ZR2:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	ZR1
	LDA	FLAG	;END OF ZREMOVE COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;*
ZGO:	LDA	FLG1	;ONLY DURING BREAK
	ANI	BRAKE
	JZ	E45
	LDA	ACTFL	;RETURN FROM BREAK
	ORA	A
	CZ	AC49 
	LDA	FLAG	;END OF ZXECUTE COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;*
ZINSE:	LDA	FLG1	;NO INSERTS IN BREAK MODE
	ANI	BRAKE
	JNZ	E44
	CALL	POSTC
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	ZI3
	CPI	1
	JNZ	E14
ZI1:	CALL	STREX	;CHECK FOR STRING EXPRESSION
	LDA	TOKEN	;CHECK FOR LABEL
	CPI	22
	JNZ	ZI2
	CALL	GTOKN
	CALL	LINER
	LDA	ACTFL	;MOVE ROUTINE POINTER
	ORA	A
	CZ	AC96 
ZI2:	LDA	ACTFL	;INSERT STRING AT CURRENT LINE
	ORA	A
	CZ	AC118
ZI3:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	ZI1
	LDA	FLAG	;END OF ZINSERT COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;*
ZLOAD:	LDA	FLG1	;ILLEGAL DURING BREAK
	ANI	BRAKE
	JNZ	E44
	CALL	POSTC
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	ZG2
	CPI	1
	JNZ	E14
ZG1:	CALL	ROUTI	;CHECK FOR ROUTINE NAME
	LDA	ACTFL	;LOAD ROUTINE
	ORA	A
	CZ	AC94 
ZG2:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	ZG1
	LDA	FLAG	;END OF ZGET COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;*
ZMOVE:	LDA	FLG1	;NO MOVES IN BREAK MODE
	ANI	BRAKE
	JNZ	E44
	CALL	POSTC
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	ZM4
	CPI	1	;ARGUMENTS PRESENT
	JZ	ZM1
	LDA	ACTFL	;MOVE ROUTINE PTR TO TOP OF ROUTINE
	ORA	A
	CZ	AC95 
	JMP	ZM5
ZM1:	LDA	TOKEN	;CHECK FOR COLON
	CPI	22
	JNZ	ZM2
	CALL	GTOKN
	LDA	ACTFL	;MOVE ROUTINE PTR TO END OF ROUTINE
	ORA	A
	CZ	AC112
	JMP	ZM4
ZM2:	CALL	LINER	;CHECK FOR LABEL[+OFFSET]
	LDA	ACTFL	;MOVE ROUTINE POINTER
	ORA	A
	CZ	AC96 
ZM4:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	ZM2
ZM5:	LDA	FLAG
	ORI	1
	STA	FLAG
	RET	
;*
;*
ZOPTI:	CALL	POSTC	;BEGINNING OF ZOPTION COMMAND
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	ZO2
	CPI	1
	JZ	ZO1
	LDA	ACTFL	;WRITE OUT CURRENT DRIVES
	ORA	A
	CZ	AC44 
	JMP	ZO3
ZO1:	LDA	ACTFL
	ORA	A
	CZ	AC20
	CALL	PARAM	;CHECK FOR DRIVE OPTIONS
	LDA	ACTFL	;SET OPTIONS
	ORA	A
	CZ	AC119
ZO2:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	ZO1
ZO3:	LDA	FLAG	;END OF ZOPTION COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;*
ZPRIN:	CALL	POSTC
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	ZL2
	CPI	1	;ARGUMENTS PRESENT
	JZ	ZL1
	LDA	ACTFL	;LIST ENTIRE ROUTINE
	ORA	A
	CZ	AC97 
	JMP	ZL3
ZL1:	LDA	TOKEN	;CHECK FOR ASTERISK
	CPI	7
	JNZ	ZL15
	CALL	GTOKN
	LDA	ACTFL	;LIST CURRENT LINE
	ORA	A
	CZ	AC113
	JMP	ZL2
ZL15:	CALL	GETLA	;CHECK FOR LABEL(S)
	LDA	ACTFL	;PRINT SPECIFIED PART
	ORA	A
	CZ	AC98 
ZL2:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	ZL1
ZL3:	LDA	FLAG	;END OF ZLIST COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;*
ZREMO:	LDA	FLG1	;NO DELETES IN BREAK MODE
	ANI	BRAKE
	JNZ	E44
	CALL	POSTC
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	ZD2
	CPI	1	;ARGUMENTS PRESENT
	JZ	ZD1
	LDA	ACTFL	;DELETE ENTIRE ROUTINE
	ORA	A
	CZ	AC92 
	JMP	ZD3
ZD1:	LDA	TOKEN	;CHECK FOR ASTERISK
	CPI	7
	JNZ	ZD15
	CALL	GTOKN
	LDA	ACTFL	;DELETE CURRENT LINE
	ORA	A
	CZ	AC114
	JMP	ZD2
ZD15:	CALL	GETLA	;CHECK FOR LABEL(S)
	LDA	ACTFL	;DELETE SPECIFIED PORTION
	ORA	A
	CZ	AC93 
ZD2:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	ZD1
ZD3:	LDA	FLAG
	ORI	1
	STA	FLAG
	RET	
;*
;*
ZSAVE:	CALL	POSTC
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	ZS3
	CPI	1	;NAME PRESENT
	JZ	ZS1
	LDA	ACTFL	;SAVE AS CURRENT NAME
	ORA	A
	CZ	AC30 
	JMP	ZS4
ZS1:	CALL	ROUTI	;CHECK FOR ROUTINE NAME
ZS2:	LDA	ACTFL	;SAVE ROUTINE
	ORA	A
	CZ	AC23 
ZS3:	CALL	COMEN
	LDA	RESUL
	CPI	1
	JNZ	ZS1
ZS4:	LDA	FLAG	;END OF ZSAVE COMMAND
	ORI	1
	STA	FLAG
	RET	
;*
;*
;*****  AMBIGUOUS SINGLE LETTER COMMANDS  *****
;*
;** H-COMMAND
HS:	CALL	POSTC	;MUST DECIDE BETWEEN HALT AND HANG
	LDA	CASE	;HALT, AT END OF LINE
	CPI	2
	JZ	C52
	CPI	3	;ARGUMENTS PRESENT; MUST BE HANG
	JNZ	HENTR
C52:	LDA	ACTFL	;TERMINATE PROGRAM EXECUTION; RETURN TO DIRECT MODE
	ORA	A
	CZ	AC55 
	LDA	FLAG
	ORI	1
	STA	FLAG
	RET		;END OF HALT
;*
;*
;**********     END OF COMMANDS     **********
;*
;********************     COMMAND SUBROUTINE TABLE     ********************
;*
;** TRANSFER POINT PRIMITIVE
TRANS:		
	CALL	SSCHK
	CALL	ENTRY	;CHECK FOR LABEL[ ROUTINE]
	LDA	ACTFL	;SAVE RETURN VALUE TOP OF STACK (T-O-S)
	ORA	A
	CZ	AC71 
	CALL	ARGCO	;CHECK FOR ARGUMENT CONDITIONAL
	LDA	CASE	;X RETURN; TRANSFER POINT EXECUTABLE
	CPI	1
	JZ	S1
	LDA	ACTFL	;REMOVE LABEL[^ROUTINE] FROM STACK
	ORA	A
	CZ	AC69 
S1:	MVI	A,1
	STA	RESUL
	RET	
;*
;** VARIABLE LIST PRIMITIVE
VARLI:		
	CALL	SSCHK
	MVI	A,TRUE
	STA	SETSW
	LDA	ACTFL	;ZERO T-O-S (END OF VARIABLE CHAIN)
	ORA	A
	CZ	AC20 
	LDA	TOKEN	;LOOK FOR LEFT PARENTHESIS
	CPI	25
	JZ	S2
	CALL	GLVN 	;CHECK FOR VARIABLE
	CALL	AC18 	;TEST FOR LOCK CASE; SET OFFSET TO NEW VALUE
	JMP	S3
S2:	CALL	GTOKN
	CALL	GLVN 	;CHECK FOR VARIABLE
	CALL	AC18 	;TEST FOR LOCK CASE; SET OFFSET TO NEW VALUE
	LDA	TOKEN	;LOOK FOR COMMA
	CPI	21
	JZ	S2
	CPI	26	;LOOK FOR RIGHT PARENTHESIS
	JNZ	E12
	CALL	GTOKN
S3:	MVI	A,1
	STA	RESUL
	MVI	A,FALSE
	STA	SETSW
	RET	
;*
GETLA:		
	CALL	SSCHK
	CALL	LINER	;CHECK FOR LABEL[+OFFSET]
	MVI	A,1	;ONE LABEL
	STA	CASE
	LDA	TOKEN	;LOOK FOR COLON
	CPI	22
	JNZ	S5
	CALL	GTOKN
	LDA	TOKEN
	CPI	31
	JZ	S35
	CPI	38
	JNZ	S4
S35:	MVI	A,3	;LABEL AND COLON PRESENT
	STA	CASE
	JMP	S5
S4:	CALL	LINER
	MVI	A,2	;TWO LABELS PRESENT
	STA	CASE
S5:	MVI	A,1
	STA	RESUL
	RET	
;*
;**********     END OF COMMAND SUBROUTINES     **********
;*
;********************     ERROR MESSAGE TABLE     ********************
E0:	XRA	A    	;MISSING LINESTART CHARACTER
	CALL	ERROR
E1:	MVI	A,1    	;STACK OVERFLOW
	CALL	ERROR
E2:	MVI	A,2    	;ARITHMETIC OVERFLOW
	CALL	ERROR
E3:	MVI	A,3    	;UNDEFINED LOCAL VARIABLE
	CALL	ERROR
E4:	MVI	A,4    	;ILLEGAL FUNCTION NAME
	CALL	ERROR
E5:	MVI	A,5    	;ILLEGAL COMMAND NAME
	CALL	ERROR
E6:	MVI	A,6    	;UNDEFINED PROGRAM NAME
	CALL	ERROR
E7:	MVI	A,7    	;UNDEFINED GLOBAL NAME
	CALL	ERROR
E8:	MVI	A,8    	;GLOBAL+VALUE TOO LONG
	CALL	ERROR
E9:	MVI	A,9    	;DIRECTORY FULL
	CALL	ERROR
E10:	MVI	A,10   	;PROGRAM LARGER THAN PARTITION
	CALL	ERROR
E11:	MVI	A,11   	;STRING TOO LONG
	CALL	ERROR
E12:	MVI	A,12   	;UNMATCHED PARENTHESES
	CALL	ERROR
E13:	MVI	A,13   	;ILLEGAL USE OF NOT OPERATOR
	CALL	ERROR
E14:	MVI	A,14   	;ILLEGAL COMMAND TERMINATOR
	CALL	ERROR
E15:	MVI	A,15   	;NAKED REFERENCE TOO LONG
	CALL	ERROR
E16:	MVI	A,16   	;UNAUTHORIZED GLOBAL ACCESS
	CALL	ERROR
E17:	MVI	A,17   	;DIVISION BY ZERO
	CALL	ERROR
E18:	MVI	A,18   	;ILLEGAL CHARACTER
	CALL	ERROR
E19:	MVI	A,19   	;SYNTAX STACK OVERFLOW
	CALL	ERROR
E20:	LDA	ACTFL	;UNMARK SYMBOL TABLE (NOP UNLESS IN EXCLUSIVE KILL)
	ORA	A
	CZ	AC76 
	MVI	A,20   	;ILLEGAL EXPRESSION
	CALL	ERROR
E21:	MVI	A,21   	;ILLEGAL PATTERN
	CALL	ERROR
E22:	MVI	A,22   	;MISSING COMMA
	CALL	ERROR
E23:	MVI	A,23   	;ILLEGAL VARIABLE NAME
	CALL	ERROR
E24:	MVI	A,24   	;ILLEGAL USE OF INDIRECTION
	CALL	ERROR
E25:	MVI	A,25   	;UNDEFINED ROUTINE LINE NUMBER
	CALL	ERROR
E26:	MVI	A,26   	;ILLEGAL NUMERIC LITERAL
	CALL	ERROR
E27:	MVI	A,27   	;MISSING EQUAL SIGN
	CALL	ERROR
E28:	MVI	A,28   	;ILLEGAL ROUTINE OR LABEL NAME
	CALL	ERROR
E29:	MVI	A,29   	;INVALID NAME SYNTAX
	CALL	ERROR
E30:	MVI	A,30   	;UNIMPLEMENTED COMMAND/FUNCTION
	CALL	ERROR
E31:	MVI	A,31   	;SYMBOL TABLE OVERFLOW
	CALL	ERROR
E32:	MVI	A,32   	;TOO MANY LEVELS OF NESTING
	CALL	ERROR
E33:	MVI	A,33   	;DUPLICATE LABEL
	CALL	ERROR
E34:	MVI	A,34   	;INVALID LINE REFERENCE
	CALL	ERROR
E35:	MVI	A,35   	;NO TRUE VALUE IN $SELECT
	CALL	ERROR
E36:	MVI	A,36   	;NAKED GLOBAL REFERENCE ILLEGAL
	CALL	ERROR
E37:	MVI	A,37   	;DISK WRITE ERROR
	CALL	ERROR
E38:	MVI	A,38   	;ROUTINE OR GLOBAL FILE NOT IN LIBRARY
	CALL	ERROR
E39:	MVI	A,39   	;DISK READ ERROR
	CALL	ERROR
E40:	MVI	A,40   	;ROUTINE IS UNNAMED
	CALL	ERROR
E41:	MVI	A,41   	;ROUTINE ALREADY IN LIBRARY
	CALL	ERROR
E42:	MVI	A,42   	;DELETE OR SAVE ROUTINE
	CALL	ERROR
E43:	MVI	A,43   	;INDIRECT MODE COMMAND ONLY
	CALL	ERROR
E44:	MVI	A,44   	;ILLEGAL WHILE IN BREAK
	CALL	ERROR
E45:	MVI	A,45   	;ONLY DURING BREAK
	CALL	ERROR
E46:	MVI	A,46   	;MISSING SUBSCRIPT
	CALL	ERROR
E47:	MVI	A,47   	;INVALID SUBSCRIPT
	CALL	ERROR
E48:	MVI	A,48   	;TOO MANY PARAMETERS
	CALL	ERROR
E49:	MVI	A,49   	;DEVICE NOT OPEN YET
	CALL	ERROR
E50:	MVI	A,50   	;INVALID DRIVE
	CALL	ERROR
E51:	MVI	A,51   	;WRITE ONLY DEVICE
	CALL	ERROR
E52:	MVI	A,52   	;INVALID DEVICE NUMBER
	CALL	ERROR
;*
;**********     END OF ERROR MESSAGES     **********
;*
;********************     COMMAND PRIMITIVES TABLE     ********************
;*
;**  ARGUMENT CONDITIONAL  **
ARGCO:		
	CALL	SSCHK
	MVI	A,1	;SET X RETURN
	STA	CASE
	LDA	TOKEN	;LOOK FOR COLON
	CPI	22
	JNZ	P1
	CALL	GTOKN
	CALL	TVEXP	;CHECK FOR BOOLEAN EXPRESSION
P1:	MVI	A,1
	STA	RESUL
	RET	
;*
;**  COMMAND POSTCONDITIONAL AND DELIMITER  **
POSTC:		
	CALL	SSCHK
	CALL	ARGCO	;CHECK FOR POSTCONDITIONAL EXPRESSION
	LDA	CASE
	CPI	1
	JZ	ARGUM
	LDA	ACTFL	;SET SEMANTIC ACTION FLAG COMACT ON
	ORA	A
	CZ	AC29 
ARGUM:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR SPACE
	CPI	31
	JZ	P2
	CPI	38	;LOOK FOR EOL
	JNZ	E14
	LDA	FLAG	;SET END OF LINE
	ORI	2
	STA	FLAG
	MVI	A,2	;Y-RETURN (NO ARGUMENTS, END OF LINE)
	STA	CASE
	JMP	P5
P2:	CALL	GTOKN
	LDA	TOKEN	;LOOK FOR SECOND SPACE
	CPI	31
	JNZ	P3
	CALL	GTOKN
	MVI	A,3	;Z-RETURN (NO ARGS, MORE COMMANDS)
	STA	CASE
	JMP	P5
P3:	CALL	INDAR	;CHECK FOR INDIRECTION ON 1ST ARGUMENT
	LDA	RESUL
	CPI	1
	JNZ	P4
	LDA	CASE	;W-RETURN (SYNTAX ONLY, 1ST ARG INDIR)
	CPI	4
	JZ	P5
P4:	MVI	A,1	;X-RETURN (ARGS PRESENT TO EVALUATE)
	STA	CASE
P5:	MVI	A,1
	STA	RESUL
	RET	
;*
;**  COMMAND ARGUMENT ENDING  **
COMEN:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR COMMA
	CPI	21
	JNZ	P7
	CALL	GTOKN
	CALL	INDAR	;CHECK FOR INDIRECTION ON NEXT ARGUMENT
	LDA	RESUL
	CPI	1
	JNZ	P6
	LDA	CASE	;SYNTAX CHECKING ONLY, INDIR ARG
	CPI	4
	JZ	COMEN
P6:	XRA	A
	STA	RESUL
	RET	
P7:	CALL	AC1  	;TEST FOR EOI AND CLEAN OFF INDIRECTION
	LDA	RESUL
	CPI	1
	JZ	COMEN
FOREN:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR SPACE
	CPI	31
	JZ	P8
	CPI	38	;LOOK FOR EOL
	JNZ	E22
	LDA	FLAG	;SET END OF LINE
	ORI	2
	STA	FLAG
	JMP	P85
P8:	CALL	GTOKN
P85:	MVI	A,1
	STA	RESUL
	RET	
;*
;**  ARGUMENT LEVEL INDIRECTION  **
INDAR:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR AT SIGN
	CPI	24
	JZ	P9
	XRA	A
	STA	RESUL
	RET		;NO INDIRECTION
P9:	CALL	GTOKN
	CALL	EXPRA	;CHECK FOR EXPRESSION ATOM
	CALL	AC9  	;TEST IF ARGUMENT INDIRECTION; SET FLAGS,CASE
	LDA	CASE	;SYNTAX CHECKING OR NAME-LEVEL INDIR
	CPI	1
	JNZ	P10
	LDA	TOKEN	;LOOK FOR ANOTHER AT SIGN
	CPI	24
	JZ	P9
P10:	MVI	A,1
	STA	RESUL
	RET	
;*
;**  NAME LEVEL INDIRECTION  **
INDNA:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR AT SIGN
	CPI	24
	JZ	P11
	CALL	AC16 	;TEST FOR FLAG FROM ARGUMENT LEVEL; SET CASE
	JMP	P12
P11:	CALL	GTOKN
	CALL	EXPRA	;CHECK FOR EXPRESSION ATOM
	MVI	A,4	;IN CASE SEMANTIC EXECUTION INHIBITED
	STA	CASE
	LDA	ACTFL	;SET NAMIND; EXECUTE STACK; SET CASE
	ORA	A
	CZ	AC109
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	1
	JNZ	P12
	LDA	TOKEN	;LOOK FOR ANOTHER AT SIGN
	CPI	24
	JZ	P11
P12:	MVI	A,1
	STA	RESUL
	RET	
;*
;**  FORMAT EXPRESSION  **
FORMA:		
	CALL	SSCHK
	CALL	FRMAT	;CHECK FOR ONE FORMAT ATOM
	LDA	RESUL
	CPI	1
	JZ	P13
	CALL	TAB  	;CHECK FOR TAB EXPRESSION
	LDA	RESUL
	CPI	1
	JZ	P14
	XRA	A
	STA	RESUL
	RET		;NOT A FORMAT STATEMENT
P13:	CALL	FRMAT	;CHECK FOR ANOTHER FORMAT ATOM
	LDA	RESUL
	CPI	1
	JZ	P13
	CALL	TAB  	;CHECK FOR FINAL TAB EXPRESSION
P14:	MVI	A,1
	STA	RESUL
	RET	
;* FORMAT ATOM PRIMITIVE
FRMAT:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR LINE-FEED
	CPI	12
	JNZ	P15
	CALL	GTOKN
	LDA	ACTFL	;PERFORM CR-LF; RESET $X, INCREMENT $Y
	ORA	A
	CZ	AC24 
	JMP	P17
P15:	LDA	TOKEN	;LOOK FOR PAGE-FEED
	CPI	9
	JZ	P16
	XRA	A
	STA	RESUL
	RET	
P16:	CALL	GTOKN
	LDA	ACTFL	;PREFORM CR-FF; RESET $X AND $Y
	ORA	A
	CZ	AC25 
P17:	MVI	A,1
	STA	RESUL
	RET	
;* TAB EXPRESSION PRIMITIVE
TAB:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR TAB
	CPI	30
	JZ	P18
	XRA	A
	STA	RESUL
	RET	
P18:	CALL	GTOKN
	CALL	INTEX	;CHECK FOR INTEGER EXPRESSION
	LDA	ACTFL	;TAB ACCORDING TO EXPRESSION VALUE, INC $X
	ORA	A
	CZ	AC28 
	MVI	A,1
	STA	RESUL
	RET	
;*
;**  TIMEOUT CONDITIONAL  **
TIMEO:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR COLON
	CPI	22
	JZ	P19
	XRA	A
	STA	RESUL
	RET	
P19:	CALL	GTOKN
	CALL	NUMEX	;CHECK FOR TIMEOUT EXPRESSION
	LDA	ACTFL	;TEST EXPR AND SET TIMEOUT
	ORA	A
	CZ	AC91 
	MVI	A,1
	STA	RESUL
	RET	
;*
;**  ROUTINE ENTRY  **
ENTRY:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR CARAT
	CPI	20
	JNZ	P20
	CALL	GTOKN
	CALL	ROUTI	;CHECK FOR ROUTINE NAME
	MVI	A,1	;ROUTINE NAME ONLY CASE
	STA	CASE
	JMP	P21
P20:	CALL	LINER	;CHECK FOR LABEL NAME[+OFFSET]
	XRA	A	;LABEL ONLY CASE
	STA	CASE
	LDA	TOKEN	;LOOK FOR CARAT
	CPI	20
	JNZ	P21
	CALL	GTOKN
	CALL	ROUTI	;CHECK FOR ROUTINE NAME
	MVI	A,2	;LABEL AND ROUTINE NAME CASE
	STA	CASE
P21:	MVI	A,1
	STA	RESUL
	RET	
;* ROUTINE NAME PRIMITIVE
ROUTI:		
	CALL	SSCHK
	CALL	INDNA	;CHECK FOR ROUTINE NAME INDIRECTION
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	P22
	CALL	AC15 	;TEST FOR ROUTINE NAME
	LDA	RESUL
	CPI	1
	JNZ	E28
	LDA	ACTFL
	ORA	A
	CZ	AC123
	LDA	ACTFL	;CHECK FOR END OF ALL LEVELS OF NAME INDIRECTION
	ORA	A
	CZ	AC110
P22:	MVI	A,1
	STA	RESUL
	RET	
;*
;**  LABEL OFFSET  **
LINER:		
	CALL	SSCHK
	CALL	LABEL	;CHECK FOR LABEL NAME
LINOF:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR PLUS
	CPI	5
	JZ	P23
	LDA	ACTFL	;ZERO T-O-S (ZERO OFFSET)
	ORA	A
	CZ	AC20 
	XRA	A
	STA	RESUL
	RET	
P23:	CALL	GTOKN
	CALL	INTEX	;CHECK FOR INTEGER OFFSET EXPRESSION
	MVI	A,1
	STA	RESUL
	RET	
;*
;**  LABEL  **
LABEL:		
	CALL	SSCHK
	CALL	INDNA	;CHECK FOR LABEL INDIRECTION
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	P244
	CALL	AC15 	;TEST FOR A NAME LABEL
	LDA	RESUL
	CPI	1
	JZ	P24
	CALL	AC17 	;TEST FOR AN INTEGER LITERAL LABEL
	LDA	RESUL
	CPI	1
	JNZ	E28
P24:	LDA	ACTFL
	ORA	A
	CZ	AC123
	LDA	ACTFL	;CHECK FOR END OF ALL LEVELS OF NAME INDIRECTION
	ORA	A
	CZ	AC110
P244:	MVI	A,1
	STA	RESUL
	RET	
;*
;**  DEVICEPARAMETERS  **
PARAM:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR LEFT PARENTHESIS
	CPI	25
	JZ	P245
	CALL	EXPR 	;CHECK FOR SINGLE DEVICE PARAMETER
	LDA	ACTFL	;CONVERT EXPR APPROPRIATELY AND INCREMENT COUNTER
	ORA	A
	CZ	AC106
	JMP	P27
P245:	CALL	GTOKN
	JMP	P26
P25:	CALL	EXPR 	;CHECK FOR NEXT DEVICE PARAMETER
	LDA	ACTFL	;CONVERT EXPR APPROPRIATELY AND INCREMENT COUNTER
	ORA	A
	CZ	AC106
	CALL	NXTPA	;CHECK FOR COLON OR RIGHT PARENTHESIS
	LDA	RESUL	;NEIGHER PRESENT; MUST BE PARAM EXPR
	CPI	1
	JNZ	P25
	LDA	CASE	;RIGHT PARENTHESIS FOUND; DONE
	CPI	2
	JZ	P27
P26:	CALL	NXTPA	;CHECK FOR ANOTHER COLON; OR RIGHT PARENTHESIS
	LDA	RESUL	;NEITHER PRESENT; MUST BE PARAM EXPR
	CPI	1
	JNZ	P25
	LDA	CASE	;RIGHT PARENTHESIS FOUND; DONE
	CPI	2
	JZ	P27
	LDA	ACTFL	;SET TO DEFAULT PARAMETER
	ORA	A
	CZ	AC107
	JMP	P26  	;CONTINUE CHECKING FOR PARAMETERS
P27:	MVI	A,1
	STA	RESUL
	RET	
;* NEXT PARAMETER DELIMITER
NXTPA:		
	CALL	SSCHK
	MVI	A,1	;COLON FOUND CASE
	STA	CASE
	LDA	TOKEN
	CPI	22
	JZ	P28
	MVI	A,2	;RIGHT PARENTHESIS FOUND CASE
	STA	CASE
	LDA	TOKEN	;LOOK FOR RIGHT PARENTHESIS
	CPI	26
	JZ	P28
	XRA	A
	STA	RESUL
	RET	
P28:	MVI	A,1
	STA	RESUL
	CALL	GTOKN
	RET	
;*
;**********     END OF COMMAND PRIMITIVES     **********
;*
;*
;********************     EXPRESSION TABLE     ********************
;*
;**  STRING-VALUE EXPRESSION  **
STREX:		
	CALL	SSCHK
	CALL	EXPR 	;CHECK FOR EXPRESSION
	LDA	ACTFL	;CONVERT TO STRING VALUE
	ORA	A
	CZ	AC33 
	MVI	A,1
	STA	RESUL
	RET	
;*
;**  NUMERIC-VALUE EXPRESSION  **
NUMEX:		
	CALL	SSCHK
	CALL	EXPR 	;CHECK FOR EXPRESSION
	LDA	ACTFL	;CONVERT TO NUMERIC VALUE
	ORA	A
	CZ	AC34 
	MVI	A,1
	STA	RESUL
	RET	
;*
;**  INTEGER-VALUE EXPRESSION  **
INTEX:		
	CALL	SSCHK
	CALL	EXPR 	;CHECK FOR EXPRESSION
	LDA	ACTFL	;CONVERT TO INTEGER VALUE
	ORA	A
	CZ	AC32 
	MVI	A,1
	STA	RESUL
	RET	
;*
;**  TRUTH-VALUE EXPRESSION  **
TVEXP:		
	CALL	SSCHK
	CALL	EXPR 	;CHECK FOR EXPRESSION
	MVI	A,1	;IN CASE SEMANTIC EXECUTION INHIBITED
	STA	CASE
	LDA	ACTFL	;CONVERT TO TRUTH VALUE; SET X (1) OR Y (0) CASE
	ORA	A
	CZ	AC31 
	MVI	A,1
	STA	RESUL
	RET	
;*
;**  EXPRESSION  **
EXPR:		
	CALL	SSCHK
	CALL	EXPRA	;CHECK FOR EXPRESSION ATOM
X1:	CALL	AC4  	;TEST FOR BINARYOP;STACK CODE IF FOUND
	LDA	RESUL
	CPI	1
	JZ	X5
	LDA	TOKEN	;LOOK FOR APOSTROPHE (NOT)
	CPI	4
	JZ	X3
	CPI	30	;LOOK FOR QUESTION MARK (PATTERN)
	JNZ	X2
	LDA	FLG1
	MOV	B,A
	MVI	A,NOTFL
	CMA	
	ANA	B
	STA	FLG1
	CALL	GTOKN
	JMP	X4
X2:	MVI	A,1
	STA	RESUL
	RET	
X3:	CALL	GTOKN
	CALL	AC2  	;TEST FOR TRUTHOP; COSE T-O-S
	LDA	RESUL
	CPI	1
	JZ	X5
	LDA	TOKEN	;LOOK FOR QUESTION MARK (PATTERN)
	CPI	30
	JNZ	E13
	CALL	GTOKN
	LDA	FLG1
	ORI	NOTFL
	STA	FLG1
X4:	CALL	PATTE	;CHECK FOR PATTERN; PERFORM PATTERN MATCH
	LDA	ACTFL
	ORA	A
	CZ	AC86
	JMP	X1
X5:	CALL	EXPRA	;CHECK FOR SECOND EXPRESSION ATOM
	LDA	ACTFL	;PERFORM OPERATION; RESULT T-O-S
	ORA	A
	CZ	AC43 
	JMP	X1
;*
;**  PATTERN EXPRESSION  **
PATTE:		
	CALL	SSCHK
	LDA	ACTFL	;CONVERT T-O-S TO STRING
	ORA	A
	CZ	AC33 
	LHLD	TOS
	SHLD	TARPT
	CALL	INDNA	;CHECK FOR PATTERN INDIRECTION
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	X7
	CALL	PATAT	;CHECK FOR ONE PATTERN ATOM
	LDA	RESUL
	CPI	1
	JNZ	E21
X6:	CALL	PATAT	;CHECK FOR PATTERN ATOM
	LDA	RESUL
	CPI	1
	JZ	X6
	LDA	ACTFL	;TEST FOR END OF ALL LEVELS OF NAME INDIRECTION
	ORA	A
	CZ	AC110
X7:	MVI	A,1
	STA	RESUL
	RET	
;*
;**  PATTERN ATOM  **
PATAT:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR PERIOD
	CPI	28
	JNZ	X8
	CALL	GTOKN
	LDA	ACTFL	;MINUS ONE T-O-S (ANY NUMBER OF PATTERNS)
	ORA	A
	CZ	AC115
	JMP	X9
X8:	CALL	AC11 	;TEST FOR AN INTEGER LITERAL; STACK IF FOUND
	LDA	RESUL
	CPI	1
	JZ	X9
	XRA	A
	STA	RESUL
	RET	
X9:	CALL	AC7  	;TEST FOR PATTERN CODE(S); INTO PATWRD IF FOUND
	LDA	RESUL
	CPI	1
	JZ	X10
	CALL	AC6  	;TEST FOR A STRING LITERAL; STACK IF FOUND
	LDA	RESUL
	CPI	1
	JNZ	E21
X10:	MVI	A,1
	STA	RESUL
	RET	
;*
;**********     END OF EXPR CONSTRUCTS     **********
;*
;*
;********************     EXPRESSION ATOM TABLE     ********************
;*
;**  EXPRESSION ATOM  **
EXPRA:		
	CALL	SSCHK
	LDA	ACTFL	;ZERO T-O-S (NO. OF UNARYOPS)
	ORA	A
	CZ	AC20 
	CALL	AC8  	;TEST FOR UNARYOP(S); STACK IF FOUND
	LDA	TOKEN	;LOOK FOR LEFT PARENTHESIS
	CPI	25
	JNZ	A2
	CALL	GTOKN
	CALL	EXPR 	;CHECK FOR EXPRESSION
	LDA	TOKEN	;LOOK FOR RIGHT PARENTHESIS
	CPI	26
	JNZ	E12
	CALL	GTOKN
A1:	LDA	ACTFL	;APPLY UNARYOPS TO VALUE; RESULT T-O-S
	ORA	A
	CZ	AC19 
	MVI	A,1
	STA	RESUL
	RET	
A2:	CALL	AC10 	;TEST FOR NUMERIC LITERAL; STACK IF FOUND
	LDA	RESUL
	CPI	1
	JZ	A1
	CALL	AC6  	;TEST FOR A STRING LITERAL; STACK IF FOUND
	LDA	RESUL
	CPI	1
	JZ	A1
	CALL	FUNCT	;CHECK FOR FUNCTION REFERENCE
	LDA	RESUL
	CPI	1
	JZ	A1
	CALL	LVN  	;CHECK FOR LOCAL VARIABLE
	LDA	RESUL
	CPI	1
	JNZ	A3
	LDA	ACTFL	;SEARCH SYMBOL TABLE FOR LVN; VALUE T-O-S
	ORA	A
	CZ	AC81 
	JMP	A1
A3:	CALL	GVN  	;CHECK FOR GLOBAL VARIABLE
	LDA	RESUL	;ERROR, NOT AN EXPRESSION ATOM
	CPI	1
	JNZ	E20
	LDA	ACTFL	;SEARCH GLOBAL FILE FOR GVN; VALUE T-O-S
	ORA	A
	CZ	AC85 
	JMP	A1
;*
;**  VARIABLE  **
GLVN:		
	CALL	SSCHK
	CALL	LVN  	;CHECK FOR LOCAL VARIABLE
	LDA	RESUL
	CPI	1
	JNZ	A4
	LDA	ACTFL	;ONE T-O-S (LOCAL VARIABLE)
	ORA	A
	CZ	AC35 
	JMP	A5
A4:	CALL	GVN  	;CHECK FOR GLOBAL VARIABLE
	LDA	RESUL
	CPI	1
	JNZ	E23
	LDA	ACTFL	;MINUS ONE T-O-S (GLOBAL VARIABLE)
	ORA	A
	CZ	AC70 
A5:	MVI	A,1
	STA	RESUL
	RET	
;*
;**  LOCAL VARIABLE NAME  **
LVN:		
	CALL	SSCHK
	CALL	INDNA	;CHECK FOR LOCAL VARIABLE INDIRECTION
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	A10
	XRA	A
	STA	GLB
	CALL	AC15 	;TEST FOR VARIABLE NAME
	LDA	RESUL
	CPI	1
	JZ	SUBSC
	XRA	A
	STA	RESUL
	RET		;NOT A LOCAL REFERENCE
;*
;**  GLOBAL VARIABLE NAME  **
GVN:		
	CALL	SSCHK
	CALL	INDNA	;CHECK FOR GLOBAL VARIABLE INDIRECTION
	LDA	CASE	;SYNTAX CHECKING ONLY
	CPI	4
	JZ	A10
	LDA	TOKEN	;LOOK FOR CARAT
	CPI	20
	JZ	A6
	XRA	A	;NOT A GLOBAL REFERENCE
	STA	RESUL
	RET	
A6:	CALL	GTOKN
	MVI	A,1
	STA	GLB
	LDA	TOKEN	;LOOK FOR LEFT PARENTHESIS
	CPI	25
	JNZ	A7
	CALL	GTOKN
	CALL	AC5  	;TEST FOR LOCK; CARAT,ZERO T-O-S (NAKED REFERENCE)
	JMP	A8
A7:	CALL	AC15 	;TEST FOR VARIABLE NAME
	LDA	RESUL
	CPI	1
	JNZ	E23
;* SUBSCRIPT LIST PRIMITIVE
SUBSC:	LDA	ACTFL
	ORA	A
	CZ	AC27
	LDA	ACTFL	;ZERO T-O-S (NO. OF SUBSCRIPTS)
	ORA	A
	CZ	AC20 
	LDA	TOKEN	;LOOK FOR LEFT PARENTHESIS
	CPI	25
	JNZ	A9
A75:	CALL	GTOKN
A8:	LDA	ACTFL
	ORA	A
	CZ	AC100
	CALL	EXPR 	;CHECK FOR SUBSCRIPT EXPRESSION
	LDA	ACTFL	;STACK EXPRESSION VALUE AS INTEGER
	ORA	A
	CZ	AC22 
	LDA	TOKEN	;LOOK FOR COMMA (MORE SUBSCRIPTS)
	CPI	21
	JZ	A75
	CPI	26	;LOOK FOR RIGHT PARENTHESIS
	JNZ	E12
	CALL	GTOKN
A9:	LDA	ACTFL	;CHECK END OF ONE OR MORE LEVELS OF NAME INDIRECTION
	ORA	A
	CZ	AC108
	XRA	A
	STA	GLB
A10:	MVI	A,1
	STA	RESUL
	RET	
;*
;**  FUNCTION  **
FUNCT:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR DOLLAR SIGN
	CPI	27
	JZ	A11
	XRA	A	;NOT A FUNCTION OR SPECIAL VARIABLE
	STA	RESUL
	RET	
A11:	CALL	GTOKN
	CALL	AC3  	;GET FUNCTION/SPECIAL VARIABLE NAME
	MVI	A,1
	STA	RESUL
	RET	
;*     AC3 SCANS OFF THE LEFT PARENTHESIS FOR FUNCTIONS; RETURNS WITH
;*     THE SPECIAL VARIABLE VALUE ON THE STACK, OR BRANCHES TO FUNCTION
;*
;**********     END OF EXPRATOM CONSTRUCTS     *****
;*
;*
;********************     FUNCTION TABLE     ********************
;*
;** ASCII FUNCTION
ASCII:	CALL	FSIEX	;CHECK FOR STRING-INTEGER EXPRESSION
	LDA	ACTFL	;STORE ASCII CODE OF POSITION T-O-S
	ORA	A
	CZ	AC36 
	JMP	FEND
;*
;** CHARACTER FUNCTION
CHAR:	LDA	ACTFL	;CHARACTER FUNCTION
	ORA	A
	CZ	AC20 
F1:	CALL	INTEX	;CHECK FOR NEXT (INTEGER) EXPRESSION
	LDA	ACTFL	;CONVERT TO TEXT; STORE NEW STRING T-O-S
	ORA	A
	CZ	AC46 
	LDA	TOKEN	;LOOK FOR COMMA
	CPI	21
	JNZ	F05
	CALL	GTOKN
	JMP	F1
F05:	LDA	ACTFL	;COMPRESS CHARACTER STRING ON STACK
	ORA	A
	CZ	AC104
	JMP	FEND
;*
;** DATA FUNCTION
DATA:	CALL	GLVN 	;CHECK FOR VARIABLE
	LDA	ACTFL	;FIND VARIABLE; RETURN CHARACTERIZATION
	ORA	A
	CZ	AC38 
	JMP	FEND
;*
;** EXTRACT FUNCTION
EXTRA:	CALL	FSIEX	;CHECK FOR STRING-INTEGER EXPRESSION
	LDA	RESUL
	CPI	1
	JNZ	E22
	CALL	FIEXP	;CHECK FOR THIRD (INTEGER) EXPRESSION
	LDA	ACTFL	;EXTRACT CHARACTERS; STORE T-O-S
	ORA	A
	CZ	AC40 
	JMP	FEND
;*
;** FIND FUNCTION
FIND:	CALL	FSSEX	;CHECK FOR STRING-STRING-INTEGER EXPR
	LDA	ACTFL	;PERFORM SEARCH; RETURN NUMBER T-O-S
	ORA	A
	CZ	AC41 
	JMP	FEND
;*
;** JUSTIFY FUNCTION
JUSTI:	CALL	EXPR 	;CHECK FOR EXPRESSION TO BE JUSTIFIED
	CALL	FIEXP	;CHECK FOR SECOND (INTEGER) EXPRESSION
	LDA	RESUL
	CPI	1
	JNZ	E22
	CALL	FIEXP	;CHECK FOR THIRD (INTEGER) EXPRESSION
	LDA	ACTFL	;JUSTIFY 1ST EXPR ACCORDING TO 2ND (AND 3RD) EXPR
	ORA	A
	CZ	AC21 
	JMP	FEND
;*
;** LENGTH FUNCTION
LENGT:	CALL	STREX	;CHECK FOR (STRING) EXPRESSION
	LDA	ACTFL	;RETURN LENGTH OF STRING T-O-S
	ORA	A
	CZ	AC42 
	JMP	FEND
;*
;** NEXT FUNCTION
NEXT:	MVI	A,1
	STA	DN
	CALL	GLVN 	;CHECK FOR VARIABLE
	LDA	ACTFL	;FIND NEXT VARIABLE SUBSCRIPT; RETURN VALUE
	ORA	A
	CZ	AC50 
	XRA	A
	STA	DN
	JMP	FEND
;*
;** ORDER FUNCTION
ORDER:	MVI	A,1
	STA	DOR
	CALL	GLVN 	;CHECK FOR VARIABLE
	LDA	ACTFL	;FIND NEXT VARIABLE SUBSCRIPT; RETURN VALUE
	ORA	A
	CZ	AC50 
	XRA	A
	STA	DOR
	JMP	FEND
;*
;** PIECE FUNCTION
PIECE:	CALL	FSSEX	;CHECK FOR STRING-STRING-INTEGER EXPR
	LDA	RESUL
	CPI	1
	JNZ	E22
	CALL	FIEXP	;CHECK FOR FOURTH (INTEGER) EXPRESSION
	LDA	ACTFL	;GET PIECES; PLACE RESULT T-O-S
	ORA	A
	CZ	AC45 
	JMP	FEND
;*
;** RANDOM FUNCTION
RANDO:	CALL	INTEX	;CHECK FOR INTEGER EXPRESSION
	LDA	ACTFL	;COMPUTE "RANDOM" INTEGER; STORE VALUE T-O-S
	ORA	A
	CZ	AC52 
	JMP	FEND
;*
;** SELECT FUNCTION
SELEC:	CALL	AC12 	;SAVE LINACT AND COMACT
F2:	CALL	TVEXP	;CHECK FOR BOOLEAN EXPRESSION
	LDA	TOKEN	;LOOK FOR COLON
	CPI	22
	JNZ	E18
	CALL	GTOKN
	LDA	ACTFL
	ORA	A
	JNZ	F25
	LDA	CASE	;BOOLEAN TRUE
	CPI	1
	JZ	F3
	LDA	ACTFL	;TURN COMACT ON
	ORA	A
	CZ	AC29 
F25:	CALL	EXPR 	;CHECK FOR SECOND EXPRESSION
	CALL	AC13 	;TURN COMACT OFF
	JMP	F4
F3:	CALL	EXPR 	;CHECK FOR RESULT EXPRESSION
	LDA	ACTFL	;TURN LINACT ON
	ORA	A
	CZ	AC105
F4:	LDA	TOKEN	;LOOK FOR COMMA
	CPI	21
	JNZ	F45
	CALL	GTOKN
	JMP	F2   	;MOVE EXPRESSIONS
F45:	CALL	AC14 	;RESTORE LINACT AND COMACT
	JMP	FEND
;*
;** TEXT FUNCTION
TEXT:	CALL	LINOF	;CHECK FOR LINE NUMBER
	LDA	RESUL
	CPI	1
	JNZ	F5
	LDA	ACTFL	;RETURNS NTH LINE OF ROUTINE
	ORA	A
	CZ	AC84 
	JMP	FEND
F5:	CALL	LINER	;CHECK FOR LABEL[+OFFSET]
	LDA	ACTFL	;RETURNS LINE TEXT OF LABEL[+OFFSET]
	ORA	A
	CZ	AC74 
	JMP	FEND
;*
;** VIEW FUNCTION
VIEW:	JMP	E30  	;NOT IMPLEMENTED
	JMP	FEND
;*
;** Z (ESCAPE) FUNCTIONS
;*     IMPLEMENTATION SPECIFIC FUNCTIONS ARE ADDED HERE
ZGRA:	CALL	INTEX	;CHECK FOR INTEGER EXPRESSION
	LDA	ACTFL	;GET ARG BYTE; STORE T-0-S AS INTEGER
	ORA	A
	CZ	AC122
	JMP	FEND
;*
;**********     END OF FUNCTIONS     **********
;*
;*
;********************     FUNCTION PRIMITIVE TABLE     ********************
;*
;** TWO STRINGS, THEN INTEGER EXPRESSION PRIMITIVE
FSSEX:		
	CALL	SSCHK
	CALL	STREX	;CHECK FOR 1ST (STRING) EXPRESSION
	LDA	TOKEN	;LOOK FOR COMMA
	CPI	21
	JNZ	E22
	CALL	GTOKN
;*
;** STRING THEN INTEGER EXPRESSION PRIMITIVE
FSIEX:		
	CALL	SSCHK
	CALL	STREX	;CHECK FOR STRING EXPRESSION
;*
;** INTEGER EXPRESSION PRIMITIVE
FIEXP:		
	CALL	SSCHK
	LDA	TOKEN	;LOOK FOR COMMA
	CPI	21
	JZ	FP1
	XRA	A
	STA	RESUL
	RET	
FP1:	CALL	GTOKN
	CALL	INTEX	;CHECK FOR ITEGER EXPRESSION
	MVI	A,1
	STA	RESUL
	RET	
;*
;** FUNCTION ENDING PRIMITIVE
FEND:	LDA	TOKEN	;LOOK FOR RIGHT PARENTHESIS
	CPI	26
	JNZ	E12
	CALL	GTOKN
	MVI	A,1
	STA	RESUL
	RET	
;*
;**********     END OF FUNCTION PRIMITIVES     **********
;*
;** END OF INTERP.TDL
;* BEGINNING OF TDL ACTION ROUTINES
;*
AC1:			;CHECK FOR ARGUMENT LEVEL INDIRECTION
	CALL	SSCHK
	XRA	A
	STA	RESUL
	LDA	INDFL
	CPI	2
	JNZ	A0011
	LDA	TOKEN
	CPI	40
	JNZ	E24
	CALL	INDRE	;RETURN FROM INDIRECTION
	MVI	A,1
	STA	RESUL
A0011:	RET	
;*
;*
AC2:		
	CALL	SSCHK
	XRA	A	;CHECK FOR TRUTH OP
	STA	RESUL
	LDA	TOKEN
	CPI	11
	JC	A0022
	CPI	17
	JC	$+6
	JNZ	A0022
	LDA	ACTFL
	ORA	A
	JNZ	A0021
	LDA	TOKEN
	CPI	14
	JC	$+6
	JNZ	A0020
	CALL	AC34 	;CONVERT OP #1 TO REAL EXPR
	JMP	A002A
A0020:	CALL	AC33 	;CONVERT OP #1 TO STRING
A002A:	LDA	TOKEN	;SET NOT
	ADI	50
	STA	TOKEN
	LXI	H,TOKEN	;SAVE OP ON STACK
	MVI	B,1
	CALL	PUSHT
A0021:	MVI	A,1
	STA	RESUL
	CALL	GTOKN	;GET NEXT TOKEN
A0022:	RET	
;*
;*
AC3:			;CHECK FOR FUNCTION AND SPECIAL VARS
	CALL	SSCHK
	LHLD	INDX	;SAVE INDX
	SHLD	PTR1
A0031:	LDA	TOKEN	;MOVE PAST NAME
	CPI	2
	JNZ	A0032
	CALL	GTOKN
	JMP	A0031
A0032:	LDA	TOKEN	;CHECK FOR (
	CPI	25
	JZ	A0033
	MVI	A,2	;SPECIAL VARIABLE
	STA	FNC
	JMP	A0034
A0033:	MVI	A,1	;FUNCTION
	STA	FNC
A0034:	LHLD	PTR1	;PUT INDX BACK
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	CALL	GTCOM
	RET	
;*
;*
HOROL:	LDA	ACTFL
	ORA	A
	JNZ	A0037
	CALL	GETTI	;GET CURRENT TIME
	LXI	H,DAYS 	;SAVE DAYS
	CALL	ITS
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I1   	;GET DAYS LENGTH
	MVI	B,1
	CALL	POPIT
	MVI	A,','  	;PUSH HOROLOG DELIMITER
	CALL	CPUSH
	LXI	H,SECS 	;SAVE SECONDS
	CALL	ITS
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I2   	;GET SECONDS LENGTH
	MVI	B,1
	CALL	POPIT
	LDA	I1	;ADD SECONDS AND DAYS LENGTH
	LXI	H,I2
	ADD	M
	STA	I1
	LXI	H,I1   	;ALLOW FOR ,
	INR	M
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	RET	
;*
IO:	LDA	IODVC	;$IO
	STA	IT
	JMP	A0036
;*
JOB:	LDA	JOBNM	;$JOB
	STA	IT
	JMP	A0036
;*
STORA:	LDA	ACTFL
	ORA	A
	JNZ	A0037
	CALL	GARBG
	LHLD	SYMEN	;$STORAGE
	SHLD	TPP
	LHLD	PRGEN
	XCHG	
	LHLD	TPP
	CALL	PSUB
	SHLD	TPP
	CALL	PTS
	RET	
;*
TEST:	LDA	SWIF	;$TEST
	CPI	2
	JZ	E3
	STA	IT
	JMP	A0036
;*
X:	LXI	D,INT1	;$X
	LHLD	DEVX
	XCHG	
	CALL	SETI
	JMP	A0035
;*
Y:	LXI	D,INT1	;$Y
	LHLD	DEVY
	XCHG	
	CALL	SETI
	JMP	A0035
;*
ZNAME:	LDA	ACTFL	;$ZNAME
	ORA	A
	JNZ	A0037
	XRA	A
	STA	IT
	LXI	H,PRG
	SHLD	PTR
ZN1:	LHLD	PTR
	MOV	A,M
	CPI	BLANK
	JZ	ZN2
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR
	INX	H
	SHLD	PTR
	LXI	H,IT
	INR	M
	JMP	ZN1
ZN2:	LXI	H,IT
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	RET	
;*
A0035:	LDA	ACTFL
	ORA	A
	JNZ	A0037
	LXI	H,INT1
	CALL	ITS
	RET	
A0036:	LDA	ACTFL
	ORA	A
	JNZ	A0037
	LDA	IT
	CALL	CTS
A0037:	RET	
;*
;*
AC4:			;BINARY OPERATOR
	CALL	SSCHK
	XRA	A
	STA	RESUL
	LDA	TOKEN
	CPI	5
	JC	A0044
	CPI	18
	JC	$+6
	JNZ	A0044
	LDA	ACTFL
	ORA	A
	JNZ	A0043
	LDA	TOKEN
	CPI	14
	JC	$+6
	JNZ	A0041
	CALL	AC34 	;CONVERT OP #1 TO NUMBER
	JMP	A0042
A0041:	CALL	AC33 	;CONVERT OP #1 TO STRING
A0042:	LXI	H,TOKEN	;SAVE OP
	MVI	B,1
	CALL	PUSHT
A0043:	MVI	A,1
	STA	RESUL
	CALL	GTOKN
A0044:	RET	
;*
AC5:			;NAKED REFERENCE
	CALL	SSCHK
	LDA	LOCKS
	CPI	1
	JZ	E36
	LDA	ACTFL
	ORA	A
	JNZ	A0051
	MVI	A,1
	STA	NR
	XRA	A
	CALL	CPUSH
	CALL	AC27
	XRA	A
	CALL	CPUSH
A0051:	RET	
;*
;*
AC6:		
	CALL	SSCHK
	XRA	A	;TEST FOR STRING LITERAL
	STA	RESUL
	LDA	TOKEN
	CPI	23
	JNZ	A0064
	MVI	A,1	;IT IS A STRING
	STA	RESUL
	XRA	A	;INITIALIZE CHARACTER COUNT
	STA	NUMBR
	LDA	PF
	ORA	A
	JZ	A0061
	LDA	ACTFL
	ORA	A
	JNZ	A0061
	LXI	H,INT1
	CALL	STI
	LHLD	TOS
	LXI	D,INT1
	CALL	SETI
	LHLD	TOS
	LXI	D,INTLN
	DAD	D
	SHLD	TOS
	SHLD	TPP
	LXI	D,INTLN
	DAD	D
	SHLD	TOS
A0061:	CALL	GTOKN
	LDA	TOKEN
	CPI	23
	JNZ	A0062
	CALL	GTOKN
	LDA	TOKEN	;IS IT END OF STRING?
	CPI	23
	JNZ	A0063
	LDA	ACTFL
	ORA	A
	JNZ	A0061
	MVI	A,'"'
	CALL	CPUSH
	LXI	H,NUMBR
	INR	M
	JMP	A0061
A0062:	LDA	TOKEN	;IF GRAPHIC CHARACTER, PUSH IT
	CPI	1
	JC	E18
	CPI	36
	JC	$+6
	JNZ	E18
	LDA	ACTFL
	ORA	A
	JNZ	A0061
	LHLD	INDX
	MVI	B,1
	CALL	PUSHT
	LXI	H,NUMBR
	INR	M
	JMP	A0061
A0063:	LDA	ACTFL
	ORA	A
	JNZ	A0064
	LDA	PF
	ORA	A
	JZ	A006A
	LXI	H,INT1
	LDA	NUMBR
	CALL	CTI
	LHLD	TPP
	LXI	D,INT1
	CALL	SETI
	JMP	A0064
A006A:	LXI	H,NUMBR	;SAVE LENGTH OF STRING
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
A0064:	XRA	A
	STA	PF
	RET	
;*
AC7:			;CHECK FOR PATATOM
	CALL	SSCHK
	XRA	A
	STA	RESUL
	STA	PATF
A0070:	LDA	TOKEN
	CPI	2
	JZ	A0071
	MVI	A,1	;SET FLAG FOR AC6
	STA	PF
	JMP	A007I
A0071:	LHLD	INDX
	MOV	A,M
	CPI	'U'
	JNZ	A0072
	LDA	PATF
	ORI	1
	STA	PATF
	JMP	A0078
A0072:	LHLD	INDX
	MOV	A,M
	CPI	'L'
	JNZ	A0073
	LDA	PATF
	ORI	2
	STA	PATF
	JMP	A0078
A0073:	LHLD	INDX
	MOV	A,M
	CPI	'A'
	JNZ	A0074
	LDA	PATF
	ORI	4
	STA	PATF
	JMP	A0078
A0074:	LHLD	INDX
	MOV	A,M
	CPI	'N'
	JNZ	A0075
	LDA	PATF
	ORI	8
	STA	PATF
	JMP	A0078
A0075:	LHLD	INDX
	MOV	A,M
	CPI	'P'
	JNZ	A0076
	LDA	PATF
	ORI	16
	STA	PATF
	JMP	A0078
A0076:	LHLD	INDX
	MOV	A,M
	CPI	'C'
	JNZ	A0077
	LDA	PATF
	ORI	32
	STA	PATF
	JMP	A0078
A0077:	LHLD	INDX
	MOV	A,M
	CPI	'E'
	JNZ	E21
	LDA	PATF
	ORI	64
	STA	PATF
A0078:	CALL	GTOKN
	LDA	TOKEN	;GET NEXT ONE
	CPI	2
	JZ	A0071
	MVI	A,1
	STA	RESUL
	LDA	ACTFL
	ORA	A
	JNZ	A007I
	LXI	H,INT1
	CALL	STI
	LHLD	TOS
	LXI	D,INT1
	CALL	SETI
	LHLD	TOS
	LXI	D,INTLN
	DAD	D
	SHLD	TOS
	SHLD	TPP
	XRA	A
	STA	COUNT
	LXI	D,INTLN
	DAD	D
	SHLD	TOS
	LDA	PATF
	ANI	64
	JZ	A0079
	LDA	PATF	;ONLY SET E BIT IF AN E
	MOV	B,A
	MVI	A,63
	CMA	
	ANA	B
	STA	PATF
	JMP	A007G
A0079:	LDA	PATF
	ANI	1
	JZ	A007A
	LDA	PATF
	ANI	2
	JZ	A007A
	LDA	PATF	;BOTH L AND U SET SO SET A
	MOV	B,A
	MVI	A,3
	CMA	
	ANA	B
	ORI	4
	STA	PATF
A007A:	LDA	PATF
	ANI	1
	JZ	A007B
	MVI	A,'U'
	CALL	CPUSH
	LXI	H,COUNT
	INR	M
A007B:	LDA	PATF
	ANI	2
	JZ	A007C
	MVI	A,'L'
	CALL	CPUSH
	LXI	H,COUNT
	INR	M
A007C:	LDA	PATF
	ANI	4
	JZ	A007D
	MVI	A,'A'
	CALL	CPUSH
	LXI	H,COUNT
	INR	M
A007D:	LDA	PATF
	ANI	8
	JZ	A007E
	MVI	A,'N'
	CALL	CPUSH
	LXI	H,COUNT
	INR	M
A007E:	LDA	PATF
	ANI	16
	JZ	A007F
	MVI	A,'P'
	CALL	CPUSH
	LXI	H,COUNT
	INR	M
A007F:	LDA	PATF
	ANI	32
	JZ	A007G
	MVI	A,'C'
	CALL	CPUSH
	LXI	H,COUNT
	INR	M
A007G:	LDA	PATF
	ANI	64
	JZ	A007H
	MVI	A,'E'
	CALL	CPUSH
	LXI	H,COUNT
	INR	M
A007H:	LXI	H,INT1
	LDA	COUNT
	CALL	CTI
	MOV	A,M
	XRI	0F0H
	MOV	M,A
	LHLD	TPP
	LXI	D,INT1
	CALL	SETI
A007I:	RET	
;*
;*
AC8:			;UNARY OPERATOR
	CALL	SSCHK
	LDA	ACTFL
	ORA	A
	JNZ	A0081
	LXI	H,IT   	;GET UNARY OP COUNT
	MVI	B,1
	CALL	POPIT
A0081:	LDA	TOKEN
	CPI	4
	JC	A0083
	CPI	6
	JC	$+6
	JNZ	A0083
	LDA	ACTFL
	ORA	A
	JNZ	A0082
	LXI	H,TOKEN	;SAVE UNARY OP
	MVI	B,1
	CALL	PUSHT
A0082:	LXI	H,IT   	;INCREMENT COUNT
	INR	M
	CALL	GTOKN
	JMP	A0081
A0083:	LDA	ACTFL
	ORA	A
	JNZ	A0084
	LXI	H,IT   	;SAVE COUNT
	MVI	B,1
	CALL	PUSHT
A0084:	RET	
;*
;*
AC9:			;CHECK FOR NAME LEVEL INDIRECTION
	CALL	SSCHK
	MVI	A,1
	STA	IT
	MVI	A,4
	STA	CASE
	LDA	TOKEN	;CHECK FOR COMMA
	CPI	21
	JZ	A0091
	CPI	31	;CHECK FOR SPACE
	JZ	A0091
	CPI	38	;CHECK FOR EOL
	JZ	A0091
	CPI	40	;CHECK FOR EOI
	JNZ	A0092
A0091:	MVI	A,2
	STA	IT
A0092:	LDA	ACTFL
	ORA	A
	JZ	A0094
	LDA	IT
	CPI	2
	JZ	A0093
	MVI	A,255	;SET FLAG FOR AC16
	STA	TOKEN
	MVI	A,3
	STA	CASE
A0093:	RET	
A0094:	CALL	AC33
	LXI	H,TYPE
	MVI	B,1
	CALL	POPIT
A009A:	LXI	H,SLENG
	MVI	B,1
	CALL	POPIT
	LDA	SLENG
	STA	N
	LHLD	TOS
	SHLD	PTR
	XRA	A
	STA	I1
A0095:	LDA	N
	ORA	A
	JZ	A0096
	LHLD	PTR
	DCX	H
	SHLD	PTR
	LXI	H,N
	DCR	M
	LHLD	PTR
	MOV	A,M
	CPI	EOL
	JZ	E24
	MOV	A,M
	CPI	EOI
	JZ	E24
	MOV	A,M
	CPI	BLANK
	JZ	A009B
	MOV	A,M
	CPI	'"'
	JNZ	A0095
	MVI	A,1	;TOGGLE I1 (INSIDE A STRING = 1)
	LXI	H,I1
	SUB	M
	STA	I2
	STA	I1
	JMP	A0095
A009B:	LDA	I1	;QUOTE NOT INSIDE A STRING
	ORA	A
	JZ	E24
	JMP	A0095
A0096:	LXI	H,SLENG	;SAVE INDIRECT STRING
	INR	M
	LXI	H,LEVEL
	INR	M
	LDA	LEVEL
	CPI	MXLVL
	JZ	E32
	MVI	A,EOI
	CALL	CPUSH
	LXI	H,SLENG
	MVI	B,1
	CALL	PUSHT
	LXI	H,INDX
	MVI	B,2
	CALL	PUSHT
	LHLD	PTR
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	LDA	IT
	CPI	2
	JZ	A0097
	LDA	TOKEN	;CHECK FOR NUMBERS AND LETTERS
	CPI	4
	JC	A0097
	CPI	19	;CHECK FOR PER CENT
	JZ	A0097
	CPI	20	;CHEC2 FOR CIRCUMFLEX
	JNZ	E24
A0097:	LXI	H,INDFL
	MVI	B,1
	CALL	PUSHT
	LDA	IT
	STA	INDFL
	MVI	A,3
	LXI	H,IT
	SUB	M
	STA	CASE
	RET	
;*
;*
AC10:			;CHECK FOR NUMLIT
	CALL	SSCHK
	XRA	A	;MINUS FLAG
	STA	SGN1
	MVI	A,255	;SET DIGIT COUNT
	STA	I1
	XRA	A	;IT=1 IF IT'S A NUMBER
	STA	IT
	STA	I2	;SIZE OF INTEGER PART
	STA	I3	;SIZE OF DECIMAL FRACTION
	LDA	FLG1
	ANI	STRNG
	JZ	A0100
	LDA	SLENG	;IF FROM STRING BET DIGIT COUNT
	STA	I1
A0100:	MVI	A,TRUE	;DELETE LEADING ZEROS
	STA	DELET
	LHLD	TOS	;SAVE START OF INTEGER
	SHLD	PTRX1
	CALL	AC11 	;CHECK FOR INTLIT
	LDA	RESUL
	CPI	FALSE
	JZ	A101A
	LDA	ACTFL
	ORA	A
	JNZ	A0101
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I2   	;GET SIZE OF INTEGER PART
	MVI	B,1
	CALL	POPIT
A0101:	MVI	A,1	;IT'S A NUMLIT
	STA	IT
A101A:	LHLD	TOS	;SAVE DECIMAL PLACE
	SHLD	PTRX2
	LDA	TOKEN	;CHECK IF #.
	CPI	28
	JNZ	A0103
	CALL	GTOKN
	LXI	H,I1
	DCR	M
	LDA	I1
	ORA	A
	JZ	A010E
	LDA	ACTFL
	ORA	A
	JNZ	A101B
	LDA	I2
	CPI	1
	JNZ	A101E
	LHLD	PTRX1
	MOV	A,M
	CPI	'0'
	JNZ	A101E
	LHLD	TOS
	DCX	H
	SHLD	TOS
	XRA	A
	STA	I2
	LHLD	PTRX2
	DCX	H
	SHLD	PTRX2
A101E:	MVI	A,'.'  	;ADD DECIMAL PLACE
	CALL	CPUSH
A101B:	CALL	AC11 	;CHECK IF #.#
	LDA	RESUL
	CPI	FALSE
	JZ	A0102
	MVI	A,TRUE	;IT'S A NUMLIT
	STA	IT
	LDA	ACTFL
	ORA	A
	JNZ	A0103
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I3   	;GET COUNT OF DECIMAL DIGITS
	MVI	B,1
	CALL	POPIT
A101C:	LXI	H,CHR  	;GET RID OF TRAILING ZEROS
	MVI	B,1
	CALL	POPIT
	LDA	CHR
	CPI	'0'
	JNZ	A101D
	LXI	H,I3
	DCR	M
	LDA	I3
	ORA	A
	JNZ	A101C
	JMP	A0102
A101D:	LXI	H,CHR  	;PUT LAST DIGIT BACK
	MVI	B,1
	CALL	PUSHT
	JMP	A0103
A0102:	LDA	ACTFL
	ORA	A
	JNZ	A0103
	LHLD	TOS	;GET RID OF DECIMAL PLACE
	DCX	H
	SHLD	TOS
A0103:	LDA	SGN1
	CPI	1
	JZ	A010E
	LDA	IT
	CPI	TRUE
	JNZ	A010G
	LHLD	INDX	;CHECK FOR EXPONENT
	MOV	A,M
	CPI	'E'
	JNZ	A010E
	CALL	GTOKN
	LXI	H,I1
	DCR	M
	LDA	I1
	ORA	A
	JZ	A010E
	LDA	TOKEN	;CHECK FOR E+
	CPI	5
	JZ	A0104
	CPI	6
	JNZ	A0105
	MVI	A,1	;SET MINUS FLAG
	STA	SGN1
A0104:	LXI	H,I1
	DCR	M
	LDA	I1
	ORA	A
	JZ	A010E
	CALL	GTOKN
A0105:	MVI	A,TRUE
	STA	DELET
	CALL	AC11 	;GET EXPONENT
	LDA	RESUL
	ORA	A
	JZ	A010I
	LDA	ACTFL
	ORA	A
	JNZ	A010G
	CALL	STC0	;GET EXPONENT AS CHARACTER
	STA	I1   
	LDA	RESUL	;EXPONENT TOO BIG
	CPI	FALSE
	JZ	E26
	LDA	I1	;EXPONENT TOO BIG
	CPI	99
	JC	$+6
	JNZ	E26
	LDA	I3
	ORA	A
	JNZ	A0106
	LDA	I2
	ORA	A
	JZ	A010E
	CPI	1
	JNZ	A0106
	LHLD	PTRX1
	MOV	A,M
	CPI	'0'
	JZ	A010E
A0106:	LDA	SGN1	;JUMP IF EXPONENT IS < 0
	CPI	1
	JZ	A010A
	LHLD	PTRX2	;PTR1 AT DECIMAL PLACE
	SHLD	PTRX1
	INX	H
	SHLD	PTRX2
	LDA	I2	;INCLUDE I1 DIGITS IN INTEGER PART
	LXI	H,I1
	ADD	M
	STA	I2
	LDA	I1	;JUMP IF EXP IS < # OF FRACTION DIGITS
	LXI	H,I3
	CMP	M
	JC	A0109
	LXI	H,I2
	CMP	M
	JNZ	A0107
A1065:	LDA	I3
	ORA	A
	JZ	A0107
	LHLD	PTRX2
	MOV	A,M
	CPI	'0'
	JNZ	A0107
	INX	H
	SHLD	PTRX2
	LXI	H,I3
	DCR	M
	LXI	H,I2
	DCR	M
	LXI	H,I1
	DCR	M
	JMP	A1065
A0107:	LHLD	PTRX1	;SHIFT FRACTION OVER DP
	XCHG	
	LHLD	PTRX2
	LDA	I3
	CALL	SHFD
	LDA	I1	;AND ADD I1-I3 ZEROS
	LXI	H,I3
	SUB	M
	STA	I1
A108A:	LDA	I1
	ORA	A
	JZ	A108B
	MVI	A,'0'
	CALL	CPUSH
	LXI	H,I1
	DCR	M
	JMP	A108A
A108B:	XRA	A
	STA	I3
	JMP	A010E
A0109:	LDA	I3
	LXI	H,I1
	SUB	M
	STA	I3
A109A:	LHLD	PTRX2
	MOV	A,M
	LHLD	PTRX1
	MOV	M,A
	INX	H
	SHLD	PTRX1
	LHLD	PTRX2
	INX	H
	SHLD	PTRX2
	LXI	H,I1
	DCR	M
	LDA	I1
	ORA	A
	JNZ	A109A
	LHLD	PTRX1
	MVI	M,'.'
	JMP	A010E
A010A:	LDA	I1
	ORA	A
	JZ	A010E
	LDA	I2	;JUMP IS INTEGER DIGITS < EXP
	LXI	H,I1
	CMP	M
	JC	A010B
	LHLD	PTRX2
	SHLD	PTRX1
	DCX	H
	SHLD	PTRX2
	LDA	I1
	STA	IXT
	LDA	I3
	ORA	A
	JNZ	A10A5
	XRA	A
	CALL	CPUSH
A10A5:	LHLD	PTRX2
	MOV	A,M
	LHLD	PTRX1
	MOV	M,A
	DCX	H
	SHLD	PTRX1
	LHLD	PTRX2
	DCX	H
	SHLD	PTRX2
	LXI	H,IXT
	DCR	M
	LDA	IXT
	ORA	A
	JNZ	A10A5
	LHLD	PTRX1
	MVI	M,'.'
	LDA	I2
	LXI	H,I1
	SUB	M
	STA	I2
	JMP	A010D
A010B:	LHLD	PTRX1
	INX	H
	SHLD	PTRX
	XCHG		;SHIFT FRACTION OVER DP
	LHLD	PTRX1
	LDA	I2
	CALL	SHFU
	LHLD	PTRX
	SHLD	PTRX2
	LXI	H,I3
	ADD	M
	STA	IXT
	LDA	I1
	LXI	H,I2
	SUB	M
	STA	I4
	LHLD	PTRX2
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTRX2
	XCHG	
	LDA	IXT
	CALL	SHFU
	LHLD	PTRX1
	MVI	M,'.'
A010C:	LHLD	PTRX1
	INX	H
	SHLD	PTRX1
	MVI	M,'0'	;ADD ZEROS AFTER DP
	LXI	H,I4
	DCR	M
	LDA	I4
	ORA	A
	JNZ	A010C
	XRA	A
	STA	I2
A010D:	LDA	I3
	LXI	H,I1
	ADD	M
	STA	I3
	ORA	A
	JNZ	A101C
;*
A010E:	LDA	ACTFL
	ORA	A
	JNZ	A010G
	LDA	I3
	ORA	A
	JZ	A010F
	LXI	H,I3   	;INCLUDE DP
	INR	M
A010F:	LDA	I3	;TOTAL SIZE
	LXI	H,I2
	ADD	M
	STA	I3
	ORA	A
	JNZ	A010H
	MVI	A,'0'
	CALL	CPUSH
	MVI	A,1
	STA	I3
A010H:	LXI	H,I3
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
A010G:	LDA	IT
	STA	RESUL
	RET	
A010I:	LDA	FLG1
	ANI	STRNG
	JZ	E26
	JMP	A010E
;*
;*
AC11:			;INTERGER LITERAL
	CALL	SSCHK
	LDA	FLG1
	ANI	STRNG
	JNZ	A0110
	MVI	A,255	;SET DIGIT COUNT
	STA	I1
A0110:	XRA	A
	STA	N
	MVI	A,FALSE
	STA	RESUL
	LDA	I1
	ORA	A
	JZ	A0113
	LDA	TOKEN	;CHECK FOR DIGIT
	CPI	3
	JNZ	A0113
	MVI	A,TRUE	;IT IS A DIGIT
	STA	RESUL
A0111:	LDA	I1
	ORA	A
	JZ	A0112
	LDA	DELET
	CPI	FALSE
	JZ	A011B
	LHLD	INDX
	MOV	A,M
	CPI	'0'
	JZ	A011C
	MVI	A,FALSE
	STA	DELET
A011B:	LDA	ACTFL
	ORA	A
	JNZ	A011A
	LHLD	INDX
	MVI	B,1
	CALL	PUSHT
A011A:	LXI	H,N
	INR	M
A011C:	LXI	H,I1
	DCR	M
	CALL	GTOKN
	LDA	TOKEN
	CPI	3
	JZ	A0111
A0112:	LDA	ACTFL
	ORA	A
	JNZ	A0113
	LDA	N
	ORA	A
	JNZ	A011D
	MVI	A,'0'
	CALL	CPUSH
	LXI	H,N
	INR	M
A011D:	LXI	H,N
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
A0113:	MVI	A,FALSE
	STA	DELET
	RET	
;*
;*
AC12:			;SAVE ACTFL
	LDA	ACTFL
	STA	SVACT
	STA	DSF
	ORA	A
	JZ	A0121
	MVI	A,2
	STA	ACTFL
A0121:	RET	
;*
;*
AC13:			;SET COMACT FALSE FOR $SELECT
	LDA	ACTFL
	MOV	B,A
	MVI	A,1
	CMA	
	ANA	B
	STA	ACTFL
	RET	
;*
;*
AC14:			;RESTORE ACTFL
	LDA	DSF
	ORA	A
	JZ	E35
	LDA	SVACT
	STA	ACTFL
	RET	
;*
;*
AC15:		
	CALL	SSCHK
	LDA	TOKEN	;CHECK FOR A NAME LITERAL
	CPI	2
	JZ	A0151
	CPI	19
	JZ	A0151
	XRA	A	;NOT A NAME
	STA	RESUL
	RET	
A0151:	MVI	A,1	;IT IS A NAME
	STA	RESUL
	XRA	A
	STA	NLENG
	LHLD	TOS
	SHLD	NAME
A0152:	LDA	ACTFL
	ORA	A
	JNZ	A0153
	LDA	NLENG
	CPI	NAMLN-1
	JZ	A0153
	LHLD	INDX 	;PUSH THE CHARACTER
	MVI	B,1
	CALL	PUSHT
	LXI	H,NLENG
	INR	M
A0153:	CALL	GTOKN	;GET NEXT TOKEN VALUE
	LDA	TOKEN
	CPI	2
	JC	A0154
	CPI	3
	JC	$+6
	JNZ	A0154
	JMP	A0152
A0154:	LDA	ACTFL
	ORA	A
	JNZ	A0155
	MVI	A,DELIM
	CALL	CPUSH
	LXI	H,NLENG
	INR	M
	MVI	B,1	;SAVE NAME LENGTH
	CALL	PUSHT
A0155:	RET	
;*
;*
AC16:			;CHECK FOR NAME INDIR DURING ARG INDIR
	CALL	SSCHK
	MVI	A,1
	STA	CASE
	LDA	ACTFL
	ORA	A
	JZ	A0161
	LDA	TOKEN
	CPI	255
	JNZ	A0161
	MVI	A,4
	STA	CASE
	LHLD	INDX
	DCX	H
	SHLD	INDX
	CALL	GTOKN
A0161:	RET	
;*
;*
AC17:			;CHECK FOR INTLIT AS LABEL
	CALL	SSCHK
	LDA	TOKEN
	CPI	3
	JZ	A0171
	XRA	A	;NOT A DIGIT
	STA	RESUL
	RET	
A0171:	MVI	A,1
	STA	RESUL
	XRA	A
	STA	COUNT
A0172:	LDA	ACTFL
	ORA	A
	JNZ	A0173
	LDA	COUNT
	CPI	8
	JZ	A0173
	LHLD	INDX 	;PUSH DIGIT
	MVI	B,1
	CALL	PUSHT
	LXI	H,COUNT
	INR	M
A0173:	CALL	GTOKN
	LDA	TOKEN
	CPI	3
	JZ	A0172
	LDA	ACTFL
	ORA	A
	JNZ	A0174
	MVI	A,DELIM
	CALL	CPUSH
	LXI	H,COUNT
	INR	M
	MVI	B,1
	CALL	PUSHT
A0174:	RET	
;*
;*
AC18:			;RESET THE LOCK SWITCH
	CALL	SSCHK
A0181:	LDA	ACTFL
	ORA	A
	JNZ	A0186
	MVI	A,1	;SET FLAG FOR AC47
	STA	SETF
	LXI	H,TYPE 	;LOCAL (1) OR GLOBAL (-1)
	MVI	B,1
	CALL	POPIT
	LXI	H,IT   	;# OF SUBSCRIPTS
	MVI	B,1
	CALL	POPIT
	LXI	H,PTR3
	MVI	B,2
	CALL	POPIT
	LHLD	TOS
	SHLD	TPP
	LHLD	PTR3
	XCHG	
	LHLD	TPP
	CALL	PSUB
	DCX	H
	SHLD	TPP
A1825:	LHLD	TPP	;NAME LENGTH
	MOV	A,M
	STA	NLENG
	DCX	H
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TPP
	MOV	A,M
	STA	COUNT
	ORA	A
	JNZ	A1835
	SHLD	SETBS
A1835:	LXI	H,COUNT	;INCREMENT COUNT OF SET ITEMS
	INR	M
	LDA	NLENG
	STA	N
	LDA	TYPE
	CPI	1
	JZ	A0184
	LDA	NLENG	;GLOBAL SO SET BIT
	ORI	128
	STA	NLENG
A0184:	LHLD	TPP
	LDA	NLENG
	MOV	M,A
	LDA	N
	MOV	C,A
	MVI	B,0
	DAD	B
	INX	H
	SHLD	TPP
	LDA	IT
	MOV	M,A
	LXI	H,COUNT	;PUT # OF SETS ON STACK
	MVI	B,1
	CALL	PUSHT
A0186:	RET	
;*
;*
AC19:			;APPLY UNARY OPERATORS,STACK EXPRATOM
	CALL	SSCHK
	XRA	A
	STA	I2X
	LXI	H,TYPE
	MVI	B,1
	CALL	POPIT
	LDA	TYPE
	CPI	3
	JNZ	A0191
	LXI	H,NX
	MVI	B,1
	CALL	POPIT
	JMP	A0192
A0191:	MVI	A,PTRLN
	STA	NX
A0192:	LHLD	TOS
	LDA	NX
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR2
	DCX	H
	SHLD	PTR3
	MOV	A,M
	STA	ITX
	ORA	A
	JZ	A019A
	LXI	H,NX
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
A0196:	CALL	AC34 	;T-O-S TO REAL
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,NX
	MVI	B,1
	CALL	POPIT
	LHLD	PTR2
	MOV	A,M
	CPI	'-'
	JNZ	A1962
	MVI	A,1
	STA	I2X
	LXI	H,NX
	DCR	M
	LHLD	PTR2
	INX	H
	SHLD	PTR2
A1962:	LHLD	PTR3 	;PTR3 AT UNARY OP
	DCX	H
	SHLD	PTR3 
	XRA	A	;NO ' YET
	STA	I4X
	STA	CASE
A1965:	LHLD	PTR3	;GET UNARY OP TOKEN
	MOV	A,M
	STA	N
	CPI	5
	JZ	A0199
	CPI	6
	JNZ	A0197
	LDA	I2X  	;CHANGE SIGN
	XRI	1
	STA	I2X  
	JMP	A0199
A0197:	LDA	I4X	;JUMP IF ALREADY BEEN THROUGH HERE
	CPI	1
	JZ	A0198
	MVI	A,1
	STA	I4X
	LXI	H,NX
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	CALL	AC31
A0198:	LDA	CASE 	;CHANGE NOT INDICATOR
	XRI	1
	STA	CASE 
	XRA	A
	STA	I2X
A0199:	LXI	H,ITX
	DCR	M
	LHLD	PTR3 	;MOVE TO PREVIOUS UNARY OP
	DCX	H
	SHLD	PTR3 
	LDA	ITX
	ORA	A
	JNZ	A1965
	INX	H	;TPP TO FIRST AVAILABLE SPOT
	SHLD	PTR3 
	LDA	I4X	;JUMP IF EVER FOUND A NOT
	CPI	1
	JZ	A019B
	LHLD	PTR2	;JUMP IF NUMBER IS ZERO
	MOV	A,M
	CPI	'0'
	JZ	A019B
	LDA	I2X	;JUMP IF > 0
	ORA	A
	JZ	A019A
	LHLD	PTR3	;SET MINUS SIGN
	MVI	M,'-'
	INX	H
	SHLD	PTR3
A019A:	LHLD	PTR3	;MOVE NUMBER DOWN
	XCHG	
	LHLD	PTR2
	LDA	NX
	CALL	SHFD
	JMP	A019E
A019B:	LHLD	PTR3	;WE HAD A NOT
	SHLD	TOS
	MVI	A,1
	STA	NX
	LDA	CASE	;JUMP IF WANT ZERO
	ORA	A
	JZ	A019D
	LDA	I2X	;JUMP IF > 0
	ORA	A
	JZ	A019C
	MVI	A,'-'
	CALL	CPUSH
A019C:	MVI	A,'1'
	CALL	CPUSH
	JMP	A019E
A019D:	MVI	A,'0'
	CALL	CPUSH
	JMP	A019F
A019E:	LDA	I2X	;JUMP IF > 0
	ORA	A
	JZ	A019F
	LXI	H,NX
	INR	M
A019F:	LXI	H,NX
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	RET	
;*
;*
AC20:		
	CALL	SSCHK
	XRA	A    	;ZERO T-O-S
	CALL	CPUSH
	RET	
;*
;*
AC21:			;$JUSTIFY ACTION
	CALL	SSCHK
	LXI	H,INT2
	CALL	STI
	LDA	RESUL
	CPI	TRUE
	JZ	A0216
	CALL	AC33 	;T-O-S TO STRING
A0211:	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,IT   	;GET STRING LENGTH
	MVI	B,1
	CALL	POPIT
	LXI	H,INT2
	MOV	A,M
	ANI	0F0H
	JNZ	A0215
	LXI	H,INT1
	LDA	IT
	CALL	CTI
	LXI	D,INT2	;JUMP IF NOT ENOUGH ROOM
	MVI	C,INTLN
	MVI	B,INTLN
	CALL	SCMP
	JC	A0215
	JZ	A0215
	LXI	H,INT2	;NUMBER OF BLANKS TO ADD
	LXI	D,INT1
	MVI	C,INTLN
	CALL	BCDSB
	CALL	ITC
	STA	N
	LDA	RESUL	;TOO MANY BLANKS TO ADD
	CPI	FALSE
	JZ	E20
	LHLD	TOS
	LDA	IT
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR1
	LDA	N
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR2
	XCHG	
	LHLD	PTR1
	LDA	IT
	CALL	SHFU
	LXI	H,N	;TOTAL LENGTH IN IT
	ADD	M
	STA	IT
A0214:	LHLD	PTR1	;PUT IN N BLANKS
	MVI	M,BLANK
	INX	H
	SHLD	PTR1
	LXI	H,N
	DCR	M
	LDA	N
	ORA	A
	JNZ	A0214
A0215:	LXI	H,IT
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	RET	
A0216:	LXI	H,INT3 	;GET FIELD SIZE
	CALL	STI
	CALL	AC34 	;T-O-S TO NUMBER
	LXI	H,INT2	;NEGATIVE #'S NOT YET
	MOV	A,M
	ANI	0F0H
	JNZ	E30
	CALL	ITC
	STA	I6
	LDA	RESUL	;TOO MANY DECIMAL PLACES
	CPI	FALSE
	JZ	E20
	MVI	A,1
	STA	DJ
	CALL	DOLJ 	;T-O-S TO STRING WITH DECIMAL PLACE
	XRA	A
	STA	DJ
	LXI	H,INT2
	LXI	D,INT3
	CALL	SETI
	JMP	A0211
;*
;*
AC22:			;EVALUATE AND STACK SUBSCRIPT EXPRESSION
	CALL	SSCHK
	MVI	A,2	;SUBSCRIPT IS STRING (DEFAULT)
	STA	CASE
	CALL	PAST
	LXI	H,PTR2 	;GET BELOW T-O-S
	MVI	B,2
	CALL	POPIT
	LXI	H,PTR3
	MVI	B,2
	CALL	POPIT
	LHLD	PTR2
	SHLD	PTR3
	MOV	A,M
	STA	GLB
	DCX	H
	MOV	A,M
	STA	SETSW
	DCX	H
	MOV	A,M
	STA	NR
	DCX	H
	MOV	A,M
	STA	INDFL
	DCX	H
	MOV	A,M	;GET SUB COUNT
	STA	SCNT
	LXI	B,-(PTRLN)
	DAD	B
	SHLD	PTR2
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR1
	LXI	H,TYPE 	;GET SUB TYPE
	MVI	B,1
	CALL	POPIT
A0221:	LDA	TYPE
	CPI	3
	JZ	A0225
	LXI	H,TYPE
	MVI	B,1
	CALL	PUSHT
	CALL	AC33 	;CONVERT TO STRING
	LHLD	TOS
	DCX	H
	SHLD	TOS
A0225:	LXI	H,SLENG
	MVI	B,1
	CALL	POPIT
	CALL	CANON
	LDA	RESUL
	CPI	FALSE
	JZ	A0227
	MVI	A,1	;IT'S A NUMBER
	STA	CASE
A0227:	LDA	CASE
	CPI	2
	JZ	A2273
	LXI	H,SLENG
	INR	M
	LHLD	PTR3
	LDA	IT
	MOV	M,A
	JMP	A2275
A2273:	LHLD	PTR3
	INX	H
	SHLD	PTR3
A2275:	LDA	SLENG
	ORA	A
	JNZ	A0228
	LDA	DOR	;INVALID SUBSCRIPT
	CPI	1
	JNZ	E47
A0228:	LHLD	PTR3
	XCHG	
	LHLD	PTR2
	LDA	SLENG
	MOV	B,A
	CALL	MOVE
A0229:	LHLD	PTR1	;ADJUST SIZE
	LDA	SLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR1
	INX	H	;INCLUDE DELIMETER IN SIZE
	SHLD	PTR1 
	LHLD	PTR2
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR2
	SHLD	TOS
	MVI	A,DELIM	;END STRING DELIMITER
	CALL	CPUSH
	LXI	H,SCNT
	INR	M
	LXI	H,PTR1
	MVI	B,2
	CALL	PUSHT
	LXI	H,SCNT
	MVI	B,1
	CALL	PUSHT
	RET	
;*
;*
AC23:			;SAVE ROUTINE (NAME ON STACK)
	CALL	SSCHK
	LDA	RTDRV
	STA	DRIVE
	MVI	A,1
	STA	FCBTY
	CALL	FSEAR	;CHECK ROUTINE ON STACK FOR DUPLICATED
	LDA	RESUL
	CPI	1
	JNZ	A0231
	LDA	FLG1	;SAME NAME--IS IT DIRTY ?
	ANI	DIRTY
	JZ	E41
	CALL	REMOV
A0231:	CALL	SAVEI
	LDA	FLG1
	MOV	B,A
	MVI	A,DIRTY
	CMA	
	ANA	B
	STA	FLG1
	RET	
;*
;*
AC24:			;NEW LINE OPERATION, UPDATE $X & $Y
	CALL	SSCHK
	MVI	A,CR
	STA	CHR
	CALL	PUTCH
	MVI	A,LF
	STA	CHR
	CALL	PUTCH
	LHLD	DEVX
	LXI	D,IZERO
	CALL	SETI
	LHLD	DEVY
	LXI	D,IONE
	MVI	C,INTLN
	CALL	BCDAD
	RET	
;*
;*
AC25:			;TOP OF FORM OPERATION, UPDATE $X & $Y
	CALL	SSCHK
	MVI	A,CR
	STA	CHR
	CALL	PUTCH
	MVI	A,FF
	STA	CHR
	CALL	PUTCH
	LHLD	DEVX
	LXI	D,IZERO
	CALL	SETI
	LHLD	DEVY
	LXI	D,IZERO
	CALL	SETI
	RET	
;*
;*
AC26:			;REMOVE STRING FROM STACK
	CALL	SSCHK
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,SLENG
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	RET	
;*
;*
AC27:			;ZERO POINTER T-O-S
	CALL	SSCHK
	LXI	H,NULL
	SHLD	PTR
	LXI	H,PTR
	MVI	B,2
	CALL	PUSHT
	RET	
;*
;*
AC28:			;TAB OPERATION, UPDATE $X
	CALL	SSCHK
	LXI	H,INT1 	;GET TAB VALUE
	CALL	STI
	MOV	A,M
	ANI	0F0H
	JNZ	A0283
	LHLD	DEVX	;JUMP IF AT/PAST TAB PLACE
	LXI	D,INT1
	MVI	C,INTLN
	MVI	B,INTLN
	CALL	SCMP
	JC	A0283
	JZ	A0283
	LXI	H,INT2
	CALL	SETI
	LHLD	DEVX
	LXI	D,INT1
	XCHG	
	MVI	C,INTLN
	CALL	BCDSB
	LHLD	DEVX
	LXI	D,INT2
	CALL	SETI
A0281:	LXI	H,INT1	;DONE
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A0283
	MVI	C,INTLN
	CALL	SUB1
	MVI	A,BLANK	;SEND SPACES
	STA	CHR
	CALL	PUTCH
	JMP	A0281
A0283:	RET	
;*
;*
AC29:			;DISABLE EVALUATION
	LDA	ACTFL	;SET COMACT
	ORI	1
	STA	ACTFL
	RET	
;*
;*
AC30:			;SAVE ROUTINE (NAME AT PRG)
	CALL	SSCHK
	LXI	H,PRG
	SHLD	PTR
	MOV	A,M
	CPI	BLANK
	JZ	E40
	XRA	A
	STA	IT
A0301:	LHLD	PTR  	;PUSH NAME ON STACK
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR
	INX	H
	SHLD	PTR
	LXI	H,IT
	INR	M
	LDA	IT
	CPI	NAMLN
	JZ	A0302
	LHLD	PTR
	MOV	A,M
	CPI	BLANK
	JNZ	A0301
A0302:	LXI	H,IT   	;SAVE LENGTH
	MVI	B,1
	CALL	PUSHT
	LDA	RTDRV
	STA	DRIVE
	MVI	A,1
	STA	FCBTY
	CALL	FSEAR
	LDA	RESUL
	CPI	1
	JNZ	A0303
	LDA	FLG1	;IF CLEAN ALREADY SAVED
	ANI	DIRTY
	JZ	A0304
	CALL	REMOV	;REMOVE OLD ONE
A0303:	CALL	SAVEI
	LDA	FLG1
	MOV	B,A
	MVI	A,DIRTY
	CMA	
	ANA	B
	STA	FLG1
A0304:	RET	
;*
;*
AC31:			;CONVERT EXPRESSION TO TRUTH VALUE
	CALL	SSCHK
	CALL	AC34 	;CONVERT EXPRESSION TO NUMBER
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,N    	;GET NUMBER SIZE
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	N
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	MOV	A,M
	CPI	'0'
	JZ	A0312
	MVI	A,1	;SET X RETURN, TRUE
	STA	CASE
	RET	
A0312:	XRA	A	;SET Y RETURN, FALSE
	STA	CASE
	RET	
;*
;*
AC32:			;CONVERT EXPRESSION TO INTEGER
	CALL	SSCHK
	CALL	AC34
	XRA	A	;IT'S AN INTEGER
	STA	IT
	CALL	MKSTR	;MAKE NUMBER INTO STRING
	RET	
;*
;*
AC33:			;CONVERT BINARY INTEGER TO STRING
	CALL	SSCHK
	LXI	H,TYPE 	;GET TYPE OF T-O-S
	MVI	B,1
	CALL	POPIT
	LDA	TYPE
	CPI	3
	JZ	A0335
	LXI	H,PTR  	;IT'S A STRING POINTER
	MVI	B,2
	CALL	POPIT
	LHLD	PTR
	MOV	A,M
	STA	COUNT
	STA	N
A0333:	LHLD	PTR
	INX	H
	SHLD	PTR
	LDA	COUNT	;MOVE STRING FROM SYM TABLE TO STAKK
	ORA	A
	JZ	A0334
	MVI	B,1
	CALL	PUSHT
	LXI	H,COUNT
	DCR	M
	JMP	A0333
A0334:	LXI	H,N
	MVI	B,1
	CALL	PUSHT
A0335:	MVI	A,3
	CALL	CPUSH
	RET	
;*
;*
AC34:			;CONVERT EXPRESSION TO NUMERIC VALUE
	CALL	SSCHK
	MVI	A,1	;IT'S TO BE A REAL
	STA	IT
	CALL	MKSTR
	RET	
;*
;*
AC35:			;PUSH A ONE ON THE STACK
	CALL	SSCHK
	MVI	A,1
	CALL	CPUSH
	RET	
;*
;*
AC36:			;$ASCII ACTION
	CALL	SSCHK
	MVI	A,1
	STA	N
	LDA	RESUL	;NO INTEGER
	CPI	FALSE
	JZ	A0361
	LXI	H,INT1
	CALL	STI
	MOV	A,M	;NO GOOD NUMBERS
	ANI	0F0H
	JNZ	A0363
	CALL	ITC
	STA	N
	LDA	RESUL
	CPI	FALSE
	JZ	A0363
	LDA	N
	ORA	A
	JZ	A0363
A0361:	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,SLENG	;GET STRING LENGTH
	MVI	B,1
	CALL	POPIT
	LDA	SLENG
	ORA	A
	JZ	A0364
	LDA	N
	LXI	H,SLENG
	CMP	M
	JC	$+6
	JNZ	A0364
	LHLD	TOS
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	LXI	H,N
	DCR	M
	LHLD	TOS	;PTR TO START OF STRING
	LDA	N
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR
	MOV	A,M
	STA	N
A0362:	LDA	N
	CALL	CTS
	RET	
A0363:	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,SLENG
	MVI	B,1
	CALL	POPIT
A0364:	LHLD	TOS
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	MVI	A,'-'
	CALL	CPUSH
	MVI	A,'1'
	CALL	CPUSH
	MVI	A,2
	CALL	CPUSH
	MVI	A,3
	CALL	CPUSH
	RET	
;*
;*
AC37:			;WRITE LOCAL VARS FOR VIEW
	CALL	SSCHK
	LHLD	SYMPT
	SHLD	PTR
A0371:	LHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	NEXTP
	LXI	D,NULL
	CALL	JPEN
	JZ	A037B
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	MOV	A,M	;GET TYPE
	STA	STYPE
	CPI	128
	JC	$+6
	JNZ	A3790
	LXI	D,5	;PTR TO NAME LENGTH
	DAD	D
	SHLD	PTR
	MOV	A,M
	STA	SLENG
	LXI	H,SLENG
	DCR	M
	LDA	STYPE
	CPI	3
	JC	$+6
	JNZ	A0372
	MVI	A,BLANK
	CALL	CPUSH
	JMP	A0373
A0372:	MVI	A,'*'
	CALL	CPUSH
A0373:	MVI	A,BLANK
	CALL	CPUSH
	MVI	A,13
	LXI	H,SLENG
	SUB	M
	STA	IT
A3735:	LHLD	PTR  	;STACK NAME
	INX	H
	SHLD	PTR  
	MVI	B,1
	CALL	PUSHT
	LXI	H,SLENG
	DCR	M
	LDA	SLENG
	ORA	A
	JNZ	A3735
A0374:	MVI	A,BLANK	;PAD WITH BLANKS
	CALL	CPUSH
	LXI	H,IT
	DCR	M
	LDA	IT
	ORA	A
	JNZ	A0374
	LHLD	PTR
	INX	H
	INX	H
	SHLD	PTR
	XRA	A
	STA	I7
	LDA	STYPE
	CPI	4
	JC	A0375
	SUI	4
	STA	STYPE
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	DP
	MVI	A,1
	STA	I7
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
A0375:	MVI	A,15
	CALL	CPUSH
	MVI	A,3
	CALL	CPUSH
	CALL	AC54
	LDA	STYPE	;DONE
	ORA	A
	JZ	A0379
A0377:	LHLD	PTR
	MOV	A,M
	STA	SLENG
	STA	IT
	LXI	H,SLENG
	INR	M
	INR	M	;ALLOW FOR QUOTES
	MVI	A,'"'
	CALL	CPUSH
A0378:	LDA	IT	;SAVE STRING
	ORA	A
	JZ	A0379
	LHLD	PTR
	INX	H
	SHLD	PTR
	MVI	B,1
	CALL	PUSHT
	LXI	H,IT
	DCR	M
	JMP	A0378
A0379:	MVI	A,'"'
	CALL	CPUSH
	LXI	H,SLENG
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
A037C:	CALL	AC54
	CALL	AC24
	LDA	VF
	ORA	A
	JZ	A3790
	LDA	I7
	ORA	A
	JZ	A3790
	CALL	LSUBS
A3790:	LHLD	NEXTP
	SHLD	PTR
	JMP	A0371
A037A:	CALL	AC33 	;CONVERT T-O-S TO STRING
	JMP	A037C
A037B:	RET	
;*
;*
AC38:			;$DATA FUNCTION
	CALL	SSCHK
	LXI	H,IT   	;GET GLOBAL OR LOCAL
	MVI	B,1
	CALL	POPIT
	LXI	H,SCNT 	;SUBSCRIPT COUNT
	MVI	B,1
	CALL	POPIT
	LXI	H,NLEN 	;GET SUBSCRIPT OFFSET
	MVI	B,2
	CALL	POPIT
	LHLD	TOS
	DCX	H
	SHLD	PTR3
	LHLD	NLEN
	XCHG	
	LHLD	PTR3
	CALL	PSUB
	SHLD	PTR3
	INX	H
	SHLD	PTR
	LHLD	PTR3	;GET NAME LENGTH
	MOV	A,M
	STA	NLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR3
	SHLD	NAME	;NAME POINTS AT START OF NAME
	SHLD	TPTR
	LDA	IT	;GLOBAL OR LOCAL
	CPI	1
	JNZ	A0385
	CALL	SEARC	;LOOK FOR VAR
	XRA	A
	STA	IT
	LDA	RESUL	;DONE--NO ENTRY
	ORA	A
	JZ	A0384
	LDA	CASE	;DONE--TOO MANY SUBS
	CPI	2
	JNZ	A0384
	LHLD	LAST	;PTR1 TO START OF ENTRY
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR1
	LDA	STYPE
	CPI	9
	JC	A0381
	MVI	A,1
	STA	IT
	LHLD	PTR1	;DONE
	MOV	E,M
	INX	H
	MOV	D,M
	LXI	H,NULL
	CALL	JPEN
	JZ	A0384
	MVI	A,11
	STA	IT
	JMP	A0384
A0381:	LDA	STYPE
	CPI	8
	JNZ	A0382
	LHLD	PTR1
	MOV	E,M
	INX	H
	MOV	D,M
	LXI	H,NULL
	CALL	JPEN
	JZ	A0384
	MVI	A,10
	STA	IT
	JMP	A0384
A0382:	LDA	STYPE
	CPI	5
	JC	A0383
	LHLD	PTR	;PTR TO DOWN POINTER
	LXI	B,-(PTRLN)
	DAD	B
	SHLD	PTR
	MVI	A,1
	STA	IT
	MOV	E,M
	INX	H
	MOV	D,M
	LXI	H,NULL
	CALL	JPEN
	JZ	A0384
	MVI	A,11
	STA	IT
	JMP	A0384
A0383:	LDA	STYPE
	CPI	4
	JNZ	A3835
	MVI	A,10
	STA	IT
	JMP	A0384
A3835:	MVI	A,1
	STA	IT
A0384:	LHLD	TPTR
	SHLD	TOS
	LDA	IT
	CALL	CTS
	RET	
;* GLOBAL SEARCH
A0385:	CALL	FNAKD
	CALL	FINDK	;SEARCH FOR ENTRY
	XRA	A
	STA	II
	LDA	RESUL	;DONE--NO ENTRY
	ORA	A
	JZ	A0387
	MVI	A,1
	STA	II
A3855:	LHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	PTR
	DAD	D
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	CALL	VALSZ
	LHLD	TPP	;SKIP OVER VALUE
	XCHG	
	LHLD	PTR
	DAD	D
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	MVI	A,FALSE	;SO GETNEXT DOESN'T SKIP
	STA	RESUL
A0387:	CALL	GETNE
	LDA	II
	STA	IT
	LDA	RESUL
	CPI	FALSE
	JZ	A0384
	LHLD	NAME
	SHLD	PTR3
	CALL	FDDSC	;FIND DESCENDENT
	LDA	RESUL
	CPI	1
	JNZ	A0384
	LDA	IT
	ADI	10
	STA	IT
	JMP	A0384
;*
;*
AC39:			;VIEW ACTION (WITH ARGUMENTS)
	CALL	SSCHK
	CALL	STC0
	STA	I1
	LDA	RESUL	;NUMBER TOO BIG
	CPI	FALSE
	JZ	E20
	LDA	I1
	ORA	A
	JNZ	A0391
	XRA	A
	STA	VF
	CALL	AC37 	;LOCAL--NO SUBS
	JMP	A0394
A0391:	LDA	I1
	CPI	1
	JNZ	A0392
	MVI	A,1
	STA	VF
	CALL	AC37 	;LOCAL PLUS SUBS
	JMP	A0394
A0392:	LDA	I1
	CPI	2
	JNZ	A0393
	CALL	LGLOB	;GLOBAL NAMES
	JMP	A0394
A0393:	LDA	I1
	CPI	3
	JNZ	E20
	CALL	AC80 	;ROUTINE NAMES
A0394:	RET	
;*
;*
AC40:			;$EXTRACT FUNCTION
	CALL	SSCHK
	LXI	H,INT1 	;GET INTEGER (START OR STOP)
	CALL	STI
	LXI	H,INT2
	LXI	D,INT1
	CALL	SETI
	LDA	RESUL
	ORA	A
	JZ	A0401
	LXI	H,INT1 	;GET START LOCATION
	CALL	STI
A0401:	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,SLENG	;GET STRING LENGTH
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	SHLD	PTR	;PTR AT START OF STRING
	LXI	H,INT3	;INT3--STRING LENGTH
	LDA	SLENG
	CALL	CTI
	LXI	H,INT1
	MOV	A,M
	ANI	0F0H
	JNZ	A4015
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A4015
	JMP	A0402
A4015:	LDA	RESUL	;IF START <= 0 AND RESULT=0, EMPTY ANSWER
	ORA	A
	JZ	A0405
	LXI	H,INT1	;IF START<=0 AND RESULT=1, START AT 1
	LXI	D,IONE
	CALL	SETI
A0402:	LXI	H,INT3	;JUMP IF END < LENGTH
	LXI	D,INT2
	MVI	C,INTLN
	MVI	B,INTLN
	CALL	SCMP
	JC	A0403
	LXI	H,INT2	;END AT END
	LXI	D,INT3
	CALL	SETI
A0403:	LXI	H,INT1	;EMPTY RESULT, END BEFORE START
	LXI	D,INT2
	MVI	C,INTLN
	MVI	B,INTLN
	CALL	SCMP
	JC	A0405
	CALL	ITC
	STA	I1
	LXI	H,INT2
	CALL	ITC
	STA	I2
	LXI	H,I1
	DCR	M
	LDA	I2	;GET # OF CHARS
	SUB	M
	STA	I2
	LHLD	PTR
	LDA	I1
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR
	LHLD	TOS	;MOVE STRING DOWN TO TOS
	XCHG	
	LHLD	PTR
	LDA	I2
	CALL	SHFD
A0404:	LXI	H,I2   	;SAVE LENGTH
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	RET	
A0405:	XRA	A
	STA	I2
	JMP	A0404
;*
;*
AC41:			;$FIND ACTION
	CALL	SSCHK
	LDA	RESUL
	CPI	1
	JZ	A0411
A0410:	MVI	A,1	;NO INTEGER EXPRESSION
	STA	N
	JMP	A0412
A0411:	LXI	H,INT1
	CALL	STI
	MOV	A,M
	ANI	0F0H
	JNZ	A0410
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A0410
	CALL	ITC
	STA	N
	LDA	RESUL
	CPI	FALSE
	JZ	A4145
A0412:	LHLD	TOS	;GET TYPE 3
	DCX	H
	SHLD	TOS
	LXI	H,I2   	;LENGTH OF STRING 2
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	I2
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	SHLD	PTR2	;PTR2 TO START OF STRING 2
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I1   	;LENGTH OF STRING 1
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	I1
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	SHLD	PTR1	;PTR1 TO START OF STRING 1
	LDA	I2
	ORA	A
	JZ	A0417
	LDA	N
	LXI	H,I1
	CMP	M
	JC	$+6
	JNZ	A0415
	LXI	H,N
	DCR	M
	LHLD	PTR1	;PTR1 TO SEARCH PLACE
	LDA	N
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR1
	LDA	I1
	LXI	H,N
	SUB	M
	STA	I1
A0414:	LDA	I1	;FAILURE
	LXI	H,I2
	CMP	M
	JC	A0415
	LHLD	PTR1	;SUCCESS
	XCHG	
	LHLD	PTR2
	LDA	I2
	MOV	C,A
	CALL	JSE
	JNZ	$+13
	SHLD	PTR2
	XCHG	
	SHLD	PTR1
	JMP	A0416
	LHLD	PTR1 	;TRY AGAIN
	INX	H
	SHLD	PTR1 
	LXI	H,I1
	DCR	M
	LXI	H,N
	INR	M
	JMP	A0414
A4145:	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I2
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	I2
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I2
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	I2
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
A0415:	XRA	A	;HERE IF FAILED
	STA	N
	JMP	A0417
A0416:	LDA	N
	LXI	H,I2
	ADD	M
	STA	N
	LXI	H,N
	INR	M
A0417:	LDA	N
	CALL	CTS
	RET	
;*
;*
AC42:			;$LENGTH ACTION
	CALL	SSCHK
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,SLENG	;GET LENGTH
	MVI	B,1
	CALL	POPIT
	LHLD	TOS	;TOS BELOW STRING
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	LDA	SLENG
	CALL	CTS
	RET	
;*
;*
AC43:			;EVALUATE BINARY OPERATORS
	CALL	SSCHK
	LDA	FLG1	;RESET NOT FLAG
	MOV	B,A
	MVI	A,NOTFL
	CMA	
	ANA	B
	STA	FLG1
	CALL	PAST 	;MOVE PTR PAST T-O-S ITEM
	LXI	H,PTR
	MVI	B,2
	CALL	POPIT
	LXI	H,TPP
	MVI	B,2
	CALL	POPIT
	LHLD	PTR	;GET OPERATOR
	MOV	A,M
	STA	I6
	SHLD	PTR2	;SAVE PTR
	CPI	50
	JC	A0431
	LDA	FLG1	;SET NOT FLAG
	ORI	NOTFL
	STA	FLG1
	LDA	I6
	SUI	50
	STA	I6
A0431:	LDA	I6	;IS IT STRING OP?
	CPI	14
	JC	$+6
	JNZ	A0432
	CALL	AC34 	;CONVERT T-O-S TO REAL
	JMP	A0433
A0432:	CALL	AC33 	;CONVERT T-O-S TO STRING
A0433:	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I2
	MVI	B,1
	CALL	POPIT
	LHLD	PTR2
	SHLD	PTR1
	INX	H
	SHLD	PTR2
	LHLD	PTR1
	DCX	H
	DCX	H
	MOV	A,M	;GET OP #1 LENGTH
	STA	I1
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR1
	LDA	I6
	CPI	14
	JC	$+6
	JNZ	A043H
	SHLD	TOS
	CALL	NUMOP	;DO NUMERIC OPERATION
	RET	
A043A:	LDA	FLG1
	ANI	NOTFL
	JNZ	A43B5
A43A5:	MVI	A,'1'
	STA	CHR
	JMP	A043C
A043B:	LDA	FLG1
	ANI	NOTFL
	JNZ	A43A5
A43B5:	MVI	A,'0'
	STA	CHR
A043C:	LXI	H,CHR
	MVI	B,1
	CALL	PUSHT
	MVI	A,1
	CALL	CPUSH
	MVI	A,3
	CALL	CPUSH
	RET	
A043H:	LDA	I6
	CPI	18
	JZ	A043N
	LHLD	PTR1	;TOS TO RIGHT PLACE
	SHLD	TOS
	CPI	15
	JNZ	A043J
	LDA	I2	;IT'S A [
	ORA	A
	JZ	A043A
	LDA	I1
	STA	I3
A043I:	LDA	I3	;NOT ENOUGH STRING LEFT
	LXI	H,I2
	CMP	M
	JC	A043B
	LHLD	PTR1
	XCHG	
	LHLD	PTR2
	LDA	I2
	MOV	C,A
	CALL	JSE
	JNZ	$+13
	SHLD	PTR2
	XCHG	
	SHLD	PTR1
	JMP	A043A
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	LXI	H,I3   	;DECREMENT STRING LEFT
	DCR	M
	JMP	A043I
A043J:	LDA	I6
	CPI	16
	JNZ	A043M
A043K:	LDA	I1	;IT'S A ]
	ORA	A
	JZ	A043B
	LDA	I2
	ORA	A
	JZ	A043A
	LHLD	PTR1
	XCHG	
	LHLD	PTR2
	LDAX	D
	CMP	M
	JZ	A043L
	LHLD	PTR1
	XCHG	
	LHLD	PTR2
	LDAX	D
	CMP	M
	JC	$+6
	JNZ	A043A
	JMP	A043B
A043L:	LHLD	PTR1 	;THE STRING HEADS ARE EQUAL
	INX	H
	SHLD	PTR1 
	LHLD	PTR2
	INX	H
	SHLD	PTR2
	LXI	H,I1
	DCR	M
	LXI	H,I2
	DCR	M
	JMP	A043K
A043M:	LDA	I1	;IT'S A =
	LXI	H,I2
	CMP	M
	JNZ	A043B
	LHLD	PTR1
	XCHG	
	LHLD	PTR2
	MOV	C,A
	CALL	JSE
	JNZ	$+13
	SHLD	PTR2
	XCHG	
	SHLD	PTR1
	JMP	A043A
	JMP	A043B
A043N:	LXI	H,INT1	;IT'S A _
	LDA	I1
	CALL	CTI
	LXI	H,INT2
	LDA	I2
	CALL	CTI
	LXI	H,INT1
	LXI	D,INT2
	MVI	C,INTLN
	CALL	BCDAD
	CALL	ITC
	STA	N
	LDA	RESUL	;STRING TOO LONG
	CPI	FALSE
	JZ	E11
	LHLD	PTR2
	LXI	B,-(3)
	DAD	B
	SHLD	PTR1
	XCHG		;SHIFT STRING2 PAST OPERATOR
	LHLD	PTR2
	LDA	I2
	CALL	SHFD
	LXI	H,N
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	RET	
;*
;*
AC44:			;RETURN CURRENT DRIVES
	CALL	SSCHK
	XRA	A
	STA	T1
	LXI	H,ZOROU
	SHLD	PTR
A0440:	MVI	A,1
	STA	COUNT
A0441:	LHLD	PTR
	MOV	A,M
	CPI	DELIM
	JZ	A0442
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR
	INX	H
	SHLD	PTR
	LXI	H,COUNT
	INR	M
	JMP	A0441
A0442:	LDA	T1
	CPI	1
	JZ	A0443
	LDA	RTDRV
	STA	IT
	JMP	A0444
A0443:	LDA	GLBDR
	STA	IT
A0444:	LDA	IT
	ADI	'A'
	STA	IT
	LXI	H,IT
	MVI	B,1
	CALL	PUSHT
	LXI	H,COUNT
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	CALL	AC54 	;WRITE OUT MESSAGE
	CALL	AC24
	LDA	T1
	CPI	1
	JZ	A0445
	LXI	H,ZOGLO
	SHLD	PTR
	MVI	A,1
	STA	T1
	JMP	A0440
A0445:	RET	
;*
;*
AC45:			;$PIECE ACTION
	CALL	SSCHK
	LDA	RESUL
	ORA	A
	JZ	A0450
	LXI	H,INT2 	;GET "OPTIONAL" INTEGER
	CALL	STI
A0450:	LXI	H,INT1 	;GET START INTEGER
	CALL	STI
	LDA	RESUL
	CPI	1
	JZ	A0451
	LXI	H,INT2	;SET END IF MISSING
	LXI	D,INT1
	CALL	SETI
A0451:	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I2   	;LENGTH OF STRING #2
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	I2
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	SHLD	PTR2	;PTR2 TO START OF STRING #2
	SHLD	PTR3
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I1   	;LENGTH OF STRING #1
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	I1
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	SHLD	PTR1	;PTR1 TO START OF STRING #1
	LDA	I2	;EMPTY RESULT--STRING #2 EMPTY
	ORA	A
	JZ	A045E
	LXI	H,INT2	;EMPTY RESULT--INT2 < 1
	MOV	A,M
	ANI	0F0H
	JNZ	A045E
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A045E
	LXI	H,INT1
	MOV	A,M
	ANI	0F0H
	JNZ	A0453
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A0453
A0452:	LXI	H,INT1	;EMPTY RESULT--INT1 > INT2
	LXI	D,INT2
	MVI	C,INTLN
	MVI	B,INTLN
	CALL	SCMP
	JC	A045E
	CALL	ITC
	STA	I3
	LDA	RESUL
	CPI	FALSE
	JZ	A045E
	LXI	H,I3
	DCR	M
	JMP	A0454
A0453:	XRA	A
	STA	I3
A0454:	LDA	I3	;FOUND START?
	ORA	A
	JZ	A0457
A0455:	LDA	I1	;EMPTY RESULT--NOT ENOUGH MATCHES
	LXI	H,I2
	CMP	M
	JC	A045E
	LHLD	PTR1
	XCHG	
	LHLD	PTR2
	LDA	I2
	MOV	C,A
	CALL	JSE
	JNZ	$+13
	SHLD	PTR2
	XCHG	
	SHLD	PTR1
	JMP	A0456
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	LXI	H,I1
	DCR	M
	JMP	A0455
A0456:	LXI	H,I3
	DCR	M
	LDA	I1
	LXI	H,I2
	SUB	M
	STA	I1
	LXI	H,INT2
	MVI	C,INTLN
	CALL	SUB1
	LHLD	PTR3
	SHLD	PTR2
	JMP	A0454
A0457:	LHLD	PTR1	;PTR1 IS AT STARTING LOCATION
	SHLD	PTR
	LDA	I1
	STA	IT
A0459:	LDA	I1	;NOT ENOUGH LEFT, TAKE IT ALL
	LXI	H,I2
	CMP	M
	JC	A045B
	LHLD	PTR1
	XCHG	
	LHLD	PTR2
	LDA	I2
	MOV	C,A
	CALL	JSE
	JNZ	$+13
	SHLD	PTR2
	XCHG	
	SHLD	PTR1
	JMP	A045A
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	LXI	H,I1
	DCR	M
	JMP	A0459
A045A:	LDA	I1
	LXI	H,I2
	SUB	M
	STA	I1
	LXI	H,INT2
	MVI	C,INTLN
	CALL	SUB1
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A045C
	LHLD	PTR3
	SHLD	PTR2
	JMP	A0459
A045B:	XRA	A
	STA	I1
	STA	I2
A045C:	LDA	IT
	LXI	H,I1
	SUB	M
	LXI	H,I2
	SUB	M
	STA	IT
	LHLD	PTR	;SHIFT RESULT TO T-O-S
	XCHG	
	LHLD	TOS
	MOV	B,A
	CALL	MOVE
	LHLD	TOS
	LDA	IT
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	TOS
A045D:	LXI	H,IT
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	RET	
A045E:	XRA	A
	STA	IT
	JMP	A045D
;*
;*
AC46:			;$CHAR ACTION
	CALL	SSCHK
	LXI	H,INT1 	;GET INTEGER
	CALL	STI
	LXI	H,COUNT	;GET COUNT
	MVI	B,1
	CALL	POPIT
	LXI	H,INT1	;IGNORE, < 0
	MOV	A,M
	ANI	0F0H
	JNZ	A0461
	CALL	ITC
	STA	N
	LXI	H,COUNT
	INR	M
	LXI	H,N
	MVI	B,1
	CALL	PUSHT
A0461:	LXI	H,COUNT
	MVI	B,1
	CALL	PUSHT
	RET	
;*
;*
AC47:			;SET VALUES
	CALL	SSCHK
	XRA	A
	STA	STCNT
	LDA	SETF
	CPI	1
	JZ	A0471
	MVI	A,1	;A FOR OR A READ
	STA	STCNT
	LHLD	PTR
	DCX	H
	MOV	A,M
	STA	SCNT
	LXI	B,-(PTRLN)
	DAD	B
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	TPP
	XCHG	
	LHLD	PTR
	CALL	PSUB
	DCX	H
	MOV	A,M
	STA	NLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR
	SHLD	SETBS
	SHLD	NAME
A0471:	XRA	A
	STA	NR
	LHLD	TOS	;IT'S A SET
	SHLD	TTPTR
	CALL	PAST
	LXI	H,SSDP 	;GET BASE OF T-O-S
	MVI	B,2
	CALL	POPIT
	LXI	H,VSZ  	;GET SIZE OF T-O-S
	MVI	B,2
	CALL	POPIT
	LXI	H,I4   	;GET TYPE IF T-O-S
	MVI	B,1
	CALL	POPIT
	LDA	I4
	CPI	3
	JNZ	A4715
	LXI	H,SLENG
	MVI	B,1
	CALL	POPIT
	LXI	H,SLENG
	MVI	B,1
	CALL	PUSHT
A4715:	LXI	H,I4
	MVI	B,1
	CALL	PUSHT
	LDA	I4
	STA	ST
	LHLD	VSZ
	SHLD	TPP
	LDA	SETF
	ORA	A
	JZ	A4720
	LDA	STCNT
	ORA	A
	JNZ	A0472
	LHLD	SETBS
	SHLD	NAME
	LHLD	SSDP
	MOV	A,M
	STA	STCNT
A0472:	LHLD	NAME	;GET LENGTH OF NAME
	MOV	A,M
	STA	NLENG
	INX	H
	SHLD	NAME
	SHLD	TNAME
	SHLD	PTR
	XRA	A
	STA	IT
	LDA	NLENG
	ANI	128
	JZ	A4719
	MVI	A,1
	STA	IT
	LDA	NLENG
	MOV	B,A
	MVI	A,128
	CMA	
	ANA	B
	STA	NLENG
A4719:	LHLD	PTR
	LDA	NLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR
	MOV	A,M	;GET SUB COUNT
	STA	SCNT
	LDA	IT
	CPI	1
	JZ	A0478
A4720:	LHLD	NAME
	SHLD	SPTR
	CALL	SEARC
	LHLD	NAME
	SHLD	PTR3
	LHLD	SPTR	;PUT NAME BACK
	SHLD	NAME
	LDA	ST
	STA	I3
	XRA	A
	STA	I1
	LDA	SCNT
	ORA	A
	JZ	A4725
	LDA	RESUL
	ORA	A
	JZ	A4724
	LDA	CASE
	ORA	A
	JNZ	A4725
	LHLD	LAST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,2
	DAD	D
	SHLD	PTR
	MOV	A,M
	ADI	4
	STA	I3
	INX	H
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,2
	DAD	D
	SHLD	TPP
	CALL	INS25
	LHLD	LAST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR2
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	PTR1
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR1
	XCHG	
	LHLD	LAST
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	B,-(2)
	DAD	B
	SHLD	PTR
	SHLD	LAST
	LHLD	PTR1
	SHLD	LPTR
	LHLD	PTR
	LXI	D,2
	DAD	D
	SHLD	PTR
	LHLD	PTR2
	LXI	D,PTRLN
	DAD	D
	MOV	A,M
	ORI	128
	MOV	M,A
	LXI	D,5
	DAD	D
	MOV	C,M
	MVI	B,0
	DAD	B
	INX	H
	SHLD	PTR2
	LDA	I3
	CPI	5
	JNZ	A4721
	MVI	A,4
	STA	COUNT
	JMP	A4723
A4721:	LDA	I3
	CPI	6
	JNZ	A4722
	MVI	A,5
	STA	COUNT
	JMP	A4723
A4722:	LHLD	PTR2
	MOV	A,M
	STA	COUNT
	LXI	H,COUNT
	INR	M
A4723:	LHLD	PTR2
	XCHG	
	LHLD	PTR
	LDA	COUNT
	MOV	B,A
	CALL	MOVE
	JMP	A0473
A4724:	MVI	A,4
	STA	I3
A4725:	LDA	RESUL
	CPI	1
	JZ	A0473
	CALL	INSER	;PUT IN NAME
	LHLD	SYMPT	;LINK ENTRY IN
	XCHG	
	LHLD	PTR1
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR1
	SHLD	SYMPT
	SHLD	LPTR
	LXI	D,8
	DAD	D
	LDA	NLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	LAST
A0473:	LDA	SCNT
	ORA	A
	JZ	A0475
	MVI	A,8
	STA	I3
	LDA	SCNT
	CPI	1
	JC	$+6
	JNZ	A0474
	LDA	ST
	ADI	8
	STA	I3
A0474:	XRA	A
	STA	I9
	CALL	SINSR	;PUT IN SUBSCRIPT ENTRY
	LHLD	PTR1	;LINK ENTRY IN
	XCHG	
	LHLD	LAST
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR1
	SHLD	LAST
	SHLD	LPTR
	LXI	H,SCNT
	DCR	M
	JMP	A0473
A0475:	CALL	SETVA	;PUT IN VALUE
A4755:	LDA	NR	;SET IN FNAKD
	CPI	1
	JNZ	A4757
	XRA	A
	STA	NR
	LHLD	TNAME
	MOV	A,M
	STA	SCNT
	INX	H
	SHLD	PTR3
A4756:	LHLD	PTR3
	MOV	A,M
	CPI	DELIM
	JZ	A4754
	INX	H
	SHLD	PTR3
	JMP	A4756
A4754:	LHLD	PTR3 	;SKIP INITIAL 1
	INX	H
	SHLD	PTR3 
	LXI	H,SCNT
	DCR	M
	LDA	SCNT
	ORA	A
	JNZ	A4756
A4757:	LXI	H,STCNT
	DCR	M
	LHLD	TTPTR	;RESTORE TOS
	SHLD	TOS
	LHLD	PTR3	;SET NAME
	SHLD	NAME
	LDA	STCNT
	ORA	A
	JNZ	A0471
	LHLD	SETBS
	SHLD	TOS
	LDA	SETF
	ORA	A
	JZ	A0476
	XRA	A
	STA	SETF
	RET	
A0476:	LDA	RDF
	CPI	1
	JZ	A0477
	LHLD	NSTOS
	SHLD	TOS
A0477:	RET	
;* SET GLOBAL VALUE
A0478:	LDA	ST
	STA	I3
	LDA	SCNT
	STA	IT
	LHLD	PTR
	INX	H
	SHLD	PTR
	SHLD	NLEN
A4781:	LDA	IT
	ORA	A
	JZ	A4783
A478W:	LHLD	NLEN
	MOV	A,M
	CPI	DELIM
	JZ	A4782
	INX	H
	SHLD	NLEN
	JMP	A478W
A4782:	LXI	H,IT
	DCR	M
	LHLD	NLEN
	INX	H
	SHLD	NLEN
	JMP	A4781
A4783:	LHLD	PTR
	XCHG	
	LHLD	NLEN
	CALL	PSUB
	SHLD	NLEN
	CALL	FNAKD
A4784:	LHLD	VSZ	;PTR4 IS SIZE OF VALUE
	SHLD	PTR4
	LHLD	NLEN	;PTR2 IS SIZE OF NAME + SUBS
	LDA	NLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	INX	H
	SHLD	PTR2
	LHLD	NAME
	SHLD	NMPTR
	LHLD	SSDP
	INX	H
	SHLD	VLPTR
	MVI	A,1
	STA	A47
	LHLD	NAME
	SHLD	PTR3
	CALL	FINDK	;SEARCH FOR ENTRY
	CALL	GLSET
	XRA	A
	STA	A47
	LHLD	NAME
	SHLD	PTR3
	LHLD	NLEN
	XCHG	
	LHLD	PTR3
	DAD	D
	LDA	NLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	INX	H
	SHLD	PTR3
	JMP	A4755
;*
;*
AC48:			;SAVE BREAK THINGS
	CALL	SSCHK
	LDA	MODE	;INDIRECT MODE ONLY
	CPI	DIREC
	JZ	E43
	CALL	CRLF
	LXI	H,BRKM 	;WRITE OUT BREAK MESSAGE
	CALL	MSG
	LDA	IODVC
	STA	SDVC
	XRA	A
	STA	I
	CALL	SETDE
	LDA	CASE
	CPI	1
	JNZ	A0481
	CALL	AC54 	;WRITE BREAK ARGUMENT
A0481:	CALL	CRLF
	LDA	INDSW
	CPI	1
	JC	$+6
	JNZ	A0482
	LXI	H,PRGLS	;SAVE LINE PTR
	MVI	B,2
	CALL	PUSHT
A0482:	LXI	H,INDX 	;SAVE INDX
	MVI	B,2
	CALL	PUSHT
	LXI	H,INDFL	;SAVE INDIRECTION FLAG
	MVI	B,1
	CALL	PUSHT
	LXI	H,FORSW
	MVI	B,1
	CALL	PUSHT
	LXI	H,INDSW
	MVI	B,1
	CALL	PUSHT
	LXI	H,DOSW
	MVI	B,1
	CALL	PUSHT
	LHLD	TOS
	SHLD	BKPTR
	XRA	A
	STA	INDFL
	STA	INDSW
	STA	FORSW
	STA	DOSW
	LDA	FLG1
	ORI	BRAKE
	STA	FLG1
	MVI	A,DIREC
	STA	MODE
	LDA	FLAG
	ORI	2
	STA	FLAG
	RET	
;*
;*
AC49:			;RETURN FROM BREAK
	CALL	SSCHK
	LXI	H,DOSW
	MVI	B,1
	CALL	POPIT
	LXI	H,INDSW
	MVI	B,1
	CALL	POPIT
	LXI	H,FORSW
	MVI	B,1
	CALL	POPIT
	LXI	H,INDFL	;RESTORE INDIRECTION FLAG
	MVI	B,1
	CALL	POPIT
	LXI	H,SPTR 	;GET INDX
	MVI	B,2
	CALL	POPIT
	LDA	INDSW
	CPI	1
	JC	$+6
	JNZ	A0491
	LXI	H,PRGPT	;GET PROGRAM POINTER
	MVI	B,2
	CALL	POPIT
A0491:	MVI	A,INDIR
	STA	MODE
	LDA	SDVC
	STA	IODVC
	STA	IT
	CALL	SETDE
	LDA	INDSW
	ORA	A
	JNZ	A0492
	CALL	INPUT	;LOAD LINE INTO LINE EXECUTION BUFFER
A0492:	LHLD	SPTR
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	LDA	FLG1
	MOV	B,A
	MVI	A,BRAKE
	CMA	
	ANA	B
	STA	FLG1
	LDA	TOKEN
	CPI	38
	JNZ	A0493
	LDA	FLAG
	ORI	2
	STA	FLAG
A0493:	RET	
;*
;*
AC50:			;$ORDER FUNCTION
	CALL	SSCHK
	LXI	H,IT   	;LOCAL OR GLOBAL
	MVI	B,1
	CALL	POPIT
	LXI	H,SCNT
	MVI	B,1
	CALL	POPIT
	LDA	SCNT	;MISSING SUBSCRIPT
	ORA	A
	JZ	E46
	STA	SSUB
	LXI	H,NLEN
	MVI	B,2
	CALL	POPIT
	LHLD	TOS
	DCX	H
	SHLD	PTR3
	LHLD	NLEN
	XCHG	
	LHLD	PTR3
	CALL	PSUB
	SHLD	PTR3
	INX	H
	SHLD	PTR
	LHLD	PTR3	;NAME LENGTH
	MOV	A,M
	STA	NLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR3
	SHLD	NAME	;NAME TO START OF NAME
	SHLD	TPTR
	LDA	IT	;GLOBAL
	CPI	1
	JNZ	A050C
	CALL	SEARC
	LHLD	NAME
	SHLD	PTR3
	LDA	RESUL	;DONE--NO MATCH
	ORA	A
	JZ	A050A
	LDA	CASE	;PERFECT MATCH--FIND NEXT ONE
	CPI	2
	JZ	A050B
	ORA	A
	JZ	A050A
	LDA	SCNT	;MORE THAN 1 SUB UNMATCHED
	CPI	1
	JNZ	A050A
A0500:	LHLD	PTR3
	SHLD	PTR
	LHLD	SDP	;START OF ROW
	SHLD	PTR3
	LXI	D,NULL
	CALL	JPEN
	JZ	A050A
	LXI	H,PBIG
	SHLD	PTR2
	LXI	H,NULL
	SHLD	LAST
A0503:	LHLD	PTR3	;CHECK ALL OF ROW
	LXI	D,PTRLN
	DAD	D
	MOV	A,M
	STA	TYPE
	LXI	D,5	;TO ACROSS PTR
	DAD	D
	SHLD	PTR3
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	AP
	LHLD	PTR3
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR3
	SHLD	PTR5
	LHLD	PTR
	SHLD	PTR4
	CALL	COMPA
	LDA	CASE	;TOO SMALL--TRY NEXT ONE
	CPI	1
	JNZ	A0507
A5065:	LHLD	PTR2
	SHLD	PTR5
	LHLD	PTR3
	SHLD	PTR4
	CALL	COMPA
	LDA	CASE	;TOO BIG--TRY NEXT ONE
	CPI	1
	JNZ	A0507
	XRA	A
	STA	I3
	LHLD	PTR3	;OK--SAVE IT
	SHLD	PTR2
	SHLD	LAST
A0507:	LHLD	AP	;GO TO NEXT ONE
	SHLD	PTR3
	LXI	D,NULL
	CALL	JPEN
	JNZ	A0503
	LHLD	LAST	;NONE LARGER
	LXI	D,NULL
	CALL	JPEN
	JZ	A050A
A0508:	LHLD	LAST
	SHLD	PTR3
	CALL	SUBSI
	LDA	I1
	STA	IT
	MVI	A,FALSE
	STA	ITX
	LHLD	LAST
	MOV	A,M
	CPI	31
	JC	$+6
	JNZ	A5085
	MOV	A,M
	CPI	14
	JC	$+6
	JNZ	A5083
	MVI	A,TRUE
	STA	ITX
	LHLD	TPTR
	INX	H
	SHLD	TPTR
A5083:	LHLD	LAST
	INX	H
	SHLD	LAST
	LXI	H,IT
	DCR	M
A5085:	LHLD	LAST
	XCHG	
	LHLD	TPTR
	LDA	IT
	MOV	B,A
	CALL	MOVE
	LDA	ITX
	CPI	FALSE
	JZ	A5088
	LDA	IT
	STA	I2
	LHLD	TPTR
	DCX	H
	SHLD	TPTR
	SHLD	PTR
	MVI	M,'-'
	LXI	H,IT
	INR	M
A5086:	LHLD	PTR
	INX	H
	SHLD	PTR
	MOV	A,M
	CPI	'.'
	JZ	A5087
	MVI	A,105
	SUB	M
	STA	I1
	MOV	M,A
A5087:	LXI	H,I2
	DCR	M
	LDA	I2
	ORA	A
	JNZ	A5086
	LHLD	PTR
	INR	M
A5088:	LHLD	TPTR
	LDA	IT
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	TPTR
	SHLD	TOS
A0509:	LXI	H,IT
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	RET	
A050A:	LHLD	TPTR	;ERROR RETURN
	SHLD	TOS
	LDA	DOR
	CPI	1
	JZ	A050X
	MVI	A,'-'
	CALL	CPUSH
	MVI	A,'1'
	CALL	CPUSH
	MVI	A,2
	STA	IT
	JMP	A0509
A050X:	XRA	A
	STA	IT
	JMP	A0509
A050B:	LHLD	LAST	;PERFECT MATCH FIXER
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,9
	DAD	D
	SHLD	PTR3
	JMP	A0500
A050C:	CALL	FNAKD
	CALL	FINDK	;GLOBAL SEARCH
	LHLD	PTR1
	LXI	D,NULL
	CALL	JPEN
	JZ	A050D
	LDA	I5	;MORE THAN 1 SUB LEFT
	CPI	1
	JC	$+6
	JNZ	A050A
A050D:	CALL	GETNE	;MOVE TO NEXT ENTRY
	LDA	RESUL
	CPI	FALSE
	JZ	A050A
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LHLD	NAME
	SHLD	PTR3
	LDA	SCNT
	STA	I5
	CALL	KEYCM
	LDA	I5
	ORA	A
	JNZ	A050E
	LHLD	PTR
	LXI	B,-(PTRLN)
	DAD	B
	SHLD	PTR
	MVI	A,TRUE
	STA	RESUL
	JMP	A050D
A050E:	LDA	I5
	CPI	1
	JNZ	A050A
	LDA	RESUL
	CPI	TRUE
	JNZ	A050A
	JMP	A0508
;*
;*
AC51:			;SET VALUE IN FOR
	CALL	SSCHK
	LHLD	VPTR
	SHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	NSTOS
	CALL	AC47 	;SET VALUE
	XRA	A    	;NO EXPRESSION VALUES SAVED
	CALL	CPUSH
	RET	
;*
;*
AC52:			;$RANDOM ACTION
	CALL	SSCHK
	LXI	H,INT1 	;GET RANGE
	CALL	STI
	MOV	A,M
	ANI	0F0H
	JNZ	E20
	MVI	C,INTLN
	CALL	ZTEST
	JZ	E20
	CALL	NXTRN	;GET NEXT RANDOM NUMBER
	RET	
;*
;*
AC53:			;DEVICE SPECIFIC WRITE
	CALL	SSCHK
	CALL	STC0
	STA	IT
	LXI	H,IT
	MVI	B,1
	CALL	PUSHT
	MVI	A,1
	CALL	CPUSH
	MVI	A,3
	CALL	CPUSH
	CALL	AC54 	;WRITE IT OUT
	RET	
;*
;*
AC54:		
	CALL	SSCHK
	LXI	H,TYPE 	;WRITE THE ITEM ON T-O-S
	MVI	B,1
	CALL	POPIT
	LDA	TYPE	;IS IT A NUMBER?
	CPI	3
	JC	A0543
	CPI	4	;IS IT STRING, BUT NOT ON STACK
	JZ	A0545
A0540:	LXI	H,COUNT
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	COUNT
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
A0542:	LHLD	TOS
	DCX	H
	SHLD	TPP
	JMP	A5455
A0543:	LXI	H,TYPE
	MVI	B,1
	CALL	PUSHT
	CALL	AC33 	;CONVERT INTEGER TO STRING
	LXI	H,TYPE
	MVI	B,1
	CALL	POPIT
	JMP	A0540
A0545:	LXI	H,TPP  	;GET PTR TO VALUE IN SYMBOL TABLE
	MVI	B,2
	CALL	POPIT
	LHLD	TPP	;STRING LENGTH
	MOV	A,M
	STA	COUNT
A5455:	LDA	COUNT
	STA	IT
A0546:	LHLD	TPP  	;WRITE IT OUT
	INX	H
	SHLD	TPP  
	LDA	IT
	ORA	A
	JZ	A0547
	MOV	A,M
	STA	CHR
	CALL	PUTCH
A5465:	LXI	H,IT
	DCR	M
	JMP	A0546
A0547:	LXI	H,INT1	;ADJUST $X
	LDA	COUNT
	CALL	CTI
	LHLD	DEVX
	LXI	D,INT1
	MVI	C,INTLN
	CALL	BCDAD
	RET	
;*
;*
AC55:			;HALT ACTION
	CALL	SSCHK
	LDA	FLG1
	ANI	DIRTY
	JNZ	E42
A0551:	CALL	GLBCL
	JMP	BOOT
;*
;*
AC56:			;SET $TEST=0, LINACT FALSE
	XRA	A
	STA	DIF
	LDA	ACTFL
	ORI	2
	STA	ACTFL
	LDA	FLAG	;IGNORE REST OF LINE
	ORI	2
	STA	FLAG
	RET	
;*
;*
AC57:			;SET $TEST=1
	MVI	A,1
	STA	DIF
	RET	
;*
;*
AC58:			;SET LINACT FALSE IF $TEST=0
	LDA	SWIF	;$TEST UNDEFINED
	CPI	2
	JZ	E3
	ORA	A
	JNZ	A0581
	LDA	ACTFL
	ORI	2
	STA	ACTFL
A0581:	RET	
;*
;*
AC59:			;SET LINACT FALSE IF $TEST=1
	LDA	SWIF	;$TEST UNDEFINED
	CPI	2
	JZ	E3
	CPI	1
	JNZ	A0591
	LDA	ACTFL
	ORI	2
	STA	ACTFL
A0591:	RET	
;*
;*
AC60:			;HANG ACTION
	CALL	SSCHK
	LXI	H,DTIME	;GET TIME TO HANG
	CALL	STI
	MOV	A,M
	ANI	0F0H
	JNZ	A0603
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A0603
	MVI	A,FALSE
	STA	TIME
	MVI	A,1
	STA	WAIT
A0601:	LDA	TIME
	CPI	FALSE
	JZ	A0601
	XRA	A
	STA	WAIT
A0603:	RET	
;*
;*
AC61:			;KILL ALL
	LHLD	PTEND
	SHLD	SYMPT
	SHLD	SYMEN
	RET	
;*
;*
AC62:			;MARK FOR EXCLUSIVE KILL
	CALL	SSCHK
	LDA	KILF
	CPI	1
	JZ	A0621
	CALL	GARBG	;MAKE SURE NO MARKED ENTRIES
A0621:	LXI	H,SCNT
	MVI	B,1
	CALL	POPIT
	LDA	SCNT
	ORA	A
	JZ	A0622
	CALL	AC76 	;NO SUBSCRIPTS ALLOWED
	JMP	E23
A0622:	LXI	H,TPP
	MVI	B,2
	CALL	POPIT
	LXI	H,NLENG	;NAME LENGTH
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	NLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	SHLD	NAME
	MVI	A,1
	STA	KILF
	CALL	SEARC
	LDA	RESUL
	CPI	1
	JZ	A0623
	RET	
A0623:	MVI	A,1
	STA	FNDF
	LHLD	LAST	;PTR1 TO START OF ENTRY
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR1
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	LAST
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	SYMPT	;LINK TO HEAD OF LIST
	XCHG	
	LHLD	PTR1
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR1
	SHLD	SYMPT
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR1
	MOV	A,M
	STA	TYPE
	MOV	A,M
	ORI	128
	MOV	M,A
	LDA	TYPE	;MOVE TO DOWN PTR
	CPI	4
	JC	A0624
	LHLD	PTR
	LXI	B,-(PTRLN)
	DAD	B
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR2
	XRA	A
	STA	IT
	CALL	MARKS	;MARK DESCENDENTS
A0624:	RET	
;*
;*
AC63:			;KILL EXCLUSIVE OF MARKED VARIABLES
	CALL	SSCHK
	XRA	A	;RESET EXCLUSIVE KILL FLAG
	STA	KILF
	LDA	FNDF
	ORA	A
	JNZ	A0630
	CALL	AC61
	RET	
A0630:	LHLD	SYMPT
	SHLD	PTR
A0631:	LHLD	PTR
	XCHG	
	LHLD	PTEND
	CALL	JPEN
	JZ	A0635
	LHLD	PTR	;SAVE START
	SHLD	TPTR
	MOV	E,M	;GET NEXT ONE
	INX	H
	MOV	D,M
	XCHG	
	SHLD	SPTR
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	MOV	A,M
	STA	TYPE
	MOV	A,M
	ANI	128
	JNZ	A0632
	MOV	A,M	;RESET, SO SET IT
	ORI	128
	MOV	M,A
	XRA	A
	STA	IT
	LHLD	PTEND
	XCHG	
	LHLD	PTR1
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	A0633
A0632:	LHLD	PTR	;SET, SO RESET IT
	MOV	B,M
	MVI	A,128
	CMA	
	ANA	B
	MOV	M,A
	MVI	A,1
	STA	IT
	LDA	TYPE
	SUI	128
	STA	TYPE
A0633:	LDA	TYPE
	CPI	4
	JC	A0634
	LHLD	PTR	;DESCENDENTS SO (RE)SET THEM
	LXI	D,5
	DAD	D
	MOV	A,M
	STA	I1
	MOV	C,A
	MVI	B,0
	DAD	B
	INX	H
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR2
	CALL	MARKS
A0634:	LHLD	TPTR
	SHLD	PTR1
	LHLD	SPTR
	SHLD	PTR
	JMP	A0631
A0635:	RET	
;*
;*
AC64:			;KILL VARIABLE + DESCENDENTS
	CALL	SSCHK
	LXI	H,TYPE 	;LOCAL OR GLOBAL
	MVI	B,1
	CALL	POPIT
	LXI	H,SCNT 	;SUBSCRIPT COUNT
	MVI	B,1
	CALL	POPIT
	LXI	H,NLEN 	;SIZE OF SUBS
	MVI	B,2
	CALL	POPIT
	LHLD	TOS
	DCX	H
	SHLD	PTR3
	LHLD	NLEN
	XCHG	
	LHLD	PTR3
	CALL	PSUB
	SHLD	PTR3
	INX	H
	SHLD	PTR
	LHLD	PTR3	;NAME LENGTH
	MOV	A,M
	STA	NLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR3
	SHLD	NAME
	SHLD	TPTR
	LDA	TYPE	;LOCAL OR GLOBAL?
	CPI	1
	JNZ	A0644
	CALL	SEARC
	LDA	RESUL	;DONE--NO ENTRY
	ORA	A
	JZ	A0643
	LDA	CASE	;DONE--INCOMPLETE SUBSCRIPT MATCH
	CPI	2
	JNZ	A0643
	LHLD	LAST	;PTR1 TO START OF ENTRY
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR1
	SHLD	TPP
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR1
	MOV	A,M	;ANY DESCENDENTS?
	CPI	3
	JC	$+6
	JNZ	A0641
	MOV	A,M	;MARK AS GARBAGE
	ORI	128
	MOV	M,A
	LHLD	TPP	;UNLINK IT
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	LAST
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	A0643	;DOEE
A0641:	LHLD	PTR1	;ARRAY HEADER?
	MOV	A,M
	CPI	7
	JC	$+6
	JNZ	A0642
	MOV	A,M	;MARK AS GARBAGE
	ORI	128
	MOV	M,A
	LHLD	TPP	;UNLINK IT
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	LAST
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR	;MOVE TO DOWN PTR
	LXI	B,-(PTRLN)
	DAD	B
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR2
	LHLD	PTR	;ZERO OUT DOWN POINTER
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	XRA	A
	STA	IT
	CALL	MARKS	;MARK DESCENDENTS
	JMP	A0643	;DONE
A0642:	LHLD	TPP	;GET PTR2 TO START FOR MARKS
	SHLD	PTR2
	LHLD	PTR1
	INX	H
	LXI	D,PTRLN
	DAD	D
	LXI	D,PTRLN	;MOVE TO ACROSS PTR
	DAD	D
	SHLD	PTR1
	MOV	E,M	;UNLINK ENTRY(S)
	INX	H
	MOV	D,M
	LHLD	LAST
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR1	;WIPE OUT ACROSS PTR
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	XRA	A
	STA	IT
	CALL	MARKS
A0643:	LHLD	TPTR
	SHLD	TOS
	RET	
A0644:	LDA	GLBDR
	STA	DRIVE
	XRA	A
	STA	FCBTY
	LDA	GLOPN
	CPI	1
	JZ	A6445
	CALL	FOPEN
	MVI	A,1
	STA	GLOPN
	CALL	RDROO
A6445:	LXI	H,ROOT
	LXI	D,NIL
	CALL	JDEN
	JZ	A0643
	CALL	FNAKD
	LDA	SCNT
	STA	SSCNT
	LHLD	TOS
	SHLD	TOP
	CALL	FINDK	;SEARCH FOR ENTRY
	LDA	RESUL
	CPI	FALSE
	JZ	A0646
A0645:	CALL	GLKIL	;KILL ENTRY
	LHLD	NAME
	SHLD	PTR3
	LDA	SSCNT
	STA	SCNT
	CALL	FINDK	;SEARCH FOR ENTRY AGAIN
A0646:	CALL	GETNE
	CALL	FDDSC	;SEE IF ANY DESCEDENTS
	LDA	RESUL
	CPI	TRUE
	JZ	A0645
	JMP	A0643
;*
;*
AC65:			;MAKE DEVICE CURRENT
	CALL	SSCHK
	LXI	H,COUNT	;GET COUNT OF PARAMS
	MVI	B,1
	CALL	POPIT
	LDA	COUNT	;TOO MANY PARAMETERS
	ORA	A
	JNZ	E48
	LXI	H,DEVNO	;GET DEVICE NUMBER
	MVI	B,1
	CALL	POPIT
	LDA	DEVNO
	STA	IT
	CALL	SETDE	;SET DEVICE PTRS
	LHLD	DEVOP	;CHECK DEVICE OPEN
	MOV	A,M
	ORA	A
	JNZ	A0651
	LDA	IODVC	;NO, BACK TO CURRENT
	STA	IT
	CALL	SETDE
	JMP	E49
A0651:	LDA	DEVNO
	STA	IODVC
	RET	
;*
;*
AC66:			;DEVICE SPECIFIC READ
	CALL	SSCHK
	LDA	RESUL
	ORA	A
	JZ	A0660
	LDA	SWIF
	ORA	A
	JZ	A0662
	JMP	A0661
A0660:	LHLD	DEVRD
	MOV	A,M
	CPI	1
	JZ	A0662
	LDA	IODVC
	ORA	A
	JNZ	A6605
	MVI	L,6
	CALL	BIOS
	STA	CHR
	JMP	A0661
BIOS:	MOV	E,L
	MVI	D,0
	LHLD	1
	DAD	D
	PCHL
A6605:	LHLD	DEVOP
	MOV	A,M
	CPI	2
	JZ	A6607
	LHLD	DVBSZ
	MOV	A,M
	LHLD	DVBSU
	MOV	M,A
A6607:	CALL	GETCH
	LHLD	DEVOP
	MVI	M,2
A0661:	LHLD	TOS
	SHLD	PTR4
	LDA	CHR
	CALL	CTS
	LHLD	DEVX
	MVI	C,INTLN
	CALL	ADD1
A0662:	LHLD	PTR4
	SHLD	PTR
	MVI	A,1
	STA	RDF
	CALL	AC47
	XRA	A
	STA	RDF
	RET	
;*
;*
AC67:			;WRITE STRING FROM A READ
	CALL	SSCHK
	CALL	AC54
	RET	
;*
;*
AC68:			;READ VALUE FROM TERMINAL
	CALL	SSCHK
	LHLD	TOS
	SHLD	PTR4
	LDA	IODVC
	STA	IT
	CALL	SETDE
	LDA	RESUL
	ORA	A
	JZ	A068A
	LDA	IODVC
	ORA	A
	JNZ	A0681
	LHLD	PTR4
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR4
	JMP	A0682
A068A:	LHLD	DEVRD	;DEVICE WRITE ONLY?
	MOV	A,M
	CPI	1
	JZ	E51
	XRA	A
	STA	SLENG
	LDA	IODVC
	ORA	A
	JZ	A0680
	LHLD	DEVOP
	MOV	A,M
	CPI	2
	JZ	A0681
A0680:	LHLD	DVBSZ
	MOV	A,M
	LHLD	DVBSU
	MOV	M,A
A0681:	CALL	GETCH	;GET A CHARACTER
	LDA	CHR
	CPI	CR
	JZ	A0682
	LDA	SLENG	;STRING TOO LONG
	CPI	STRLN
	JZ	E11
	LXI	H,SLENG
	INR	M
	LXI	H,CHR
	MVI	B,1
	CALL	PUSHT
	LDA	CHR
	CPI	EOF
	JZ	A0682
	JMP	A0681
A0682:	LXI	H,SLENG	;SAVE LENGTH
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	LDA	IODVC
	ORA	A
	JZ	A6825
	CALL	GETCH
A6825:	LHLD	DEVOP
	MVI	M,2
	LXI	H,INT1	;ADJUST $X
	LDA	SLENG
	CALL	CTI
	LHLD	DEVX
	LXI	D,INT1
	MVI	C,INTLN
	CALL	BCDAD
	LHLD	PTR4
	SHLD	PTR
	MVI	A,1
	STA	RDF
	CALL	AC47 	;SET VALUE
	XRA	A
	STA	RDF
A0683:	RET	
;*
;*
AC69:			;CLEAR OFF TRANSPT INFO
	CALL	SSCHK
	LXI	H,IT   	;GET TYPE
	MVI	B,1
	CALL	POPIT
	LDA	IT
	ORA	A
	JZ	A0691
	LXI	H,SLENG	;GET ROUTINE NAME LENGTH
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
A0691:	LDA	IT	;DONE
	CPI	1
	JZ	A0693
	LXI	H,IT   	;GET OFFSET
	MVI	B,1
	CALL	POPIT
	LDA	IT	;NO OFFSET
	ORA	A
	JZ	A0692
	LXI	H,SLENG
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
A0692:	LXI	H,IT   	;GET LABEL LENGTH
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	IT
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
A0693:	RET	
;*
;*
AC70:			;PUT -1 ON STACK
	CALL	SSCHK
	MVI	A,255
	CALL	CPUSH
	RET	
;*
;*
AC71:			;SAVE VALUE OF CASE
	CALL	SSCHK
	LXI	H,CASE
	MVI	B,1
	CALL	PUSHT
	RET	
;*
;*
AC72:			;GOTO ACTION
	CALL	SSCHK
	CALL	GTTRN	;GET TRANSFER POINT LOADED
A0721:	LDA	INDFL
	ORA	A
	JZ	A0722
	CALL	INDRE	;RETURN FROM INDIRECTION
	JMP	A0721
A0722:	LDA	FORSW
	ORA	A
	JZ	A0723
	POP	H
	SHLD	PTR1
	POP	H
	SHLD	PTR2
	CALL	AC89 	;RETURN FROM FOR
	CALL	AC90
	POP	H
	POP	H
	LHLD	PTR2
	PUSH	H
	LHLD	PTR1
	PUSH	H
	JMP	A0722
A0723:	CALL	AC105	;IGNORE REST OF LINE
	XRA	A
	STA	MODE
	MVI	A,FALSE
	STA	GOTOF
	LDA	INDSW
	ORA	A
	JZ	A0724
	MVI	A,TRUE
	STA	GOTOF
A0724:	RET	
;*
;*
AC73:			;DO ACTION
	CALL	SSCHK
	CALL	GTTRN	;GET TRANSFER POINT LOADED
	LDA	NLENG
	STA	IT
A0731:	LDA	IT
	ORA	A
	JZ	A0732
	LHLD	PTR4
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR4
	INX	H
	SHLD	PTR4
	LXI	H,IT
	DCR	M
	JMP	A0731
A0732:	LXI	H,NLENG	;SAVE OLD NAME LENGTH
	MVI	B,1
	CALL	PUSHT
	LXI	H,PRGLS	;SAVE START OF LINE
	MVI	B,2
	CALL	PUSHT
	LXI	H,INDX 	;SAVE LOCATION IN LINE
	MVI	B,2
	CALL	PUSHT
	LXI	H,FORSW	;SAVE FOR COUNT
	MVI	B,1
	CALL	PUSHT
	LXI	H,INDSW	;SAVE XECUTE COUNT
	MVI	B,1
	CALL	PUSHT
	LXI	H,INDFL	;SAVE INDIRECTION FLAG
	MVI	B,1
	CALL	PUSHT
	LXI	H,MODE
	MVI	B,1
	CALL	PUSHT
	LXI	H,DOSW
	INR	M
	LXI	H,LEVEL
	INR	M
	LDA	LEVEL	;NESTING TOO DEEPLY
	CPI	MXLVL
	JZ	E32
	XRA	A
	STA	FORSW
	STA	INDSW
	STA	INDFL
	STA	MODE
	CALL	INPUT
	JMP	MMP6
;*
;*
AC74:			;$TEST WITH LINEREF
	CALL	SSCHK
	CALL	MV2LN	;PTR1 TO LINE
	LHLD	TOS
	DCX	H
	SHLD	TOS
	CALL	LN2ST	;LINE TO STACK
	RET	
;*
;*
AC75:			;QUIT ACTION
	CALL	SSCHK
	LDA	FORSW
	ORA	A
	JZ	A0751
	CALL	AC89 	;RETURN FROM FOR
	CALL	AC90
	LDA	FORSW
	ORA	A
	JNZ	A0753
	LDA	FLAG
	ORI	2
	STA	FLAG
	JMP	A0753
A0751:	LDA	INDSW
	ORA	A
	JZ	A0752
	CALL	XECRE
	JMP	A0754
A0752:	LDA	DOSW
	ORA	A
	JZ	A0755
	CALL	DORET	;RETURN FROM DO
	JMP	A0754
A0753   POP     H
A0754   POP     H
        POP     H
	JMP	A0756
A0755:	LDA	AUTO
	CPI	3
	JZ	A0551
	MVI	A,1
	STA	MODE
	MVI	A,2
	STA	FLAG
A0756:	RET	
;*
;*
AC76:			;UNMARK SYMBOL TABLE AFTER EXCLUSIVE KILL
	CALL	SSCHK
	LDA	KILF	;DONE--NOTHING MARKED YET
	ORA	A
	JZ	A0762
	XRA	A
	STA	KILF
	LHLD	SYMEN
	SHLD	PTR
A0761:	LHLD	PTR
	XCHG	
	LHLD	PTEND
	CALL	JPEN
	JZ	A0762
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	MOV	B,M	;RESET GARBAGE FLAG
	MVI	A,128
	CMA	
	ANA	B
	MOV	M,A
	INX	H
	SHLD	TPP
	MOV	E,M	;GET SIZE
	INX	H
	MOV	D,M
	XCHG	
	SHLD	TPP
	XCHG	
	LHLD	PTR
	DAD	D
	SHLD	PTR
	JMP	A0761
A0762:	RET	
;*
;*
AC77:			;CLOSE DEVICE--RELEASE
	CALL	SSCHK
	LXI	H,NUMBR	;GET COUNT OF PARAMS
	MVI	B,1
	CALL	POPIT
	LDA	NUMBR
	ORA	A
	JZ	A0771
	CPI	1	;TOO MANY PARAMS
	JNZ	E48
	LXI	H,INT1 	;GET ARGUMENT
	CALL	STI
A0771:	LXI	H,DEVNO	;GET DEVICE NUMBER
	MVI	B,1
	CALL	POPIT
	LDA	DEVNO
	STA	IT
	CALL	SETDE	;SET DEVICE PTRS
	LDA	DEVNO	;CHECK IF DISK
	CPI	2
	JC	A0772
	LHLD	DEVOP	;LAST USED FOR A WRITE?
	MOV	A,M
	CPI	3
	JNZ	A0772
	LHLD	DVPTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MVI	M,EOF
	LDA	XTDRV
	STA	DRIVE
	LHLD	DEVPM
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	FCB
	LHLD	DVBST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BUFFR
	CALL	FWRIT
A0772:	LHLD	DEVOP
	MOV	A,M
	ORA	A
	JZ	E49
	MVI	M,0
	LDA	NUMBR
	ORA	A
	JZ	A0775
	LDA	DEVNO
	CPI	2
	JC	A0775
	LDA	XTDRV
	STA	DRIVE
	LHLD	DEVPM
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	FCB
	LXI	H,INT1
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A0774
A0773:	CALL	REMOV
	JMP	A0775
A0774:	CALL	FCLOS
A0775:	LDA	DEVNO
	LXI	H,IODVC
	CMP	M
	JNZ	A0776
	XRA	A
	STA	IT
	STA	IODVC
	CALL	SETDE
A0776:	RET	
;*
;*
AC78:			;SEIZE OWNERSHIP OF DEVICE
	CALL	SSCHK
	LXI	H,COUNT	;GET COUNT OF PARAMS
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	SHLD	PTR
	LDA	COUNT
	ORA	A
	JZ	A0781
	CPI	2	;TOO MANY PARAMETERS
	JC	$+6
	JNZ	E48
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,IT   	;GET NAME LENGTH
	MVI	B,1
	CALL	POPIT
	LDA	IT	;SEE IF DEFAULT
	ORA	A
	JNZ	A078A
	LXI	H,SYSF	;DEFAULT NAME
	SHLD	PTR
A078B:	LHLD	PTR
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR
	INX	H
	SHLD	PTR
	LXI	H,IT
	INR	M
	LHLD	PTR
	MOV	A,M
	CPI	DELIM
	JNZ	A078B
A078A:	LHLD	TOS
	SHLD	PTR
	LXI	H,IT
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR  	;PTR TO END OF NAME
	DCX	H
	SHLD	PTR  
	LDA	IT	;PTR TO START OF NAME
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR
	DCX	H	;PTR TO LENGTH OF DRIVE
	SHLD	PTR  
	MOV	A,M
	STA	IT
	CPI	1
	JC	$+6
	JNZ	E50
	ORA	A
	JNZ	A078C
	XRA	A	;DEFAULT DRIVE IS A
	STA	XTDRV
	JMP	A0781
A078C:	LHLD	PTR
	DCX	H
	SHLD	PTR
	MOV	A,M	;GET DRIVE LETTER
	SUI	'A'
	STA	XTDRV
A0781:	LHLD	PTR
	DCX	H
	SHLD	PTR
	MOV	A,M
	STA	IT
	CALL	SETDE
	LDA	COUNT
	ORA	A
	JZ	A0784
	MVI	A,2	;SET UP FCB
	STA	FCBTY
	LDA	XTDRV
	STA	DRIVE
	CALL	FSEAR
	LDA	RESUL	;FILE EXISTS
	CPI	1
	JNZ	A0782
	CALL	FOPPL
	LHLD	DEVRD
	MVI	M,2
	JMP	A0783
A0782:	CALL	MAKE
	LHLD	DEVRD
	MVI	M,1
A0783:	LHLD	TOS
	DCX	H
	SHLD	TOS
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LHLD	TOS
	DCX	H
	SHLD	TOS
A0784:	LHLD	TOS
	DCX	H
	SHLD	TOS
	LHLD	DEVOP	;SET DEVICE OPEN
	MVI	M,1
	LDA	IODVC	;RETURN CURRENT
	STA	IT
	CALL	SETDE	;DEVICE PARAMETERS
	RET	
;*
;*
AC79:			;SET NUMERIC VALUE FOR FOR
	CALL	SSCHK
	CALL	AC34 	;CONVERT T-O-S TO NUMERIC
	LXI	H,FREAL
	CALL	STN
	RET	
;*
;*
AC80:			;WRITE OUT ROUTINE NAMES
	CALL	SSCHK
	XRA	A
	STA	IT
	STA	I4X
A0801:	CALL	SERCH	;LOOK FOR AN MMP FILE
	LDA	RESUL
	CPI	FALSE
	JZ	A0805
	XRA	A
	STA	COUNT
A0802:	LDA	COUNT
	CPI	8
	JZ	A0803
	LHLD	PTR  	;ROUTINE NAME ON STACK
	MVI	B,1
	CALL	PUSHT
	LXI	H,COUNT
	INR	M
	LHLD	PTR
	INX	H
	SHLD	PTR
	MOV	A,M
	CPI	BLANK
	JNZ	A0802
A0803:	MVI	A,12	;PAD NAME SO IT TAKES 12 SPACES
	LXI	H,COUNT
	SUB	M
	STA	ITX
A0804:	MVI	A,' '	;'
	CALL	CPUSH
	LXI	H,ITX
	DCR	M
	LDA	ITX
	ORA	A
	JNZ	A0804
	MVI	A,12
	CALL	CPUSH
	MVI	A,3
	CALL	CPUSH
	CALL	AC54 	;WRITE OUT NAME
	MVI	A,1	;AT LEAST SECOND TIME TO SERCH
	STA	IT
	LXI	H,I4X
	INR	M
	LDA	I4X	;SEE IF NEED NEW LINE (5 PER LINE)
	CPI	5
	JNZ	A0801
	CALL	AC24
	XRA	A
	STA	I4X
	JMP	A0801
A0805:	LDA	I4X
	ORA	A
	JZ	A0806
	CALL	AC24
A0806:	RET	
;*
;*
AC81:			;SEARCH SYMBOL TABLE FOR NAME
	CALL	SSCHK
	LXI	H,SCNT 	;GET SUBSCRIPT COUNT
	MVI	B,1
	CALL	POPIT
	LXI	H,TPP  	;GET POINTER TO BASE OF SUBS
	MVI	B,2
	CALL	POPIT
	LHLD	TOS
	SHLD	PTR3
	LXI	D,PTRLN+SHTLN
	DAD	D
	SHLD	TOS
	LHLD	PTR3
	DCX	H
	SHLD	PTR3
	LHLD	TPP
	XCHG	
	LHLD	PTR3
	CALL	PSUB
	MOV	A,M
	STA	NLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR3
	SHLD	NAME
	CALL	SEARC
	LDA	RESUL	;NO MATCH
	ORA	A
	JZ	E3
	LDA	STYPE
	CPI	4
	JZ	E3
	CPI	8
	JZ	E3
	LDA	SCNT
	ORA	A
	JNZ	E3
	LDA	STYPE
	CPI	4
	JC	A8126
	SUI	4
	STA	STYPE
	CPI	4
	JC	A8126
	SUI	4
	STA	STYPE
A8126:	LDA	STYPE
	STA	TYPE
	LDA	FORFL
	CPI	1
	JZ	A8127
	LHLD	PTR3
	SHLD	TOS
	JMP	A8128
A8127:	LHLD	TOPTR
	SHLD	TOS
A8128:	LHLD	PTR	;IT'S A STRING
	MOV	A,M
	STA	SLENG
	INX	H
	SHLD	PTR
	STA	IT
A8129:	LDA	IT
	ORA	A
	JZ	A812A
	LHLD	PTR
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR
	INX	H
	SHLD	PTR
	LXI	H,IT
	DCR	M
	JMP	A8129
A812A:	LXI	H,SLENG
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	STA	TYPE
	JMP	A0815
A0815:	LXI	H,TYPE
	MVI	B,1
	CALL	PUSHT
	XRA	A
	STA	FORFL
	RET	
;*
;*
AC82:			;EXECUTE SCOPE OF FOR ONCE
	CALL	SSCHK
	LXI	H,INDX
	MVI	B,2
	CALL	PUSHT
	LHLD	TOS
	LXI	B,-(PTRLN+SHTLN)
	DAD	B
	SHLD	PTR
	MOV	A,M
	STA	IT
A0821:	LDA	IT
	ORA	A
	JZ	A0822
	LHLD	PTR
	DCX	H
	DCX	H
	MOV	A,M
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR
	LXI	H,IT
	DCR	M
	JMP	A0821
A0822:	LHLD	PTR
	LXI	B,-(PTRLN)
	DAD	B
	SHLD	PTR
	MOV	E,M	;RETRIEVE B-O-S
	INX	H
	MOV	D,M
	XCHG	
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	JMP	MMP6
;*
;*
AC83:			;ADD INCREMENT FOREVER
	CALL	SSCHK
	LXI	H,INDX 	;GET VALUES OFF STACK
	MVI	B,2
	CALL	POPIT
	LHLD	TOS
	SHLD	PTR1
	LHLD	PTR1 	;PTR1 TO # OF EXPRESSIONS
	DCX	H
	DCX	H	;PTR1 TO STRING INDICATOR         
	DCX	H	;PTR TO LENGTH OF INCREMENT
	SHLD	PTR1 
	MOV	A,M	;GET LENGTH TO I1
	STA	I1X
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR1
	LHLD	TOS
	SHLD	TOPTR
	SHLD	PTR2
	LHLD	PTR1
	LXI	B,-(PTRLN)
	DAD	B
	SHLD	TOS
	SHLD	VPTR
	MVI	A,1
	STA	FORFL
	CALL	AC81 	;GET VALUE
	CALL	AC34
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I2
	MVI	B,1
	CALL	POPIT
	LDA	I1X
	STA	I1
	MVI	A,5	;MAKE IT +
	STA	I6
	CALL	NUMOP
	LHLD	VPTR
	SHLD	PTR
	LHLD	TOPTR
	SHLD	NSTOS
	CALL	AC47 	;SET CONTROL VALUE
	MVI	A,2	;ENABLE SEMANTIC ACTIONS
	STA	CASE
	RET	
;*
;*
AC84:			;$TEXT WITH OFFSET
	CALL	SSCHK
	MVI	A,1
	STA	DT
	LHLD	PRGAD
	SHLD	PTR1
	LXI	H,INT1
	CALL	STI
	MVI	C,INTLN
	CALL	SUB1
	CALL	ITS
	CALL	MV2LN	;PTR1 TO LINE
	CALL	LN2ST	;LINE TO STACK
	XRA	A
	STA	DT
	RET	
;*
;*
AC85:			;RETURN GLOBAL VALUE ON STACK
	CALL	SSCHK
	LXI	H,SCNT 	;GET SUBSCRIPT COUNT
	MVI	B,1
	CALL	POPIT
	LXI	H,TPP  	;GET POINTER TO BASE OF SUBS
	MVI	B,2
	CALL	POPIT
	LHLD	TPP
	SHLD	NLEN
	LHLD	TOS
	DCX	H
	SHLD	PTR6
	LHLD	TPP	;PTR3 TO LENGTH OF NAME
	XCHG	
	LHLD	PTR6
	CALL	PSUB
	SHLD	PTR6
	INX	H
	SHLD	PTR
	LHLD	PTR6
	MOV	A,M
	STA	NLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR6
	SHLD	PTR3
	SHLD	NAME
	CALL	FNAKD
	XRA	A
	STA	NR
	CALL	FINDK	;SEARCH FOR KEY
	LDA	RESUL	;NO SUCH NAME
	ORA	A
	JZ	E7
	LHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	PTR
	DAD	D
	LXI	D,PTRLN
	DAD	D
	MOV	A,M
	STA	STYPE
	INX	H
	SHLD	PTR
	LHLD	PTR6
	SHLD	TOS
A0853:	LHLD	PTR	;SET STRING LENGTH
	MOV	A,M
	STA	SLENG
	INX	H
	SHLD	PTR
	STA	IT
A8532:	LDA	IT
	ORA	A
	JZ	A8535
	LHLD	PTR
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR
	INX	H
	SHLD	PTR
	LXI	H,IT
	DCR	M
	JMP	A8532
A8535:	LXI	H,SLENG
	MVI	B,1
	CALL	PUSHT
A0854:	LXI	H,STYPE
	MVI	B,1
	CALL	PUSHT
	RET	
;*
;*
AC86:			;PATTERN MATCHING
	CALL	SSCHK
	LHLD	INDX
	SHLD	TPP
	LHLD	TOS
	LXI	D,IMIN2
	CALL	SETI
	LHLD	TOS
	LXI	D,INTLN
	DAD	D
	SHLD	TOS
	LHLD	TARPT
	SHLD	PTR1
	DCX	H
	DCX	H
	SHLD	INDX
	MOV	A,M
	STA	SLENG
	SHLD	PTR2	;MARK END OF STRING
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	INDX
	SHLD	PTR3
	DCX	H
	SHLD	INDX
	CALL	GTOKN	;SAVE START OF STRING
	MVI	A,1
	STA	RESUL
	XRA	A
	STA	I1
A0861:	LXI	D,INT2	;GET REPITION COUNT
	LHLD	PTR1
	XCHG	
	CALL	SETI
	LHLD	PTR1
	LXI	D,INTLN
	DAD	D
	SHLD	PTR1
	LXI	H,INT2
	MOV	A,M
	ANI	0F0H
	JNZ	A8612
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A8612
	JMP	A0864
A8612:	LXI	H,INT2
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A0862
	LXI	D,IMIN1
	MVI	B,INTLN
	MVI	C,INTLN
	CALL	SCMP
	JZ	A0862
	LHLD	INDX
	XCHG	
	LHLD	PTR2
	CALL	JPEN
	JZ	A0868
	JMP	A0865
A8615:	LXI	H,INT2
	LXI	D,IMIN1
	CALL	SETI
A0862:	LXI	H,I1   	;INCREMENT LEVEL
	INR	M
	LXI	H,PTR1 	;SAVE CURRENT STATUS
	MVI	B,2
	CALL	PUSHT
	LXI	H,INDX
	MVI	B,2
	CALL	PUSHT
	LXI	D,INT3
	LHLD	PTR1
	XCHG	
	CALL	SETI
	LHLD	PTR1
	LXI	D,INTLN
	DAD	D
	SHLD	PTR1
	LXI	H,INT3
	MOV	A,M
	ANI	0F0H
	JNZ	A8625
	JMP	A0863
A8625:	LXI	H,INT3
	MOV	A,M
	XRI	0F0H
	MOV	M,A
A0863:	LXI	H,INT3
	CALL	ITC
	STA	IT
	LHLD	PTR1
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR1
	JMP	A0861
A0864:	CALL	MATCH
	LXI	H,INT2
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A0861
	LXI	H,INT1
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A0861
A0865:	LDA	I1
	ORA	A
	JNZ	A0866
	XRA	A
	STA	RESUL
	JMP	A0868
A0866:	LXI	H,INDX
	MVI	B,2
	CALL	POPIT
	LXI	H,PTR1
	MVI	B,2
	CALL	POPIT
	LXI	H,I1
	DCR	M
	LXI	H,INT2
	LXI	D,IMIN1
	CALL	SETI
	LHLD	INDX
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	CALL	MATCH
	LXI	H,INT2
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A8615
	JMP	A0865
A0868:	LHLD	PTR3
	SHLD	TOS
	LDA	FLG1
	ANI	NOTFL
	JZ	A0869
	LDA	FLG1
	MOV	B,A
	MVI	A,NOTFL
	CMA	
	ANA	B
	STA	FLG1
	LDA	RESUL
	XRI	1
	STA	RESUL
A0869:	LDA	RESUL
	CALL	CTS
	LHLD	TPP
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	RET	
;*
;*
AC87:			;CHECK IF ITERATION NEEDED
	CALL	SSCHK
	LHLD	TOS
	SHLD	TOPTR
	LHLD	VPTR
	SHLD	TOS
	MVI	A,1
	STA	FORFL
	CALL	AC81 	;GET CONTROL VALUE
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,LVAL 	;GET LENGTH OF VALUE
	MVI	B,1
	CALL	POPIT
	MVI	A,6	;DO A SUBTRACT
	STA	I6
	LHLD	TOS	;SAVE WHERE START OF SUBTRACT WILL BE
	SHLD	PTR
	LHLD	IPTR
	MOV	A,M
	CPI	'-'
	JZ	A0871
	LHLD	TOPTR	;GET VALUE - FINAL
	SHLD	PTR1
	LHLD	FPTR
	SHLD	PTR2
	LDA	LVAL
	STA	I1
	LDA	FSZ
	STA	I2
A0870:	CALL	NUMOP
	LHLD	TOPTR
	SHLD	TOS
	LHLD	PTR
	MOV	A,M
	CPI	'-'
	JZ	A0872
	MOV	A,M
	CPI	'0'
	JZ	A0872
	XRA	A	;NO ITERATIONS
	STA	CASE
	LXI	H,INDX
	MVI	B,2
	CALL	PUSHT
	RET	
A0871:	LHLD	FPTR
	SHLD	PTR1
	LHLD	TOPTR
	SHLD	PTR2
	LDA	FSZ
	STA	I1
	LDA	LVAL
	STA	I2
	JMP	A0870
A0872:	MVI	A,1	;ITERATIONS
	STA	CASE
	RET	
;*
;*
AC88:			;ADD INCREMENT TO CONTROL VAR AND TEST
	CALL	SSCHK
	XRA	A
	STA	CASE
	CALL	FORSE	;SET FOR POINTERS IN STACK
	LHLD	VPTR
	SHLD	TOS
	MVI	A,1
	STA	FORFL
	CALL	AC81 	;GET CONTROL VALUE
	CALL	AC34
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,LVAL 	;GET LENGTH OF CONTROL VALUE
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	SHLD	PTR
	LHLD	FPTR
	SHLD	PTR1
	LDA	FSZ
	STA	I1
	LHLD	IPTR
	SHLD	PTR2
	LDA	ISZ
	STA	I2
	MVI	A,6
	STA	I6
	CALL	NUMOP	;GET FINAL - INCREMENT
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I3
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	SHLD	PTR4
	LHLD	IPTR
	MOV	A,M
	CPI	'-'
	JZ	A0881
	LHLD	PTR
	SHLD	PTR1
	LDA	I3
	STA	I1
	LHLD	TOPTR
	SHLD	PTR2
	LDA	LVAL
	STA	I2
A0880:	CALL	NUMOP	;TEST IF AT END
	LHLD	PTR4
	MOV	A,M
	CPI	'-'
	JZ	A0883
	JMP	A0882
A0881:	LHLD	TOPTR
	SHLD	PTR1
	LDA	LVAL
	STA	I1
	LHLD	PTR
	SHLD	PTR2
	LDA	I3
	STA	I2
	JMP	A0880
A0882:	LHLD	IPTR
	SHLD	PTR1
	LDA	ISZ
	STA	I1
	LHLD	TOPTR
	SHLD	PTR2
	LDA	LVAL
	STA	I2
	MVI	A,5
	STA	I6
	CALL	NUMOP	;GET INCREMENT + CONTROL VALUE
	LHLD	VPTR
	SHLD	PTR
	LHLD	TOPTR
	SHLD	NSTOS
	CALL	AC47 	;ENTER VALUE IN SYMBOL TABLE
	MVI	A,1
	STA	CASE
	RET	
A0883:	LHLD	TOPTR
	SHLD	TOS
	LXI	H,INDX
	MVI	B,2
	CALL	PUSHT
	RET	
;*
;*
AC89:			;REMOVE FOR EXPRESSIONS FROM STACK
	CALL	SSCHK
	LXI	H,INDX
	MVI	B,2
	CALL	POPIT
	LXI	H,TYPE
	MVI	B,1
	CALL	POPIT
A0890:	LDA	TYPE
	ORA	A
	JZ	A0892
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I1
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	I1
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	LXI	H,TYPE
	DCR	M
	JMP	A0890
A0892:	LHLD	INDX
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	LHLD	TOS
	SHLD	PTR5
	LXI	B,-(PTRLN)
	DAD	B
	SHLD	VPTR
	RET	
;*
;*
AC90:			;REMOVE LAST OF FOR INFO
	CALL	SSCHK
	LXI	H,LEVEL
	DCR	M
	LXI	H,FORSW
	DCR	M
	LHLD	TOS	;PAST B-O-S
	LXI	B,-(PTRLN)
	DAD	B
	SHLD	TOS
	DCX	H	;PAST SUB COUNT
	SHLD	TOS  
	LXI	H,PTR
	MVI	B,2
	CALL	POPIT
	LHLD	PTR	;PAST SUBSCRIPTS
	XCHG	
	LHLD	TOS
	CALL	PSUB
	SHLD	TOS
	LHLD	TOS  	;TO NAME LENGTH
	DCX	H
	SHLD	TOS  
	MOV	A,M	;PAST NAME
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
A0901:	LDA	TOKEN
	CPI	38
	JZ	A0902
	CALL	GTOKN
	JMP	A0901
A0902:	RET	
;*
;*
AC91:			;TIMEOUT ACTION
	CALL	SSCHK
	LXI	H,DTIME	;GET NUMBER OF SECONDS      
	CALL	STI
	XRA	A
	STA	SLENG
	LDA	LOCKS
	CPI	1
	JZ	A0916
	MOV	A,M
	ANI	0F0H
	JNZ	A0913
	MVI	C,INTLN
	CALL	ZTEST
	JZ	A0913
	LDA	IODVC
	ORA	A
	JNZ	A0916
	MVI	A,FALSE
	STA	TIME
	MVI	A,1
	STA	WAIT
A0911:	MVI	L,3
	CALL	BIOS
	ORA	A
	JZ	A0912
	MVI	L,6
	CALL	BIOS
	STA	CHR
	LDA	TIMF
	ORA	A
	JZ	A0914
	LDA	CHR
	CPI	CR
	JZ	A0914
	CALL	TRMOT
	LXI	H,CHR
	MVI	B,1
	CALL	PUSHT
	LXI	H,SLENG
	INR	M
	LDA	SLENG
	CPI	STRLN
	JZ	A0913
A0912:	LDA	TIME
	CPI	FALSE
	JZ	A0911
A0913:	XRA	A
	STA	SWIF
	LDA	TIMF
	CPI	1
	JZ	A0915
	LHLD	TOS
	SHLD	PTR4
	LXI	H,IMIN1
	CALL	ITS
	JMP	A0915
A0914:	MVI	A,1
	STA	SWIF
A0915:	XRA	A
	STA	WAIT
	RET	
A0916:	MVI	A,1
	STA	SWIF
	RET	
;*
;*
AC92:			;DELETE ROUTINE
	LHLD	PRGAD
	SHLD	PRGEN
	SHLD	PRGPT
	LXI	H,PRG	;CLEAR NAME
	SHLD	PTR
	MVI	A,NAMLN
	STA	IT
A0921:	LHLD	PTR
	MVI	M,BLANK
	LXI	H,IT
	DCR	M
	LDA	IT
	ORA	A
	JNZ	A0921
	LDA	FLG1	;NOT DIRTY
	MOV	B,A
	MVI	A,DIRTY
	CMA	
	ANA	B
	STA	FLG1
	LHLD	PRGEN
	MVI	M,EOR
	RET	
;*
;*
AC93:			;DELETE FROM LINE A TO LINE B
	CALL	SSCHK
	CALL	LINSE
	CALL	LINDE	;DELETE LINE
	RET	
;*
;*
AC94:			;LOAD ROUTINE
	CALL	SSCHK
	CALL	LOADI
	LHLD	PRGEN
	SHLD	PRGPT
	LDA	FLG1
	MOV	B,A
	MVI	A,DIRTY
	CMA	
	ANA	B
	STA	FLG1
	RET	
;*
;*
AC95:			;PRGPT TO TOP
	LHLD	PRGAD
	SHLD	PRGPT
	RET	
;*
;*
AC96:			;MOVE PRGPT TO LINE
	CALL	SSCHK
	CALL	MV2LN	;MOVE PTR1 TO LINE
	LDA	RESUL
	ORA	A
	JZ	E34
	LHLD	PTR1
	SHLD	PRGPT
	RET	
;*
;*
AC97:			;LIST ENTIRE ROUTINE
	CALL	SSCHK
	LHLD	PRGAD
	SHLD	PTR
A0971:	LHLD	PTR
	MOV	A,M
	CPI	EOR
	JZ	A0972
	CALL	LINWR	;WRITE OUT LINE
	JMP	A0971
A0972:	RET	
;*
;*
AC98:			;LIST FROM LINE A TO LINE B
	CALL	SSCHK
	CALL	LINSE
	LHLD	PTR1	;PTR TO START OF LINE(S)
	SHLD	PTR
A0981:	CALL	LINWR	;LINE WRITE ROUTINE
	LHLD	PTR
	XCHG	
	LHLD	PTR3
	CALL	JPEN
	JNZ	A0981
	RET	
;*
;*
AC99:			;SCAN FOR B-O-S
	CALL	SSCHK
	LXI	H,FORSW
	INR	M
	LXI	H,LEVEL
	INR	M
	LDA	LEVEL	;NEESTING TOO DEEPLY
	CPI	MXLVL
	JZ	E32
	LHLD	INDX	;SAVE INDX
	SHLD	PTR
	LDA	TOKEN	;SAVE TOKEN
	STA	IT
	XRA	A
	STA	I1
A0991:	LDA	TOKEN	;CHECK FOR SPACE
	CPI	31
	JZ	A9915
	CPI	38	;CHECK FOR EOL
	JZ	A0993
	CPI	23
	JNZ	A9913
	MVI	A,1
	LXI	H,I1
	SUB	M
	STA	I2
	STA	I1
A9913:	CALL	GTOKN
	JMP	A0991
A9915:	LDA	I1
	CPI	1
	JZ	A9913
A0992:	LHLD	INDX
	INX	H
	SHLD	INDX
A0993:	LXI	H,INDX 	;SAVE B-O-S
	MVI	B,2
	CALL	PUSHT
	LHLD	PTR	;RETURN INDX
	SHLD	INDX
	LDA	IT	;AND TOKEN
	STA	TOKEN
	RET	
;*
;*
AC100:			;PUSH GLB ON STACK
	CALL	SSCHK
	LXI	H,INDFL
	MVI	B,1
	CALL	PUSHT
	LXI	H,NR
	MVI	B,1
	CALL	PUSHT
	LXI	H,SETSW
	MVI	B,1
	CALL	PUSHT
	LXI	H,GLB
	MVI	B,1
	CALL	PUSHT
	XRA	A
	STA	INDFL
	MVI	A,FALSE
	STA	SETSW
	RET	
;*
;*
AC101:			;DUMMY ROUTINE TO FIX STABK FOR LOCK
	LHLD	SETBS
	SHLD	TOS
	XRA	A
	STA	SETF
	RET	
;*
;*
AC102:	RET	
;*
;*
AC103:			;XECUTE ACTION
	CALL	SSCHK
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,SLENG
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR
	LXI	H,INDSW
	INR	M
	LXI	H,LEVEL
	INR	M
	LDA	LEVEL	;NESTING TOO DEEPLY
	CPI	MXLVL
	JZ	E32
	LXI	H,SLENG
	INR	M
	MVI	A,EOL
	CALL	CPUSH
	LXI	H,SLENG	;SAVE LENGTH
	MVI	B,1
	CALL	PUSHT
	XRA	A
	STA	N
	LXI	H,PRG
	SHLD	PTR1
A1031:	LHLD	PTR1	;SAVE ROUTINE NAME
	MOV	A,M
	CPI	BLANK
	JZ	A1032
	MVI	B,1
	CALL	PUSHT
	LXI	H,N
	INR	M
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	LDA	N
	CPI	NAMLN
	JNZ	A1031
A1032:	LXI	H,N    	;SAVE NAME5 LENGTH
	MVI	B,1
	CALL	PUSHT
	LDA	INDSW
	CPI	1
	JC	$+6
	JNZ	A1033
	LXI	H,PRGLS	;SAVE LINE PTR IN ROUTINE
	MVI	B,2
	CALL	PUSHT
A1033:	LXI	H,INDX
	MVI	B,2
	CALL	PUSHT
	LXI	H,FORSW
	MVI	B,1
	CALL	PUSHT
	LXI	H,INDFL
	MVI	B,1
	CALL	PUSHT
	LXI	H,MODE
	MVI	B,1
	CALL	PUSHT
	XRA	A
	STA	FORSW
	STA	INDFL
	LHLD	PTR	;SET INDX TO START OF STRING
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	JMP	MMP6
;*
;*
AC104:			;MAKE STACK T-O-S TO STRING FOR $CHAR
	CALL	SSCHK
	MVI	A,3
	CALL	CPUSH
	RET	
;*
;*
AC105:		
	MVI	A,1
	STA	DSF
	LDA	ACTFL	;SET LINACT
	ORI	2
	STA	ACTFL
	RET	
;*
;*
AC106:			;CONVERT PARAM EXPR AND INCREMENT COUNT
	CALL	SSCHK
	CALL	AC33 	;T-O-S TO STRING
	CALL	PAST 	;GO PAST T-O-S ITEM
	LXI	H,PTR
	MVI	B,2
	CALL	POPIT
	LXI	H,TPP
	MVI	B,2
	CALL	POPIT
	LHLD	PTR	;GET OLD COUNT
	MOV	A,M
	STA	COUNT
	SHLD	PTR2	;SAVE PTR
	INX	H
	SHLD	PTR1
A1061:	LHLD	PTR1
	MOV	A,M
	LHLD	PTR
	MOV	M,A
	LHLD	TPP
	DCX	H
	SHLD	TPP
	LHLD	PTR
	INX	H
	SHLD	PTR
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	LHLD	TPP
	LXI	D,NULL
	CALL	JPEN
	JNZ	A1061
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,COUNT
	INR	M
	MVI	B,1	;SAVE NEW COUNT
	CALL	PUSHT
	RET	
;*
;*
AC107:		
	CALL	SSCHK
	LXI	H,COUNT
	MVI	B,1
	CALL	POPIT
	XRA	A
	CALL	CPUSH
	MVI	A,3
	CALL	CPUSH
A1072:	LXI	H,COUNT
	INR	M
	MVI	B,1
	CALL	PUSHT
	RET	
;*
;*
AC108:			;CHECK FOR END OF NAME LEVEL INDIRECTION
	CALL	SSCHK
	LDA	INDFL
	CPI	1
	JNZ	A1082
	LDA	TOKEN
	CPI	40
	JNZ	E24
A1081:	CALL	INDRE	;RETURN FROM INDIRECTION
	LDA	INDFL
	CPI	2
	JNZ	A1082
	LDA	TOKEN
	CPI	40
	JZ	A1081
A1082:	RET	
;*
;*
AC109:			;PUT INDIRECT STRING ON STACK
	CALL	SSCHK
	MVI	A,4
	STA	CASE
	LXI	H,TYPE
	MVI	B,1
	CALL	POPIT
	LDA	TYPE
	CPI	3
	JZ	A1091
	CPI	4
	JNZ	E24
	LXI	H,TYPE
	MVI	B,1
	CALL	PUSHT
	CALL	AC33
	LXI	H,TYPE
	MVI	B,1
	CALL	POPIT
A1091:	LXI	H,SLENG
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR
	LXI	H,SLENG
	INR	M
	LXI	H,LEVEL
	INR	M
	LDA	LEVEL
	CPI	MXLVL
	JZ	E32
	MVI	A,EOI
	CALL	CPUSH
	LXI	H,SLENG
	MVI	B,1
	CALL	PUSHT
	LXI	H,INDX 	;SAVE RETURN INFORMATION
	MVI	B,2
	CALL	PUSHT
	LXI	H,INDFL
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR	;GET READY TO DO INDIRECTION
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	MVI	A,1
	STA	INDFL
	STA	CASE
A1092:	RET	
;*
;*
AC110:			;CHECK FOR END OF ALL LEVELS OF NAME INDIR
	CALL	SSCHK
	LDA	INDFL
	CPI	1
	JNZ	A1102
A1101:	LDA	TOKEN
	CPI	40
	JNZ	E24
	CALL	INDRE
	LDA	INDFL
	CPI	1
	JZ	A1101
A1102:	RET	
;*
;*
AC111:			;REMOVE ROUTINE FROM DISK
	CALL	SSCHK
	LDA	RTDRV
	STA	DRIVE
	MVI	A,1
	STA	FCBTY
	CALL	FSEAR
	CALL	REMOV
	RET	
;*
;*
AC112:			;PRGPT TO END
	LHLD	PRGEN
	SHLD	PRGPT
	RET	
;*
;*
AC113:			;LIST CURRENT LINE
	CALL	SSCHK
	LHLD	PRGPT	;NO CURRENT LINE
	XCHG	
	LHLD	PRGEN
	CALL	JPEN
	JZ	A1131
	LHLD	PRGPT
	SHLD	PTR
	CALL	LINWR
A1131:	RET	
;*
;*
AC114:			;DELETE CURRENT LINE
	CALL	SSCHK
	LHLD	PRGEN	;NO CURRENT LINE
	XCHG	
	LHLD	PRGPT
	CALL	JPEN
	JZ	A1141
	LHLD	PRGPT
	SHLD	PTR1
	MOV	C,M
	MVI	B,0
	DAD	B
	LXI	D,2
	DAD	D
	SHLD	PTR3
	CALL	LINDE
A1141:	RET	
;*
;*
AC115:			;PUT INTEGER -1 T-O-S
	CALL	SSCHK
	LXI	H,IMIN1
	CALL	ITS
	RET	
;*
;*
AC117:			;CONVERT DEVICE # TO SHORT
	CALL	SSCHK
	CALL	STC0
	STA	DEVNO
	LDA	RESUL
	CPI	FALSE
	JZ	E52
	LDA	DEVNO
	CPI	MAXDV
	JC	$+6
	JNZ	E52
	LXI	H,DEVNO
	MVI	B,1
	CALL	PUSHT
	CALL	AC20 	;INITIALIZE PARAM COUNT
	RET	
;*
;*
AC118:			;INSERT STRING AT PRGPT
	CALL	SSCHK
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,RLENG	;GET STRING LENGTH
	MVI	B,1
	CALL	POPIT
	LDA	RLENG
	ORA	A
	JZ	E0
	LHLD	TOS
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR3
	LDA	RLENG
	STA	IT
	SHLD	TPP
	XRA	A
	STA	NLENG
	SHLD	PTR4
A1181:	LHLD	TPP	;LOOK FOR LS
	MOV	A,M
	CPI	BLANK
	JZ	A1182
	MOV	A,M
	CPI	LS
	JZ	A1182
	INX	H
	SHLD	TPP
	LXI	H,NLENG	;LABEL LENGTH
	INR	M
	LXI	H,IT
	DCR	M
	LDA	IT
	ORA	A
	JNZ	A1181
A1182:	LHLD	TPP	;SET LS
	MVI	M,LS
	LDA	IT
	ORA	A
	JZ	E0
	LHLD	PTR3
	SHLD	PTR
	CALL	LININ	;INSERT LINE INTO ROUTINE
	LHLD	PTR4
	SHLD	TOS
	RET	
;*
;*
AC119:			;SET OPTIONS
	CALL	SSCHK
	LXI	H,COUNT	;GET PARAMETER COUNT
	MVI	B,1
	CALL	POPIT
A1191:	LDA	COUNT
	ORA	A
	JZ	A1194
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,SLENG
	MVI	B,1
	CALL	POPIT
	LDA	SLENG	;IF DEFAULT, DON'T CHANGE ANYTHING
	ORA	A
	JZ	A1193
	CPI	1	;TOO LONG
	JNZ	E20
	LXI	H,CHR  	;GET DRIVE
	MVI	B,1
	CALL	POPIT
	LDA	CHR
	SUI	'A'
	STA	CHR
	LDA	COUNT
	CPI	1
	JNZ	A1192
	LDA	CHR
	STA	RTDRV
	JMP	A1193
A1192:	LDA	GLBDR
	LXI	H,CHR
	CMP	M
	JZ	A1193
	CALL	GLBCL	;CLOSE GLOBALS SINCE CHANGING DRIVES
	LDA	CHR
	STA	GLBDR
	XRA	A
	STA	GLOPN
A1193:	LXI	H,COUNT
	DCR	M
	JMP	A1191
A1194:	RET	
;*
;*
AC120:			;TRANSFER CONTROL TO ASSEMBLY LANGUAGE
	JMP	ASROU
;*
;*
AC121:			;SET STRING PARAM
	CALL	SSCHK
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,SLENG	;GET STRING LENGTH
	MVI	B,1
	CALL	POPIT
	LDA	SLENG	;STRING TOO LONG
	CPI	MAXAR
	JC	$+6
	JNZ	E20
	LXI	H,ARGPL	;PTR TO ARG START
	MOV	C,A
	MVI	B,0
	DAD	B
	DCX	H
	SHLD	PTR
A1211:	LDA	SLENG	;SET STRING
	ORA	A
	JZ	A1212
	LHLD	PTR
	MVI	B,1
	CALL	POPIT
	LXI	H,SLENG
	DCR	M
	LHLD	PTR
	DCX	H
	SHLD	PTR
	JMP	A1211
A1212:	RET	
;*
;*
AC122:			;GET ARG BYTE TO T-O-S
	CALL	SSCHK
	CALL	STC0
	STA	IT
	LDA	RESUL	;# TOO BIG
	ORA	A
	JZ	E20
	LDA	IT	;OFFSET TOO BIG
	CPI	MAXAR
	JC	$+6
	JNZ	E20
	LXI	H,ARGPL	;PTR TO ARG START
	MOV	C,A
	MVI	B,0
	DAD	B
	DCX	H
	SHLD	PTR
	MOV	A,M
	CALL	CTS
	RET	
;*
;*
AC123:			;MAKE STRING LOOK LIKE NAME
	CALL	SSCHK
	LXI	H,COUNT
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,COUNT
	DCR	M
	MVI	B,1
	CALL	PUSHT
	RET	
;*
;*
AC124:			;SET FOR VARIABLE TO FREAL
	CALL	SSCHK
	LHLD	VPTR
	SHLD	PTR
	LHLD	TOS
	SHLD	NSTOS
	LXI	H,FREAL
	CALL	NTS
	CALL	AC47
	LHLD	TOS
	SHLD	PTR
	LDA	FCASE
	STA	I1
A1240:	LHLD	PTR
	DCX	H
	DCX	H
	SHLD	PTR
	LDA	I1
	CPI	1
	JZ	A1241
	MOV	A,M
	STA	FSZ
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR
	LXI	H,I1
	DCR	M
	JMP	A1240
A1241:	LHLD	PTR
	MOV	A,M
	STA	ISZ
	LXI	H,FCASE
	MVI	B,1
	CALL	PUSHT
	RET	
;*
;*  END OF TDL ACTION ROUTINES
;**
*UTILT.TDL
;**
;*        TDL UTILTY ROUTINES BEGIN HERE
;*
;*
CANON:			;CHECK FOR CANONICAL NUMBER
	CALL	SSCHK
	LXI	H,INDX
	MVI	B,2
	CALL	PUSHT
	LHLD	PTR3	;INDX TO START OF STRING
	SHLD	INDX
	CALL	GTOKN
	LDA	SLENG	;I1 IS STRING LENGTH
	STA	I1
	MVI	A,15	;IT IS FAKE LENGTH
	STA	IT
	MVI	A,FALSE	;ITX IS NEGATIVE FLAG
	STA	ITX
	STA	RESUL
	LDA	I1
	CPI	1
	JNZ	CANO1
	LHLD	INDX	;CHECK FOR SINGLE ZERO
	MOV	A,M
	CPI	'0'
	JZ	CANOT
CANO1:	LDA	TOKEN	;CHECK FOR MINUS SIGN
	CPI	6
	JNZ	CANO2
	MVI	A,TRUE	;IT'S NEGATIVE
	STA	ITX
	LHLD	PTR3 	;MOVE START PAST '-'
	INX	H
	SHLD	PTR3 
	LXI	H,I1   	;DECREMENT STRING SIZE
	DCR	M
	LXI	H,SLENG
	DCR	M
	LDA	I1
	ORA	A
	JZ	CANOF
	CALL	GTOKN
CANO2:	LXI	H,IT
	INR	M
	LDA	TOKEN	;CHECK FOR LEADING '.'
	CPI	28
	JZ	CANO4
	CPI	3	;CHECK FOR DIGITS
	JNZ	CANOF
	LHLD	INDX	;NO LEADING ZEROS
	MOV	A,M
	CPI	'0'
	JZ	CANOF
CANO3:	LDA	ITX	;SEE IF < 0
	CPI	FALSE
	JZ	CAN35
	MVI	A,105
	LHLD	INDX
	SUB	M
	STA	I2
	MOV	M,A
CAN35:	LXI	H,I1
	DCR	M
	LXI	H,IT
	INR	M
	LDA	IT	;TOO MANY DIGITS
	CPI	29
	JZ	CANOF
	LDA	I1	;IT'S AN INTEGER
	ORA	A
	JZ	CANOT
	CALL	GTOKN
	LDA	TOKEN	;CHECK FOR '.'
	CPI	28
	JZ	CANO4
	CPI	3	;CHECK FOR DIGITS
	JNZ	CANOF
	JMP	CANO3
CANO4:	LXI	H,I1
	DCR	M
	LDA	I1	;#. AND . NOT ALLOWED
	ORA	A
	JZ	CANOF
CANO5:	CALL	GTOKN
	LDA	TOKEN	;CHECK FOR DIGITS
	CPI	3
	JNZ	CANOF
	LHLD	INDX	;SAVE LAST DIGIT
	MOV	A,M
	STA	COUNT
	LDA	ITX	;SEE IF < 0
	CPI	FALSE
	JZ	CAN55
	MVI	A,105
	SUB	M
	STA	I2
	MOV	M,A
CAN55:	LXI	H,I1
	DCR	M
	LDA	I1	;SEE IF DONE
	ORA	A
	JNZ	CANO5
	LDA	COUNT	;NO TRAILING ZEROS
	CPI	'0'
	JZ	CANOF
CANOT:	LDA	ITX
	CPI	FALSE
	JZ	CANO7
	MVI	A,30
	LXI	H,IT
	SUB	M
	STA	I2
	STA	IT
	LHLD	INDX
	INR	M
CANO7:	MVI	A,TRUE
	STA	RESUL
CANOF:	LXI	H,INDX 	;PUT INDX BACK
	MVI	B,2
	CALL	POPIT
	LHLD	INDX
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	LDA	RESUL
	CPI	TRUE
	JZ	CANO8
	LDA	ITX
	CPI	FALSE
	JZ	CANO8
	LXI	H,SLENG
	INR	M
	LHLD	PTR3
	DCX	H
	SHLD	PTR3
CANO8:	RET	
;*
;*
COMPA:			;COMPARE 2 STRINGS
	XRA	A
	STA	CASE
COMP1:	LHLD	PTR4
	MOV	A,M
	CPI	DELIM
	JNZ	COMP2
	LHLD	PTR5
	MOV	A,M
	CPI	DELIM
	JZ	COMP5
	JMP	COMP6
COMP2:	LHLD	PTR5
	MOV	A,M
	CPI	DELIM
	JZ	COMP4
	LHLD	PTR4
	XCHG	
	LHLD	PTR5
	LDAX	D
	CMP	M
	JZ	COMP3
	LHLD	PTR4	;PTR4 < PTR5
	XCHG	
	LHLD	PTR5
	LDAX	D
	CMP	M
	JC	COMP6
	JMP	COMP4	;PTR4 > PTR5
COMP3:	LHLD	PTR4
	INX	H
	SHLD	PTR4
	LHLD	PTR5
	INX	H
	SHLD	PTR5
	JMP	COMP1
COMP4:	LXI	H,CASE 	;PTR4 > PTR5 : CASE = 3
	INR	M
COMP5:	LXI	H,CASE 	;PTR4 = PTR5 : CASE = 2
	INR	M
COMP6:	LXI	H,CASE 	;PTR4 < PTR5 : CASE = 1
	INR	M
	RET	
;*
;*
GTSIZ:			;GET SIZE OF T-O-S ITEM
	CALL	SSCHK
	LXI	H,NULL
	SHLD	TPP
	LDA	I3
	CPI	8
	JZ	GT2
	CALL	PAST 	;CHECK T-O-S ITEM
	LXI	H,TPP
	MVI	B,2
	CALL	POPIT
	LXI	H,TPP  	;GET SIZE + A LITTLE
	MVI	B,2
	CALL	POPIT
	LHLD	TPP
	DCX	H
	SHLD	TPP
	LXI	H,TYPE
	MVI	B,1
	CALL	POPIT
GT0:	LDA	TYPE
	CPI	4
	JNZ	GT1
	LXI	H,PTR
	MVI	B,2
	CALL	POPIT
	LXI	H,PTR
	MVI	B,2
	CALL	PUSHT
	LHLD	PTR
	MOV	A,M
	STA	SLENG
	LXI	H,NULL
	MOV	C,A
	MVI	B,0
	DAD	B
	INX	H
	SHLD	TPP
GT1:	LXI	H,TYPE
	MVI	B,1
	CALL	PUSHT
GT2:	RET	
;*
;*
PAST:		
	CALL	SSCHK
	LHLD	TOS
	SHLD	PTR
	LHLD	PTR  	;INITIALIZE PTR AT TYPE OF T-O-S
	DCX	H
	SHLD	PTR  
	MOV	A,M	;GET TYPE OF T-O-S
	STA	TYPE
PAS2:	LDA	TYPE
	CPI	3
	JNZ	PAS3
	LHLD	PTR  	;STRING T-O-S
	DCX	H
	SHLD	PTR  
	MOV	A,M	;GET LENGTH
	STA	COUNT
	JMP	PAS4
PAS3:	MVI	A,PTRLN	;STRING PTR T-O-S
	STA	COUNT
PAS4:	LHLD	PTR
	LDA	COUNT
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR
	LHLD	TOS
	SHLD	TPP
	LHLD	PTR	;GET SIZE TO T-O-S
	XCHG	
	LHLD	TPP
	CALL	PSUB
	SHLD	TPP
	LHLD	PTR  	;PTR IS NOW BELOW T-O-S
	DCX	H
	SHLD	PTR  
	LXI	H,TPP  	;SAVE SIZE
	MVI	B,2
	CALL	PUSHT
	LXI	H,PTR  	;SAVE BASE OF T-O-S
	MVI	B,2
	CALL	PUSHT
	RET	
;*
;*
SUBCH:			;CHECK IF SUBSCRIPT IS INTEGER
	CALL	SSCHK
	MVI	A,FALSE
	STA	RESUL
	CALL	SUBSI	;GET SIZE OF SUBSCRIPT
	LDA	I1
	ORA	A
	JZ	SUBC1
	LHLD	PTR3
	MOV	A,M
	CPI	31
	JC	$+6
	JNZ	SUBC1
	MVI	A,TRUE
	STA	RESUL
SUBC1:	RET	
;*
;*
SUBSI:			;GET SIZE OF SUB INTO I1--STARTS AT PTR3
	XRA	A
	STA	I1
	LHLD	PTR3
	SHLD	TPP
SUBS1:	LHLD	TPP
	MOV	A,M
	CPI	DELIM
	JZ	SUBS2
	INX	H
	SHLD	TPP
	LXI	H,I1
	INR	M
	JMP	SUBS1
SUBS2:	RET	
;*
;*
GETCH:			;GET CHAR FROM DEVICE
	CALL	SSCHK
	LHLD	DVBSU
	XCHG	
	LHLD	DVBSZ
	LDAX	D
	CMP	M
	JNZ	GETC3
	LDA	IODVC
	ORA	A
	JNZ	GETC1
	CALL	TRMIN	;READ BUFFER FULL FROM TERMINAL
	LHLD	DVBST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LDA	RLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR
	MVI	M,CR
	JMP	GETC2
GETC1:	LDA	XTDRV
	STA	DRIVE
	LHLD	DEVPM
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	FCB
	LHLD	DVBST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BUFFR
	CALL	FREAD
GETC2:	LHLD	DVBSU	;ZERO SIZE USED
	MVI	M,0
	LHLD	DVBST	;INITIALIZE BUFFER PTR
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	DVPTR
	MOV	M,E
	INX	H
	MOV	M,D
GETC3:	LHLD	DVPTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	A,M
	STA	CHR
	CPI	EOF
	JZ	GETC4
	INX	H
	SHLD	PTR
	XCHG	
	LHLD	DVPTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	DVBSU	;INCREMENT SIZE USED
	INR	M
GETC4:	RET	
;*
;*
PUTCH:			;SEND CHAR TO DEVICE
	CALL	SSCHK
	LDA	IODVC
	ORA	A
	JNZ	PUTC1
	LDA	CHR
	CALL	TRMOT
	RET	
PUTC1:	LDA	IODVC
	CPI	1
	JNZ	PUTC2
	LDA	CHR
	CALL	LIST
	RET	
PUTC2:	LHLD	DEVOP
	MOV	A,M
	CPI	3
	JZ	PUTC0
	LHLD	DVBST
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	DVPTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	DVBSU
	MVI	M,0
PUTC0:	LHLD	DVPTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	LDA	CHR
	MOV	M,A
	LHLD	DVBSU
	INR	M
	LHLD	PTR
	INX	H
	SHLD	PTR
	XCHG	
	LHLD	DVPTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	DVBSU
	XCHG	
	LHLD	DVBSZ
	LDAX	D
	CMP	M
	JNZ	PUTC3
	LDA	XTDRV
	STA	DRIVE
	LHLD	DEVPM
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	FCB
	LHLD	DVBST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BUFFR
	CALL	FWRIT
	LHLD	DVBSU
	MVI	M,0
	LHLD	DVBST
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	DVPTR
	MOV	M,E
	INX	H
	MOV	M,D
PUTC3:	LHLD	DEVOP
	MVI	M,3
	RET	
;*
;*
SETDE:			;SET UP DEVICE POINTERS
	LXI	H,DEVTA	;POINTER TO START OF DEVICE TABLE
	SHLD	PTR
SETD1:	LDA	IT
	ORA	A
	JZ	SETD2
	LHLD	PTR	;MOVE PTR TO NEXT DEVICE
	LXI	D,DEVSZ
	DAD	D
	SHLD	PTR
	LXI	H,IT
	DCR	M
	JMP	SETD1
SETD2:	LHLD	PTR	;SET OPEN/CLOSE PTR
	SHLD	DEVOP
	INX	H
	SHLD	PTR
	SHLD	DEVRD	;SET READ/WRITE PTR
	INX	H
	SHLD	PTR
	SHLD	DEVX	;SET $X PTR
	LXI	D,INTLN
	DAD	D
	SHLD	PTR
	SHLD	DEVY	;SET $Y PTR
	LXI	D,INTLN
	DAD	D
	SHLD	PTR
	SHLD	DVBSZ	;SET BUFFER SIZE PTR
	INX	H
	SHLD	PTR
	SHLD	DEVPM	;SET PARAMETER PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	SHLD	DVBST	;SET BUFFER START PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	SHLD	DVPTR	;SET BUFFER PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	SHLD	DVBSU	;SET BUFFER SIZE USED PTR
	RET	
;*
;*
MKSTR:			;CONVERT T-O-S TO STRING ON STACK
	CALL	SSCHK
	LXI	H,TYPE
	MVI	B,1
	CALL	POPIT
	LDA	TYPE
	CPI	3
	JNZ	A0344
	LXI	H,SLENG	;GET STRING LENGTH
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	SPTR
A0343:	LHLD	SPTR
	SHLD	TOS
	JMP	A3455
A0344:	LXI	H,PTR
	MVI	B,2
	CALL	POPIT
	LHLD	PTR	;GET STRING LENGTH IN SYM TABLE
	MOV	A,M
	STA	SLENG
	INX	H	;MOVE PTR TO START OF STRING
	SHLD	PTR  
A0345:	LHLD	PTR
	XCHG	
	LHLD	TOS
	LDA	SLENG
	MOV	B,A
	CALL	MOVE
	LHLD	TOS
	SHLD	SPTR
A3455:	LHLD	TOS
	LDA	SLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	TOS
	XRA	A	;I4 KEEPS TRACK OF SIGN
	STA	I4
	LHLD	INDX	;SAVE INDX
	SHLD	TPP
	LHLD	SPTR
	DCX	H
	SHLD	INDX
A0346:	LDA	SLENG
	ORA	A
	JZ	A0349
	CALL	GTOKN
	LDA	TOKEN	;IT'S A DIGIT
	CPI	3
	JZ	A0348
	CPI	28	;IT'S A .
	JZ	A0348
	CPI	5	;IT'S A +
	JZ	A0347
	CPI	6
	JNZ	A0349
	LDA	I4   	;CHANGE SIGN
	XRI	1
	STA	I4   
A0347:	LXI	H,SLENG
	DCR	M
	JMP	A0346
A0348:	LDA	FLG1	;SET STRING FLAG FOR AC10
	ORI	STRNG
	STA	FLG1
	LHLD	TOS	;SAVE START OF NUMBER
	SHLD	PTR
	LDA	IT	;JUMP IF WANT INTEGER
	ORA	A
	JZ	A3483
	CALL	AC10 	;CONVERT TO NUMBER
	JMP	A3485
A3483:	LDA	SLENG
	STA	I1
	CALL	AC11 	;CONVERT TO INTEGER
A3485:	LDA	FLG1
	MOV	B,A
	MVI	A,STRNG
	CMA	
	ANA	B
	STA	FLG1
	LDA	RESUL
	CPI	TRUE
	JNZ	A0349
	LHLD	TOS
	DCX	H
	SHLD	TOS
	LXI	H,I1   	;GET SIZE OF NUMBER
	MVI	B,1
	CALL	POPIT
	LDA	I4
	ORA	A
	JZ	A034A
	LHLD	PTR
	INX	H
	SHLD	PTR1
	XCHG	
	LHLD	PTR
	LDA	I1
	CALL	SHFU
	MVI	M,'-'	;SET MINUS SIGN
	LXI	H,I1
	INR	M
A034A:	LHLD	SPTR
	XCHG	
	LHLD	PTR
	LDA	I1
	CALL	SHFD
	JMP	A034B
A0349:	LHLD	SPTR
	SHLD	TOS
	MVI	A,'0'
	CALL	CPUSH
	MVI	A,1
	STA	I1
A034B:	LXI	H,I1   	;SET SIZE
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	LHLD	TPP	;PUT INDX BACK
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	RET	
;*
;*
CKLS:			;CHECK FOR LS
	LDA	RLENG
	STA	IT
	XRA	A
	STA	NLENG
	LHLD	PTR
	SHLD	TPP
CK01:	LHLD	TPP
	MOV	A,M
	CPI	LS
	JZ	CK02
	INX	H
	SHLD	TPP
	LXI	H,NLENG
	INR	M
	LXI	H,IT
	DCR	M
	LDA	IT
	ORA	A
	JNZ	CK01
	XRA	A	;NO LS
	STA	RESUL
	RET	
CK02:	MVI	A,1	;A LS
	STA	RESUL
	RET	
;*
;*
FNDLB:			;SEARCH ROUTINE FOR LABEL
	CALL	SSCHK
	LXI	H,I1   	;GET LABEL LENGTH
	MVI	B,1
	CALL	POPIT
	LHLD	TOS	;TOS TO LABEL START
	LDA	I1
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	LDA	INF
	CPI	1
	JZ	FND3
	SHLD	PTR
	LHLD	PRGAD	;PTR1 TO ROUTINE START
	SHLD	PTR1
FND1:	LHLD	PTR1	;NO MATCH
	MOV	A,M
	CPI	EOR
	JZ	FND3
	SHLD	PTR2	;SAVE START OF LINE
	MOV	A,M	;GET COMMAND LENGTH
	STA	I2
	INX	H
	MOV	A,M	;GET LABEL LENGTH
	STA	IT
	INX	H
	SHLD	PTR1
	ORA	A
	JZ	FND2
	CPI	NAMLN
	JC	FND15
	MVI	A,NAMLN
	STA	IT
FND15:	LDA	IT	;LABELS SAME LENGTH ?
	LXI	H,I1
	CMP	M
	JNZ	FND2
	LHLD	PTR1
	XCHG	
	LHLD	PTR
	LDA	I1
	MOV	C,A
	CALL	JSE
	JNZ	$+13
	SHLD	PTR
	XCHG	
	SHLD	PTR1
	JMP	FND4
FND2:	LHLD	PTR1	;MOVE TO NEXT LINE
	LDA	I2
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR1
	JMP	FND1
FND3:	XRA	A	;NO MATCH
	STA	RESUL
	RET	
FND4:	LHLD	PTR2
	SHLD	PTR1
	MVI	A,1	;A MATCH
	STA	RESUL
	RET	
;*
;*
GTTRN:			;GET TRANSPT AND LOAD ROUTINE
	CALL	SSCHK
	LXI	H,TYPE 	;GET TYPEOF TRANSPT
	MVI	B,1
	CALL	POPIT
	LDA	TYPE
	ORA	A
	JZ	GTT01
	CALL	LOADI	;LOAD ROUTINE
GTT01:	LDA	TYPE
	CPI	1
	JZ	GTT02
	ORA	A
	JNZ	GTT15
	CALL	NAMCK
GTT15:	CALL	MV2LN	;MOVE TO LINE
	LDA	RESUL
	ORA	A
	JZ	E34
	LHLD	PTR1
	SHLD	PRGPT
	RET	
GTT02:	LHLD	PRGAD
	SHLD	PRGPT
	RET	
;*
;*
LINDE:			;DELETE FROM PTR1 TO PTR3
	CALL	SSCHK
	LHLD	PTR1
	SHLD	PRGPT
LIN60:	LHLD	PTR3
	XCHG	
	LHLD	PRGEN
	CALL	JPEN
	JZ	LIN61
	LHLD	PTR3
	MOV	A,M
	LHLD	PTR1
	MOV	M,A
	INX	H
	SHLD	PTR1
	LHLD	PTR3
	INX	H
	SHLD	PTR3
	JMP	LIN60
LIN61:	LHLD	PTR1
	SHLD	PRGEN
	MVI	M,EOR
	LDA	FLG1
	ORI	DIRTY
	STA	FLG1
	RET	
;*
;*
LININ:			;PUT LINE IN STARTING AT PRGPT
	CALL	SSCHK
	LDA	FLG1
	ANI	BRAKE
	JNZ	E44
	LHLD	PTR
	SHLD	PTR3
	LDA	NLENG
	STA	COUNT
	ORA	A
	JZ	LIN02
	LHLD	INDX
	SHLD	PTR5
	LHLD	PTR
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	CALL	AC15 	;TRY NAME LABEL
	LDA	RESUL
	ORA	A
	JNZ	LIN01
	CALL	AC17 	;TRY NUMERIC LABEL
	LDA	RESUL
	ORA	A
	JZ	E28
LIN01:	CALL	AC123
	LHLD	PTR
	LDA	COUNT
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	TPP
	LHLD	INDX	;INVALID LABEL
	XCHG	
	LHLD	TPP
	CALL	JPEN
	JNZ	E28
	LHLD	PTR5
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	CALL	FNDLB
	LDA	RESUL	;DUPLICATE LABEL
	CPI	1
	JZ	E33
LIN02:	LHLD	PRGEN	;SEE IF ROOM
	LDA	RLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	LXI	D,2
	DAD	D
	SHLD	TPP
	XRA	A
	STA	N
LIN03:	LHLD	SYMEN
	XCHG	
	LHLD	TPP
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	LIN04
	LDA	N
	CPI	1
	JZ	E10
	CALL	GARBG
	MVI	A,1
	STA	N
	JMP	LIN03
LIN04:	LHLD	PRGEN
	SHLD	PTR1
	LHLD	TPP	;ADJUST PRGEN
	SHLD	PRGEN
LIN0A:	LHLD	PTR1
	XCHG	
	LHLD	PRGPT
	CALL	JPEN
	JZ	LIN05
	LHLD	PTR1 	;SHIFT ROUTINE SO LINE WILL FIT
	DCX	H
	SHLD	PTR1 
	LHLD	TPP
	DCX	H
	SHLD	TPP
	LHLD	PTR1
	MOV	A,M
	LHLD	TPP
	MOV	M,A
	JMP	LIN0A
LIN05:	LHLD	PRGPT	;PUT IN NEW LINE
	LDA	RLENG
	MOV	M,A
	INX	H
	LDA	COUNT
	MOV	M,A
	INX	H
	SHLD	PRGPT
	LHLD	PTR3
	XCHG	
	LHLD	PRGPT
	LDA	RLENG
	MOV	B,A
	CALL	MOVE
	LHLD	PRGPT
	LDA	RLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PRGPT
	LHLD	PRGEN
	MVI	M,EOR
	LDA	FLG1
	ORI	DIRTY
	STA	FLG1
	RET	
;*
;*
LINSE:			;SET PTR1 AND PTR3 AROUND LINES
	CALL	SSCHK
	CALL	MV2LN
	LDA	RESUL
	ORA	A
	JZ	E34
	LHLD	PTR1	;PTR3 AT START OF LINE
	SHLD	PTR3
	LDA	CASE
	CPI	1
	JNZ	LIN21
	MOV	C,M	;ONE LINE
	LHLD	PTR3
	MVI	B,0
	DAD	B
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR3
	RET	
LIN21:	LDA	CASE
	CPI	2
	JNZ	LIN22
	CALL	MV2LN	;LINE TO LINE
	LDA	RESUL
	ORA	A
	JZ	E34
	LHLD	PTR3
	MOV	C,M
	MVI	B,0
	DAD	B
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR3
	RET	
LIN22:	LHLD	PRGEN
	SHLD	PTR3
	RET	
;*
;*
LINWR:			;WRITE OUT A LINE AT PTR
	CALL	SSCHK
	LHLD	PTR	;LINE LENGTH
	MOV	A,M
	STA	SLENG
	INX	H
	MOV	A,M	;LABEL LENGTH
	STA	NLENG
	INX	H
	SHLD	PTR
	LDA	SLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR2
	MVI	A,12
	STA	IT
	LXI	H,NLENG
	CMP	M
	JC	$+6
	JNZ	LIN40
	MVI	A,5
	STA	IT
	JMP	LIN41
LIN40:	LDA	IT	;GET # OF BLANKS AFTER LBBEL
	LXI	H,NLENG
	SUB	M
	STA	IT
	LHLD	DEVOP
	MOV	A,M
	CPI	3
	JZ	LIN41
	LHLD	DVBST	;INITIALIZE DEVICE PTR
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	DVPTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	DVBSU
	MVI	M,0
LIN41:	LDA	NLENG
	ORA	A
	JZ	LIN42
	LHLD	PTR
	MOV	A,M
	STA	CHR
	CALL	PUTCH	;WRITE OUT A CHAR
	LXI	H,NLENG
	DCR	M
	LHLD	PTR
	INX	H
	SHLD	PTR
	JMP	LIN41
LIN42:	MVI	A,BLANK	;WRITE OUT BLANKS AFTER LABEL
	STA	CHR
	CALL	PUTCH
	LXI	H,IT
	DCR	M
	LDA	IT
	ORA	A
	JNZ	LIN42
	LHLD	PTR  	;SKIP OVER LS
	INX	H
	SHLD	PTR  
LIN43:	LHLD	PTR	;WRITE OUT REST OF LINE
	XCHG	
	LHLD	PTR2
	CALL	JPEN
	JZ	LIN44
	LHLD	PTR
	MOV	A,M
	STA	CHR
	CALL	PUTCH
	LHLD	PTR
	INX	H
	SHLD	PTR
	JMP	LIN43
LIN44:	MVI	A,CR
	STA	CHR
	CALL	PUTCH
	MVI	A,LF
	STA	CHR
	CALL	PUTCH
	LHLD	DEVOP
	MVI	M,3
	LHLD	DEVY
	MVI	C,INTLN
	CALL	ADD1
	LHLD	DEVX
	LXI	D,IZERO
	CALL	SETI
	RET	
;*
;*
LOADI:			;LOAD ROUTINE
	CALL	SSCHK
	CALL	NAMCK
	LDA	RESUL
	CPI	1
	JZ	LD4
	LDA	SLENG
	ORA	A
	JZ	LD4
	LDA	FLG1
	ANI	DIRTY
	JNZ	E42
	CALL	NAMLD
	LDA	RTDRV
	STA	DRIVE
	MVI	A,1
	STA	FCBTY
	CALL	FOPEN
	LXI	H,RTBUF
	SHLD	BUFFR
	CALL	FREAD
	LXI	H,RTBUF
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PRGEN
	SHLD	PTR2
	LHLD	PRGAD
	XCHG	
	LHLD	PRGEN
	DAD	D
	SHLD	PRGEN
	XRA	A
	STA	N
LD01:	LHLD	SYMEN	;SEE IF ROOM
	XCHG	
	LHLD	PRGEN
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	LD02
	LDA	N	;NOT ENOUGH ROOM
	CPI	1
	JZ	E10
	CALL	GARBG
	MVI	A,1
	STA	N
	JMP	LD01
LD02:	LHLD	PRGAD
	SHLD	PTR1
	LHLD	PTR	;SKIP OVER SIZE
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LXI	H,PTRLN
	SHLD	PTR3
LD1:	LHLD	PTR2	;ALL FINISHED
	LXI	D,NULL
	CALL	JPEN
	JZ	LD2
	LHLD	PTR
	MOV	A,M
	LHLD	PTR1
	MOV	M,A
	INX	H
	SHLD	PTR1
	LHLD	PTR
	INX	H
	SHLD	PTR
	LHLD	PTR2
	DCX	H
	SHLD	PTR2
	LHLD	PTR3
	INX	H
	SHLD	PTR3
	LXI	D,BUFSZ
	CALL	JPEN
	JNZ	LD1
	CALL	FREAD	;REFILL BUFFER
	LXI	H,RTBUF
	SHLD	PTR
	LXI	H,NULL
	SHLD	PTR3
	JMP	LD1
LD2:	LHLD	PRGEN
	MVI	M,EOR
	RET	
LD4:	LHLD	TOS
	DCX	H
	SHLD	TOS
	LHLD	TOS
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	RET	
;*
;*
MV2LN:			;MOVE PTR1 TO LINEREF
	CALL	SSCHK
	LXI	H,IT
	MVI	B,1
	CALL	POPIT
	LDA	IT
	ORA	A
	JNZ	MT1
	LXI	H,INT1
	LXI	D,IZERO
	CALL	SETI
	JMP	MT2
MT1:	LXI	H,IT
	MVI	B,1
	CALL	PUSHT
	LXI	H,INT1 	;GET OFFSET
	CALL	STI
MT2:	LDA	DT
	CPI	1
	JZ	MT3
	CALL	FNDLB	;GET PTR1 TO LABEL LINE
	LDA	RESUL	;NO LABEL
	ORA	A
	JZ	MT5
MT3:	LHLD	PTR1	;OFFSET TOO LARGE
	XCHG	
	LHLD	PRGEN
	CALL	JPEN
	JZ	MT5
	LXI	H,INT1
	MVI	C,INTLN
	CALL	ZTEST
	JZ	MT4
	LHLD	PTR1
	MOV	C,M
	MVI	B,0
	DAD	B
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR1
	LXI	H,INT1
	MVI	C,INTLN
	CALL	SUB1
	JMP	MT3
MT4:	MVI	A,1
	STA	RESUL
	RET	
MT5:	XRA	A
	STA	RESUL
	RET	
;*
;*
NAMCK:			;COMPARE NAME T-O-S WITH PRG
	CALL	SSCHK
	LHLD	TOS
	DCX	H
	MOV	A,M	;GET NAME LENGTH
	STA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR
	LXI	H,PRG
	SHLD	PTR1
	LHLD	TOS
	SHLD	PTR3
	XRA	A
	STA	NLENG
NAM01:	LHLD	PTR1
	MOV	A,M
	CPI	BLANK
	JZ	NAM02
	MVI	B,1	;SAVE CURRENT NAME5 ON STACK
	CALL	PUSHT
	LXI	H,NLENG	;AND GET LENGTH
	INR	M
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	LDA	NLENG
	CPI	NAMLN
	JNZ	NAM01
NAM02:	LHLD	PTR3
	SHLD	TOS
	SHLD	PTR4
	LDA	NLENG	;NAMES SAME LENGTH?
	LXI	H,SLENG
	CMP	M
	JNZ	NAM03
	LHLD	PTR
	XCHG	
	LHLD	PTR3
	MOV	C,A
	CALL	JSE
	JNZ	$+13
	SHLD	PTR3
	XCHG	
	SHLD	PTR
	JMP	NAM04
NAM03:	XRA	A
	STA	RESUL
	RET	
NAM04:	MVI	A,1	;SAME NAMES
	STA	RESUL
	RET	
;*
;*
NAMLD:			;LOAD NAME INTO PRG
	CALL	SSCHK
	LHLD	TOS
	DCX	H
	MOV	A,M
	STA	IT
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR
	XCHG	
	LXI	H,PRG
	LDA	IT
	MOV	B,A
	CALL	MOVE
	MVI	A,NAMLN
	LXI	H,IT
	SUB	M
	STA	I1
	LXI	H,PRG
	LDA	IT
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR
NAM10:	LDA	I1
	ORA	A
	JZ	NAM11
	LHLD	PTR
	MVI	M,BLANK
	LXI	H,I1
	DCR	M
	JMP	NAM10
NAM11:	RET	
;*
;*
SAVEI:			;SAVE ROUTINE
	CALL	SSCHK
	CALL	MAKE 	;ENTER NAME INTO DIRECTORY
	LHLD	PRGEN	;GET SIZE
	SHLD	PTR
	LHLD	PRGAD
	XCHG	
	LHLD	PTR
	CALL	PSUB
	SHLD	PTR
	LHLD	PRGAD	;PUT SIZE BEFORE ROUTINE
	LXI	B,-(PTRLN)
	DAD	B
	SHLD	PTR1
	LHLD	PTR
	XCHG	
	LHLD	PTR1
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LXI	H,RTBUF
	SHLD	BUFFR
SAV01:	LXI	H,RTBUF
	SHLD	PTR2
	LXI	H,BUFSZ
	SHLD	PTR3
SAV02:	LHLD	PTR
	LXI	D,NULL
	CALL	JPEN
	JZ	SAV03
	LHLD	PTR1	;MOVE DATA TO BUFFER
	MOV	A,M
	LHLD	PTR2
	MOV	M,A
	INX	H
	SHLD	PTR2
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	LHLD	PTR
	DCX	H
	SHLD	PTR
	LHLD	PTR3
	DCX	H
	SHLD	PTR3
	LXI	D,NULL
	CALL	JPEN
	JNZ	SAV02
	CALL	FWRIT	;WRITE BUFFER OUT
	JMP	SAV01
SAV03:	CALL	FWRIT
	CALL	FCLOS
	RET	
;*
;*
LN2ST:			;PUT PTR1'S LINE ON STACK
	CALL	SSCHK
	XRA	A
	STA	IT
	LDA	RESUL	;NO LINE MATCH
	ORA	A
	JZ	STK4
	LHLD	PTR1	;GET LINE LENGTH
	MOV	A,M
	STA	I1
	STA	IT
	INX	H
	SHLD	PTR1
	MOV	A,M	;GET LABEL LENGTH
	STA	I2
	INX	H	;PTR1 TO LINE
	SHLD	PTR1 
STK1:	LDA	I2
	ORA	A
	JZ	STK2
	LHLD	PTR1 	;PUSH LABEL
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	LXI	H,I2
	DCR	M
	LXI	H,I1
	DCR	M
	JMP	STK1
STK2:	MVI	A,BLANK	;LS
	CALL	CPUSH
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	LXI	H,I1
	DCR	M
STK3:	LDA	I1
	ORA	A
	JZ	STK4
	LHLD	PTR1 	;PUSH REST OF LINE
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	LXI	H,I1
	DCR	M
	JMP	STK3
STK4:	LXI	H,IT   	;SAVE LENGTH
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	RET	
;*
;*
DORET:			;RETURN FROM DO
	CALL	SSCHK
	LXI	H,MODE
	MVI	B,1
	CALL	POPIT
	LXI	H,INDFL	;RESTORE THINGS FROM STACK
	MVI	B,1
	CALL	POPIT
	LXI	H,INDSW
	MVI	B,1
	CALL	POPIT
	LXI	H,FORSW
	MVI	B,1
	CALL	POPIT
	LXI	H,SPTR
	MVI	B,2
	CALL	POPIT
	LXI	H,PRGPT
	MVI	B,2
	CALL	POPIT
	CALL	LOADI	;LOAD ROUTINE
	LXI	H,DOSW
	DCR	M
	LXI	H,LEVEL
	DCR	M
	LDA	MODE
	CPI	1
	JZ	DOR1
	CALL	INPUT
	JMP	DOR2
DOR1:	LHLD	DRBUF
	XCHG	
	LHLD	LBUFF
	LDA	DRLNG
	MOV	B,A
	CALL	MOVE
	LHLD	LBUFF
	LDA	DRLNG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR
	MVI	M,EOL
DOR2:	LHLD	SPTR
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	XRA	A
	STA	FLAG
	RET	
;*
;*
FORSE:			;GET FOR INFO OFF STACK
	CALL	SSCHK
	LXI	H,INDX
	MVI	B,2
	CALL	POPIT
	LHLD	TOS
	SHLD	PTR
	SHLD	TOPTR
	LXI	B,-(SHTLN+SHTLN+SHTLN)
	DAD	B
	MOV	A,M
	STA	FSZ
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR
	SHLD	FPTR
	LXI	B,-(SHTLN+SHTLN)
	DAD	B
	MOV	A,M
	STA	ISZ
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR
	SHLD	IPTR
	LXI	B,-(PTRLN)
	DAD	B
	SHLD	PTR
	SHLD	VPTR
	RET	
;*
;*
INDRE:			;RETURN FROM INDIRECTION
	CALL	SSCHK
	LXI	H,LEVEL
	DCR	M
	LHLD	INDX
	SHLD	PTR
	SHLD	PTR2
	SHLD	PTR1
IND0:	LHLD	PTR1
	MOV	A,M
	CPI	EOI
	JZ	IND1
	INX	H
	SHLD	PTR1
	JMP	IND0
IND1:	LHLD	PTR1
	LXI	D,SHTLN+SHTLN+PTRLN+SHTLN
	DAD	D
	SHLD	PTR1
	LHLD	TOS
	XCHG	
	LHLD	PTR1
	CALL	JPEN
	JZ	IND3
	LHLD	PTR
	INX	H
	MOV	A,M
	STA	IT
	INX	H
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	INDX
	LHLD	PTR
	LXI	D,2
	DAD	D
	MOV	A,M
	STA	INDFL
	INX	H
	SHLD	PTR
	LHLD	TOS
	SHLD	PTR1
	LHLD	PTR2
	SHLD	TOS
	LXI	H,IT
	DCR	M
	LHLD	TOS
	LDA	IT
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
IND2:	LHLD	PTR
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR
	INX	H
	SHLD	PTR
	XCHG	
	LHLD	PTR1
	CALL	JPEN
	JNZ	IND2
	JMP	IND5
IND3:	LXI	H,INDFL
	MVI	B,1
	CALL	POPIT
	LXI	H,INDX
	MVI	B,2
	CALL	POPIT
	LXI	H,SLENG
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
IND5:	LHLD	INDX
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	RET	
;*
;*
LSUBS:			;LIST SUBSCRIPTS AND VALUES
	CALL	SSCHK
	XRA	A
	STA	I6
	LXI	H,I6
	MVI	B,1
	CALL	PUSHT
LSB1:	LHLD	DP
	SHLD	PTR
	LXI	D,NULL
	CALL	JPEN
	JZ	LSB13
	LHLD	DP	;GET NEXT LEVEL DOWN IN DP
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	DP
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	MOV	A,M
	STA	STYPE
	LXI	D,5	;TO ACROSS PTR
	DAD	D
	SHLD	PTR1
	LXI	H,I6
	INR	M
	LHLD	PTR1 	;SAVE IT
	MVI	B,2
	CALL	PUSHT
	LXI	H,I6
	MVI	B,1
	CALL	PUSHT
	MVI	A,5	;INDENT
	STA	IT
	STA	SLENG
LSB2:	MVI	A,BLANK	;LEADING BLANKS
	CALL	CPUSH
	LXI	H,IT
	DCR	M
	LDA	IT
	ORA	A
	JNZ	LSB2
	LDA	I6
	STA	IT
	DCR	M	;PERIODS
LSB3:	LDA	IT
	ORA	A
	JZ	LSB4
	MVI	A,'.'
	CALL	CPUSH
	MVI	A,BLANK
	CALL	CPUSH
	LDA	SLENG
	ADI	2
	STA	SLENG
	LXI	H,IT
	DCR	M
	JMP	LSB3
LSB4:	LXI	H,SLENG
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	CALL	AC54
	LHLD	PTR1
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR1
	XRA	A
	STA	SLENG
	MVI	A,FALSE
	STA	ITX
	MOV	A,M
	CPI	31
	JC	$+6
	JNZ	LSB5
	MOV	A,M
	CPI	14
	JC	$+6
	JNZ	LSB45
	MVI	A,'-'
	CALL	CPUSH
	LXI	H,SLENG
	INR	M
	MVI	A,TRUE
	STA	ITX
LSB45:	LHLD	PTR1
	INX	H
	SHLD	PTR1
LSB5:	LHLD	PTR1
	MOV	A,M
	CPI	DELIM
	JZ	LSB55
	MOV	A,M
	CPI	'.'
	JZ	LSB53
	LDA	ITX
	CPI	FALSE
	JZ	LSB53
	MVI	A,105
	SUB	M
	STA	IT
	LXI	H,IT
	MVI	B,1
	CALL	PUSHT
	JMP	LSB54
LSB53:	LHLD	PTR1
	MVI	B,1
	CALL	PUSHT
LSB54:	LXI	H,SLENG
	INR	M
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	JMP	LSB5
LSB55:	LDA	ITX
	CPI	FALSE
	JZ	LSB56
	LXI	H,IT
	MVI	B,1
	CALL	POPIT
	LXI	H,IT
	INR	M
	MVI	B,1
	CALL	PUSHT
LSB56:	LHLD	PTR1
	INX	H
	SHLD	PTR1
	MVI	A,'='
	CALL	CPUSH
	LXI	H,SLENG
	INR	M
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	CALL	AC54
	LDA	STYPE
	CPI	8
	JZ	LSB12
LSB7:	LHLD	PTR1
	MOV	A,M
	STA	IT
	STA	I1
	LXI	H,I1
	INR	M
	INR	M
	MVI	A,'"'
	CALL	CPUSH
LSB8:	LDA	IT
	ORA	A
	JZ	LSB9
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	MVI	B,1
	CALL	PUSHT
	LXI	H,IT
	DCR	M
	JMP	LSB8
LSB9:	MVI	A,'"'
	CALL	CPUSH
	LXI	H,I1
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
LSB11:	CALL	AC54
LSB12:	CALL	AC24
	JMP	LSB1
LSB13:	LXI	H,I6
	MVI	B,1
	CALL	POPIT
	LDA	I6
	ORA	A
	JZ	LSB14
	LXI	H,I6
	DCR	M
	LXI	H,DP
	MVI	B,2
	CALL	POPIT
	JMP	LSB1
LSB14:	RET	
;*
;*
MATCH:			;CHECK PATTERN AGAINST STRING
	CALL	SSCHK
	LHLD	PTR1	;SAVE PATTERN POINTER
	SHLD	PTR
MAT1:	LXI	D,INT1	;GET PATTERN SIZE
	LHLD	PTR1
	XCHG	
	CALL	SETI
	LHLD	PTR1
	LXI	D,INTLN
	DAD	D
	SHLD	PTR1
	LXI	H,INT1
	MOV	A,M
	ANI	0F0H
	JNZ	MAT2A
	CALL	ITC
	STA	PLENG
	ORA	A
	JNZ	MAT2
	LHLD	INDX
	XCHG	
	LHLD	PTR2
	CALL	JPEN
	JNZ	MAT16
	JMP	MAT12
MAT2:	LDA	PLENG	;STRING ALL MATCHED UP
	ORA	A
	JZ	MAT1A
	LHLD	INDX
	XCHG	
	LHLD	PTR2
	CALL	JPEN
	JZ	MAT16
	LHLD	INDX	;CHARS THE SAME?
	XCHG	
	LHLD	PTR1
	LDAX	D
	CMP	M
	JNZ	MAT14
	INX	H	;LOOK AT NEXT ONES
	SHLD	PTR1 
	LHLD	INDX
	INX	H
	SHLD	INDX
	LXI	H,PLENG
	DCR	M
	JMP	MAT2
MAT2A:	LXI	H,INT1
	MOV	A,M
	XRI	0F0H
	MOV	M,A
	CALL	ITC
	STA	PLENG
MAT3:	LHLD	INDX
	XCHG	
	LHLD	PTR2
	CALL	JPEN
	JZ	MAT16
	LHLD	PTR1	;GET PATTERN SYMBOL
	MOV	A,M
	STA	CHR
	CPI	'U'
	JNZ	MAT4
	LDA	TOKEN	;UPPER CASE
	CPI	2
	JZ	MAT11
	JMP	MAT10
MAT4:	LDA	CHR
	CPI	'L'
	JNZ	MAT5
	LDA	TOKEN	;LOWER CASE
	CPI	1
	JZ	MAT11
	JMP	MAT10
MAT5:	LDA	CHR
	CPI	'A'
	JNZ	MAT6
	LDA	TOKEN	;ALPHABETIC
	CPI	1
	JZ	MAT11
	CPI	2
	JZ	MAT11
	JMP	MAT10
MAT6:	LDA	CHR
	CPI	'N'
	JNZ	MAT7
	LDA	TOKEN	;NUMERIC
	CPI	3
	JZ	MAT11
	JMP	MAT10
MAT7:	LDA	CHR
	CPI	'P'
	JNZ	MAT8
	LDA	TOKEN	;PUNCUATION
	CPI	4
	JC	MAT10
	CPI	36
	JC	$+6
	JNZ	MAT10
	JMP	MAT11
MAT8:	LDA	CHR
	CPI	'C'
	JNZ	MAT9
	LDA	TOKEN
	CPI	36
	JC	$+6
	JNZ	MAT11
	JMP	MAT10
MAT9:	LDA	TOKEN
	ORA	A
	JNZ	MAT11
MAT10:	LHLD	PTR1
	INX	H
	SHLD	PTR1
	LXI	H,PLENG
	DCR	M
	LDA	PLENG
	ORA	A
	JNZ	MAT3
	JMP	MAT16
MAT1A:	LHLD	INDX
	DCX	H
	SHLD	INDX
MAT11:	CALL	GTOKN
MAT12:	LXI	H,INT2
	MVI	C,INTLN
	CALL	SUB1
	MOV	A,M
	ANI	0F0H
	JNZ	MAT13
	MVI	C,INTLN
	CALL	ZTEST
	JZ	MAT14
	LHLD	PTR
	SHLD	PTR1
	JMP	MAT1
MAT13:	LHLD	PTR
	SHLD	PTR1
	LXI	H,INT2
	LXI	D,IZERO
	CALL	SETI
	JMP	MAT16
MAT14:	LHLD	PTR1
	LDA	PLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR1
MAT16:	RET	
;*
;*
XECRE:			;RETURN FROM XECUTE
	CALL	SSCHK
	LXI	H,MODE
	MVI	B,1
	CALL	POPIT
	LXI	H,INDFL	;RESTORE THINGS FROM STACK
	MVI	B,1
	CALL	POPIT
	LXI	H,FORSW
	MVI	B,1
	CALL	POPIT
	LXI	H,SPTR
	MVI	B,2
	CALL	POPIT
	LDA	INDSW
	CPI	1
	JC	$+6
	JNZ	XEC0
	LXI	H,PRGPT
	MVI	B,2
	CALL	POPIT
XEC0:	CALL	LOADI	;LOAD ROUTINE
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	LDA	N
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
	LXI	H,INDSW
	DCR	M
	LXI	H,LEVEL
	DCR	M
	XRA	A
	STA	FLAG
	LDA	MODE
	CPI	1
	JZ	XEC1
	LDA	INDSW
	ORA	A
	JNZ	XEC1
	CALL	INPUT
	JMP	XEC2
XEC1:	LHLD	DRBUF
	XCHG	
	LHLD	LBUFF
	LDA	DRLNG
	MOV	B,A
	CALL	MOVE
	LHLD	LBUFF
	LDA	DRLNG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR
	MVI	M,EOL
XEC2:	LHLD	SPTR
	DCX	H
	SHLD	INDX
	CALL	GTOKN
	MVI	A,FALSE
	STA	GOTOF
	RET	
;*
;*
GARBG:			;GARBAGE COLLECTOR AND TRASH MASHER
	CALL	SSCHK
	LHLD	SYMPT
	XCHG	
	LHLD	PTEND
	CALL	JPEN
	JZ	GAR18
	LHLD	SYMEN	;SEQUENTIAL SCAN TO FIND GARBAGE
	SHLD	TOP
	SHLD	LOC
GAR1:	LHLD	LOC	;AT END OF SYM TABLE?
	XCHG	
	LHLD	PTEND
	CALL	JPEN
	JZ	GAR3
	LHLD	LOC
	SHLD	TGP
	LXI	D,PTRLN	;MOVE TO TYPE
	DAD	D
	MOV	A,M
	STA	GTYPE
	INX	H
	SHLD	LOC
	MOV	E,M	;GET ENTRY SIZE
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	LHLD	LOC	;MOVE TO GARBAGE POINTER
	LXI	D,PTRLN
	DAD	D
	SHLD	LOC
	ANI	128
	JNZ	GAR2
	LHLD	TOP	;SET COMPACTION PTR
	XCHG	
	LHLD	LOC
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	BSIZE
	XCHG	
	DAD	D
	SHLD	TOP
GAR2:	LHLD	TGP
	SHLD	LOC
	LHLD	BSIZE	;ADVANCE LOC
	XCHG	
	LHLD	LOC
	DAD	D
	SHLD	LOC
	JMP	GAR1
GAR3:	LHLD	TOP	;GET ADJUSTMENT FACTOR
	XCHG	
	LHLD	LOC
	CALL	PSUB
	SHLD	LOC
	SHLD	ADJ
	LHLD	SYMEN
	SHLD	LOC
GAR4:	LHLD	LOC
	XCHG	
	LHLD	PTEND
	CALL	JPEN
	JZ	GAR6
	LHLD	LOC	;ADJUST THE COMPACTION POINTERS
	SHLD	TGP
	LXI	D,PTRLN
	DAD	D
	MOV	A,M
	STA	GTYPE
	INX	H
	SHLD	LOC
	MOV	E,M	;GET ENTRY SIZE
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	LHLD	LOC	;MOVE TO GARBAGE PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	LOC
	ANI	128
	JNZ	GAR5
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	GPTR
	LHLD	ADJ	;ADJUST PTR
	XCHG	
	LHLD	GPTR
	DAD	D
	SHLD	GPTR
	XCHG	
	LHLD	LOC
	MOV	M,E
	INX	H
	MOV	M,D
GAR5:	LHLD	TGP
	SHLD	LOC
	LHLD	BSIZE	;MOVE TO NEXT ENTRY
	XCHG	
	LHLD	LOC
	DAD	D
	SHLD	LOC
	JMP	GAR4
GAR6:	MVI	A,2
	STA	GARL
	LHLD	LAST
	LXI	D,SYMPT
	CALL	JPEN
	JZ	GAR65
	XRA	A
	STA	GARL
	LHLD	LPTR
	XCHG	
	LHLD	LAST
	CALL	JPEN
	JNZ	GAR64
	MVI	A,1
	STA	GARL
GAR64:	LHLD	LPTR
	LXI	D,5
	DAD	D
	SHLD	LOC
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	LPTR
GAR65:	LHLD	SYMPT	;ADJUST SYMPT
	LXI	D,5
	DAD	D
	SHLD	LOC
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	SYMPT
	LHLD	SYMEN	;REDEFINE ALL POINTERS
	SHLD	LOC
GAR7:	LHLD	LOC
	XCHG	
	LHLD	PTEND
	CALL	JPEN
	JZ	GAR11
	LHLD	LOC
	SHLD	TOP
	LXI	D,PTRLN
	DAD	D
	MOV	A,M
	STA	GTYPE
	INX	H
	SHLD	LOC
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	ANI	128
	JNZ	GAR9
	LHLD	TOP	;ADJUST FIRST PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	TGP
	LXI	D,NULL
	CALL	JPEN
	JZ	GAR75
	LHLD	TGP
	XCHG	
	LHLD	PTEND
	CALL	JPEN
	JZ	GAR75
	LHLD	TGP
	LXI	D,5
	DAD	D
	SHLD	TGP
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	TOP
	MOV	M,E
	INX	H
	MOV	M,D
GAR75:	LDA	GTYPE
	CPI	4
	JC	GAR9
	CPI	7
	JC	$+6
	JNZ	GAR8
	LHLD	LOC	;TYPE 4-7
	LXI	D,4
	DAD	D
	MOV	C,M
	MVI	B,0
	DAD	B
	INX	H
	SHLD	LOC
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	TGP
	LXI	D,NULL
	CALL	JPEN
	JZ	GAR9
	LHLD	TGP
	LXI	D,5
	DAD	D
	SHLD	TGP
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	LOC
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	GAR9
GAR8:	LHLD	LOC	;TYPE 8-11
	LXI	D,4
	DAD	D
	SHLD	LOC
	MOV	E,M	;ADJUST ACROSS PTR
	INX	H
	MOV	D,M
	XCHG	
	SHLD	TGP
	LXI	D,NULL
	CALL	JPEN
	JZ	GAR9
	LHLD	TGP
	LXI	D,5
	DAD	D
	SHLD	TGP
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	LOC
	MOV	M,E
	INX	H
	MOV	M,D
GAR9:	LHLD	TOP
	SHLD	LOC
	LHLD	BSIZE
	XCHG	
	LHLD	LOC
	DAD	D
	SHLD	LOC
	JMP	GAR7
GAR11:	LHLD	SYMEN	;COMPACT SYM TABLE
	SHLD	TOP
	SHLD	LOC
GAR12:	LHLD	LOC	;AT END?
	XCHG	
	LHLD	PTEND
	CALL	JPEN
	JZ	GAR15
	LHLD	LOC
	SHLD	TGP
	LXI	D,PTRLN	;MOVE TO TYPE
	DAD	D
	MOV	A,M
	STA	GTYPE
	INX	H
	SHLD	LOC
	MOV	E,M	;GET ENTRY SIZE
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	LHLD	TGP
	SHLD	LOC
	ANI	128
	JNZ	GAR14
GAR13:	LHLD	LOC	;MOVE ENTRY DOWN
	MOV	A,M
	LHLD	TOP
	MOV	M,A
	INX	H
	SHLD	TOP
	LHLD	LOC
	INX	H
	SHLD	LOC
	LHLD	BSIZE
	DCX	H
	SHLD	BSIZE
	LXI	D,NULL
	CALL	JPEN
	JNZ	GAR13
	JMP	GAR12
GAR14:	LHLD	BSIZE	;GET NEXT ENTRY
	XCHG	
	LHLD	LOC
	DAD	D
	SHLD	LOC
	JMP	GAR12
GAR15:	LHLD	PTEND
	DCX	H
	SHLD	LOC
	LHLD	TOP
	DCX	H
	SHLD	TOP
GAR16:	LHLD	TOP	;SHIFT ENTIRE TABLE UP
	XCHG	
	LHLD	SYMEN
	CALL	JPEN
	JZ	GAR17
	LHLD	TOP
	MOV	A,M
	LHLD	LOC
	MOV	M,A
	DCX	H
	SHLD	LOC
	LHLD	TOP
	DCX	H
	SHLD	TOP
	JMP	GAR16
GAR17:	LHLD	TOP
	MOV	A,M
	LHLD	LOC
	MOV	M,A
	SHLD	SYMEN	;ADJUST SYMEN
	LDA	GARL
	CPI	2
	JZ	GAR18
	ORA	A
	JNZ	GAR1A
	LHLD	LPTR
	LXI	D,PTRLN
	DAD	D
	MOV	A,M
	STA	GTYPE
	LXI	D,PTRLN+PTRLN+SHTLN
	DAD	D
	SHLD	LPTR
	CPI	7
	JC	$+6
	JNZ	GAR1A
	MOV	C,M
	MVI	B,0
	DAD	B
	INX	H
	SHLD	LPTR
GAR1A:	LHLD	LPTR
	SHLD	LAST
GAR18:	RET	
;*
;*
INSER:			;PUTS NAME PART OF SYMBOL TABLE IN
	CALL	SSCHK
	CALL	GTSIZ	;GET SIZE OF T-O-S ITEM
	LDA	I3
	CPI	4
	JC	INS1
	CPI	4	;ADJUST TPP IF AN ARRAY HEAD
	JNZ	INS05
	LXI	H,NULL
	SHLD	TPP
INS05:	LHLD	TPP
	LXI	D,10
	DAD	D
	SHLD	TPP
	JMP	INS2
INS1:	LHLD	TPP	;ADJUST TPP IF NOT ARRAY
	LXI	D,8
	DAD	D
	SHLD	TPP
INS2:	LHLD	TPP	;ADD IN NAME LENGTH
	LDA	NLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	TPP
	LHLD	PTR3
	MOV	C,A
	MVI	B,0
	DAD	B
	INX	H
	SHLD	PTR3
INS25:	XRA	A	;GARBAGE COLLECTION FLAG
	STA	N
	MVI	A,1
	STA	I1
INS26:	LHLD	SYMEN	;SEE IF ROOM FOR ENTRY
	SHLD	PTR
	LHLD	TPP
	XCHG	
	LHLD	PTR
	CALL	PSUB
	SHLD	PTR
INS3:	LHLD	PTR
	XCHG	
	LHLD	PRGEN
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	INS4
	LDA	N	;ALREADY COLLECTED
	CPI	1
	JZ	E31
	CALL	GARBG
	MVI	A,1	;SET GARBAGE FLAG
	STA	N
	JMP	INS26
INS4:	LHLD	PTR	;SAVE START
	SHLD	PTR1
	SHLD	SYMEN
	LXI	D,2
	DAD	D
	LDA	I3	;SET TYPE
	MOV	M,A
	STA	STYPE
	INX	H
	SHLD	PTR
	LHLD	TPP	;SET SIZE
	XCHG	
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,4
	DAD	D
	LDA	NLENG	;SET NAME LENGTH
	MOV	M,A
	INX	H
	SHLD	PTR
	LHLD	NAME	;SET NAME
	XCHG	
	LHLD	PTR
	MOV	B,A
	CALL	MOVE
	LHLD	PTR	;MOVE PTR PAST NAME
	LDA	NLENG
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	PTR
	LDA	I3
	CPI	5
	JC	INS5
	CPI	7
	JC	$+6
	JNZ	INS5
	LXI	D,2
	DAD	D
	SHLD	PTR
INS5:	RET	
;*
;*
MARKS:			;MARK ALL DESCENDENTS OF A NODE
	CALL	SSCHK
	LXI	H,NULL
	SHLD	PTR3
MRK1:	LHLD	PTR2
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LDA	IT
	CPI	1
	JZ	MRK11
	MOV	A,M	;GARBAGE ALREADY?
	ANI	128
	JNZ	MRK3
	MOV	A,M
	ORI	128
	MOV	M,A
	JMP	MRK15
MRK11:	LHLD	PTR
	MOV	A,M
	ANI	128
	JZ	MRK3
	MOV	B,M
	MVI	A,128
	CMA	
	ANA	B
	MOV	M,A
MRK15:	LHLD	PTR
	INX	H
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	MVI	M,0
MRK2:	LHLD	PTR2
	LXI	D,PTRLN
	DAD	D
	INX	H
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	MOV	A,M	;TRY ACROSS THEN DOWN PTRS
	ORA	A
	JZ	MRK20
	MOV	A,M	;TRY DOWN PTR
	CPI	1
	JZ	MRK21
	JMP	MRK3 	;BACK UP
MRK20:	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	TPP
	MVI	A,1
	STA	TYPE
	MOV	E,M
	INX	H
	MOV	D,M
	LXI	H,NULL
	CALL	JPEN
	JNZ	MRK25
MRK21:	MVI	A,2
	STA	TYPE
	LHLD	PTR2	;GET DOWN PTR
	SHLD	TPP
	MOV	E,M
	INX	H
	MOV	D,M
	LXI	H,NULL
	CALL	JPEN
	JNZ	MRK25
	JMP	MRK3 	;BACK UP
MRK25:	LHLD	PTR	;SAVE BRANCH TYPE
	LDA	TYPE
	MOV	M,A
	LHLD	TPP	;ROTATE LINKS
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	LHLD	PTR3
	XCHG	
	LHLD	TPP
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR2
	SHLD	PTR3
	LHLD	PTR
	SHLD	PTR2
	JMP	MRK1
MRK3:	LHLD	PTR3	;DONE
	LXI	D,NULL
	CALL	JPEN
	JZ	MRK4
	LHLD	PTR3	;RETRACE CHAIN 1 PLACE
	LXI	D,PTRLN
	DAD	D
	INX	H
	LXI	D,PTRLN	;MOVE TO GARBAGE FIELD
	DAD	D
	MOV	A,M
	STA	TYPE
	LXI	D,PTRLN	;MOVE TO ACROSS PTR
	DAD	D
	SHLD	PTR
	LHLD	PTR3	;GRAB DOWN PTR (JUST IN CASE)
	SHLD	TPP
	CPI	1
	JNZ	MRK35
	LHLD	PTR	;NEEDED ACROSS
	SHLD	TPP
MRK35:	LHLD	TPP	;ROTATE LINKS
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	LHLD	PTR2
	XCHG	
	LHLD	TPP
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR3
	SHLD	PTR2
	LHLD	PTR
	SHLD	PTR3
	JMP	MRK2
MRK4:	RET	
;*
;*
SEARC:			;SEARCH SYMBOL TABLE FOR ENTRY
	CALL	SSCHK
	XRA	A
	STA	CASE
	LXI	H,SYMPT	;LAST POINTS TO PREVIOUS ENTRY
	SHLD	LAST
	LHLD	SYMPT	;PTR TO START OF SYMBOL TABLE
	SHLD	PTR
SEA1:	LHLD	PTR	;TPP TO NEXT ENTRY
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	TPP
	LXI	D,NULL
	CALL	JPEN
	JZ	SEA14
	LHLD	PTR	;PTR TO TYPE
	LXI	D,2
	DAD	D
	MOV	A,M
	STA	STYPE
	LXI	D,5	;PTR TO NAME LENGTH
	DAD	D
	SHLD	PTR
	MOV	A,M
	STA	COUNT
	INX	H	;PTR TO NAME
	SHLD	PTR  
	LXI	H,NLENG
	CMP	M
	JNZ	SEA2
	LHLD	PTR
	XCHG	
	LHLD	NAME
	LDA	NLENG
	MOV	C,A
	CALL	JSE
	JNZ	$+13
	SHLD	NAME
	XCHG	
	SHLD	PTR
	JMP	SEA3
SEA2:	LHLD	TPP	;TRY NEXT ONE
	SHLD	PTR
	LHLD	LAST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	LAST
	JMP	SEA1
SEA3:	LHLD	LAST
	SHLD	LPTR
	LDA	SCNT	;NAME MATCH--NO SUBS
	ORA	A
	JZ	SEA1B
;*  HERE IF SUBSCRIPTS TO MATCH
	LHLD	NAME
	INX	H
	SHLD	NAME
SEA4:	LDA	STYPE	;NO SUBS IN SYMBOL TABLE
	CPI	4
	JC	SEA13
	LHLD	LAST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	LPTR
	LHLD	PTR
	SHLD	LAST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	SHLD	SDP
	LXI	D,NULL
	CALL	JPEN
	JZ	SEA8
SEA5:	LHLD	PTR	;SET DOWN PTR
	SHLD	DP
	LXI	D,2
	DAD	D
	MOV	A,M	;SET TYPE
	STA	STYPE
	LXI	D,5
	DAD	D
	SHLD	PTR
	SHLD	AP	;SET ACROSS PTR
	LXI	D,2
	DAD	D
	SHLD	PTR
;*  NOW CHECK IF SUBSCRIPTS EQUAL
	SHLD	PTR5
	LHLD	NAME
	SHLD	PTR4
	CALL	COMPA
	LDA	CASE
	CPI	2
	JZ	SEA11
SEA7:	LHLD	AP	;NO MATCH--MOVE ACROSS
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	LHLD	AP
	SHLD	LAST
	LHLD	DP
	SHLD	LPTR
	LHLD	PTR
	LXI	D,NULL
	CALL	JPEN
	JNZ	SEA5
SEA8:	MVI	A,1	;NOT ALL SUBS MATCH
	STA	CASE
	JMP	SEA13
SEA11:	LHLD	PTR5
	INX	H
	SHLD	PTR
	LHLD	PTR4
	INX	H
	SHLD	NAME
	LXI	H,SCNT
	DCR	M
	LDA	SCNT
	ORA	A
	JZ	SEA12
	LHLD	DP
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	SHLD	SDP
	LHLD	DP
	SHLD	LAST
	SHLD	LPTR
	LHLD	PTR
	LXI	D,NULL
	CALL	JPEN
	JNZ	SEA5
	MVI	A,1	;NOT ALL SUBS MATCH
	STA	CASE
	JMP	SEA13
SEA1B:	LHLD	NAME
	INX	H
	SHLD	NAME
SEA12:	MVI	A,2	;COMPLETE MATCH
	STA	CASE
	LDA	STYPE
	CPI	4
	JC	SEA13
	CPI	7
	JC	$+6
	JNZ	SEA13
	LHLD	PTR	;MOVE PTR TO VALUE
	LXI	D,2
	DAD	D
	SHLD	PTR
SEA13:	MVI	A,1
	STA	RESUL
	RET	
SEA14:	XRA	A
	STA	RESUL
	RET	
;*
;*
SETVA:			;SETS VALUE IN SYMBOL TABLE
	CALL	SSCHK
SET0:	LXI	H,I4
	MVI	B,1
	CALL	POPIT
	LDA	I1
	CPI	1
	JZ	SET9
	LHLD	TOS
	INX	H
	SHLD	TOS
	LDA	I4
	STA	I3
SET5:	LDA	STYPE
	CPI	7
	JC	$+6
	JNZ	SET7
	CPI	4
	JC	SET55
	LDA	I3
	ADI	4
	STA	I3
SET55:	LHLD	PTR3
	SHLD	SPTR
	CALL	INSER	;PUT IN NEW ENTRY
	LHLD	SPTR
	SHLD	PTR3
	LHLD	LAST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR2
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	PTR1
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR1
	XCHG	
	LHLD	LAST
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR1
	SHLD	PTR
	LHLD	PTR2
	LXI	D,2
	DAD	D
	SHLD	PTR2
	MOV	A,M	;MARK OLD AS GARBAGE
	ORI	128
	MOV	M,A
	LHLD	PTR
	LXI	D,7
	DAD	D
	MOV	A,M
	STA	COUNT
	MOV	C,A
	MVI	B,0
	DAD	B
	INX	H
	SHLD	PTR
	LDA	STYPE
	CPI	4
	JC	SET0
	LHLD	PTR2
	LXI	D,5
	DAD	D
	LDA	COUNT
	MOV	C,A
	MVI	B,0
	DAD	B
	INX	H
	SHLD	PTR2
	MOV	E,M	;COPY DOWN PTR
	INX	H
	MOV	D,M
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,2
	DAD	D
	SHLD	PTR
	JMP	SET0
SET7:	LDA	I3
	ADI	8
	STA	I3
	LHLD	PTR3
	SHLD	SPTR
	LHLD	LAST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,9
	DAD	D
	SHLD	PTR3
	MVI	A,1
	STA	I9
	CALL	SINSR	;PUT IN SUBSCRIPT WITH VALUE
	LHLD	SPTR
	SHLD	PTR3
	LHLD	LAST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR2
	LHLD	PTR1
	XCHG	
	LHLD	LAST
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR2	;PUT IN DOWN PTR
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	PTR1
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR1
	LXI	D,7
	DAD	D
	SHLD	PTR
	LHLD	PTR2
	LXI	D,2
	DAD	D
	MOV	A,M	;SET GARBAGE BIT
	ORI	128
	MOV	M,A
	LXI	D,5
	DAD	D
	SHLD	PTR2
	MOV	E,M	;SET ACROSS PTR
	INX	H
	MOV	D,M
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,2
	DAD	D
	SHLD	PTR
SET8:	LHLD	PTR	;SKIP PAST SUBSCRIPT
	MOV	A,M
	CPI	DELIM
	JZ	SET85
	INX	H
	SHLD	PTR
	JMP	SET8
SET85:	LHLD	PTR  	;SKIP DELIMITER
	INX	H
	SHLD	PTR  
	JMP	SET0
SET9:	LHLD	TOS
	DCX	H
	MOV	A,M
	STA	SLENG
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	PTR2
SET10:	LHLD	PTR
	LDA	SLENG
	MOV	M,A
	INX	H
	SHLD	PTR
	LHLD	PTR2
	XCHG	
	LHLD	PTR
	MOV	B,A
	CALL	MOVE
	RET	
;*
;*
SINSR:			;INSERT DUMMY NODES IN SYMBOL TABLE
	CALL	SSCHK
	XRA	A	;GARBAGE COLLECTION FLAG
	STA	N
	MVI	A,1
	STA	I1
	CALL	GTSIZ
SIN0:	LHLD	TPP	;BASIC SIZE (NO SUBSCRIPT)
	LXI	D,9
	DAD	D
	SHLD	TPP
	LHLD	PTR3
	SHLD	PTR8
SIN1:	LHLD	PTR3
	MOV	A,M
	CPI	DELIM
	JZ	SIN15
	INX	H
	SHLD	PTR3
	LHLD	TPP
	INX	H
	SHLD	TPP
	JMP	SIN1
SIN15:	LHLD	TPP
	INX	H
	SHLD	TPP
	LHLD	PTR8
	SHLD	PTR3
SIN2:	LHLD	SYMEN	;SEE IF IT'LL FIT
	SHLD	PTR
	LHLD	TPP
	XCHG	
	LHLD	PTR
	CALL	PSUB
	SHLD	PTR
	XCHG	
	LHLD	PRGEN
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	SIN3
	LDA	N	;NO ROOM, ALREADY COLLECTED
	CPI	1
	JZ	E31
	CALL	GARBG
	MVI	A,1	;SET FLAG
	STA	N
	LDA	I9
	ORA	A
	JZ	SIN2
	LHLD	LAST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,9
	DAD	D
	SHLD	PTR3
	JMP	SIN2
SIN3:	LHLD	PTR
	SHLD	PTR1
	SHLD	SYMEN
	LHLD	PTR	;NULL DOWN PTR
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,2
	DAD	D
	LDA	I3	;SET TYPE
	MOV	M,A
	STA	STYPE
	INX	H
	SHLD	PTR
	LHLD	TPP	;SET SIZE
	XCHG	
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,4
	DAD	D
	SHLD	PTR
	LXI	D,NULL	;NULL ACROSS PTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,2
	DAD	D
	SHLD	PTR
SIN4:	LHLD	PTR3
	MOV	A,M
	CPI	DELIM
	JZ	SIN5
	MOV	A,M
	LHLD	PTR
	MOV	M,A
	INX	H
	SHLD	PTR
	LHLD	PTR3
	INX	H
	SHLD	PTR3
	JMP	SIN4
SIN5:	LHLD	PTR
	MVI	M,DELIM
	INX	H
	SHLD	PTR
	LHLD	PTR3 
	INX	H
	SHLD	PTR3 
	RET	
;*
;*
DEL:			;KILL GLOBAL NOT ON LEAF
	CALL	SSCHK
	MVI	A,FALSE
	STA	SPLT
	LXI	H,SGREC
	LXI	D,GREC
	CALL	SETD
	LDA	N
	STA	SN
	LXI	H,N
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC
	MVI	B,3
	CALL	PUSHT
	LHLD	PTR
	LXI	D,-(GVLEN)
	DAD	D
	SHLD	PTR
	LXI	D,GREC
	XCHG
	CALL	SETD
	LXI	H,GRCXX
	LXI	D,GREC
	CALL	SETD
DEL1:	CALL	GREAD
	CALL	G2END
	LXI	H,N
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC
	MVI	B,3
	CALL	PUSHT
	LXI	H,GRCC3
	LXI	D,NIL
	CALL	JDEN
	JZ	DELA
	LXI	H,GREC
	LXI	D,GRCC3
	CALL	SETD
	JMP	DEL1
DELA:	LHLD	PTR
	SHLD	SPTR
	LHLD	TOS
	SHLD	TRAIL
	LXI	H,SN
	MVI	B,1
	CALL	PUSHT
	LXI	H,SGREC
	MVI	B,3
	CALL	PUSHT
	CALL	SAVKE
	LHLD	SPTR
	SHLD	PTR
	CALL	SETSE
	CALL	SQUAS	;DELETE ENTRY IN LEAF
	LXI	H,GREC
	MVI	B,3
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC
	MVI	B,3
	CALL	PUSHT
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	UBSZ
	CALL	GREAD	;READ IN HIGH UP NODE
	CALL	SETPT	;MOVE PTR TO START OF ENTRY
	LXI	H,GREC
	LXI	D,GRCXX
	CALL	SETD
	MVI	A,TRUE
	STA	FRMDE
	CALL	GLST0	;SET THE LEAF VALUE UP HIGH
	MVI	A,FALSE
	STA	UF
	LHLD	UBSZ
	LXI	D,BLKS2
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JC	DEL2
	MVI	A,TRUE
	STA	UF
	CALL	FIXTR
DEL2:	RET	
;*
;*
ENTSI:			;GET SIZE OF ENTRY TO TPP
	CALL	SSCHK
	LHLD	PTR
	SHLD	PTR2
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR3
	XCHG	
	LHLD	PTR
	DAD	D
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	CALL	VALSZ
	LHLD	PTR3
	XCHG	
	LHLD	TPP
	DAD	D
	LXI	D,PTRLN+GVLEN
	DAD	D
	SHLD	TPP
	LHLD	PTR2
	SHLD	PTR
	RET	
;*
;*
FDDSC:			;IS NEXT ENTRY A DESCENDENT
	CALL	SSCHK
	LXI	H,PTR3
	MVI	B,2
	CALL	PUSHT
	LXI	H,NLEN
	MVI	B,2
	CALL	PUSHT
	LHLD	PTR
	SHLD	TPP
	XRA	A
	STA	RESUL
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PLEN
	LHLD	TPP
	LXI	D,PTRLN
	DAD	D
	SHLD	TPP
	LHLD	PLEN
	XCHG	
	LHLD	NLEN
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	FDD0
	JMP	FDD4 	;DONE--NO DESCENDENTS
FDD0:	LDA	SCNT
	STA	I5
	LHLD	TPP
	SHLD	PTR5
	LHLD	PTR3
	SHLD	PTR4
	CALL	COMPA
	LDA	CASE
	CPI	2
	JNZ	FDD4
	LHLD	PTR4
	INX	H
	INX	H
	SHLD	PTR4
	LHLD	PTR5
	INX	H
	INX	H
	SHLD	PTR5
FDD1:	LHLD	NLEN
	LXI	D,NULL
	CALL	JPEN
	JZ	FDD3
	LHLD	PTR4
	MOV	A,M
	CPI	DELIM
	JNZ	FDD12
	LHLD	PTR5
	MOV	A,M
	CPI	DELIM
	JZ	FDD13
	JMP	FDD4
FDD12:	LHLD	PTR5
	MOV	A,M
	CPI	DELIM
	JZ	FDD4
	LHLD	PTR4
	XCHG	
	LHLD	PTR5
	LDAX	D
	CMP	M
	JNZ	FDD4
FDD13:	LHLD	PTR4
	INX	H
	SHLD	PTR4
	LHLD	PTR5
	INX	H
	SHLD	PTR5
	LHLD	NLEN
	DCX	H
	SHLD	NLEN
	JMP	FDD1
FDD3:	MVI	A,1
	STA	RESUL
FDD4:	LXI	H,NLEN 	;RESTORE VALUES
	MVI	B,2
	CALL	POPIT
	LXI	H,PTR3
	MVI	B,2
	CALL	POPIT
	RET	
;*
;*
FINDK:			;FIND PLACE FOR A KEY
	CALL	SSCHK
	MVI	A,TRUE
	STA	PASSU
	MVI	A,FALSE
	STA	RESUL
	LDA	GLBDR
	STA	DRIVE
	XRA	A
	STA	FCBTY
	LDA	GLOPN
	CPI	1
	JZ	FDKA
	CALL	FOPEN
	MVI	A,1
	STA	GLOPN
	CALL	RDROO
FDKA:	LXI	H,GREC
	LXI	D,ROOT
	CALL	SETD
FDK0:	LXI	H,GREC
	LXI	D,NIL
	CALL	JDEN
	JZ	FDK4
	LDA	PASSU
	CPI	TRUE
	JNZ	FDK4
	CALL	GREAD
	LHLD	GLBUF	;PTR TO START OF BUFFER
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	MOV	E,M	;GET MIDDLE OFFSET
	INX	H
	MOV	D,M
	XCHG	
	SHLD	TPP
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	MOV	A,M
	STA	N
	INX	H
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	SHLD	PTR7	;SAVE STARTING PLACE
	LHLD	TPP	;MOVE PTR TO MIDDLE
	XCHG	
	LHLD	PTR
	DAD	D
	SHLD	PTR
	MOV	E,M	;GET KEY SIZE
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR1
	LXI	D,NULL
	CALL	JPEN
	JZ	FDK05
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LDA	SCNT
	STA	I5
	CALL	KEYCM	;COMPARE KEYS
	LDA	CASE
	CPI	2
	JZ	FDK2
	MVI	A,FALSE
	STA	RESUL
	LDA	CASE
	CPI	3
	JZ	FDK15
FDK05:	LHLD	PTR7	;PUT PTR BACK TO START
	SHLD	PTR
	XRA	A
	STA	N
FDK1:	LHLD	PTR	;GET KEY SIZE
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR1
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LHLD	PTR1
	LXI	D,NULL
	CALL	JPEN
	JZ	FDK3
	LDA	SCNT
	STA	I5
	CALL	KEYCM	;COMPARE KEYS
	LDA	CASE	;FOUND IT?
	CPI	2
	JZ	FDK2
	MVI	A,FALSE
	STA	RESUL
	LDA	CASE
	CPI	1
	JZ	FDK3
FDK15:	LHLD	PTR1	;PTR PAST KEY TO TYPE
	XCHG	
	LHLD	PTR
	DAD	D
	SHLD	PTR
	CALL	VALSZ
	LHLD	TPP	;PTR PAST VALUE TO DOWN PTR
	XCHG	
	LHLD	PTR
	DAD	D
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	LXI	H,N
	INR	M
	JMP	FDK1
FDK2:	MVI	A,FALSE	;IT'S FOUND
	STA	PASSU
	MVI	A,TRUE
	STA	RESUL
FDK3:	LXI	H,N    	;SAVE LOCATION IN BLOCK
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC 	;SAVE BLOCK NUMBER
	MVI	B,3
	CALL	PUSHT
	LHLD	PTR
	LXI	B,-(GVLEN+PTRLN)
	DAD	B
	SHLD	PTR
	LXI	D,GREC	;GET NEXT BLOCK BELOW
	XCHG	
	CALL	SETD
	JMP	FDK0
FDK4:	LHLD	PTR
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	RET	
;*
;*
FINDM:			;SCAN TO MIDDLE ENTRY OF NODE
	CALL	SSCHK
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	ORA	A
	LHLD	BSIZE	;DIVIDE BSIZE BY TWO
	MOV	A,H
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	SHLD	BSIZE
	LHLD	PTR	;PTR TO START OF FIRST KEY
	LXI	D,PTRLN+PTRLN+GVLEN
	DAD	D
	INX	H
	SHLD	PTR
	XRA	A
	STA	N
	LXI	H,NULL
	SHLD	PTR1
FNDM1:	LXI	H,PTR1
	MVI	B,2
	CALL	PUSHT
	LHLD	PTR	;GET NAME AND SUB SIZE
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	TPP
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LHLD	TPP	;PTR TO VAR TYPE
	XCHG	
	LHLD	PTR
	DAD	D
	SHLD	PTR
	LHLD	TPP
	XCHG	
	LHLD	PTR1
	DAD	D
	LXI	D,PTRLN+GVLEN
	DAD	D
	SHLD	PTR1
	CALL	VALSZ	;GET VALUE SIZE TO TPP
	LHLD	TPP	;PTR TO DOWN PTR
	XCHG	
	LHLD	PTR
	DAD	D
	LXI	D,GVLEN	;PTR TO NEXT ENTRY
	DAD	D
	SHLD	PTR
	LHLD	TPP
	XCHG	
	LHLD	PTR1
	DAD	D
	SHLD	PTR1
	LXI	H,N
	INR	M
	LXI	H,TPP
	MVI	B,2
	CALL	POPIT
	LHLD	PTR1
	XCHG	
	LHLD	BSIZE
	CALL	JPEN
	JZ	FNDM2
	LHLD	BSIZE
	XCHG	
	LHLD	PTR1
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	FNDM1
	LHLD	TPP
	SHLD	PTR1
	LXI	H,N
	DCR	M
FNDM2:	RET	
;*
;*
FIXTR:			;FIX UP TRAIL FOR UNDERFLOW
	CALL	SSCHK
	LDA	SPLT	;SEE IF DID A SPLIT
	CPI	TRUE
	JZ	FIXT1
	LHLD	TRAIL	;MOVE TOS BACK TO TRAIL
	SHLD	TOS
FIXT0:	LXI	H,GREC 	;GET UNDERFLOW NODE
	MVI	B,3
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	CALL	GREAD	;MAKE UNERFLOW NODE CURRENT
	RET	
FIXT1:	LHLD	TOP	;PTR1 TO BEGINNING OF OLD TRAIL
	SHLD	PTR1
	SHLD	PTR
	LHLD	USTAK	;GET TOP ENTRY OFF SPLIT TRAIL
	LXI	D,-(GVLEN)
	DAD	D
	SHLD	USTAK
	XCHG
	LXI	H,TGREC
	CALL	SETD
	LHLD	USTAK
	DCX	H
	SHLD	USTAK
	MOV	A,M
	STA	TN
	LXI	H,TGREC	;FOUND START OF SPLIT TRAIL YET?
	LXI	D,ROOT
	CALL	JDEN
	JZ	FIXT3
FIXT2:	LHLD	PTR1	;SAVE START OF ENTRY
	SHLD	PTR
	MOV	A,M	;GET OFFSET
	STA	N
	INX	H
	SHLD	PTR1
	XCHG		;GET BLOCK NUMBER
	LXI	H,TGREC
	CALL	SETD
	LHLD	PTR1
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR1
	LXI	H,GREC
	LXI	D,TGREC
	CALL	JDEN
	JNZ	FIXT2
FIXT3:	LHLD	PTR	;MOVE TOS TO WHERE STACK GOES BAD
	SHLD	TOS
	LDA	TN
	STA	N
	LXI	H,GREC
	LXI	D,TGREC
	CALL	SETD
FIXT4:	LXI	H,N	;SAVE OFFSET ON STACK
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC	;SAVE BLOCK NUMBER ON STACK
	MVI	B,3
	CALL	PUSHT
	LHLD	USTAK	;USED UP SPLIT STACK?
	LXI	D,TSTAK
	CALL	JPEN
	JZ	FIXT5
	LHLD	USTAK
	LXI	D,-(GVLEN)
	DAD	D
	SHLD	USTAK
	XCHG
	LXI	H,GREC
	CALL	SETD
	LHLD	USTAK
	DCX	H
	SHLD	USTAK
	MOV	A,M
	STA	N
	JMP	FIXT4
FIXT5:	CALL	GREAD	;READ IN NODE THAT SPLIT
	CALL	SETPT	;MOVE PTR TO BEFORE INSERTED ENTRY
	LHLD	PTR	;BACK PTR UP TO DOWN PTR
	LXI	D,-(GVLEN)
	DAD	D
	SHLD	PTR
	XCHG
	LXI	H,GREC
	CALL	SETD
FIXT6:	CALL	GREAD	;GET NODE BELOW ONE FROM SPLIT
	CALL	G2END
	LXI	H,N	;SAVE LAST ENTRY PLACE
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC	;AND BLOCK NUMBER
	MVI	B,3
	CALL	PUSHT
	LXI	H,GRCC3	;JUMP IF AT LEAF
	LXI	D,NIL
	CALL	JDEN
	JZ	FIXT7
	LXI	H,GREC	;GET NEXT LEVEL DOWN
	LXI	D,GRCC3
	CALL	SETD
	JMP	FIXT6
FIXT7:	LHLD	TOS	;NOW HAVE NEW TRAIL
	SHLD	TRAIL
	JMP	FIXT0
;*
;*
FNAKD:			;FIX UP NAKED REFERENCE
	CALL	SSCHK
	LDA	NLENG
	ORA	A
	JNZ	NAK3
	LDA	NSUBS
	ORA	A
	JZ	E36
	LDA	SCNT
	ORA	A
	JZ	E36
	MVI	A,1
	STA	NR
	LHLD	NAME
	SHLD	TPP
	LDA	SCNT	;# OF SUBS ON STACK
	STA	I5
	LXI	H,NSUBS	;BACK UP NAKED 1 SUB
	DCR	M
	LHLD	NLAST
	SHLD	NPTR
	LHLD	TPP
	INX	H
	SHLD	TPP
	CALL	MOVSU	;MOVE SUBS TO NAKED PLACE
	LDA	NSUBS
	STA	SCNT
	STA	SSUB
	LHLD	NSIZE
	LDA	NMSZ
	CMA	
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	DCX	H
	SHLD	NLEN
	LDA	NMSZ	;SET SIZE OF NAME
	STA	NLENG
	LXI	H,NREF
	SHLD	NAME
	SHLD	PTR3
	RET	
NAK3:	LDA	SCNT
	ORA	A
	JZ	NAK4
	CALL	SNAKD
	LHLD	PTR
	SHLD	TPP
	LDA	SCNT
	STA	I5
	CALL	MOVSU
NAK4:	RET	
;*
;*
FNDOL:			;FIND OLDEST ENTRY (AGE IS 0)
	CALL	SSCHK
	LHLD	GLBTA
	LXI	D,GVLEN
	DAD	D
	SHLD	TPP
	XRA	A
	STA	IT
FNDO1:	LHLD	TPP	;FIND OLD ONE
	MOV	A,M
	ORA	A
	JZ	FNDO2
	LXI	D,GBTSZ	;TPP TO NEXT ENTRY
	DAD	D
	SHLD	TPP
	LXI	H,IT
	INR	M
	JMP	FNDO1
FNDO2:	LDA	IT	;SAVE BUFFER NUMBER
	STA	BUFNO
	CALL	SETGL	;SET GLOBAL PTRS
	LHLD	GLDRT
	MOV	A,M
	ORA	A
	JZ	FNDO3
	LXI	H,GRCC4	;DIRTY, SO WRITE IT
	LXI	D,GREC
	CALL	SETD
	LXI	D,GREC
	LHLD	GLBNO
	XCHG	
	CALL	SETD
	CALL	GWRIT
	LXI	H,GREC
	LXI	D,GRCC4
	CALL	SETD
FNDO3:	LHLD	GLBNO	;SET RECORD NUMBER
	LXI	D,GREC
	CALL	SETD
	CALL	UPDRE	;UPDATE AGES
	RET	
;*
;*
FNDRE:			;LOOK FOR BLOCK 'GREC'
	CALL	SSCHK
	XRA	A
	STA	RESUL
	LHLD	GLBTA	;TPP TO START OF TABLE
	SHLD	TPP
	STA	IT
FNDR1:	LHLD	TPP
	LXI	D,GREC
	CALL	JDEN
	JZ	FNDR2
	LHLD	TPP	;TPP TO NEXT ENTRY
	LXI	D,GBTSZ
	DAD	D
	SHLD	TPP
	LXI	H,IT
	INR	M
	LDA	IT
	LXI	H,NGBUF
	CMP	M
	JNZ	FNDR1
	RET	
FNDR2:	MVI	A,1
	STA	RESUL
	RET	
;*
;*
G2END:			;MOVE PTR TO LAST ENTRY--SET PTR4 
	CALL	SSCHK
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	MOV	E,M	;GET MIDDLE OFFSET
	INX	H
	MOV	D,M
	XCHG	
	SHLD	TPP
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	MOV	A,M
	STA	N
	INX	H
	SHLD	PTR
	XCHG
	LXI	H,GRCC3
	CALL	SETD
	LHLD	PTR
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	LHLD	TPP	;MOVE TO MIDDLE ENTRY
	XCHG	
	LHLD	PTR
	DAD	D
	SHLD	PTR
G2E1:	LHLD	PTR	;SAVE ENTRY NAME SIZE
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR2
	LXI	D,NULL
	CALL	JPEN
	JZ	G2E2
	LHLD	PTR	;SAVE ENTRY START
	SHLD	PTR3
	LHLD	PTR2
	XCHG	
	LHLD	PTR
	DAD	D
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	CALL	VALSZ
	LHLD	TPP
	SHLD	PTR4
	XCHG	
	LHLD	PTR
	DAD	D
	SHLD	PTR
	LXI	D,GRCC3
	XCHG	
	CALL	SETD
	LHLD	PTR
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	LXI	H,N
	INR	M
	JMP	G2E1
G2E2:	LHLD	PTR3
	SHLD	PTR
	RET	
;*
;*
GETFI:			;GET FIRST ENTRY IN TREE
	CALL	SSCHK
	MVI	A,FALSE
	STA	RESUL
	LXI	H,GREC
	LXI	D,ROOT
	CALL	SETD
GTFS1:	LXI	H,GREC
	LXI	D,NIL
	CALL	JDEN
	JZ	GTFS2
	XRA	A
	STA	N
	LXI	H,N    	;LEAVE A TRAIL
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC
	MVI	B,3
	CALL	PUSHT
	CALL	GREAD	;READ IN NODE
	CALL	SETPT	;SET PTR AT FIRST ENTRY
	LHLD	PTR
	LXI	B,-(GVLEN)
	DAD	B
	SHLD	PTR
	LXI	D,GREC	;GET FIRST DOWN PTR
	XCHG	
	CALL	SETD
	MVI	A,TRUE
	STA	RESUL
	JMP	GTFS1
GTFS2:	LDA	RESUL
	CPI	FALSE
	JZ	GTFS3
	LHLD	PTR
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
GTFS3:	RET	
;*
;*
GETNE:			;GET NEXT ENTRY AFTER PTR (CALL FINDKEY FIRST)
	CALL	SSCHK
	LXI	H,ROOT
	LXI	D,NIL
	CALL	JDEN
	JZ	GTNX4
	LXI	H,GREC
	MVI	B,3
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	LDA	RESUL
	CPI	FALSE
	JZ	GTNX1
	LHLD	PTR	;SKIP OVER PREFECT MATCH
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	PTR
	DAD	D
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	CALL	VALSZ	;SKIP OVER VALUE
	LHLD	TPP
	XCHG	
	LHLD	PTR
	DAD	D
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	LXI	H,N
	INR	M
GTNX1:	LHLD	PTR	;PTR AT START OF NEXT ONE
	LXI	B,-(GVLEN)
	DAD	B
	SHLD	PTR
	LXI	D,GRCC1
	XCHG	
	CALL	SETD
	LXI	H,GRCC1	;CHECK IF ROOM TO GO DOWN
	LXI	D,NIL
	CALL	JDEN
	JNZ	GTNX3
	LHLD	PTR	;CAN'T GO DOWN
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
GTNX2:	LHLD	PTR	;NOT AT END SO DONE
	MOV	E,M
	INX	H
	MOV	D,M
	LXI	H,NULL
	CALL	JPEN
	JNZ	GTNX5
	LXI	H,GREC	;AT ROOT?
	LXI	D,ROOT
	CALL	JDEN
	JZ	GTNX4
	LXI	H,GREC 	;GO UP A LEVEL
	MVI	B,3
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	CALL	GREAD
	CALL	SETPT
	JMP	GTNX2
GTNX3:	LXI	H,N    	;LEAVE A TRAIL
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC
	MVI	B,3
	CALL	PUSHT
	LXI	H,GREC
	LXI	D,GRCC1
	CALL	SETD
	CALL	GREAD
	XRA	A
	STA	N
	CALL	SETPT	;SET PTR AT FIRST ENTRY
	JMP	GTNX1
GTNX4:	MVI	A,FALSE	;NO MORE
	STA	RESUL
	RET	
GTNX5:	MVI	A,TRUE
	STA	RESUL
	LXI	H,N
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC
	MVI	B,3
	CALL	PUSHT
	RET	
;*
;*
GINSE:			;INSERT A GLOBAL VALUE
	CALL	SSCHK
	LHLD	PTR2
	SHLD	PTR1
	LHLD	PTR4
	XCHG	
	LHLD	PTR1
	DAD	D
	SHLD	PTR1
	LXI	D,BLKSH
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JC	E8
	LXI	H,GREC 	;RETRIEVE LOCATION
	MVI	B,3
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	CALL	GREAD
	CALL	SETPT	;MOVE PTR TO INSERT PLACE
	LHLD	BSIZE	;PTR1 IS SIZE USED IN BLOCK
	SHLD	PTR1
	LHLD	PTR2	;ADD ON NEW ENTRY SIZE -- NAME + SUBS
	XCHG	
	LHLD	PTR1
	DAD	D
	SHLD	PTR1
	LHLD	PTR4
	XCHG	
	LHLD	PTR1
	DAD	D
	LXI	D,OVRHD	;ADD ON OVERHEAD -- SIZE + PTRS
	DAD	D
	SHLD	PTR1
	LXI	D,BLKSZ	;WILL IT FIT?
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	GINS1
	CALL	SPLIT	;NO, SO SPLIT NODE
	RET	
GINS1:	CALL	SETGV	;SET GLOBAL VALUE
	MVI	A,FALSE
	STA	PASSU
	RET	
;*
;*
GLBCL:			;CLOSE GLOBAL FILE
	CALL	SSCHK
	LDA	GLOPN
	CPI	1
	JNZ	GLB2
	XRA	A
	STA	BUFNO
GLB0:	LDA	BUFNO
	STA	IT
	CALL	SETGL
	LHLD	GLDRT
	MOV	A,M
	ORA	A
	JZ	GLB1
	LXI	D,GREC
	LHLD	GLBNO
	XCHG	
	CALL	SETD
	CALL	GWRIT
GLB1:	LHLD	GLDRT
	MVI	M,0
	LHLD	GLBNO
	LXI	D,NIL
	CALL	SETD
	LXI	H,BUFNO
	INR	M
	LDA	BUFNO
	LXI	H,NGBUF
	CMP	M
	JNZ	GLB0
GLB2:	RET	
;*
;*
GLKIL:			;KILL A GLOBAL VARIABLE
	CALL	SSCHK
	MVI	A,TRUE
	STA	FRMKL
	LXI	H,GRCY
	LXI	D,NIL
	CALL	SETD
	LXI	H,GREC
	MVI	B,3
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	LHLD	PTR	;SAVE ENTRY START
	LXI	B,-(GVLEN)
	DAD	B
	SHLD	TPP
	LXI	D,NIL	;SEE IF AT LEAF
	CALL	JDEN
	JZ	GLKL1
	CALL	DEL  	;NOT ON LEAF
	JMP	GLKL3
GLKL1:	CALL	SQUAS
	MVI	A,TRUE
	STA	UF
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	LXI	H,BLKS2
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JC	GLKL3
	MVI	A,FALSE
	STA	UF
GLKL3:	LXI	H,ROOT
	LXI	D,GREC
	CALL	JDEN
	JZ	GLKL4
	LDA	UF
	CPI	TRUE
	JNZ	GLKL4
	CALL	UNDER
	JMP	GLKL3
GLKL4:	LDA	UF
	CPI	TRUE
	JNZ	GLKL5
	CALL	GREAD
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	LXI	D,NULL
	CALL	JPEN
	JNZ	GLKL5
	LHLD	PTR	;DEALLOCATE ROOT
	LXI	D,PTRLN+PTRLN
	DAD	D
	INX	H
	SHLD	PTR
	LXI	D,GRCX
	XCHG	
	CALL	SETD
	CALL	DEALL
	LXI	H,ROOT
	LXI	D,GRCX
	CALL	SETD
	LXI	H,GREC	;NOW GET FIRST BLOCK (MAP)
	LXI	D,GZERO
	CALL	SETD
	CALL	GREAD
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	LXI	D,ROOT
	CALL	SETD
	LHLD	GLDRT
	MVI	M,1
GLKL5:	LHLD	TOP
	SHLD	TOS
	RET	
;*
;*
GLSET:			;SET GLOBAL VARIABLE
	CALL	SSCHK
	MVI	A,FALSE
	STA	FRMKL
	LHLD	TOS
	SHLD	TRAIL
	LDA	RESUL
	CPI	FALSE
	JZ	GLST1
GLST0:	CALL	SQUAS	;DELETE ENTRY IF SAME
	MVI	A,TRUE
	STA	PASSU
	JMP	GLST2
GLST1:	LXI	H,GRCX
	LXI	D,NIL
	CALL	SETD
GLST2:	LXI	H,TSTAK
	SHLD	USTAK
GLSTA:	LDA	PASSU
	CPI	FALSE
	JZ	GLST3
	LXI	H,GREC
	LXI	D,ROOT
	CALL	JDEN
	JZ	GLST3
	CALL	GINSE
	JMP	GLSTA
GLST3:	LDA	PASSU
	CPI	FALSE
	JZ	GLST4
	XRA	A	;ASSUME CAME FROM FIRST HALF
	STA	I9
	LXI	H,GRCC1
	LXI	D,ROOT
	CALL	JDEN
	JZ	GLST5
	MVI	A,1
	STA	I9
GLST5:	LXI	H,GRCC1
	LXI	D,ROOT
	CALL	SETD
	CALL	ALLOC
	CALL	FNDOL
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	LXI	H,ROOT
	LXI	D,GREC
	CALL	SETD
	LHLD	USTAK
	LDA	I9
	MOV	M,A
	INX	H
	SHLD	USTAK
	LXI	D,ROOT
	CALL	SETD
	LHLD	USTAK
	LXI	D,GVLEN
	DAD	D
	SHLD	USTAK
	LHLD	PTR
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	MVI	M,0
	INX	H
	SHLD	PTR
	LXI	D,GRCC1
	CALL	SETD
	LHLD	PTR
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	CALL	SETGV
	LXI	H,GREC	;NOW GET FIRST BLOCK (MAP)
	LXI	D,GZERO
	CALL	SETD
	CALL	GREAD
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	LXI	D,ROOT
	CALL	SETD
	LHLD	GLDRT
	MVI	M,1
GLST4:	RET	
;*
;*
GREAD:			;READ IN GREC'TH BLOCK
	CALL	SSCHK
	CALL	FNDRE	;SEE IF ALREADY AROUND
	LDA	RESUL
	CPI	1
	JZ	GRE1
	CALL	FNDOL	;FIND PLACE TO READ TO
	CALL	GREED	;READ IT
	LHLD	GLDRT
	MVI	M,0
	RET	
GRE1:	CALL	SETGL	;SET GLOBAL POINTERS
	CALL	UPDRE
	RET	
;*
;*
KEYCM:			;KEY COMPARISON
	CALL	SSCHK
	LXI	H,PTR3 	;SAVE STARTING POINTS
	MVI	B,2
	CALL	PUSHT
	LXI	H,PTR
	MVI	B,2
	CALL	PUSHT
	LXI	H,PTR4
	MVI	B,2
	CALL	PUSHT
	LHLD	PTR	;SET PTR5 FOR COMPARE ROUTINE
	SHLD	PTR5
	LHLD	PTR3	;SET PTR4 FOR COMPARE ROUTINE
	SHLD	PTR4
	CALL	COMPA	;COMPARE NAMES
	MVI	A,FALSE
	STA	RESUL
	LDA	CASE
	CPI	2
	JNZ	KEY9
	MVI	A,TRUE
	STA	RESUL
	LHLD	PTR5 	;PAST DELIMITER
	INX	H
	MOV	A,M	;GET NUMBER OF SUBS
	STA	I6
	INX	H	;PAST SUB COUNT
	SHLD	PTR5 
	LHLD	PTR4 	;SAME FOR PTR4
	INX	H
	SHLD	PTR4 
	INX	H
	SHLD	PTR4
KEY1:	LDA	I5
	ORA	A
	JZ	KEY7
	LDA	I6
	ORA	A
	JZ	KEY8
	LHLD	PTR5
	SHLD	LAST
	CALL	COMPA	;COMPARE SUBS
	LDA	CASE
	CPI	2
	JNZ	KEY9
	LHLD	PTR4 	;MOVE PAST DELIMITERS
	INX	H
	SHLD	PTR4 
	LHLD	PTR5
	INX	H
	SHLD	PTR5
	LXI	H,I5
	DCR	M
	LXI	H,I6
	DCR	M
	JMP	KEY1
KEY7:	LDA	I6
	ORA	A
	JZ	KEY9
	MVI	A,1
	STA	CASE
	JMP	KEY9
KEY8:	MVI	A,3
	STA	CASE
KEY9:	LXI	H,PTR4 	;RESTORE POINTERS
	MVI	B,2
	CALL	POPIT
	LXI	H,PTR
	MVI	B,2
	CALL	POPIT
	LXI	H,PTR3
	MVI	B,2
	CALL	POPIT
	RET	
;*
;*
LGLOB:			;LIST GLOBAL NAMES
	CALL	SSCHK
	LDA	GLBDR
	STA	DRIVE
	XRA	A
	STA	FCBTY
	LDA	GLOPN
	CPI	1
	JZ	LGL0
	CALL	FOPEN	;OPEN GLOBAL FILE
	MVI	A,1
	STA	GLOPN
	CALL	RDROO	;READ IN GLOBAL MAP
LGL0:	CALL	GETFI
	LDA	RESUL
	CPI	FALSE
	JZ	LGL5
LGL1:	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN+PTRLN+GVLEN
	DAD	D
	INX	H
	SHLD	PTR
LGL2:	LHLD	PTR
	SHLD	SPTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	MVI	A,BLANK
	CALL	CPUSH
	MVI	A,BLANK
	CALL	CPUSH
	LHLD	TOS
	SHLD	NMPTR
	XRA	A
	STA	SLENG
	LXI	H,VAR
	SHLD	PTR1
LGL3:	LHLD	PTR
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR
	MOV	A,M
	LHLD	PTR1
	MOV	M,A
	LHLD	PTR
	INX	H
	SHLD	PTR
	LXI	H,SLENG
	INR	M
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	LHLD	PTR
	MOV	A,M
	CPI	DELIM
	JNZ	LGL3
	LHLD	PTR1
	MVI	M,DELIM
LGL4:	LDA	SLENG
	ADI	2
	STA	IT
	LXI	H,IT
	MVI	B,1
	CALL	PUSHT
	MVI	A,3
	CALL	CPUSH
	CALL	AC54
	CALL	AC24
	LHLD	SPTR
	SHLD	PTR
LGL45:	MVI	A,TRUE
	STA	RESUL
	CALL	GETNE
	LDA	RESUL
	CPI	FALSE
	JZ	LGL5
	LXI	H,VAR
	SHLD	PTR4
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR5
	CALL	COMPA
	LDA	CASE
	CPI	2
	JZ	LGL45
	JMP	LGL2
LGL5:	RET	
;*
;*
MERGL:			;MERGE WITH PAGE TO LEFT
	CALL	SSCHK
	LXI	H,GREC
	LXI	D,GRECA
	CALL	SETD
	CALL	GREAD	;MAKE UNDERFLOW CURRENT NODE
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN+PTRLN
	DAD	D
	SHLD	PTR3
	INX	H	;PTR TO DOWN PTR
	SHLD	PTR3 
	LXI	D,GRCX
	XCHG	
	CALL	SETD
	LXI	H,GREC
	LXI	D,GRECB
	CALL	SETD
	CALL	GREAD	;MAKE LEFT PAGE CURRENT
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	PTR
	DAD	D
	LXI	D,PTRLN+PTRLN+GVLEN
	DAD	D
	SHLD	PTR
	INX	H	;PTR IS AT END
	SHLD	PTR  
	CALL	SETGV	;SET ANCESTOR GUY IN B
	LHLD	PTR3
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	LHLD	GLBUF	;MOVE PTR1 TO END OF B
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR1
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	XCHG	
	LHLD	PTR1
	DAD	D
	LXI	D,PTRLN+PTRLN+GVLEN
	DAD	D
	SHLD	PTR1
	INX	H	;PTR1 AT END
	SHLD	PTR1 
	CALL	MOVAL	;MOVE A TO END OF B
	LHLD	PTR1
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	GLDRT
	MVI	M,1
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	LHLD	BSIZE	;SET NEW SIZE
	XCHG	
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	CALL	FINDM	;GET MIDDLE PTRS FOR B
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LHLD	PTR1	;SET MIDDLE OFFSET
	XCHG	
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LDA	N
	MOV	M,A
	LXI	H,GREC
	LXI	D,GRECA
	CALL	SETD
	CALL	GREAD
	CALL	DEALL	;RETURN NODE A TO SYSTEM
	LXI	H,GREC
	LXI	D,GRECC
	CALL	SETD
	CALL	GREAD
	LDA	CN
	STA	N
	CALL	SETPT
	CALL	SQUAS
	RET	
;*
;*
MERGR:			;MERGE WITH PAGE ON RIGHT
	CALL	SSCHK
	LXI	H,GREC
	LXI	D,GRECB
	CALL	SETD
	CALL	GREAD	;GET PAGE ON RIGHT
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN+PTRLN+GVLEN
	DAD	D
	SHLD	PTR
	INX	H	;PTR TO START OF "B"
	SHLD	PTR  
	LXI	H,GREC
	LXI	D,GRECA
	CALL	SETD
	CALL	GREAD
	LHLD	GLBUF	;GET PAGE "A"
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR1
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	LHLD	PTR1
	LXI	D,PTRLN+PTRLN+GVLEN
	DAD	D
	INX	H
	SHLD	PTR1
	LHLD	BSIZE	;PTR1 TO END OF "A"
	XCHG	
	LHLD	PTR1
	DAD	D
	SHLD	PTR1
	CALL	MOVAL	;MOVE "B" TO "A"
	LHLD	PTR1
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	GLDRT
	MVI	M,1
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	LHLD	BSIZE	;SET NEW SIZE FOR A
	XCHG	
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	CALL	FINDM
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LHLD	PTR1
	XCHG	
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LDA	N
	MOV	M,A
	LXI	H,GREC
	LXI	D,GRECB
	CALL	SETD
	CALL	GREAD
	CALL	DEALL	;RETURN B TO SYSTEM
	LXI	H,GREC
	LXI	D,GRECC
	CALL	SETD
	CALL	GREAD
	LDA	CN
	STA	N
	CALL	SETPT
	CALL	SQUAS
	RET	
;*
;*
MOVAL:			;MOVE ALL OF NODE FROM PTR TO PTR1
	CALL	SSCHK
MOVA1:	LHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	TPP
	LXI	D,NULL
	CALL	JPEN
	JZ	MOVA2
	LHLD	TPP
	LXI	D,PTRLN
	DAD	D
	SHLD	TPP
	CALL	MOVEN
	JMP	MOVA1
MOVA2:	RET	
;*
;*
MOVEN:			;MOVE ENTRY FROM PTR TO PTR1
	CALL	SSCHK
MOVE1:	LHLD	PTR	;SET NAME AND SUBS
	MOV	A,M
	LHLD	PTR1
	MOV	M,A
	INX	H
	SHLD	PTR1
	LHLD	PTR
	INX	H
	SHLD	PTR
	LHLD	BSIZE
	INX	H
	SHLD	BSIZE
	LHLD	TPP
	DCX	H
	SHLD	TPP
	LXI	D,NULL
	CALL	JPEN
	JNZ	MOVE1
	CALL	VALSZ
	LHLD	TPP
	LXI	D,GVLEN
	DAD	D
	SHLD	TPP
MOVE2:	LHLD	PTR	;SET VALUE AND TYPE
	MOV	A,M
	LHLD	PTR1
	MOV	M,A
	INX	H
	SHLD	PTR1
	LHLD	PTR
	INX	H
	SHLD	PTR
	LHLD	BSIZE
	INX	H
	SHLD	BSIZE
	LHLD	TPP
	DCX	H
	SHLD	TPP
	LXI	D,NULL
	CALL	JPEN
	JNZ	MOVE2
	RET	
;*
;*
MOVSU:			;MOVE SUBS FROM STACK TO NAKED PLACE
	CALL	SSCHK
MOVS0:	LHLD	NPTR
	SHLD	NLAST
MOVS1:	LHLD	TPP	;MOVE SUBS TO NAKED PLACE
	MOV	A,M
	STA	IT
	LHLD	NPTR
	MOV	M,A
	INX	H
	SHLD	NPTR
	LXI	D,VAR
	CALL	JPEN
	JZ	E15
	LHLD	TPP
	INX	H
	SHLD	TPP
	LDA	IT
	CPI	DELIM
	JNZ	MOVS1
MOVS2:	LXI	H,NSUBS
	INR	M
	LXI	H,I5
	DCR	M
	LDA	I5
	ORA	A
	JNZ	MOVS0
	LHLD	NPTR
	SHLD	NSIZE
	LXI	D,NREF	;GET SIZE OF NAKED ENTRYE
	CALL	PSUB
	SHLD	NSIZE
	LXI	H,NREF
	LDA	NMSZ
	MOV	C,A
	MVI	B,0
	DAD	B
	SHLD	TPP
	LDA	NSUBS	;SET # OF SUBS
	MOV	M,A
	RET	
;*
;*         
RDROO:			;READ IN FIRST MAP BLOCK AND GET ROOT
	CALL	SSCHK
	LXI	H,GREC
	LXI	D,GZERO
	CALL	SETD
	CALL	GREAD	;READ IN FIRST BLOCK
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	LXI	D,ROOT	;GET VALUE OF ROOT
	XCHG	
	CALL	SETD
	LHLD	PTR
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	MOV	A,M	;GET SIZE OF MAP
	STA	MAPSZ
	RET	
;*
;*
SAVKE:			;SAVE KEY AND VALUE ON STACK
	CALL	SSCHK
	LXI	H,GRCY
	LXI	D,ROOT
	CALL	JDEN
	JZ	SAVK0
	LXI	H,GRCC3
	MVI	B,3
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	LDA	A47
	ORA	A
	JZ	SAVK0
	LHLD	TOS
	SHLD	TRAIL
SAVK0:	LHLD	PTR	;SET SIZE OF NAME AND SUBS
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PPTR2
	SHLD	TPP
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LHLD	TOS	;SAVE NAME START
	SHLD	SNMPT
SAVK1:	LHLD	PTR  	;SAVE NAME AND SUBS ON STACK
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR
	INX	H
	SHLD	PTR
	LHLD	TPP
	DCX	H
	SHLD	TPP
	LXI	D,NULL
	CALL	JPEN
	JNZ	SAVK1
	LHLD	PTR
	MOV	A,M
	STA	SST
	CPI	3
	JNZ	SAVK2
	INX	H
	SHLD	TPP
	MOV	A,M	;GET STRING LENGTH
	STA	SSLEN
SAVK2:	CALL	VALSZ	;GET SIZE OF VALUE
	LHLD	TPP	;SAVE VALUE SIZE
	SHLD	PPTR4
	LHLD	TOS	;SAVE VALUE START
	SHLD	SVLPT
SAVK3:	LHLD	PTR  	;SAVE VALUE AND TYPE
	MVI	B,1
	CALL	PUSHT
	LHLD	PTR
	INX	H
	SHLD	PTR
	LHLD	TPP
	DCX	H
	SHLD	TPP
	LXI	D,NULL
	CALL	JPEN
	JNZ	SAVK3
	LXI	D,GRCZ	;SAVE DOWN PTR
	LHLD	PTR
	XCHG	
	CALL	SETD
	LHLD	PTR
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	LHLD	SVLPT
	INX	H
	SHLD	SVLPT
	LXI	H,GRCY
	LXI	D,ROOT
	CALL	JDEN
	JZ	SAVK4
	LXI	H,N
	MVI	B,1
	CALL	PUSHT
	LXI	H,GRCC3
	MVI	B,3
	CALL	PUSHT
SAVK4:	RET	
;*
;*
;*
;*
SETGL:			;SET GLOBAL BUFFER POINTERS
	LHLD	GLBTA	;TPP TO START OF GLOBAL TABLE
	SHLD	TPP
SETG1:	LDA	IT
	ORA	A
	JZ	SETG2
	LHLD	TPP	;PTR TO NEXT ENTRY
	LXI	D,GBTSZ
	DAD	D
	SHLD	TPP
	LXI	H,IT
	DCR	M
	JMP	SETG1
SETG2:	LHLD	TPP	;SET BLOCK NUMBER PTR
	SHLD	GLBNO
	LXI	D,GVLEN
	DAD	D
	SHLD	TPP
	SHLD	GLAGE	;SET BUFFER AGE PTR
	INX	H
	SHLD	TPP
	SHLD	GLDRT	;SET BUFFER DIRTY PTR
	INX	H
	SHLD	TPP
	SHLD	GLBUF	;SET BUFFER START PTR
	RET	
;*
;*
SETGV:			;SET GLOBAL VARIABLE
	CALL	SSCHK
	LHLD	PTR
	SHLD	PTR1
STGV1:	LHLD	PTR	;AT END?
	MOV	E,M
	INX	H
	MOV	D,M
	LXI	H,NULL
	CALL	JPEN
	JZ	STGV2
	LHLD	PTR	;SKIP NAME AND SUBS
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	PTR
	DAD	D
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	CALL	VALSZ
	LHLD	TPP	;PTR PAST VALUE
	XCHG	
	LHLD	PTR
	DAD	D
	LXI	D,GVLEN	;PTR PAST DOWN PTR
	DAD	D
	SHLD	PTR
	JMP	STGV1
STGV2:	LHLD	PTR
	SHLD	TPP
	LHLD	PTR2	;MOVE OVER NAME AND SUBS
	XCHG	
	LHLD	PTR
	DAD	D
	SHLD	PTR
	LHLD	PTR4	;MOVE OVER VALUE SIZE
	XCHG	
	LHLD	PTR
	DAD	D
	LXI	D,PTRLN+GVLEN	;PTR AT NEW END
	DAD	D
	SHLD	PTR
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	DCX	H
	SHLD	PTR
STGV3:	LHLD	TPP	;MOVE EVERYTHING AFTER PTR
	XCHG	
	LHLD	PTR1
	CALL	JPEN
	JZ	STGV4
	LHLD	TPP
	DCX	H
	SHLD	TPP
	MOV	A,M
	LHLD	PTR
	MOV	M,A
	DCX	H
	SHLD	PTR
	JMP	STGV3
STGV4:	LHLD	PTR2	;SET SIZE OF NAME AND SUBS
	XCHG	
	LHLD	PTR1
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR1
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR1
	LHLD	PTR2
	SHLD	TPP
	LHLD	NMPTR
	SHLD	BASE
STGV5:	LHLD	NMPTR	;SET NAME AND SUBS
	MOV	A,M
	LHLD	PTR1
	MOV	M,A
	INX	H
	SHLD	PTR1
	LHLD	NMPTR
	INX	H
	SHLD	NMPTR
	LHLD	TPP
	DCX	H
	SHLD	TPP
	LXI	D,NULL
	CALL	JPEN
	JNZ	STGV5
	LHLD	PTR1	;SET TYPE
	LDA	ST
	MOV	M,A
	INX	H
	SHLD	PTR1
	LHLD	PTR4
	SHLD	TPP
	CPI	3
	JNZ	STGV6
	LDA	A47
	ORA	A
	JZ	STGV6
	LHLD	PTR1	;SET STRING LENGTH
	LDA	SLENG
	MOV	M,A
	INX	H
	SHLD	PTR1
	LHLD	TPP
	DCX	H
	SHLD	TPP
STGV6:	LHLD	TPP
	DCX	H
	SHLD	TPP
STGV7:	LHLD	TPP
	LXI	D,NULL
	CALL	JPEN
	JZ	STGV8
	LHLD	VLPTR	;SET VALUE
	MOV	A,M
	LHLD	PTR1
	MOV	M,A
	INX	H
	SHLD	PTR1
	LHLD	VLPTR
	INX	H
	SHLD	VLPTR
	LHLD	TPP
	DCX	H
	SHLD	TPP
	JMP	STGV7
STGV8:	LHLD	PTR1	;SET DOWN PTR
	LXI	D,GRCX
	CALL	SETD
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	LHLD	PTR2	;ADD ON NAME AND SUBS
	XCHG	
	LHLD	BSIZE
	DAD	D
	SHLD	BSIZE
	LHLD	PTR4	;ADD ON VALUE SIZE
	XCHG	
	LHLD	BSIZE
	DAD	D
	LXI	D,PTRLN+GVLEN
	DAD	D
	SHLD	BSIZE
	XCHG	
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	CALL	FINDM	;FIND MIDDLE ENTRY
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LHLD	PTR1	;SET OFFSET TO MIDDLE
	XCHG	
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LDA	N
	MOV	M,A
	LHLD	GLDRT
	MVI	M,1
	RET	
;*
;*
SETPT:			;MOVE PTR TO I'TH PLACE
	CALL	SSCHK
	LDA	N
	STA	I4
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	LHLD	PTR
	LXI	D,PTRLN+PTRLN+GVLEN
	DAD	D
	SHLD	PTR
	INX	H	;PTR TO FIRST ITEM
	SHLD	PTR  
SETP1:	LDA	I4
	ORA	A
	JZ	SETP2
	LHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	PTR
	DAD	D
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	CALL	VALSZ
	LHLD	TPP	;PTR PAST VALUE
	XCHG	
	LHLD	PTR
	DAD	D
	LXI	D,GVLEN	;PTR PAST DOWN PTR
	DAD	D
	SHLD	PTR
	LXI	H,I4
	DCR	M
	JMP	SETP1
SETP2:	RET	
;*
;*
SETSE:			;SET PTRS FROM TEMP PTRS IN SAVKEY
	LHLD	PPTR2
	SHLD	PTR2
	LHLD	PPTR4
	SHLD	PTR4
	LHLD	SNMPT
	SHLD	NMPTR
	LHLD	SVLPT
	SHLD	VLPTR
	LDA	SST
	STA	ST
	LDA	SSLEN
	STA	SLENG
	RET	
;*
;*
SHIFL:			;SHIFT ITEMS FROM LEFT PAGE TO UNDERFLOW
	CALL	SSCHK
	LXI	H,GREC
	LXI	D,GRECC
	CALL	SETD
	CALL	GREAD
	LDA	CN
	STA	N
	CALL	SETPT
	CALL	SQUAS
	LXI	H,GREC
	LXI	D,GRECA
	CALL	SETD
	CALL	GREAD
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN+PTRLN+SHTLN
	DAD	D
	SHLD	PTR
	LXI	D,GRCX
	XCHG	
	CALL	SETD
SHL0:	LXI	H,GREC
	LXI	D,GRECA
	CALL	SETD
	CALL	GREAD
	XRA	A
	STA	N
	CALL	SETPT	;PTR TO START IN "A" NODE
	CALL	SETGV	;SET NEW ENTRY IN "A" NODE
	LHLD	TRAIL
	SHLD	TOS
SHL1:	LXI	H,GREC
	LXI	D,GRECB
	CALL	SETD
	CALL	GREAD
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	CALL	G2END	;MOVE PTR TO END OF NODE "B"
	CALL	ENTSI
	LHLD	TPP
	XCHG	
	LHLD	BSIZE
	CALL	PSUB
	LXI	D,PTRLN+PTRLN+SHTLN+GVLEN
	DAD	D
	SHLD	BSIZE
	LXI	D,BLKS2
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	SHL2
	LHLD	PTR
	SHLD	SPTR
	LXI	H,N
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC
	MVI	B,3
	CALL	PUSHT
	CALL	SAVKE
	LXI	H,GREC
	MVI	B,3
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	LXI	H,GREC
	LXI	D,GRECA
	CALL	SETD
	CALL	GREAD	;MAKE UNDERFLOW PAGE CURRENT
	LHLD	GLBUF	;PTR2 TO START OF BUFFER
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR2
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR2
	LHLD	PPTR2	;ADD IN NAME AND SUB SIZE
	XCHG	
	LHLD	PTR2
	DAD	D
	SHLD	PTR2
	LHLD	PPTR4	;ADD IN VALUE SIZE
	XCHG	
	LHLD	PTR2
	DAD	D
	LXI	D,OVRHD
	DAD	D
	SHLD	PTR2
	LXI	D,BLKSZ	;SEE IF NEW ENTRY WILL FIT
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JC	SHL2
	LXI	H,GREC
	LXI	D,GRECB
	CALL	SETD
	CALL	GREAD	;MAKE PAGE TO LEFT CURRENT
	LHLD	SPTR
	SHLD	PTR
	CALL	SQUAS
	CALL	SETSE
	JMP	SHL0
SHL2:	LXI	H,GREC
	LXI	D,GRECB
	CALL	SETD
	CALL	GREAD
	CALL	G2END
	LXI	H,N
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC
	MVI	B,3
	CALL	PUSHT
	LHLD	PTR
	SHLD	SPTR
	CALL	SAVKE
	LXI	H,GREC
	MVI	B,3
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	LHLD	SPTR
	SHLD	PTR
	CALL	SQUAS
	LXI	H,GREC
	LXI	D,GRECA
	CALL	SETD
	CALL	GREAD
	XRA	A
	STA	N
	CALL	SETPT
	LHLD	PTR
	LXI	B,-(GVLEN)
	DAD	B
	SHLD	PTR
	LXI	D,GRCX	;SET IN SAVKEY
	CALL	SETD
	LXI	H,GRCX
	LXI	D,GRECA
	CALL	SETD
	MVI	A,TRUE
	STA	PASSU
	LXI	H,CN
	MVI	B,1
	CALL	PUSHT
	LXI	H,GRECC
	MVI	B,3
	CALL	PUSHT
	CALL	SETSE
	CALL	GLST2
	RET	
;*
;*
SHIFR:			;SHIFT ITEMS FROM RIGHT PAGE TO UNDERFLOW
	CALL	SSCHK
	LXI	H,GREC
	LXI	D,GRECC
	CALL	SETD
	CALL	GREAD
	LDA	CN
	STA	N
	CALL	SETPT
	CALL	SQUAS
	LXI	H,GREC
	LXI	D,GRECA
	CALL	SETD
	CALL	GREAD
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR1
	SHLD	PTRX
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	LHLD	PTR1
	LXI	D,PTRLN+PTRLN+GVLEN
	DAD	D
	SHLD	PTR1
	INX	H	;PTR1 AT FIRST ENTRY
	SHLD	PTR1 
	LHLD	BSIZE	;PTR1 AFTER LAST ENTRY
	XCHG	
	LHLD	PTR1
	DAD	D
	SHLD	PTR1
	LXI	H,GREC
	LXI	D,GRECB
	CALL	SETD
	CALL	GREAD
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	SBSIZ
	LHLD	PTR
	LXI	D,PTRLN+PTRLN+GVLEN
	DAD	D
	SHLD	PTR
	INX	H	;PTR AT FIRST ENTRY
	SHLD	PTR  
SHRT1:	CALL	ENTSI	;SET TPP TO ENTRY SIZE
	LHLD	BSIZE
	SHLD	PTR2
	LHLD	TPP	;GET PROPOSED NEW SIZE
	XCHG	
	LHLD	PTR2
	DAD	D
	LXI	D,OVRHD
	DAD	D
	SHLD	PTR2
	LXI	D,BLKSZ	;SEE IF IT FITS
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JC	SHRT2
	LHLD	TPP
	XCHG	
	LHLD	SBSIZ
	CALL	PSUB
	LXI	D,PTRLN+PTRLN+SHTLN+GVLEN
	DAD	D
	SHLD	SBSIZ
	LXI	D,BLKS2
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	SHRT2
	LHLD	PTR
	SHLD	SPTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN
	DAD	D
	SHLD	TPP
	CALL	MOVEN	;MOVE ENTRY FROM B TO A
	LHLD	PTR1
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	SPTR
	SHLD	PTR
	LXI	H,PTR1
	MVI	B,2
	CALL	PUSHT
	LXI	H,BSIZE
	MVI	B,2
	CALL	PUSHT
	CALL	SQUAS
	LXI	H,BSIZE
	MVI	B,2
	CALL	POPIT
	LXI	H,PTR1
	MVI	B,2
	CALL	POPIT
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	SPTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	SBSIZ
	JMP	SHRT1
SHRT2:	LHLD	BSIZE
	XCHG	
	LHLD	PTRX
	MOV	M,E
	INX	H
	MOV	M,D
	LXI	H,N
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC
	MVI	B,3
	CALL	PUSHT
	LHLD	PTR
	SHLD	SPTR
	CALL	SAVKE
	LHLD	SPTR
	SHLD	PTR
	LXI	H,GREC
	MVI	B,3
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	CALL	SQUAS
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN+PTRLN+SHTLN
	DAD	D
	SHLD	PTR
	LXI	D,GRCX
	CALL	SETD
	LXI	H,GRCX
	LXI	D,GRECB
	CALL	SETD
	MVI	A,TRUE
	STA	PASSU
	LXI	H,CN
	MVI	B,1
	CALL	PUSHT
	LXI	H,GRECC
	MVI	B,3
	CALL	PUSHT
	CALL	SETSE
	CALL	GLST2
	RET	
;*
;*
SNAKD:			;SET NAKED REF NAME
	CALL	SSCHK
	LDA	NLENG
	STA	COUNT
	STA	NMSZ
	LXI	H,COUNT
	INR	M
	LHLD	NAME
	XCHG	
	LXI	H,NREF
	LDA	COUNT
	MOV	B,A
	CALL	MOVE
	XRA	A
	STA	NSUBS
	LXI	H,NREF
	SHLD	NLAST
	LDA	COUNT
	MOV	L,A
	MVI	H,0
	SHLD	NSIZE
	XCHG	
	LHLD	NLAST
	DAD	D
	SHLD	NLAST
	SHLD	NPTR
	XRA	A
	STA	NR
	RET	
;*
;*
SPLIT:			;SPLIT BUFFER AND PASS UP MIDDLE ENTRY
	CALL	SSCHK
	MVI	A,TRUE
	STA	SPLT
	LXI	H,GRCY
	LXI	D,GREC
	CALL	SETD
	LHLD	PTR	;SAVE ENTRY POINT
	SHLD	PTR7
	LDA	N
	STA	INN
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR8
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	SBSIZ
	LHLD	PTR8	;PTR TO MIDDLE POINTER
	LXI	D,PTRLN+PTRLN+SHTLN+GVLEN
	DAD	D
	SHLD	PTR8
	LHLD	SBSIZ	;PTR8 TO END OF USED SPACE
	XCHG	
	LHLD	PTR8
	DAD	D
	SHLD	PTR8
	LXI	H,GRCC1	;GRCC1 WILL BE NODE INSERTING INTO
	LXI	D,GREC
	CALL	SETD
	LXI	H,GRCC2	;GRCC2 IS THE OLD NODE
	LXI	D,GREC
	CALL	SETD
	CALL	ALLOC	;GREC IS THE NEW NODE
	CALL	FNDOL	;GET BUFFER SPACE
	LXI	H,GRECA
	LXI	D,GREC
	CALL	SETD
	LDA	A47
	CPI	1
	JZ	SPTC
	LXI	H,GRCY	;IF AT ROOT, IT'S OK
	LXI	D,ROOT
	CALL	JDEN
	JZ	SPTC
SPTE:	LHLD	TRAIL	;GET START OF ENTRY
	SHLD	PTRA
	SHLD	PTRB
	LHLD	PTRA	;PTRA TO ANCESTOR BLOCK
	LXI	B,-(GVLEN)
	DAD	B
	SHLD	PTRA
	LXI	D,TGREC	;SAVE IT
	XCHG	
	CALL	SETD
	LHLD	PTRA 	;PTRA TO LOCATION IN BLOCK
	DCX	H
	SHLD	PTRA 
	MOV	A,M	;SAVE IT
	STA	TN
SPTA:	LHLD	PTRB
	XCHG	
	LHLD	TOS
	CALL	JPEN
	JZ	SPTB
	LHLD	PTRB	;MOVE TO  ITEM DOWN
	MOV	A,M
	LHLD	PTRA
	MOV	M,A
	INX	H
	SHLD	PTRA
	LHLD	PTRB
	INX	H
	SHLD	PTRB
	JMP	SPTA
SPTB:	LHLD	PTRA	;SHIFT LOCATION IN BLOCK AND
	LDA	TN
	MOV	M,A
	INX	H
	SHLD	PTRA
	LXI	D,TGREC	;ANCESTOR BLOCK TO TOS
	CALL	SETD
	LHLD	NMPTR	;ADJUST NMPTR AND
	LXI	B,-(GVLEN+SHTLN)
	DAD	B
	SHLD	NMPTR
	LHLD	VLPTR	;VLPTR
	LXI	B,-(GVLEN+SHTLN)
	DAD	B
	SHLD	VLPTR
	LHLD	TRAIL
	LXI	B,-(GVLEN+SHTLN)
	DAD	B
	SHLD	TRAIL
	LXI	H,TGREC
	LXI	D,ROOT
	CALL	JDEN
	JZ	SPTC
	LDA	FRMDE
	CPI	FALSE
	JZ	SPTC
	LXI	H,TGREC
	MVI	B,3
	CALL	POPIT
	LXI	H,TN
	MVI	B,1
	CALL	POPIT
	LXI	H,TGREC
	LXI	D,GRCY
	CALL	JDEN
	JNZ	SPTE
	MVI	A,FALSE
	STA	FRMKL
	JMP	SPTE
SPTC:	MVI	A,FALSE
	STA	FRMKL
	STA	FRMDE
	LXI	H,GREC
	LXI	D,GRCC2
	CALL	SETD
	CALL	GREAD	;MAKE SPLITTING NODE CURRENT
	LXI	H,PTR2
	MVI	B,2
	CALL	PUSHT
	LXI	H,PTR4
	MVI	B,2
	CALL	PUSHT
	CALL	G2END
	LXI	H,PTR4
	MVI	B,2
	CALL	POPIT
	LXI	H,PTR2
	MVI	B,2
	CALL	POPIT
	LDA	N	;WILL MAKE MALFORMED TREE
	CPI	1
	JZ	E8
	LDA	N
	ORA	A
	RAR		;N/2
	STA	N
	CALL	SETPT	;PUT PTR AT "MIDDLE"
	LHLD	PTR
	SHLD	PTR9
	XRA	A
	STA	I9
	LHLD	PTR7
	XCHG	
	LHLD	PTR
	CALL	JPEN
	JNZ	SPT0
	MVI	A,1	;PASSING NEW ENTRY UP
	STA	I9
	LXI	H,GRCZ	;FIRST DOWN PTR OF NEW BLOCK
	LXI	D,GRCX
	CALL	SETD
	JMP	SPT2
SPT0:	LHLD	PTR
	XCHG
	LHLD	PTR7
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	SPTZ
	LXI	H,GRCC1	;SET NODE INSERTING INTO
	LXI	D,GRECA
	CALL	SETD
	LDA	INN
	LXI	H,N
	SUB	M
	STA	INN
	LXI	H,INN
	DCR	M
	JMP	SPT1
SPTZ:	LXI	H,N	;BACK UP ONE ENTRY
	DCR	M
	CALL	SETPT
	LHLD	PTR	;PUT PTR9 THERE TOO
	SHLD	PTR9
SPT1:	CALL	SAVKE	;SAVE KEY ON STACK AND SET PTRS AND SIZES
	LHLD	PPTR2
	XCHG	
	LHLD	SBSIZ
	CALL	PSUB
	SHLD	SBSIZ
	LHLD	PPTR4
	XCHG	
	LHLD	SBSIZ
	CALL	PSUB
	LXI	B,-(GVLEN+PTRLN)
	DAD	B
	SHLD	SBSIZ
SPT2:	LHLD	USTAK	;SAVE OFFSET ON SPLIT STACK
	LDA	INN
	MOV	M,A
	INX	H
	SHLD	USTAK
	LXI	D,GRCC1
	CALL	SETD
	LHLD	USTAK
	LXI	D,GVLEN
	DAD	D
	SHLD	USTAK
	LHLD	PTR8	;CALCULATE BUFFER SIZES USED
	SHLD	LAST
	LHLD	PTR
	XCHG	
	LHLD	LAST
	CALL	PSUB
	SHLD	LAST
	XCHG	
	LHLD	SBSIZ
	CALL	PSUB
	SHLD	SBSIZ
	LXI	H,GREC
	LXI	D,GRECA
	CALL	SETD
	CALL	GREAD
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR1
	LHLD	LAST	;SET NEW NODE SIZE USED
	XCHG	
	LHLD	PTR1
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR1
	LXI	D,PTRLN+PTRLN
	DAD	D
	INX	H
	SHLD	PTR1
	LXI	D,GRCZ	;SET FIRST PTR
	CALL	SETD
	LHLD	PTR1
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR1
SPT3:	LHLD	PTR
	XCHG	
	LHLD	PTR7
	CALL	JPEN
	JNZ	SPT4
	LHLD	PTR1	;MOVE INSERT PLACE TO NEW NODE
	SHLD	PTR7
SPT4:	LHLD	PTR	;MOVE REST OF BLOCK TO NEW NODE
	XCHG	
	LHLD	PTR8
	CALL	JPEN
	JZ	SPT5
	LHLD	PTR
	MOV	A,M
	LHLD	PTR1
	MOV	M,A
	LHLD	PTR
	INX	H
	SHLD	PTR
	LHLD	PTR1
	INX	H
	SHLD	PTR1
	JMP	SPT3
SPT5:	LHLD	PTR1
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR9
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	LXI	H,GRCC3
	LXI	D,GREC
	CALL	SETD
	CALL	FINDM	;GET MIDDLE OF NEW NODE
	LHLD	GLDRT
	MVI	M,1
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LHLD	PTR1	;SET MIDDLE OFFSET
	XCHG	
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LDA	N
	MOV	M,A
	LXI	H,GREC
	LXI	D,GRCC2
	CALL	SETD
	CALL	GREAD	;MAKE OLD NODE CURRENT
	LHLD	GLDRT
	MVI	M,1
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	LHLD	SBSIZ	;SET SIZE
	XCHG	
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	CALL	FINDM
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LHLD	PTR1	;SET MIDDLE OFFSET
	XCHG	
	LHLD	PTR
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	PTR
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	LDA	N
	MOV	M,A
	LDA	I9
	CPI	1
	JZ	SPT6
	LXI	H,GREC	;GET NODE INSERTING IN
	LXI	D,GRCC1
	CALL	SETD
	CALL	GREAD
	LHLD	PTR7	;PUT PTR IN RIGHT PLACE
	SHLD	PTR
	CALL	SETGV	;SET NEW VALUE
	LDA	A47
	CPI	1
	JZ	SPT60
	LHLD	BASE	;GET BASE OF JUST SET VARIABLE
	SHLD	PTR1
	LHLD	VLPTR
	SHLD	PTR
	SHLD	TPP
	LHLD	BASE	;GET SIZE OF JUST SET VARIABLE
	XCHG	
	LHLD	TPP
	CALL	PSUB
	SHLD	TPP
SPT55:	LHLD	PTR	;SEE IF IT'S ALL MOVED
	XCHG	
	LHLD	TOS
	CALL	JPEN
	JZ	SPT57
	LHLD	PTR	;MOVE A CHARACTER
	MOV	A,M
	LHLD	PTR1
	MOV	M,A
	INX	H
	SHLD	PTR1
	LHLD	PTR
	INX	H
	SHLD	PTR
	JMP	SPT55
SPT57:	LDA	A47
	ORA	A
	JZ	SPT59
	LHLD	TPP	;ADJUST TRAIL PTR DOWN
	XCHG	
	LHLD	TRAIL
	CALL	PSUB
	SHLD	TRAIL
SPT59:	LHLD	TPP	;ADJUST SNMPT PTR DOWN
	XCHG	
	LHLD	SNMPT
	CALL	PSUB
	SHLD	SNMPT
	LHLD	TPP	;ADJUST SVLPT PTR DOWN
	XCHG	
	LHLD	SVLPT
	CALL	PSUB
	SHLD	SVLPT
	LHLD	PTR1	;SHIFT TOS DOWN
	SHLD	TOS
SPT60:	MVI	A,TRUE
	STA	PASSU
	CALL	SETSE
	XRA	A
	STA	A47
SPT6:	LXI	H,GRCX
	LXI	D,GRCC3
	CALL	SETD
	LXI	H,GREC
	LXI	D,GRCY
	CALL	SETD
	RET	
;*
;*
SQUAS:			;DELETE ENTRY POINTED TO BY PTR
	CALL	SSCHK
	LXI	H,PTR2
	MVI	B,2
	CALL	PUSHT
	LXI	H,PTR4
	MVI	B,2
	CALL	PUSHT
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR5
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	BSIZE
	LHLD	PTR5
	LXI	D,PTRLN+PTRLN+GVLEN
	DAD	D
	INX	H
	SHLD	PTR5
	LHLD	BSIZE	;PTR AT END
	XCHG	
	LHLD	PTR5
	DAD	D
	SHLD	PTR5
	LHLD	PTR
	SHLD	LAST
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR2
	XCHG	
	LHLD	PTR
	DAD	D
	LXI	D,PTRLN	;PTR AT TYPE
	DAD	D
	SHLD	PTR
	CALL	VALSZ
	LHLD	TPP
	SHLD	PTR4
	XCHG		;TO DOWN PTR
	LHLD	PTR
	DAD	D
	SHLD	PTR
	LXI	D,GRCX	;SAVE DOWN PTR
	XCHG	
	CALL	SETD
	LHLD	PTR
	LXI	D,GVLEN
	DAD	D
	SHLD	PTR
	LHLD	LAST
	SHLD	TPP
	LHLD	PTR2	;GET SIZE OF ENTRY DELETED
	XCHG	
	LHLD	PTR4
	DAD	D
	LXI	D,GVLEN+PTRLN
	DAD	D
	SHLD	PTR4
	LHLD	TPP
	SHLD	PTR2
SQ4:	LHLD	PTR5
	XCHG	
	LHLD	PTR
	CALL	JPEN
	JZ	SQ5
	LHLD	PTR	;SHIFT EVERYTHING DOWN
	MOV	A,M
	LHLD	LAST
	MOV	M,A
	INX	H
	SHLD	LAST
	LHLD	PTR
	INX	H
	SHLD	PTR
	JMP	SQ4
SQ5:	LHLD	LAST
	LXI	D,NULL
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	TPP
	LHLD	PTR4
	XCHG	
	LHLD	BSIZE
	CALL	PSUB
	SHLD	BSIZE
	XCHG	
	LHLD	TPP
	MOV	M,E
	INX	H
	MOV	M,D
	CALL	FINDM
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN
	DAD	D
	SHLD	TPP
	LHLD	PTR1
	XCHG	
	LHLD	TPP
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	TPP
	LXI	D,PTRLN
	DAD	D
	SHLD	TPP
	LDA	N
	MOV	M,A
	LHLD	PTR2
	SHLD	PTR
	LHLD	GLDRT
	MVI	M,1
	LXI	H,PTR4
	MVI	B,2
	CALL	POPIT
	LXI	H,PTR2 
	MVI	B,2
	CALL	POPIT
	RET	
;*
;*
UNDER:			;FIX UP NODE THAT'S TOO SMALL
	CALL	SSCHK
	MVI	A,FALSE
	STA	SPLT
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	SBSIZ
	LXI	H,GRECA	;SAVE UNDERFLOW PAGE
	LXI	D,GREC
	CALL	SETD
	XRA	A
	STA	I2
	LXI	H,GREC 	;GET PARENT
	MVI	B,3
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	LHLD	TOS
	SHLD	TRAIL
	LXI	H,GRECC	;SAVE PARENT PAGE
	LXI	D,GREC
	CALL	SETD
	LDA	N
	STA	CN
	CALL	GREAD
	CALL	SETPT	;MOVE TO PLACE
	LHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	LXI	H,NULL
	CALL	JPEN
	JNZ	UNDF0
	MVI	A,1
	STA	I2
	LXI	H,N
	DCR	M
	LXI	H,CN
	DCR	M
	CALL	SETPT
UNDF0:	LHLD	PTR
	SHLD	SPTR
	LXI	B,-(GVLEN)
	DAD	B
	SHLD	PTR2
	LXI	H,N
	MVI	B,1
	CALL	PUSHT
	LXI	H,GREC
	MVI	B,3
	CALL	PUSHT
	CALL	SAVKE
	LXI	H,GREC
	MVI	B,3
	CALL	POPIT
	LXI	H,N
	MVI	B,1
	CALL	POPIT
	LHLD	SPTR
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	PTR
	DAD	D
	LXI	D,PTRLN
	DAD	D
	SHLD	PTR
	CALL	VALSZ
	LHLD	TPP
	XCHG	
	LHLD	PTR
	DAD	D
	SHLD	PTR
	SHLD	PTR1	;SAVE PLACE
	LXI	D,GVLEN	;SKIP PAST ENTRY
	DAD	D
	SHLD	PTR
	XRA	A
	STA	I3
	LDA	I2
	ORA	A
	JNZ	UNDF1
	LXI	D,GRECB	;GET NODE TO RIGHT OF UNDERFLOW
	LHLD	PTR1
	XCHG	
	CALL	SETD
	JMP	UNDF2
UNDF1:	LXI	D,GRECB	;GET NODE TO LEFT OF UNDERFLOW
	LHLD	PTR2
	XCHG	
	CALL	SETD
	MVI	A,1	;IT'S THE LEFT NODE
	STA	I3
UNDF2:	LXI	H,GREC
	LXI	D,GRECB
	CALL	SETD
	CALL	GREAD	;READ SIBLING (RIGHT OR LEFT)
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	TPP
	SHLD	PTR1
	LHLD	SBSIZ
	XCHG	
	LHLD	TPP
	DAD	D
	LXI	D,OVRHD
	DAD	D
	SHLD	TPP
	CALL	SETSE
	LHLD	PTR2
	XCHG	
	LHLD	TPP
	DAD	D
	SHLD	TPP
	LHLD	PTR4
	XCHG	
	LHLD	TPP
	DAD	D
	SHLD	TPP
	XRA	A	;DO A MERGE
	STA	I2
	LXI	D,BLKSZ
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	UNDF3
	MVI	A,1	;DO A MOVE
	STA	I2
	LHLD	PTR1
	LXI	D,BLKS2
	XCHG
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	UNDF3
	MVI	A,FALSE
	STA	UF
	JMP	UNDF8
UNDF3:	LDA	I3	;DO LEFT
	CPI	1
	JZ	UNDF5
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	LXI	D,PTRLN+PTRLN
	DAD	D
	INX	H
	SHLD	PTR
	LXI	D,GRCX
	XCHG	
	CALL	SETD
	LXI	H,GREC
	LXI	D,GRECA
	CALL	SETD
	CALL	GREAD
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG	
	SHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	PTR
	DAD	D
	LXI	D,PTRLN+PTRLN+GVLEN+SHTLN
	DAD	D
	SHLD	PTR
	CALL	SETGV
	LHLD	TRAIL
	SHLD	TOS
	LDA	I2
	ORA	A
	JZ	UNDF4
	CALL	SHIFR
	JMP	UNDF7
UNDF4:	CALL	MERGR
	JMP	UNDF7
UNDF5:	LDA	I2
	ORA	A
	JZ	UNDF6
	CALL	SHIFL
	JMP	UNDF7
UNDF6:	CALL	MERGL
UNDF7:	LXI	H,GREC
	LXI	D,GRECC
	CALL	SETD
	CALL	GREAD
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	SHLD	PTR
	MVI	A,FALSE
	STA	UF
	LDA	SPLT
	CPI	TRUE
	JZ	UNDF8
	LHLD	PTR
	MOV	E,M
	INX	H
	MOV	D,M
	LXI	H,BLKS2
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	UNDF8
	MVI	A,TRUE
	STA	UF
	LHLD	TRAIL
	SHLD	TOS
	LXI	H,CN
	MVI	B,1
	CALL	PUSHT
	LXI	H,GRECC
	MVI	B,3
	CALL	PUSHT
	LHLD	TOS
	SHLD	TRAIL
	CALL	FIXTR
UNDF8:	RET	
;*
;*
UPDRE:			;UPDATE BUFFER AGES
	LHLD	GLAGE
	MOV	A,M
	STA	IT
	LHLD	GLBTA
	LXI	D,GVLEN
	DAD	D
	SHLD	TPP
	XRA	A
	STA	I1
UPDR1:	LHLD	TPP	;LEAVE ALONE
	LDA	IT
	CMP	M
	JC	$+6
	JNZ	UPDR3
	CMP	M	;UPDATE
	JNZ	UPDR2
	LDA	NGBUF
	MOV	M,A
UPDR2:	LHLD	TPP
	DCR	M
UPDR3:	LXI	H,I1
	INR	M
	LHLD	TPP	;MOVE TO NEXT ENTRY
	LXI	D,GBTSZ
	DAD	D
	SHLD	TPP
	LDA	I1
	LXI	H,NGBUF
	CMP	M
	JNZ	UPDR1
	RET	
;*
;*
VALSZ:			;GET SIZE OF VALUE
	LHLD	PTR
	SHLD	TPP
	MOV	A,M
	STA	I1
VAL2:	LDA	I1	;STRING
	CPI	3
	JNZ	VALA
VAL25:	LHLD	TPP
	INX	H
	SHLD	TPP
	MOV	A,M
	STA	I1
	MOV	L,A
	MVI	H,0
	INX	H
	SHLD	TPP
	JMP	VAL4
VALA:	LDA	I1
	CPI	7
	JZ	VAL25
	XRA	A
	STA	I1
VAL3:	LDA	I1
	MOV	L,A
	MVI	H,0
	SHLD	TPP
VAL4:	LHLD	TPP
	INX	H
	SHLD	TPP
	RET	
;*
;*        END OF TDL UTILITY ROUTINES
