title	'ram disk drivers for cp/m 3.0 for Jonos computers'
;
;	last update 8/24/83
;
true		equ	-1		;	
false		equ	not true	;
;
banked		equ	true	;
interrupt	equ	true	;if open door interrupt is used
;
	dseg			;may be in banked memory
;
;	disk dispatching tables
	public	?rmd1		;one 320K ram disk
;
;	variables containing parameters passed by bdos
	extrn	@adrv,@rdrv
	extrn	@dma,@trk,@sect
	extrn	@dbnk,@cbnk
;
;	system control block variables
	extrn	@ermde		;bdos error mode
	extrn	@cnt		;multi sector count	
;
;	utility routines in standard BIOS
	extrn	?wboot		;warm boot vector
	extrn	?pmsg		;print message @<HL> up to 0, saves <BC,DE>
	extrn	?pdec		;print binary number in <A> from 0 to 99
	extrn	?pderr		;print BIOS disk error header
	extrn	?conin,?cono	;console in and out
	extrn	?const		;get console status
	extrn	?bank		;select bank for use
;
;	port address equates
	maclib	ports		;
;
;	cp/m 3 disk definition macros
	maclib	cpm3		;
;
;	z80 macro library instruction definitions
	maclib	z80
;
;	common control characters
cr	equ	13		;
lf	equ	10		;
bell	equ	7		;
;
;	extended disk parameter headers (XPDHs)
;
;
;
	dw	rd$write	;write for ram disk
	dw	rd$read		;read for ram disk
	dw	rd$login	;login for ram disk
	dw	rd$init		;initialization ram disk
	db	0,0		;relative drive 4 (E:)
?rmd1	dph	0,dpbrd
;
;
	cseg			;DPB must be in common memmory
;
dpbrd	;320K
	dw	36		;128 byte sectors per track
	db	4		;block shift
	db	15		;block mask
	db	1		;extnt mask
	dw	159		;disk size
	dw	63		;directory max
	db	128		;alloc0
	db	0		;alloc1
	dw	8000h		;check size (high order bit set)
	dw	0		;offset track 0
	db	0,0		;physical sector size shift
;
	dseg
;
;	Disk I/O routines for Ram Disk, 320K
;
rd$init:
	;set up ram disk dir tracks
	xra	a	;set up ram disk address
	out	ladd	;write low address
	out	madd	;write middle address
	out	hadd	;write high address
	lxi	d,0800h	;clear 2k to 0e5h
	mvi	b,0e5h	;to erase the dir.
rdclear:
	mov	a,b	;get E5hex
	out	rdata	;output to ramdisk
	dcx	d	;lower count 
	mov	a,e	;test for zero
	ora	d	;
	jnz	rdclear	;loop till frist 2k of ram disk cleared
	ret		;
;
;
rd$login:
	ret			;this routine is called to determine
				;density. Ram Disk does not need this.
;
;
;
;
	cseg			;in common
;
;	ram disk i/o routines
;
rd$read:
	call	comp$add	;get and set address
	if	banked
	lda	@dbnk		;get bank # for transfer
	call	?bank		;select it
	;	inir			z80 block input instruction
	db	0edh		;
	db	0b2h		;
	xra	a		;select bank 0
	call	?bank
	else
	;	inir			z80 block input instruction
	db	0edh		;
	db	0b2h		;
	endif
	xra	a		;set no error for cp/m
	ret			;return
rd$write:
	call	comp$add	;get and set address
	if	banked
	lda	@dbnk		;get bank # for transfer
	call	?bank		;select it
	;	otir			z80 block output instruction
	db	0edh		;
	db	0b3h		;
	;
	xra	a		;select bank 0
	call	?bank
	else
	;	otir			z80 block output instruction
	db	0edh		;
	db	0b3h		;
	endif
	;
	xra	a		;set no error for cp/m
	ret			;return
;
	dseg			;not in common
;
comp$add:		;compute 20 bit address for ram disk
	lhld	@trk		;get track number
	mov	e,l		;put in de to work with
	mov	d,h		;
	dad	h		;*2
	dad	h		;*4
	xchg			;move partial product tp de
	dad	h		;*2
	dad	h		;*4
	dad	h		;*8
	dad	h		;*16
	dad	h		;*32
	dad	d		;add to get *36 product
	mvi	d,00h		;zero working register
	lda	@sect		;get sector number
	mov	e,a		;put in working reg.
	dad	d		;add to get offset in sectors
	mov	c,h		;shift c,h,l
	mov	h,l		;as a 24 bit vector
	mvi	l,00h		;(*256)
	;divide by 2 and out put to ram disk 
	mov	a,c		;high address
	rar			;/2
	mov	c,a		;
	mov	a,h		;
	rar			;/2, add borrow form carry 
	mov	h,a		;
	mov	a,l		;
	rar			;/2, add borrow form carry
	out	ladd		;output low address to ram disk
	mov	a,h		;get middle address
	out	madd		;out to ram disk
	mov	a,c		;get high address
	out	hadd		;out to ram disk
	lhld	@dma		;get address to readd/write data 
	mvi	b,80h		;move 128 byte at a time
	mvi	c,rdata		;point to ram disk data port
	mvi	a,01h		;set mutlio count 1
	sta	@cnt		;store it
	ret

	end
 	
