 

*****************************************************************
*								* 
*    MORROW 68K SYSTEM DMA I/O TEST REV 0.			* 
*								*
*    initial coding:  5/3/84 -bjg-				*
*      								* 
*****************************************************************



ioaddr	=	$ff0000			* compupro i/o address space


***********************************
*  Compupro interfacer IV equates *
***********************************

sio	=	ioaddr+$10		* interfacer base address
siostat	=	sio+$1			* uart status
siodat  =	sio			* uart data 
select	=	sio+$7			* group select port
console =	7			* interface left port

**********************
*   mult i/o equates *
**********************

base	=	ioaddr+$48		* standard base address
grpctl	=	base+$7			* select port
dll	=	base			* divisor latch lsb
dlm	=	base+$1			* divisor latch msb
ier	=	base+$1			* interrupt enable register
lcr	=	base+$3			* line control register
mcr	=	base+$4			* modem control register
lsr	=	base+$5			* line status register 
rbr	=	base			* receive buffer register
thr	=	base			* trasnmitter holding register

dlab	=	$80			* divisor latch access bit
thre	=	$20			* transmitter hold reg empty status
dr	=	$1			* received data ready status

********************
* SIO4/DMA equates *
********************

* sio port assignments

sbase	=	ioaddr+$20 		* SIO4 base I/O address

dmaddrl =	sbase			* low byte dma address
dmaddrh	=	sbase+$1		* high byte dma address
dmaddre =	sbase+$2		* extended byte of dma address
recntrl =	sbase+$3		* receiver control port
lcount	=	sbase+$4		* low byte of dma  count	
hcount  =       sbase+$5		* high byte of dma count
enable  =	sbase+$6		* start / stop enable
dmacntl =	sbase+$7		* dma control and status
sdata	=	sbase+$8		* uart data port
sstatus =	sbase+$9		* uart status port
smode	=	sbase+$a		* uart mode register
scommnd =	sbase+$b		* uart command register	
fifost  =	sbase+$c		* fifo status
fifoda	=	sbase+$d		* fifo data
dmaglbl = 	sbase+$e		* global dma status
sselect =	sbase+$f		* tty select port

* sio constants

control =	$27		        * normal async mode
ttya	=	0			* select byte for ttya
ttyb	=	1			* select byte for tttb
ttyc	=	2			* select byte for tttc
ttyd	=	3			* select byte for tttd
divisor =	$d			* 9600 baud divisor

* sio flags and masks

done	=	$40			* DMA idle when port 27 = 40
sro	=	$1			* transmit buffer empty when high
sr1	=	$2			* receive buffer full when high
sr6	=	$40			* carrier detected when low
sr7	=	$80			* data set ready when low
kick	=	1			* value to kick controller



***************************
*  miscellaneous equates  *
***************************

alf	=	$a			* ascii line feed
acr	=	$d			* ascii carriage return
asp	=	$20			* ascii space
acs	=	$1a			* ascii clear for ADM31
qpat	=	$AA55			* initial ram test pattern
spat	=	$00ff	 		* marching pattern
stop	=	$F0000			* end of 2 Meg ramtest area
page	=	1024			* 2K X 8 ram chips
image	=	0
uerr	=	$4fe

*************************
*	B E G I N	*
*************************


* 	PRINT SIGNON

init:	bsr	acrlf
	move.w	#$09,d0
	move.l	#signon,d1
	trap	#$2
	bsr	acrlf
	bsr	acrlf
	move.w	#$09,d0
	move.l	#signon1,d1
	trap	#$2
	bsr	acrlf
	bsr	acrlf
	bsr	sbaud			* initialize the baud rates
	bsr	sendt
	bsr	fillram

* main program loop

main:	bsr	output			* do the QBF pattern
	bsr	nout			* do the barber pole pattern
	bsr	keybrd			* check for console key pressed
	jmp	main


* routine sets all 4 ttys to 9600 baud

sbaud:	move.b	#ttya,d2		* select uart 0
sbaud1:	move.b	d2,sselect		* select the tty
	move.b 	scommnd,d0		* set up for uart mode reg. 1	
	move.b  smode,d1		* read mode register 1 point to 2      
	move.b	smode,d0		* read mode register 2 point to 1
	move.b	smode,d1		* read mode register 1 setup for 2
	andi.b  #$f0,d0			* strip baud rate off
	ori.b	#divisor,d0		* lower 4 bits = 9600 baud
	move.b  d0,smode		* write register 2
	move.b  #control,scommnd	* set it for normal async rs232
	addq.b	#1,d2			* next one
	cmpi.b	#4,d2
	bne	sbaud1
	rts



* routine sends barber pole to each UART via direct I/O
	
sendt:  move.w	#ttya,d2		* select uart 0
sendt1:	move.b	d2,sselect		* write select port
	move.w	d2,uerr			* stash for later
	move.b	#asp,d3			* start with a 'space'
sendt2:	move.l	#$1FFFF,d5		* timeout count
sendt3:	subq.l	#1,d5			* decr the timer
	bne	sendt4
	jmp	uerror			* timeout, print the error	
sendt4:	move.b	sstatus,d4
	andi.b	#1,d4			* check uart tbe flag
	beq	sendt3			* loop till empty	
	move.b	d3,sdata		* send the data
	addq.b	#1,d3			* next character
	cmpi.b	#$7f,d3			* check for last ascii character
	bne	sendt2			* loop for whole set
sendt5:	addq.b	#1,d2			* repeat for next uart
	cmpi.b	#4,d2			* last uart??			
	bne	sendt1		
	rts

uerror: bsr	acrlf
	move.w	#$09,d0
	move.l	#ermsg1,d1
	trap	#$2
	move.w	#$02,d0
	move.w	uerr,d1			* get the uart number
	add.b	#'A',d1			* force ascii A as base
	trap	#$2			* call bdos
	bsr	acrlf
	bsr	acrlf
	move.w	uerr,d2			* get back select
	jmp	sendt5			* go on to next uart


* executes once...fill ram dma output buffer with the barber pole

fillram:
	move.w	#2048,d6		* byte count--one screen 
	move.l	#textend,a1

*  write barber pole to memory buffer

nloop:	move.b	#asp,d0
nloop1:	move.b  d0,(a1)+
	subq.w	#1,d6
	beq	nchk
	addq.b	#1,d0			* next ascii char
	cmpi.b	#$7f,d0			* check for last ascii char
	bne	nloop1
	bra	nloop
	rts		



* QUICK BROWN FOX - set up the dma and send  buffer to each uart

output: move.b	#25,d3			* repeat count for one screen

output1:
	subq.b	#1,d3			
	bne	output2
	rts

output2:
	move.b	#ttya,d2		* select uart 0
dmaset: move.b	d2,sselect
	move.l	#textbeg,d7		* set up dma address
	move.w	#textsiz,d6		* byte count
	move.l	#0,d5			* test phase 0

	bsr	idle			* check for idle
	move.b	d7,dmaddrl		* output the low and high byte
	ror.l	#8,d7
	move.b	d7,dmaddrh
	ror.l	#8,d7
	move.b	d7,dmaddre
	move.b	d6,lcount		* buffer size
	ror.l	#8,d6
	move.b	d6,hcount
	move.b	#kick,dmacntl		* kick the controller

dmaset1:
	addq.b	#1,d2			* increment for next channel
	cmpi.b	#4,d2
	bne	dmaset
	bra	output1			* loop for one screen


*  BARBER POLE - set up the dma and send  buffer to each uart

nout:   move.b	#ttya,d2		* select uart 0
	
nset:   move.b	d2,sselect
	
nchk: 	move.b	d2,sselect		* next uart
	move.l	#textend,d7
	move.w	#2048,d6		* byte count--one screen 
	move.l	#1,d5			* test phase 1

	bsr	idle			* check for idle
	move.b	d7,dmaddrl		* output the low address
	ror.l	#8,d7
	move.b	d7,dmaddrh		* output high address
	ror.l	#8,d7
	move.b	d7,dmaddre		* output extended address
	move.b	d6,lcount		* buffer size lsb
	ror.l	#8,d6
	move.b	d6,hcount		* buffer size msb
	move.b	#kick,dmacntl		* kick the controller

nchk1:	addq.b	#1,d2			* increment for next channel
	cmpi.b	#4,d2
	bne	nchk
	rts

* delay loop

dummy:	move.l	a5,-(a7)			* save a5
	move.l	#-1,a5
dumb1:	subq.l	#1,a5
	bne	dumb1
	move.l	(a7)+,a5			* get it back
	rts

* routine loops till dma channel is idle
* and preserves registers 

idle:	move.l	d5,-(a7)		* save d5
	move.l	d3,-(a7)		* save d3
	move.l	#$0fff,d5
idle1:  subq.l	#1,d5
	bne	idle2
	move.l	(a7)+,d3		* get registers back
	move.l	(a7)+,d5
	move.l	(a7)+,d0		* realign the stack
	cmpi.b	#0,d5			* check which pass
	beq	dmaset1
	bra	nchk1
idle2:	move.b	dmacntl,d3		* check for idle
	andi.b	#done,d3
	beq	idle1
	move.l	(a7)+,d3		* restore d3
	move.l	(a7)+,d5		* restore d5
	rts


*  PRINT A SPACE through CP/M

aspace: move.w	#$02,d0
	move.w	#asp,d1
	trap	#$2			* call bdos
	rts

*  PRINT A CARRIAGE RETURN / LINE FEED through CP/M

acrlf:	move.w	#$02,d0			* bdos write char call
	move.w	#acr,d1			
	trap	#$2			* call bdos
	move.w	#$02,d0
	move.w	#alf,d1
	trap	#$2			* call bdos	
	rts

keybrd: move.w	#$b,d0			* bdos con stat call
	trap	#2			* call bdos
	cmpi.w	#0,d0			* was key pressed?
	beq	leave
	addq.l	#4,(a7)				
leave:	rts

	


signon:	.dc.b	'Morrow 68k system serial port test Version 0 $'

signon1:
	.dc.b	'Type any key on the console to abort test... $'

ermsg1:	.dc.b	'Transmitter buffer full timeout. Check DTR (pin 20 must be high) on channel $'

textbeg: .dc.b  'THE QUICK BROWN FOX JUMPED OVER THE LAZY DOGS BACK 0123456789'
	 .dc.b	$0a
	 .dc.b  $0d
textend: .dc.b	0

textsiz: equ	textend-textbeg

	.end