
;************************************************************************
;* 									*
;*	SIMPLE SWITCHBOARD SCREENING TEST @ 70H				*
;*      (INITIAL CODING 2/12/84: bjg					*
;*									*
;*		CONSTRUCT TEST CABLE:					*
;*									*
;*	PIN ON J1          PIN ON J2					*
;*									*
;*	   1		       2					*
;*         2	               1					*
;*	   9	              19					*
;*	  11 - 19							*
;*        13 - 17							*
;*	  15		      17		      			*
;*									*
;*		     SET SWITCHES AS FOLLOWS:				*
;*									*
;*	SW1	1 - 8 OFF          ( OR MATCH 1-4 WITH 5 - 8)		*
;*	SW2	1 - 8 OFF          (19200 BAUD)    			*
;*	SW3	DON'T CARE         (STROBE POLARITY)			*
;*	SW4	5-8 DON'T CARE     (ATTN POLARITY)			*
;*		1-4 ON             (ENABLE PARALLEL OUTPUT DRIVERS)	*
;*	SW5	1  ON		   (BOARD REPSONDS TO PHANTOM)		*
;*		2,4,6 OFF; 3,5 ON  (PORT 70H)				*
;*		7 ON               (DISABLE EPROM) 			*
;*		8 ON 	           (DISABLE RAM)			*
;*	SW6	1-4 OFF 	   (PLACES RAM @ F000H)			*
;*		5-8 OFF		   (PLACES EPROM @ F000H)		*
;*									*
;************************************************************************












;****************************************************************




	ORG	100H

BASE	EQU	70H
SER1	EQU	BASE + 0
SER2	EQU	BASE + 1
STATUS  EQU	BASE + 2
STROBE	EQU	BASE + 3
PPORT1	EQU	BASE + 4
PPORT2	EQU	BASE + 5
PPORT3	EQU	BASE + 6
PPORT4	EQU	BASE + 7

RDA1	EQU	04H
RDA2	EQU	040H
TBE1	EQU	08H
TBE2	EQU	080H
BDOS	EQU	05H


; 	PRINT SIGNON MESSAGE
	
SIGNON:	LXI	SP,100H
	MVI	C,2
	MVI	E,01AH	
	CALL	BDOS			;CLEAR SCREEM
	CALL	CRLF
	CALL	CRLF
	MVI	C,09
	LXI	D,BANNER
	CALL	BDOS
	CALL	CRLF
	CALL	CRLF

;	CLEAR ALL PORTS AND TEST FOR SWITCHBOARD PRESENT

TPRSNT: MVI	A,0
	OUT	PPORT1		;INITIALIZE ALL PORTS
	OUT	PPORT2
	OUT	PPORT3
	OUT	PPORT4
	IN	PPORT1		;CLEAR ATTN SIGNALS
	IN	PPORT2
	IN	PPORT3
	IN	PPORT4	
	IN 	SER1		;RESET RDA
	IN	SER2		;RESET RDA
	IN 	STATUS		;READ STATUS
	IN	PPORT1
	CPI	0FFH
	JNZ	TESTS1
	CALL	CRLF
	CALL	CRLF
	LXI	D,NPRMSG
	MVI	C,9
	CALL	BDOS
	CALL	CRLF
	CALL	CRLF
	JMP	0

	; SERIAL PORT 1 OUTPUT, PORT 2 INPUT LOOP TEST

TESTS1: MVI	A,31H
	STA	PASS
	MVI	C,9
	LXI	D,SERTST1
	CALL	BDOS
	MVI	C,0

S1LOOP:	CALL	SOUT1
	CALL	SINP2
	CMP	C
	JZ	S1L1
	LXI	D,TEST1ER
	JMP	UERROR

S1L1:	INR	C
	JNZ	S1LOOP


	; SERIAL PORT 2 OUTPUT, PORT 1 INPUT LOOP TEST

TESTS2: MVI	A,32H
	STA	PASS
	CALL	CRLF
	CALL	CRLF
	MVI	C,9
	LXI	D,SERTST2
	CALL	BDOS
	MVI	C,0



S2LOOP: CALL	SOUT2
	CALL	SINP1
	CMP	C
	JZ	S2L1
	LXI	D,TEST1ER
	JMP	UERROR
S2L1:	INR	C
	JNZ	S2LOOP


; PARALLEL PORT 1 TEST

TESTP1: MVI	A,1
	STA	PASS
	CALL	CRLF
	CALL	CRLF
	LXI	D,PP1MSG
	MVI	C,9
	CALL	BDOS
	MVI	C,0
P1LOOP:	MOV	A,C
	OUT	PPORT1
	IN	PPORT1
	CMP	C
	JZ	P1LOP1
	LXI	D,PERR
	JMP	PPERR
P1LOP1:	INR	C
	JNZ	P1LOOP


;	PARALLEL PORT 2 TEST

TESTP2: MVI	A,2
	STA	PASS
	CALL	CRLF
	CALL	CRLF
	LXI	D,PP2MSG
	MVI	C,9
	CALL	BDOS
	MVI	C,0
P2LOOP:	MOV	A,C
	OUT	PPORT2
	IN	PPORT2
	CMP	C
	JZ	P2LOP1
	LXI	D,PERR
	JMP	PPERR
P2LOP1:	INR	C
	JNZ	P2LOOP

;	PARALLEL PORT 3 TEST

TESTP3: MVI	A,3
	STA	PASS
	CALL	CRLF
	CALL	CRLF
	LXI	D,PP3MSG
	MVI	C,9
	CALL	BDOS
	MVI	C,0
P3LOOP:	MOV	A,C
	OUT	PPORT3
	IN	PPORT3
	CMP	C
	JZ	P3LOP1
	LXI	D,PERR
	JMP	PPERR
P3LOP1:	INR	C
	JNZ	P3LOOP


;	PARALLEL PORT 4 TEST

TESTP4: MVI	A,4
	STA	PASS
	CALL	CRLF
	CALL	CRLF
	LXI	D,PP4MSG
	MVI	C,9
	CALL	BDOS
	MVI	C,0
P4LOOP:	MOV	A,C
	OUT	PPORT4
	IN	PPORT4
	CMP	C
	JZ	P4LOP1
	LXI	D,PERR
	JMP	PPERR
P4LOP1:	INR	C
	JNZ	P4LOOP
	JMP	TATTN


;	PARALLEL PORT ERROR PRINT ROUTINE

PPERR:	MVI	C,9
	CALL	BDOS
	LDA	PASS
	CPI	1
	JZ	TESTP2
	CPI	2
	JZ	TESTP3
	CPI	3
	JZ	TESTP4


;	BEGIN ATTN AND STROBE TESTING

TATTN:	CALL	CRLF
	CALL	CRLF
	MVI	C,9
	LXI	D,ATNMSG
	CALL	BDOS
	CALL	CRLF

;	TEST ATTN E AND STROBE A

ATTNE:  CALL	CLRATN
	IN	STROBE
	CPI	0F0H
	JZ	CONTE
	LXI	D,ATNERR
	MVI	C,9
	CALL	BDOS
	JMP	ATTNF
CONTE:	CALL	CRLF
	LXI	D,ATEMSG
	MVI	C,9
	CALL	BDOS
	MVI 	A,0
	OUT	STROBE
	IN	STROBE
	ANI	01H
	JNZ	ATTNF
	LXI	D,ATNERE
	MVI	C,09
	CALL	BDOS


;  	TEST ATTN F AND STROBE B	

ATTNF:	CALL	CLRATN
	IN	STROBE
	CPI	0F0H
	JZ	CONTF
	CALL	CRLF
	LXI	D,ATNERR
	MVI	C,9
	CALL	BDOS
	JMP	ATTNG	
CONTF:	CALL	CRLF
	LXI	D,ATFMSG
	MVI	C,9
	CALL	BDOS
	MVI 	A,1
	OUT	STROBE
	IN	STROBE
	ANI	02H
	JNZ	ATTNG
	LXI	D,ATNERF
	MVI	C,09
	CALL	BDOS
	CALL	CRLF


;	TEST ATTN G AND STROBE C

ATTNG:	CALL	CLRATN
	IN	STROBE
	CPI	0F0H
	JZ	CONTG
	CALL	CRLF
	LXI	D,ATNERR
	MVI	C,9
	CALL	BDOS
	JMP	ATTNH	
CONTG:	CALL	CRLF
	LXI	D,ATGMSG
	MVI	C,9
	CALL	BDOS
	MVI 	A,2
	OUT	STROBE
	IN	STROBE
	ANI	04H
	JNZ	ATTNH
	LXI	D,ATNERG
	MVI	C,09
	CALL	BDOS
	CALL	CRLF


;	TEST ATTN H AND STROBE D

ATTNH:	CALL	CLRATN
	IN	STROBE
	CPI	0F0H
	JZ	CONTH
	LXI	D,ATNERR
	MVI	C,9
	CALL	BDOS
	JMP	TSTRB			;GOTO NEXT TEST
CONTH:	CALL	CRLF
	LXI	D,ATHMSG
	MVI	C,9
	CALL	BDOS
	MVI 	A,3
	OUT	STROBE
	IN	STROBE
	ANI	08H
	JNZ	TSTRB
	LXI	D,ATNERH
	MVI	C,09
	CALL	BDOS
	JMP	TSTRB


;	CLEAR ALL ATTN BITS TO ZERO (LOWER 4 BITS OF STROBE PORT)

CLRATN: IN	PPORT1
	IN	PPORT2
	IN	PPORT3
	IN	PPORT4
	RET

;	LOOP TO OBSERVE STROBES WITH SCOPE

TSTRB:	CALL	CRLF
	CALL	CRLF
	LXI	D,STBMSG
	MVI	C,9
	CALL	BDOS
	CALL	CRLF
	MVI	C,9
	LXI	D,WMSG
	CALL	BDOS

;	KEEP DOING STROBES UNTIL KEY PRESSED

STBSU:	MVI	C,0BH
	CALL	BDOS
	ORA	A
	JNZ	DONE
	MVI	C,0	
STBLOP: MOV	A,C
	CPI	8
	JZ	STBSU
	OUT	STROBE
	INR	C
	JMP	STBLOP		


;	PRINT SIGNOFF AND BACK TO CP/M

DONE:	CALL	CRLF
	CALL	CRLF
	CALL	CRLF
	MVI	C,9
	LXI	D,SIGNOFF
	CALL	BDOS
	CALL	CRLF
	CALL	CRLF
	JMP	0

;	UART ERRO PRINTING ROUTINE

UERROR:	MVI	C,9
	CALL	BDOS
	LDA	PASS
	CPI	031H
	JZ	TESTS2
	JMP	TESTP1


; RETURN WITH CHARACTER IN A

SINP1:	CALL	INIT
	MVI	A,0
	STA	SIO
SINP10:	CALL	TIMOUT
	IN 	STATUS
	ANI	RDA1
	JZ	SINP10
	IN	SER1
	RET



; RETURN WITH CHARACTER IN A	

SINP2:  CALL	INIT
	MVI	A,1
	STA	SIO
SINP20:	CALL	TIMOUT
	IN 	STATUS
	ANI	RDA2
	JZ	SINP20
	IN	SER2
	RET



; CALL WITH CHARACTER IN C

SOUT1:  CALL	INIT
	MVI	A,2
	STA	SIO
SOUT10:	CALL	TIMOUT
	IN 	STATUS
	ANI	TBE1
	JZ	SOUT10
	MOV	A,C
	OUT 	SER1
	RET



; CALL WITH CHARACTER IN C

SOUT2:  CALL	INIT
	MVI	A,3
	STA	SIO
SOUT20:	CALL	TIMOUT
	IN 	STATUS
	ANI	TBE2
	JZ	SOUT20
	MOV	A,C
	OUT 	SER2
	RET

;	PRINT A CARRIAGE RETURN LINE FEED

CRLF:	MVI	C,2
	MVI 	E,0AH
	CALL 	BDOS
	MVI	C,2
	MVI	E,0DH
	CALL	BDOS
	RET

;	COUNTER SETUP ROUTINE FOR TIMEOUT CONSTANTS

INIT:	LXI	H,0FFFFH
	LXI	D,0fffh
	RET

;	TIMEOUT LOOP

TIMOUT:	DCX	H
	MOV	A,L
	XRA	H
	RNZ
	DCX	D
	MOV	A,E
	XRA	D
	RNZ
	LDA	SIO
	CPI	0
	JNZ	TO1
	LXI	D,TOMSG0
	JMP	LEAVE
TO1:	CPI	1
	JNZ	TO2
	LXI	D,TOMSG1
	JMP	LEAVE
TO2:	CPI	2
	JNZ	TO3
	LXI	D,TOMSG2
	JMP	LEAVE
TO3:	LXI	D,TOMSG3
	JNZ	STRANGE
	LXI	D,TOMSG3
LEAVE:	POP	H
	JMP	UERROR	

STRANGE:
	LXI	D,STRMSG
	JMP	LEAVE


;	TEST MESSAGES

BANNER:	DB	' SWITCHBOARD TEST VERSION 1.0 $'	 
SERTST1:
	DB	' Testing SERIAL OUTPUT 1, SERIAL INPUT 2 $'
SERTST2:
	DB	' Testing SERIAL OUTPUT 2, SERIAL INPUT 1 $'
UERSTR:	DB	' ==>> DATA MIS-MATCH, UART ERROR!! $ '
SIGNOFF: 
	DB	' TEST COMPLETE, RETURNING TO CP/M. $'
TEST1ER:
	 DB	'  ==>> DATA MISMATCH ERROR!! $'
TOMSG:  DB	'  ==>> TIME OUT ERROR!! $'
NPRMSG: DB	' NO SWITCHBOARD PRESENT IN SYSTEM or NOT ADDRESSED @ 70H !! $'
TOMSG0:	DB	' ==>> TIMEOUT IN SERIAL PORT 1 							INPUT ROUTINE!! $'
TOMSG1:	DB	' ==>> TIMEOUT IN SERIAL PORT 2 							INPUT ROUTINE!! $'
TOMSG2:	DB	' ==>> TIMEOUT IN SERIAL PORT 3 							OUTPUT ROUTINE!! $'
TOMSG3:	DB	' ==>> TIMEOUT IN SERIAL PORT 2 							OUTPUT ROUTINE!! $'
STRMSG: DB	' ==>> UNKNOWN ERROR!! $'
PP1MSG: DB	' Testing PARALLEL PORT 1  $ '
PP2MSG: DB	' Testing PARALLEL PORT 2  $ '
PP3MSG: DB	' Testing PARALLEL PORT 3  $ '
PP4MSG: DB	' Testing PARALLEL PORT 4  $ '
PERR :  DB	'  ==>> DATA COMPARE ERROR !! $ '
ATNMSG: DB	' Testing STROBES and ATTN lines (E,F,G and H): $'
ATEMSG: DB	' Testing STROBE A & ATTN LINE E $'
ATFMSG: DB	' Testing STROBE B & ATTN LINE F $'
ATGMSG:	DB	' Testing STROBE C & ATTN LINE G $'
ATHMSG: DB	' Testing STROBE D & ATTN LINE H $'
ATNERR: DB	' UNABLE TO RESET THE ATTN LINES!! $'
ATNERE: DB	'   ==>> ERROR IN ATTN LINE E $'
ATNERF: DB	'   ==>> ERROR IN ATTN LINE F $'
ATNERG: DB	'   ==>> ERROR IN ATTN LINE G $'
ATNERH: DB	'   ==>> ERROR IN ATTN LINE H $'
STBMSG:	DB	' Now generating STROBES on pins 9, 11, 13, 15 of J1 and J2 $ '
WMSG:  	DB	' Type any key to terminate STROBE test... $ '

PASS:	DB	0
SIO:	DB	0

	END
