;
;	Seeker for Micro Decision
;
	ORG	0100H

BIOS	EQU	0F600H

BDOS	EQU	0005H
WARM	EQU	0

SIZE	EQU	34
TSTCNT  EQU	10			;NUMBER OF PASSES 

SETTRK	EQU	BIOS+1EH
SETSEC	EQU	BIOS+21H
READ	EQU	BIOS+27H
SETDMA	EQU	BIOS+24H

BEGIN:  LDA	082H			    ;PICK UP DRIVE NUMBER	
	ANI	04FH			    ;UPPER CASE CONVERT	
	CPI	'A'
	JZ	SELECT
	CPI	'B'
	JNZ	BADPAR

SELECT: ANI	3			   ;SELECT A DRIVE
	DCR	A
	MOV	E,A
	MVI	C,0EH
	CALL	BDOS
	

	LXI	SP,BEGIN
	MVI	E,0CH
	CALL	COUT	                    ;PRINT FORM FEED
	LXI	D,SIGNON
	CALL	PMSG
	MVI	E,0DH
	CALL	COUT
	MVI	E,0AH
	CALL	COUT
	MVI	C,TSTCNT  		     ;NUMBER OF PASSES
	

START:	PUSH 	B
	MVI	E,02EH
	CALL	COUT
	LXI	H,0
	SHLD	FIRST
	LXI	H,SIZE
	SHLD	LAST
	LXI	B,BUFFER
	CALL	SETDMA
	POP	B

MAIN:	LHLD	FIRST
	CALL	SEEK
	LHLD	LAST
	CALL	SEEK
	LHLD	FIRST
	INX	H
	SHLD	FIRST


	LHLD	LAST
	CALL	SEEK
	LHLD	FIRST
	CALL	SEEK
	LHLD	LAST
	DCX	H
	SHLD	LAST
	MOV	A,H
	ORA	L
	JNZ	MAIN
	DCR	C	
	JNZ	START
	JMP	SEEKOK


SEEK:	PUSH	B			;SAVE PASS COUNTER
	MOV	B,H
	MOV	C,L
	CALL	SETTRK
	LXI	B,1
	CALL	SETSEC
	CALL	READ
	ORA	A
	JNZ	ERROR
	MVI	C,0BH			;CHECK KEY PRESSED
	CALL	BDOS
	CPI	0
	JNZ	WARM	
	POP	B
	RET

SEEKOK: LXI	D,GDMESS
	CALL	PMSG
	JMP	WARM

ERROR:  LXI	D,BDMESS
	CALL	PMSG
	MVI	E,0AH
	CALL	COUT
	MVI	E,0DH
	CALL	COUT
	LXI	D,RETURN
	CALL	PMSG

LOOP0:	MVI	C,0BH			;CHECK KEY PRESSED
	CALL	BDOS
	CPI	0
	JNZ	WARM
	MVI	E,07H			;BEEP THE TERMINAL
	CALL	COUT
	JMP	LOOP0

COUT:	MVI	C,02
	CALL	BDOS
	RET


PMSG:	MVI	C,09H
	CALL	BDOS
	MVI	E,0AH
	CALL	COUT
	MVI	E,0DH
	CALL	COUT
	RET

BADPAR: LXI	D,PARAM
	CALL	PMSG
	JMP	WARM

SIGNON: DB	'Micro Decision Seek Test... Type any key to abort: $'

GDMESS: DB	'Seek Test Complete... No errors!! $'

BDMESS: DB	' ===>> SEEK ERROR <<=== $'

RETURN: DB	' Type any key to return to CP/M: $'

PARAM:  DB	'Bad drive value, select either "A" or "B". $'

FIRST:	DW	0
LAST:	DW	SIZE
BUFFER	EQU	$

	END
