;
;	FLOPPY VERIFIER for DJ/DMA 5 INCH MEDIA
;	- INITIAL CODING  -  7/20/83  -  BJG
;
;	- V1.1-  change the read track verify to include
;		 table chaecking for errors, added TSTAT.  
;		 	8/1/83 - BJG

	ORG	0100H

BIOS	EQU	0F600H
WARM	EQU	0
BDOS	EQU	0005H

TSTCNT  EQU	1			;NUMBER OF PASSES 


;********************
CHANNEL	EQU	050H
TRACK	EQU	CHANNEL + 1
HEAD	EQU	CHANNEL + 2
DRIVE	EQU	CHANNEL + 3
HEAD0	EQU	0
HEAD1	EQU	080H


BEGIN:	CALL	FORM
	CALL	CRLF
	CALL	CRLF
	CALL	CRLF
	LXI	D,SIGNON
	CALL	PMSG
	CALL	CRLF
	CALL	CRLF
	
; PRINT THE OPTION MENU

	LXI	D,OPT1
	CALL	PMSG
	LXI	D,OPT2
	CALL	PMSG
	LXI	D,OPT3
	CALL	PMSG
	LXI	D,OPT4
	CALL	PMSG
	CALL	CRLF
	LXI	D,WAITMSG
	CALL	NPMSG

WAIT:	MVI	C,0BH			;CONSOLE STATUS
	CALL	BDOS			;CHECK KEY PRESSED
	CPI	0
	JZ	WAIT			;WAIT FOR IT
	MVI	C,01
	CALL	BDOS			;CONSOLE INPUT
	ANI	04FH			;FORCE UPPER CASE
	CPI	'A'			;1 RETRY
	JNZ	BTEST
	MVI	A,1
	JMP	SAVE

BTEST:	CPI	'B'			;5 RETRIES
	JNZ	CTEST
	MVI	A,5
	JMP	SAVE

CTEST:	CPI	'C'			;10 RETRIES
	JNZ	DTEST
	MVI	A,10
	JMP	SAVE	

DTEST:	CPI	'D'			;25 RETRIES
	JNZ	BADPAR			;BAD PARAMETER
	MVI	A,25
	
SAVE:   STA	051H			;STORE IT IN CHANNEL
	MVI	A,028H
	STA	050H			;SET RETRY COUNT COMMAND
	MVI	A,25H			;HALT COMMAND
	STA	052H
	MVI	A,0
	STA	053H			;NULL THE STATUS BYTE

DOIT:	OUT	0EFH			;ATTN => DJ/DMA
	LXI	H,053H
	LXI	B,0
	MVI	D,10H
STAT:   DCX	B
	MOV	A,B
	ORA	C
	JZ	STAT1
	MOV	A,M
	CPI	0
	JZ	STAT
	JMP	WARM
	
STAT1:  DCR	D
	JZ	TIMEOUT
	JMP	STAT


CRLF:	MVI	E,0AH		;PRINT A CR AND LF
	CALL	COUT
	MVI	E,0DH

COUT:	MVI	C,02		;PRINT CHAR IN A
	CALL	BDOS
	RET

FORM:	MVI	E,0CH
	CALL	COUT
	RET

; COME HERE IF CONTROLLER NOT RESPONDING

TIMEOUT:
	LXI	D,TOMSG	
	CALL	PMSG
	JMP	0

PMSG:	MVI	C,09H
	CALL	BDOS
	CALL	CRLF
	RET

NPMSG:  MVI	C,09H
	CALL	BDOS
	RET

BADPAR: CALL	CRLF
	LXI	D,PARAM
	CALL	NPMSG
	JMP	WAIT




SIGNON: DB	'To set DJ/DMA error retry count, select an option:  $'

OPT1:	DB   '             A  -  1  RETRY  (diagnostic mode) $'
OPT2:	DB   '             B  -  5  RETRIES $'
OPT3:   DB   '             C  - 10  RETRIES (normal mode) $'
OPT4:   DB   '             D  - 25  RETRIES (fault tolerant) $'	

WAITMSG:
	DB   '		        Select A,B,C or D:  $'

PARAM:  DB  'Sorry, not a valid option  ==>>   Select A,B,C or D only:   $'

TOMSG:	DB	' DJ/DMA not responding to commands !!  $'

HSTAT:  DW	0

BUFFER	EQU	$

	END
