




;	Seeker for Micro Decision
;
	ORG	0100H

BIOS	EQU	0AB00H

BDOS	EQU	0005H
WARM	EQU	0

SIZE	EQU	39
TSTCNT  EQU	0			;NUMBER OF PASSES 

SETTRK	EQU	BIOS+1EH
SETSEC	EQU	BIOS+21H
READ	EQU	BIOS+27H
SETDMA	EQU	BIOS+24H
WRITE	EQU	BIOS+2AH

BEGIN:  LDA	80H			   ;CHECK FOR PARAMETERS	
	ORA	A
	JZ	BADPAR 
	LDA	082H			    ;PICK UP DRIVE NUMBER	
	ANI	04FH			    ;UPPER CASE CONVERT	
	CPI	'A'
	JZ	SELECT
	CPI	'B'
	JNZ	BADPAR

SELECT: ANI	3			   ;SELECT A DRIVE
	DCR	A
	MOV	E,A
	MVI	C,0EH
	CALL	BDOS
	

	LXI	SP,BEGIN
	MVI	E,0CH
	CALL	COUT	                    ;PRINT FORM FEED
	LXI	D,SIGNON
	CALL	PMSG
	MVI	E,0DH
	CALL	COUT
	MVI	E,0AH
	CALL	COUT
	MVI	C,TSTCNT  		     ;NUMBER OF PASSES


START:	PUSH 	B
	MVI	E,02EH
	CALL	COUT
	LXI	B,BUFFER
	CALL	SETDMA
	POP	B
	
	

;  DE = MULTIPLICAND
;  HL = PRODUCT
;   A = MULTIPLIER
;   B = COUNT

MAIN:	LHLD	LAST			;GET CURRENT TRACK
	MOV	A,L
	INR	A
	LXI	D,153
	LXI	H,7
	MVI	B,8
MULT:   DAD	H
	RAL
	JNC	CHCNT
	DAD	D
CHCNT:  DCR	B
	JNZ	MULT
	SHLD	LAST
	MOV	A,L


	ANI	03FH			;MAKE IT FIT SIZE
	MOV	B,A
	SUI	SIZE			;WITHIN TRACK LIMIT?
	JNC	MAIN1
	MOV	A,B
	RRC
	MOV	B,A

MAIN1:  MOV	L,B
	MVI	H,0
	SHLD	LAST
	CALL	SEEK
	DCR	C	
	JNZ	START
	JMP	SEEKOK


;   ENTER WITH HL POINTING TO NEW TRACK, C HAS PASS NUMBER 
;   AND DMA ADRESS SET.


SEEK:	PUSH	B			;SAVE PASS COUNTER
	MOV	B,H
	MOV	C,L
	CALL	SETTRK
	LXI	B,1
	CALL	SETSEC
	CALL	READ
	ORA	A
	JNZ	ERROR
;	CALL	WRITE
;	ORA	A
;	JNZ	ERROR
	MVI	C,0BH			;CHECK KEY PRESSED
	CALL	BDOS
	CPI	0
	JNZ	WARM	
	POP	B
	RET

SEEKOK: LXI	D,GDMESS
	CALL	PMSG
	JMP	WARM

ERROR:  LXI	D,BDMESS
	CALL	PMSG
	MVI	E,0AH
	CALL	COUT
	MVI	E,0DH
	CALL	COUT
	JMP	WARM

COUT:	MVI	C,02
	CALL	BDOS
	RET


PMSG:	MVI	C,09H
	CALL	BDOS
	MVI	E,0AH
	CALL	COUT
	MVI	E,0DH
	CALL	COUT
	RET

BADPAR: LXI	D,PARAM
	CALL	PMSG
	JMP	WARM

SIGNON: DB	'Micro Decision Disk Test... Type any key to abort: $'

GDMESS: DB	'Read/Write Test Complete... No errors!! $'

BDMESS: DB	' ===>> Read/Write ERROR <<=== $'

RETURN: DB	' Type any key to return to CP/M: $'

PARAM:  DB	'Bad drive value, select either "A" or "B". $'

FIRST:	DW	0
LAST:	DW	SIZE
BUFFER	EQU	$

	END
