

;*************************************************************
;*							     *
;*     INTEST - (C) 1982 MORROW DESIGNS			     *
;*              MORROW INTERRUPT TEST FOR 8259 ON MULT I/O   *
;*              AND WUNDERBUS I/O.  PRINTS A "." EVERTIME    *
;*              CLOCK GENERATES AN INTERRUPT (2048 PER SEC.) *
;*              AND TERMINATES WHEN ANY CHARACTER IS ON      *
;*              THE CONSOLE IS PRESSED. THESE RELY ON THE    *
;*              CP/M BDOS CALLS THROUGH LOCATION 5.          *
;*                                                           *
;*              WB I/O MUST HAVE SWITCH 7C:  1,2,4,5 - ON    *
;*                                           3,6,7,8 - OFF   *
;*                                                           *          
;*                               SWITCH 10A  1,3     - ON    *
;*                                           OTHERS  - OFF   *
;*                                                           *
;*                               JUMPER J2   A - B           *
;*                                                           *
;*                               JUMPER J3   INSTALLED       *    
;*							     *
;*               MULT I/O MUST HAVE:                         *
;*                               SWITCH 2D:  1        - OFF  *
;*                                           2-8      - ON   *
;*                                                           *
;*                               SWITCH 7B: 1,2,4,5   - ON   *
;*                                          3,6,7,8   - OFF  *
;*                                                           *
;*                               SWITCH 10B: 5,6      - ON   *
;*                                           OTHERS   - OFF  *     
;*                                                           *
;*                               JUMPER J4 - INSTALLED       *
;*                                                           *
;*                               JUMPER J5 - B TO PINT       *
;*                                                           *
;*                               JUMPER J6 - NOT INSTALLED   *
;*                                                           *
;*                 MEMORY MUST BE SET FOR EXTENDED ADDRESS!  *
;*							     *
;* MULT I/O NOTES:					     *
;*                 THE MULT I/O BOARD SHOULD HAVE EITHER A   *
;*                 MULTX-B OR MULTX-C FPLA AT LOCATION 9A.   *
;*                 IT SHOULD ALSO HAVE A JUMPER WIRE BETWEEN *
;* 		   PIN 2 OF IC AT LOCATION 13B AND PIN 4 OF  *
;*                 IC AT LOCATION 14C.  IN ADDITION 14C PIN  *
;*                 4 MUST BE REMOVED FROM THE SOCKET.        *
;*							     *
;*  WB I/O NOTES:  THE WB I/O BOARD SHOULD BE AT REVISION 2. *
;*                       (ECN # 4  6/3/1982)		     *
;*                                                           *
;*  BJG - 821115                                             *               
;*************************************************************

	ORG     0100H
	
BASE	EQU	048H

SELECT	EQU 	BASE + 7
CLOCK   EQU 	BASE + 2
ICW1	EQU	BASE + 4
ICW2    EQU     BASE + 5
ICW4    EQU     BASE + 5
OCW1    EQU     BASE + 5
OCW2    EQU     BASE + 4
BDOS    EQU	0005H
WARM    EQU     0000H

INIT:	LXI SP,200H
	DI
	MVI A,0
	OUT SELECT		;SELECT GROUP 0
        MVI A,18H
	OUT CLOCK		;INITIALIZE CLOCK TO 2048 TPS
	MVI A,38H
	OUT CLOCK		;CLOCK STROBE HIGH (ACTIVE)
	MVI A,18H
	OUT CLOCK		;CLOCK STROBE LOW  (INACTIVE)

;*******************************************************************
;*			   					   *
;* INITIALIZE THE PIC FOR SINGLE PIC, 4 BYTE INCREMENT CALLS,      *
;* LEVEL TRIGGER MODE, BUFFERED MODE, MASTER, NO AEOI, 8080 MODE.  *
;* CALLS BEGIN AT 120H FOR IR0 AND END AT 13CH FOR IR7 (CLOCK TP). *
;*                                                                 *
;*******************************************************************

	MVI A,03FH		;LOW CALL ADDRESS / MODE FOR PIC
	OUT ICW1
	MVI A,01		;HIGH BYTE OF CALL ADDRESS (0120H)
        OUT ICW2
	MVI A,0CH		;8080 MODE, MASTER
	OUT ICW4
	MVI A,07FH
	OUT OCW1		;MASK ALL BUT CLOCK TP INTERRUPTS
	MVI A,08H
	OUT SELECT		;MULT I/O ENABLE INTERRUPT BIT
	EI

LOOP:   JMP LOOP

STORE:  DS 16			;FILL TO INTERRUPT SEVICE ROUTINE
				;FOR CLOCK

SERVE:  IN CLOCK		;CLEAR CLOCK INTERRUPT
	MVI A,20H
	OUT OCW2		;SEND THE PIC AN EOI
	
PRINT:  MVI C,2			;PRINT A "." FOR EACH TICK OF CLOCK
	MVI E,02EH
	CALL BDOS

STAT:   MVI C,0BH		;CHECK FOR KEY PRESSED
	CALL BDOS
	CPI 0
	JNZ WARM
	MVI A,08H		;CONTINUE UNTIL KEY PRESSED
	OUT SELECT
	EI
	RET

	END
