
;*********************************************************
;Begin Definitions for the Console and List Device Drivers
;*********************************************************
;
;Define Printer Character Constants
;----------------------------------
acr	equ	0Dh		;Carriage return
alf	equ	0Ah		;Line Feed
clear	equ	1Ah		;Clear screen on an ADM 3
xoff	equ	13h		;Xoff character
xon	equ	11h		;Xon character

	if	(contyp eq 2) or (lsttyp ge 2)	;Multio or Wunderbuss

;Multio/Wunderbuss Equates
;-------------------------
;	The following equates will define the Decision I mother
;	board I/O or the Multi I/O environments if needed.
;
;Location Definitions
;--------------------
mbase	equ	48h		;Base address of Multi I/O or Decision I
rbr	equ	mbase		;Read data buffer
thr	equ	mbase		;Tranmitter data buffer
dll	equ	mbase		;Divisor (lsb)
strobe	equ	mbase		;parallel port strobe out
status	equ	mbase		;parallel port status in
dlm	equ	mbase+1		;Divisor (msb)
ier	equ	mbase+1		;Interupt enable register
sensesw	equ	mbase+1		;Sense switches
data	equ	mbase+1		;parallel port data buffer
clk	equ	mbase+2		;WB14 printer select port
lcr	equ	mbase+3		;Line control register
mcr	equ	mbase+4
lsr	equ	mbase+5		;Line status register
msr	equ	mbase+6
grpsel	equ	mbase+7		;Group select port
;
;Define Transmitter/Reciever Mask Bytes
;--------------------------------------
dr	equ	01h		;Line status DR bit
cts	equ	10h		;Clear to send
dsr	equ	20h		;Data set ready
thre	equ	20h		;Status line THRE bit
dlab	equ	80h		;Divisor latch access bit
;
wls0	equ	1		;Word length select bit 0
wls1	equ	2		;Word length select bit 1 for 8 bit word
stb	equ	4		;Stop bit count - 2 stop bits
;
; Define Modem Control Register bits
;-----------------------------------
dtrenb	equ	1		;DTR enable
rtsenb	equ	2		;RTS enable
;
;Define group select Masks
;-------------------------
spp	equ	0		;select parallel port
s0	equ	01h		;Group number (0-3)
s1	equ	02h
smask	equ	03h
bank	equ	04h
enint	equ	08h
restor	equ	10h		;Printer restore on Multi I/O
busy	equ	20h		;parallel printer busy mask
denable	equ	20h		;Driver enable on Multi I/O
;
;Group Port Assignments
;----------------------
congr	eq			;Consol por (1=p1 2=p2 3=p3)
lstgrp	equ	3		;Printer port (1=p1, 2=p2, 3=p3)

	endif			;For Multio/Wunderbuss Definitions
	page


;
;List Output
;-----------
;
lstout:	call	lstost
	ora	a
	jz	lstout
	in	sensesw		;read motherboard switches
	cpi	0FFh		;FF means Multio
	jz	pmult

	mov	a,c		;Print the character
	out	data
	mvi	a,0BFh
	out	strobe		;strobe low (asserted)
	xthl
	xthl			;stall 10 us
	mvi	a,0FFH
	out	strobe		;strobe high (inactive)
	ret

pmult:	mov	a,c		;Print the character
	out	strobe		;really 'data'
	mvi	a,0BFh
	out	data		;strobe low (asserted) (really strobe)
	xthl
	xthl			;stall 10 us
	mvi	a,0FFH
	out	data		;strobe high (inactive)	(really strobe)
	ret

;List Status
;-----------
;
lstost:	lda	group
	ori	spp
	out	grpsel		;select parallel printer group
	in	status
	ani	busy
	rz			;Return busy if buffer is not empty
	mvi	a,0FFh
	ret			;return not busy
	endif			;Multio Wbio parallel
	page

