	page

	if	order = 0
;	Bootstrap load.
;	Do not change any addresses from here to START:
;	Entry	C= Board switches from ROM (0 .. 3)
	ORG	100h
BOOT:
	JMP	START		;invariance
	ds	6
stack	equ	$
	space	4,10
;	Function data for controller to boot
DATA	DB	0		;Extended
ENTRY:	DB	high BIOS
	DB	low BIOS
LDMA	EQU	*-DATA

SPEC	DB	F.SPEC
	VFD	4\SRT,4\HUT
	VFD	7\HLT,1\ND
LSPEC	=	*-SPEC

RECAL	DB	F.RECA,0
LRECAL	=	*-RECAL


READ:	DB	F.RDAT
	DB	0		;hds,ds1,ds0
	DB	0		;C = sector ID info
	DB	0		;Head
	DB	5		;Record (sector)
	DB	0		;N
	DB	26		;Read to end of track
	DB	7		;GPL
	DB	128		;DTL
LREAD	=	*-READ



START:	lxi	sp,stack
	MOV	A,C		;save board options
	STO	A,OPTS
RETRY:
	LDK	DE,DATA
	LDK	B,LDMA

;	Output beginning DMA address

ADDR:	LD	A,[de]
	OUT	DMA		;set DMA
	INX	D
	DCR	B
	JNZ	ADDR		;if NOT all 3 bytes


;	Load Specify Command

	LDK	B,LSPEC
SPEC1:	IN	FDCS
	OR	A
	JP	SPEC1		;if no master ready bit
	LD	A,[de]		;load command byte
	OUT 	FDCD		;to controller
	INX	D
	DCR	B
	JNZ	SPEC1		;if more bytes

;	Recalibrate drive

	LDK	B,LRECAL
RCAL1:	IN	FDCS
	OR	A
	JP	RCAL1		;if no master ready bit
	LD	A,[de]		;load command byte
	OUT 	FDCD		;to controller
	INX	D
	DCR	B
	JNZ	RCAL1		;if more bytes

RCAL2:	IN	INTS
	ORA	A
	JP	RCAL2		;If not complete

	MVI	A,F.RSTS
	OUT	FDCD

RCAL3:	IN	FDCS
	ORA	A
	JP	RCAL3
	IN	FDCD
	SUI	20h
	MOV	C,A
RCAL4:	IN	FDCS
	ORA	A
	JP	RCAL4
	IN	FDCD
	ORA	C
	JNZ	START


;	Now set-up read command

	LDK	B,LREAD
READ1:	IN	FDCS
	OR	A
	JP	READ1		;if no master ready bit
	LD	A,[de]		;load command byte
	OUT 	FDCD		;to controller
	INX	D
	DCR	B
	JNZ	READ1		;if more bytes

READ2:	IN	INTS
	ORA	A
	JP	READ2		;If not complete

READ3:	IN	FDCS
	ORA	A
	JP	READ3
	IN	FDCD
	SUI	40h
	MOV	L,A
READ4:	IN	FDCS
	ORA	A
	JP	READ4
	IN	FDCD
	SUI	80h
	MOV	H,A

	LDK	B,7-2
READ5:	IN	FDCS
	OR	A
	JP	READ5		;if not ready
	IN	FDCD		;read status
	DEC	B
	JNZ	READ5		;wait until all done

	MOV	A,L
	ORA	H
	JNZ	RETRY		;if problems
	LD	HL,ENTRY
	MOV	D,H
	MOV	H,L		;reverse
	MOV	L,D
	JMP	[hl]		;enter CBIOS
	endif
