	page
;BIOS1 - Sorcim CBios setups.

CR:	EQU	0Dh
LF:	EQU	0Ah
DELCNT:	EQU	5*1000		;Delay count for 5 Mhz CPU


K:	EQU	1024
	IF	OPARM < (64+2)	;If absolute
MSIZE:	EQU	OPARM		;Size of CP/M memory
BIOS:	EQU	MSIZE*K-BIOSLN	;Start of CP/M jump table
LWAMEM:	EQU	MSIZE*K-1
	MSG	'Assembling BIOS for LWA of ',LWAMEM,'h.'
	ENDIF
	IF	OPARM > (64+1)	;If PRL generation
MSIZE:	EQU	(OPARM+BIOSLN)/K	;Size of CP/M memory
BIOS:	EQU	OPARM		;Start of CP/M jump table
LWAMEM:	EQU	OPARM+BIOSLN-1
	MSG	'Assembling for relocation.'
	ENDIF
BDOS:	EQU	BIOS-0E00h+6	;BDOS entry point
CCP:	EQU	BIOS-1600h
	space	4,10
;	Page Zero Definitions.
IOBYTE:	EQU	3		;Location of IOBYTE
CDISK:	EQU	4		;Location of current disk
BIORAM:	EQU	40h		;16 ram cells
OPTS:	EQU	BIORAM		;GBC DISK1 board switch options
;		BIORAM+1	;GBC (cell before TICK)
TICK:	EQU	BIORAM+2	;GBC Sample period
DBUF:	EQU	80h		;Default sector buffer
	space	4,10
;	CP/M to host disk constants

HSTSIZ:	EQU	1024		;Blocking/Deblocking buffer size
CPMSIB:	EQU	1024/128	;Standard sectors in block
FPYSIB:	EQU	2048/128	;Sectors in floppy disk block

;	CP/M disk control block equates which define the
;	disk types and maximum storage capability of each
;	disk type.

DSKS1:	EQU	0	;Single density, single sided.
DSKS2:	EQU	1	;Single density, double sided.
DSKD1:	EQU	2	;Double density, single sided.
DSKD2:	EQU	3	;Double density, double sided.
DSKD3:	EQU	4	;Double density, single sided
DSKD4:	EQU	5	;Double density, double sided
DSKD5:	EQU	6	;Double density, single sided
DSKD6:	EQU	7	;Double density, double sided
MAXFTP:	EQU	DSKD6	;Maximum floppy type
DSK8S1:	EQU	8	;SA 1002 and first half SA 1004
DSK8S2:	EQU	9	;last half SA 1004.
DSK8M1:	EQU	10	;First half of Memorex 8 inch drive
DSK8M2:	EQU	11	;Last half of Memorex 8 inch drive

S1DSM:	EQU	((77-2)*26)/CPMSIB
S2DSM:	EQU	((77-2)*2*26)/FPYSIB
D1DSM:	EQU	((77-2)*2*26)/FPYSIB
D2DSM:	EQU	((77-2)*2*2*26)/FPYSIB
D3DSM:	EQU	((77-2)*4*15)/FPYSIB
D4DSM:	EQU	((77-2)*2*4*15)/FPYSIB
D5DSM:	EQU	((77-2)*8*8)/FPYSIB
D6DSM:	EQU	((77-2)*2*8*8)/FPYSIB


;	BDOS constants on entry to write

WRALL:	EQU	0		;write to allocated
WRDIR:	EQU	1		;write to directory
WRUAL:	EQU	2		;write to unallocated
	page
;	Macro for generating Control Blocks for disk drives
;	The format of these disk control blocks are as follows:
;	16 bits = -> translation table.
;	48 bits = Work area for CP/M.
;	16 bits = -> DIRBUF.
;	16 bits = -> Parameter block.
;	16 bits = -> check vector.
;	16 bits = -> allocation vector.

NDSK:	SET	0		;Number of disk drives
NOHRD:	SET	0		;Number of hard disk drives
NOFDD:	SET	0		;Number of floppy disk drives
ALVS:	SET	0		;Allocation vector size
CSVS:	SET	0		;Check vector size

DPHGEN	MACRO	TYPE,XLATE,DIRBUF,DPBADR
NDSK:	SET	NDSK+1
	DW	%2
	DW	0,0,0
	DW	%3
	DW	%4
	DW	CSV+CSVS
	DW	ALV+ALVS
.type	IF	%1 <= MAXFTP
NOFDD:	SET	NOFDD+1
CSVS:	SET	CSVS+(256/4)
ALVS:	SET	ALVS+((D6DSM+7)/8)
	else
	ERR	- Hard disk not supported.
.type	ENDIF
	ENDM
	space	4,10
;	Macro for generating the Disk Parameter Blocks.
;
;	Disk type definition blocks for each particular mode.
;	The format of these areas are as follow:
;	8 bit = disk type code
;	16 bit = Sectors per track
;	8 bit  = Block shift
;	8 bit  = BS mask
;	8 bit  = Extent mask
;	16 bit = Disk size/1024 - 1.
;	16 bit = Directory size.
;	16 bit = Allocation for directory.
;	16 bit = check area size.
;	16 bit = offset to first track.

DPBGEN	MACRO	TYPE,SPT,BSH,BSM,EXM,DSM,DIRSIZ,ALVMSK,OFFSET
	DB	%1
	DW	%2
	DB	%3,%4,%5
	DW	%6-1,%7-1,REV (%8)
.hrd	IF	%1 <= MAXFTP
	DW	(%7+3)/4
	else
	DW	0
.hrd	ENDIF
	DW	%9
	ENDM
	page
;	The following jump table defines the entry points
;	into the CBIOS for use by CP/M and other external
;	routines; therfore the order of these jump cannot
;	be modified.  The location of these jumps can only
;	be modified by 400h locations, which is a restriction
;	of MOVCPM.

	ORG	BIOS

	JMP	CBOOT		;Cold boot
	JMP	WBOOT		;Warm boot
J.CST	JMP	CONST		;Console status (input)
J.CIN	JMP	CONIN		;Console input
J.COUT	JMP	CONOUT		;Console output
J.LIST	JMP	LIST		;List output
	JMP	PUNCH		;Punch output
	JMP	READER		;Reader input
	JMP	HOME		;Set track to zero
	JMP	SELDSK		;Select disk unit
	JMP	SETTRK		;Set track
	JMP	SETSEC		;Set sector
	JMP	SETDMA		;Set Disk Memory Address
	JMP	READ		;Read from disk
	JMP	WRITE		;Write onto disk
J.LST	JMP	LISTST		;List status (output)
	JMP	SECTRN		;Translate sector number
	JMP	SETNUM		;Set number of sectors to read
	JMP	SETXAD		;Set extended address bank.


;	Endx	BIOS1.asm
