	page

;	CompuPro Interfacer 3 support routines

GBI3:	EQU	10h		;Interfacer 3 Base address
GBI3D:	EQU	GBI3+0		;Uart data location
GBI3S:	EQU	GBI3+1		;Uart status
GBI3M:	EQU	GBI3+2		;Uart mode register
GBI3C:	EQU	GBI3+3		;Uart command register
GBI3U:	EQU	GBI3+7		;Uart select register

GBI3DV:	EQU	0000_0010b	;Interfacer 3 Data Available
GBI3MT:	EQU	0000_0001b	;Interfacer 3 Transmit Buffer Empty
	page
;	C O N S O L   I N I T I A L I Z A T I O N
;
;	This routine performs the initialization required by
;	the Interfacer 3.
;

I3INIT:
	XRA	A		;Zero the accumulator
	OUT	GBI3U		;Select Uart 0
	MVI	A,1110_1110b	;Async, 16x, 8 bits, no parity, even, 2 stops
	OUT	GBI3M		;Set up mode register 1
	MVI	A,0111_1110b	;9600 baud
	OUT	GBI3M		;Set up mode register 2
	MVI	A,0010_0111b	;Trans. on, dtr low, rec. on, no break,
				;	no reset, rts low
	OUT	GBI3C		;Set up command port
	RET
	space	4,10
;	C O N S O L   S T A T U S
;
;	This routine samples the Console status and returns the
;	following values in the A register.
;
;	EXIT	A = 0 (zero), means no character
;		currently ready to read.
;
;		A = FFh (255), means character
;		currently ready to read.

I3CONST:
	IN	GBI3S		;Input from port
	ANI	GBI3DV		;Mask data available
	RZ			;If data not available
	ORI	0FFH
	RET
	space	4,10
;	C O N S O L   I N P U T
;
;	Read the next character into the A register, clearing
;	the high order bit.  If no character currently ready to
;	read then wait for a character to arrive before returning.
;
;	EXIT	A = character read from terminal.

I3CONIN:
	IN	GBI3S		;Get status from uart
	ANI	GBI3DV
	JZ	I3CONIN
	IN	GBI3D
	ANI	7Fh
	RET
	space	4,10
;	C O N S O L   O U T P U T
;
;	Send a character to the console.  If the console
;	is not ready to receive a character wait until
;	the console is ready.
;
;	ENTRY	C = ASCII character to output to console.

I3CONOUT:
	IN	GBI3S		;Get uart status
	ANI	GBI3MT		;Test if buffer empty
	JZ	I3CONOUT
	MOV	A,C
	OUT	GBI3D
	RET

;	Endx	GBcbiov3.asm
