assert.h
#ifndef NDEBUG
#ifndef stderr
#include <stdio.h>
#endif
#define assert(x) if (!(x)) {fprintf(stderr,"Assertion failed: x, file %s, line %d\n",__FILE__,__LINE__); exit(1);}
#else
#define assert(x)
#endif
ctype.h
/* Copyright (C) 1984 by Manx Software Systems */

extern char ctp_[];

#define isalpha(x) (ctp_[(x)+1]&0x03)
#define isupper(x) (ctp_[(x)+1]&0x01)
#define islower(x) (ctp_[(x)+1]&0x02)
#define isdigit(x) (ctp_[(x)+1]&0x04)
#define isxdigit(x) (ctp_[(x)+1]&0x08)
#define isalnum(x) (ctp_[(x)+1]&0x07)
#define isspace(x) (ctp_[(x)+1]&0x10)
#define ispunct(x) (ctp_[(x)+1]&0x40)
#define iscntrl(x) (ctp_[(x)+1]&0x20)
#define isprint(x) (ctp_[(x)+1]&0xc7)
#define isgraph(x) (ctp_[(x)+1]&0x47)
#define isascii(x) (((x)&0x80)==0)

#define toascii(x) ((x)&127)
#define _tolower(x) ((x)|0x20)
#define _toupper(x) ((x)&0x5f)
dioctl.h
/* Copyright (C) 1983 by Manx Software Systems */

#define TIOCGETP	0		/* read contents of tty control structure */
#define TIOCSETP	1		/* set contents of tty control structure */
#define TIOCSETN	1		/* ditto only don't wait for output to flush */

/* special codes for MSDOS 2.x only */
#define TIOCREAD	2		/* read control info from device */
#define TIOCWRITE	3		/* write control info to device */
#define TIOCDREAD	4		/* same as 2 but for drives */
#define TIOCDWRITE	5		/* same as 3 but for drives */
#define GETISTATUS	6		/* get input status */
#define GETOSTATUS	7		/* get output status */

struct sgttyb {
	short sg_flags;		/* control flags */
	char sg_erase;		/* ignored */
	char sg_kill;		/* ignored */
};

/* settings for flags */
#define RAW		0x20	/* no echo or mapping of input/output BDOS(6) */

/* Refer to the MSDOS technical reference for detailed information on
 * the remaining flags.
 */
errno.h
extern int errno;
extern char *sys_errlist[];
extern int sys_nerr;

/* MsDos return codes */
#define EINVAL	1
#define ENOENT	2
#define ENOTDIR	3
#define EMFILE	4
#define EACCES	5
#define EBADF	6
#define EARENA	7
#define ENOMEM	8
#define EFAULT	9
#define EINVENV	10
#define EBADFMT	11
#define EINVACC	12
#define EINVDAT	13
#define ENODEV	15
#define ERMCD	16
#define EXDEV	17
#define ENOMORE	18

/* additional codes used by Aztec C */
#define EEXIST	19
#define ENOTTY	20
/* used by the math library */
#define ERANGE	21
#define EDOM	22
fcntl.h
#define O_RDONLY	0
#define O_WRONLY	1
#define O_RDWR		2
#define O_CREAT		0x0100
#define O_TRUNC		0x0200
#define O_EXCL		0x0400
#define O_APPEND	0x0800
io.h
/* Copyright (C) 1982 by Manx Software Systems */
/*
 * if MAXCHAN is changed then the initialization of chantab in croot.c
 * should be adjusted so that it initializes EXACTLY MAXCHAN elements of 
 * the array.  If this is not done, the I/O library may exhibit
 * strange behavior.
 */
#define MAXCHAN	11	/* maximum number of I/O channels */

/*
 * argument to device routines.
 *		this is a typedef to allow future redeclaration to guarantee 
 *		enough space to store either a pointer or an integer.
 */
typedef char *_arg;

/*
 * device control structure
 */
struct device {
	char d_read;
	char d_write;
	char d_ioctl;	/* used by character special devices (eg CON:) */
	char d_seek;	/* used by random I/O devices (eg: a file) */
	int (*d_open)();	/* for special open handling */
};

/*
 * device table, contains names and pointers to device entries
 */
struct devtabl {
	char *d_name;
	struct device *d_dev;
	_arg d_arg;
};

/*
 * channel table: relates fd's to devices
 */
struct channel {
	char c_read;
	char c_write;
	char c_ioctl;
	char c_seek;
	int (*c_close)();
	_arg c_arg;
} ;
extern struct channel chantab[MAXCHAN];

struct fcb {
	char f_driv;
	char f_name[8];
	char f_type[3];
	char f_ext;
	char f_resv[2];
	char f_rc;
	char f_sydx[16];
	char f_cr;
	unsigned f_record; char f_overfl;
};

struct fcbtab {
	struct fcb fcb;
	char offset;
	char flags;
	char user;
};

#define	OPNFIL	15
#define CLSFIL	16
#define DELFIL	19
#define READSQ	20
#define WRITSQ	21
#define MAKFIL	22
#define SETDMA	26
#define GETUSR	32
#define READRN	33
#define WRITRN	34
#define FILSIZ	35
#define SETREC	36

#define Wrkbuf ((char *)0x80)
libc.h
/* Copyright (C) 1981, 1982 by Manx Software Systems */

extern int errno;
#define FLT_FAULT	0		/* vector for floating-point faults */
extern int (*Sysvec[])();

#define NULL 0
#define EOF -1
#define BUFSIZ 1024

#define _BUSY	0x01
#define _ALLBUF	0x02
#define _DIRTY	0x04
#define _EOF	0x08
#define _IOERR	0x10
#define _TEMP	0x20	/* temporary file (delete on close) */

typedef struct {
	char *_bp;			/* current position in buffer */
	char *_bend;		/* last character in buffer + 1 */
	char *_buff;		/* address of buffer */
	char _flags;		/* open mode, etc. */
	char _unit;			/* token returned by open */
	char _bytbuf;		/* single byte buffer for unbuffer streams */
	int	_buflen;		/* length of buffer */
	char *_tmpname;		/* name of file for temporaries */
} FILE;

extern FILE Cbuffs[];
extern char *Stdbufs;			/* free list of buffers */
long ftell();

#define stdin (&Cbuffs[0])
#define stdout (&Cbuffs[1])
#define stderr (&Cbuffs[2])
#define getchar() agetc(stdin)
#define putchar(c) aputc(c, stdout)
#define feof(fp) (((fp)->_flags&_EOF)!=0)
#define ferror(fp) (((fp)->_flags&_IOERR)!=0)
#define clearerr(fp) ((fp)->_flags &= ~(_IOERR|_EOF))
#define fileno(fp) ((fp)->_unit)
lmacros.h
	nlist
; Copyright (C) 1985 by Manx Software Systems, Inc.
; :ts=8
	ifndef	MODEL
MODEL	equ	0
	endif
	if	MODEL and 1
	largecode
FARPROC	equ 1
FPTRSIZE equ	4
	else
FPTRSIZE equ	2
	endif
	if	MODEL and 2
LONGPTR equ 1
	endif

;this macro to be used on returning
;restores bp and registers 
pret	macro
if havbp
	pop bp
endif
	ret
	endm

internal macro	pname
	public	pname
pname	proc
	endm

intrdef	macro	pname
	public	pname
ifdef FARPROC
	pname	label	far
else
	pname	label	near
endif
	endm

procdef	macro	pname, args
	public pname&_
ifdef	FARPROC
	_arg	= 6
	pname&_	proc	far
else
	_arg	= 4
	pname&_	proc	near
endif
ifnb <args>
	push bp
	mov bp,sp
	havbp = 1
	decll <args>
else
	havbp = 0
endif
	endm

entrdef	macro	pname, args
	public pname&_
ifdef	FARPROC
	_arg	= 6
	pname&_:
else
	_arg	= 4
	pname&_:
endif
ifnb <args>
if	havbp
	push	bp
	mov	bp,sp
else
	error must declare main proc with args, if entry has args
endif
	decll <args>
endif
	endm

;this macro equates 'aname' to arg on stack
decl	macro 	aname, type
;;'byte' or anything else
havtyp	= 0
ifidn	<type>,<byte>
	aname	equ	byte ptr _arg[bp]
	_arg = _arg + 2
	havtyp = 1
endif
ifidn	<type>,<dword>
	aname	equ dword ptr _arg[bp]
	_arg = _arg + 4
	havtyp = 1
endif
ifidn <type>,<cdouble>
	aname	equ qword ptr _arg[bp]
	_arg = _arg + 8
	havtyp = 1
endif
ifidn <type>, <ptr>
	ifdef LONGPTR
		aname	equ dword ptr _arg[bp]
		_arg = _arg + 4
	else
		aname equ	word ptr _arg[bp]
		_arg = _arg + 2
	endif
	havtyp = 1
endif
ifidn <type>, <fptr>
	ifdef FARPROC
		aname	equ dword ptr _arg[bp]
		_arg = _arg + 4
	else
		aname equ	word ptr _arg[bp]
		_arg = _arg + 2
	endif
	havtyp = 1
endif
ifidn <type>, <word>
	aname equ	word ptr _arg[bp]
	_arg = _arg + 2
	havtyp = 1
endif
ife	havtyp
	error -- type is unknown.
endif
	endm

;this macro loads an arg pointer into DEST, with optional SEGment
ldptr	macro	dest, argname, seg
ifdef	LONGPTR
	ifnb <seg>		;;get segment if specified
		ifidn <seg>,<es>
			les	dest,argname
		else
			ifidn <seg>,<ds>
				lds dest,argname
			else
				mov dest, word ptr argname
				mov seg, word ptr argname[2]
			endif
		endif
	else
		ifidn <dest>,<si>		;;si gets seg in ds
			lds	si, argname
		else
			ifidn <dest>,<di>	;;or, es:di
				les	di, argname
			else
				garbage error: no seg for long pointer
			endif
		endif
	endif
else
	mov dest, word ptr argname	;;get the pointer
ENDIF
	ENDM

decll	macro	list
	IRP	i,<list>
	decl i
	ENDM
	ENDM

pend	macro	pname
pname&_	endp
	endm

retptrm	macro	src,seg
mov	ax, word ptr src
ifdef	LONGPTR
	mov	dx, word ptr src+2
endif
	endm

retptrr	macro	src,seg
mov	ax,src
ifdef LONGPTR
	ifnb <seg>
		mov	dx, seg
	endif
endif
	endm

retnull	macro
ifdef LONGPTR
	sub	dx,dx
endif
	sub	ax,ax
 	endm

pushds	macro
	ifdef LONGPTR
	push	ds
	endif
	endm

popds	macro
	ifdef LONGPTR
	pop	ds
	endif
	endm

finish	macro
codeseg	ends
	endm

	list
codeseg	segment	byte public 'code'
	assume	cs:codeseg
math.h
double sin(), cos(), tan(), cotan();
double asin(), acos(), atan(), atan2();
double ldexp(), frexp(), modf();
double floor(), ceil(), fabs();
double log(), log10(), exp(), sqrt(), pow();
double sinh(), cosh(), tanh();

#define HUGE_VAL 1.79e+308
#define LOGHUGE	709.778
#define TINY_VAL 2.2e-308
#define LOGTINY	-708.396
memory.h
extern char *memcpy(), *memchr(), *memcpy(), memset();
extern int memcmp();
search.h
typedef	int VISIT;
#define preorder 	1
#define postorder 	2
#define endorder 	3
#define	leaf 		4
setjmp.h
/* Copyright (C) 1983 by Manx Software Systems */
#define JBUFSIZE	(6*sizeof(int))

typedef char jmp_buf[JBUFSIZE];
sgtty.h
/* Copyright (C) 1983 by Manx Software Systems */

#define TIOCGETP	0		/* read contents of tty control structure */
#define TIOCSETP	1		/* set contents of tty control structure */
#define TIOCSETN	1		/* ditto only don't wait for output to flush */

struct sgttyb {
	char sg_erase;		/* ignored */
	char sg_kill;		/* ignored */
	short sg_flags;		/* control flags */
};

/* settings for flags */
#define _VALID	0x3a
#define RAW		0x20	/* no echo or mapping of input/output BDOS(6) */
#define CRMOD	0x10	/* map input CR to NL, output NL to CR LF */
#define ECHO	0x08	/* ignored unless CBREAK is set */
#define CBREAK	0x02	/* input using BDOS(1), unless echo off then */
						/* same as RAW */
signal.h
/* Copyright (C) 1985 by Manx Software Systems, Inc. */

#define SIG_DFL	((void (*)())0)
#define SIG_IGN	((void (*)())1)
#define SIG_ERR	((void (*)())-1)

#define SIGINT	1
#define SIGTERM	2
#define SIGABRT	3
#define SIGFPE	4
#define SIGILL	5
#define SIGSEGV	6

#define _NUMSIG	6
#define _FSTSIG	1
stat.h
/* Copyright (C) 1984 by Manx Software Systems */

struct stat {
	char st_attr;
	long st_mtime;
	long st_size;
};

/* settings of the st_attr field */
#define ST_RDONLY	0x01	/* read only file */
#define ST_HIDDEN	0x02	/* hidden file */
#define ST_SYSTEM	0x04	/* system file */
#define ST_VLABEL	0x08	/* volume label */
#define ST_DIRECT	0x10	/* file is a sub-directory */
#define ST_ARCHIV	0x20	/* set when file has been written and closed */

/* the format of the st_mtime field is:
	<   year    > < month> <  day  >  < hours > <  minutes > < sec/2 >
	3 3 2 2 2 2 2 2  2 2 2 2 1 1 1 1  1 1 1 1 1 1 0 0  0 0 0 0 0 0 0 0
	1 0 9 8 7 6 5 4  3 2 1 0 9 8 7 6  5 4 3 2 1 0 9 8  7 6 5 4 3 2 1 0

where:
	year is from 0-119 for 1980-2099
	month is 1-12
	day is 1-31
	hours is 0-23
	minutes is 0-59
	sec/2 is 0-29
*/
stdio.h
/* Copyright (C) 1982, 1984 by Manx Software Systems */
#define fgetc getc
#define fputc putc
#define NULL (void *)0
#define EOF -1


#define BUFSIZ 1024
#define MAXSTREAM	20

#define _BUSY	0x01
#define _ALLBUF	0x02
#define _DIRTY	0x04
#define _EOF	0x08
#define _IOERR	0x10
#define _TEMP	0x20	/* temporary file (delete on close) */

typedef struct {
	char *_bp;			/* current position in buffer */
	char *_bend;		/* last character in buffer + 1 */
	char *_buff;		/* address of buffer */
	char _flags;		/* open mode, etc. */
	char _unit;			/* token returned by open */
	char _bytbuf;		/* single byte buffer for unbuffer streams */
	int	_buflen;		/* length of buffer */
	char *_tmpname;		/* name of file for temporaries */
} FILE;

extern FILE Cbuffs[];
FILE *fopen();
long ftell();

#define stdin (&Cbuffs[0])
#define stdout (&Cbuffs[1])
#define stderr (&Cbuffs[2])
#define getchar() agetc(stdin)
#define putchar(c) aputc(c, stdout)
#define feof(fp) (((fp)->_flags&_EOF)!=0)
#define ferror(fp) (((fp)->_flags&_IOERR)!=0)
#define clearerr(fp) ((fp)->_flags &= ~(_IOERR|_EOF))
#define fileno(fp) ((fp)->_unit)
#define fflush(fp) flsh_(fp,-1)

#define	P_tmpdir	""
#define L_tmpnam	40
time.h
/* Copyright (C) 1984, 1985 by Manx Software Systems */

#define CLK_TCK 100
typedef long time_t;
typedef long clock_t;

struct tm {
	short tm_sec;
	short tm_min;
	short tm_hour;
	short tm_mday;
	short tm_mon;
	short tm_year;
	short tm_wday;
	short tm_yday;
	short tm_isdst;
	short tm_hsec;
};

struct tm *gmtime(), *localtime();
char *asctime(), *ctime();
time_t time();
 $fldpss:%,$fldpds:%,$fldsss:%,$fldsds:%,$fstss:%,$fstds:%
	extrn $fs