
	;************************;
	;*    MATE I/O PATCH	*;
	;************************;

;REV 3.02

	;THIS VERSION IS FOR CP/M ASM
	;TO USE PASM-II, DELETE THE NEXT 5 SEMICOLONS
;	.PABS
;	.PHEX
;	.XLINK
;	.EPOP
;	ASEG

MACSZ EQU 200		;SIZE OF PERMANENT MACRO AREA
MEMMAP EQU -1		;NON-ZERO IF MEMORY MAPPED
UINIT EQU 4E59H

	ORG 109H

		;JUMP VECTORS AND USER VARIABLES
UINITL:	JMP UINIT	;USER INITIIALIZATION
UEXIT:	RET		;USER EXIT ROUTINE
	NOP
	NOP
CI:	JMP 0		;CONSOLE INPUT VECTOR
CSTS:	JMP 0		;CONSOLE STATUS VECTOR
COUT:	JMP 0		;CONSOLE OUTPUT VECTOR
LO:	JMP 0		;LIST VECTOR
LSTS:	DB 0,0,0	;LIST STATUS VECTOR
MONTR:	RET		;MONITOR VECTOR
	NOP
	NOP
KEYTAB:	DW KEYTB	;POINTER TO INSTANT COMMAND KEYSTROKE TABLE
ICSIZ:	DB 3		;SIZE OF SLOT IN TABLE
UINST:	DW UINCM	;POINTER TO TABLE OF USER DEFINED INSTANT COMMANDS
UINSZ:	DB 2		;NUMBER OF ENTRIES IN TABLE
UCOM:	DW USRCOM	;POINTER TO USER COMMAND EXECUTED BEFORE INPUT
			;OF NEXT COMMAND

		;DISPLAY PARAMATERS
TDPSZ:	DB 21		;NUMBER OF LINES IN TEXT SECTION OF DISPLAY = DPSZ-3
DPSZ:	DB 24		;TOTAL NUMBER OF LINES IN VIDEO DISPLAY
CHRLN:	DB 80		;NUMBER OF CHARACTERS IN EACH LINE
SHFTCT:	DB 1		;SIZE OF SHIFT WHEN CURSOR MOVES OFF RIGHT
			;SIDE OF SCREEN
SCRLCT:	DB 2		;MAXIMUM NUMBER OF LINES TO SCROLL USING INSERT
			;AND DELETE LINE CAPABILITIES
WANDER:	DB 4		;NUMBER OF LINES FROM CENTER CURSOR CAN WANDER
CONTXT:	DB 3		;NUMBER OF LINES REDRAWN IN FOREGROUND
NOLSTC:	DB 0		;0FFH IF LAST CHARACTER OF DISPLAY MUST BE SUPPRESSED

DOWN:	DB 0FFH		;IF SET TO 0FFH, DISPLAY PROCEEDS FROM TOP TO BOTTOM
EVRYLN:	DB 0		;IF SET TO 0FFH, DISPLAY CURSOR BEFORE DRAWING EACH LINE
BLNKCT:	DB 25		;CURSOR BLINK COUNT -- 0 FOR NO BLINK
IGNRIC:	DB 3		;IGNORE INSTANT COMMANDS IF DEEPER THAN THIS IN BUFFER

MMAP:	DB MEMMAP AND 0FFH	;-1 FOR MEMORY MAPPED DISPLAY

	IF MEMMAP	;FOR MEMMAP DISPLAY

VRAM0:	DW 0E000H	;BEGINNING OF VIDEO RAM
LSPAC:	DW 128		;SPACE BETWEEN LINES OF VIDEO RAM
DSPCUR:			;ROUTINE TO DISPLAY CURSOR AT MEMORY POINTED TO BY HL
	MOV A,M
	ORI 80H
	MOV M,A
	RET
	DS 16		;21 BYTES TOTAL

CLRCUR:			;ROUTINE TO CLEAR CURSOR FROM MEMORY POINTED TO BY HL
	MOV A,M
	ANI 7FH
	MOV M,A
	RET
	DS 16		;21 BYTES TOTAL

DSPCHR:			;ROUTINE TO STORE CHAR IN REG A IN VIDEO MEMORY
			;POINTED TO BY DE
	STAX D
	RET
	DS 19		;21 BYTES TOTAL

	ENDIF
	IF NOT MEMMAP		;FOR SERIAL TERMINAL

		;VIDEO CODES - SEQUENCES END IN 0, THEN NEXT BYTE IS NUMBER OF
		;MILLISECONDS TO DELAY
VIDCLS:	DB 26,0,0,0,0,0,0,0,0	;SEQUENCE OF BYTES THAT CLEAR SCREEN
VIDCLL: DB 27,'T',0,0,0,0,0,0,0	;SEQUENCE OF BYTES THAT CLEARS TO END OF LINE

		;CURSOR ADDRESSING
VIDASC:	DB 0		;ASCII FLAG -  -1 FOR ASCII
VIDXY:	DB 0		;XY FLAG --  0 FOR Y COORDINATE FIRST, -1 FOR X FIRST
VIDOF1:	DB 32		;OFFSET OF FIRST COORDINATE
VIDOF2:	DB 32		;OFFSET OF SECOND COORDINATE

VIDCUL:		;LEAD IN
	DB 27,'=',0,0,0,0,0,0,0
VIDCUM:		;MIDDLE
	DB 0,0,0,0,0,0,0,0,0
VIDCUE:		;END
	DB 0,0,0,0,0,0,0,0,0


VIDIL:
	DB 27,'E',0,0,0,0,0,0,0	;SEQUENCE OF BYTES THAT INSERT LINE -- END IN 0
VIDDL:
	DB 27,'R',0,0,0,0,0,0,0	;SEQUENCE OF BYTES THAT DELETE LINE -- END IN 0

	ENDIF


Z80:	DB 0FFH		;0FFH IF Z-80, 0 IF 8080
DELAY:	DB 100		;DELAY TIME FOR QD COMMAND
ABRT:	DB 'C'-40H	;ABORT CHARACTER
ICRFL:	DB 0		;0FFH IF CR'S AND TABS ARE TO BE INSERTED IN OVERTYPE

BASE:

CORBEG:	DW EDEND+MACSZ+1	;FIRST AVAILABLE CORE LOCATION
CORMX:	DW 0			;LAST AVAILABLE CORE LOCATION
GBGSZ:	DW -1000	;NEGATIVE MINIMUM SIZE OF GARBAGE AREA
TXTEND:	DW 0		;LAST LOCATION AVAILABLE FOR TEXT, REST
				;IS RESERVED FOR GARBAGE
MACBEG:	DW EDEND	;FIRST AVAILABLE LOCATION FOR PERMANENT MACROS
MACEND:	DW EDEND+MACSZ	;LAST AVAILABLE LOCATION FOR PERMANENT MACROS



		;THE FOLLOWING VARIABLES CAN BE SET BY THE Q COMMANDS

UVAR0:	DW 0		;USER DEFINABLE VARIABLES
UVAR1:	DW 0
UVAR2:	DW 0
UVAR3:	DW 0
UVAR4:	DW 0
UVAR5:	DW 0
UVAR6:	DW 0
UVAR7:	DW 0
UVAR8:	DW 0
UVAR9:	DW 0

SHFCHR:	DB 0		;UPPER OR LOWER CASE SHIFT CHARACTER
CNTCHR:	DB '^'		;CONTROL CHARACTER
PAGSZ:	DW 0		;NUMBER OF LINES IN PAGE
PAGSEP:	DB 'L'-40H	;PAGE SEPARATOR
SCRLNS:	DW 6		;NUMBER OF LINES TO SCROLL IN INSTANT COMMANDS
BKUFL:	DB 0FFH		;0FFH IF BACKUPS ARE TO BE MADE
XMAX:	DB 250		;MAXIMUM ALLOWED X CURSOR POSITION
CRCHR:	DB '<'		;DISPLAYED FOR END OF PARAGRAPH


GLBLSZ:	DW 0		;SIZE OF BLOCK FOR DISK SCROLL WRITES
GLROOM:	DW 0		;ROOM LEFT AFTER GLOBAL DISK OPERATIONS
GLINSZ:	DW 1000		;SIZE OF BLOCK WRITTEN OUT TO MAKE ROOM FOR INSERT




	;********************************;
	;*	USER INITIALIZATION	*;
	;********************************;

	ORG UINIT

	LHLD 06H	;POINTER TO BEGINNING OF FDOS
	DCX H
	SHLD CORMX	;LAST AVAILABLE CORE LOCATION
	XCHG
	LHLD GBGSZ	;NEGATIVE OF SIZE ALLOWED FOR GARBAGE AREA
	DAD D
	SHLD TXTEND

		;GET 1/4 (TXTEND-CORBEG) TO HL (ROUGHLY -- HIGH BYTE ONLY) 
	LHLD CORBEG
	LDA TXTEND+1
	SUB H
	RAR		;DIVIDE BY 2
	ANA A		;CLEAR CARRY
	RAR		;DIVIDE BY 2 AGAIN
	MOV H,A
	MVI L,0
	SHLD GLROOM	;LEAVE THAT AMOUNT OF ROOM FREE
	SHLD GLBLSZ	;AND USE SAME AMOUNT FOR SCROLL BLOCK SIZE


	LHLD 01H	;POINTER TO WARM BOOT VECTOR
	LXI D,3
	DAD D		;CONSOLE STATUS VECTOR
	SHLD CSTS+1
	DAD D
	SHLD CI+1	;CONSOLE IN VECTOR
	DAD D
	SHLD COUT+1	;CONSOLE OUT
	DAD D
	SHLD LO+1	;LIST DEVICE
	RET



	;****************************************;
	;*	USER INSTANT COMMANDS		*;
	;****************************************;

UINCM:		;TABLE OF USER INSTANT COMMAND VECTORS
	DW UIC1
	DW UIC2

UIC1:	DB 'ITHIS IS USER COMMAND NUMBER 1',13,0
UIC2:	DB 'ITHIS IS USER COMMAND NUMBER 2!!',13,0


USRCOM:		;INITIALLY EXECUTED USER COMMAND
	DB 0



	;****************************************;
	;*	INSTANT COMMAND TABLE		*;
	;****************************************;

KEYTB:
	DB 0+128	;-- MOVE TO TOP
	DB 'A'-40H	
	DB 0
	DB 0

	DB 2+128	;-- MOVE LEFT
	DB 'G'-40H	
	DB 0
	DB 0

	DB 3+128	;-- MOVE LEFT ONE WORD
	DB 'O'-40H	
	DB 0
	DB 0

	DB 4+128	;-- MOVE RIGHT
	DB 'H'-40H	
	DB 0
	DB 0

	DB 5+128	;-- MOVE RIGHT ONE WORD
	DB 'P'-40H	
	DB 0
	DB 0

	DB 26+128	;-- MOVE UP ONE LINE
	DB 'Y'-40H	
	DB 0
	DB 0

	DB 7+128	;-- MOVE UP 6 LINES
	DB 'U'-40H	
	DB 0
	DB 0

	DB 27+128	;-- MOVE DOWN ONE LINE
	DB 'B'-40H	
	DB 0
	DB 0

	DB 9+128	;-- MOVE DOWN 6 LINES
	DB 'J'-40H	
	DB 0
	DB 0

	DB 10+128	; -- DELETE CHARACTER
	DB 'D'-40H	
	DB 0
	DB 0

	DB 11+128	; -- KILL LINE
	DB 'K'-40H	
	DB 0
	DB 0

	DB 12+128	; -- GO TO INSERT MODE
	DB 'N'-40H	
	DB 0
	DB 0

	DB 13+128	; -- EDIT COMMAND
	DB '_'-40H	
	DB 0
	DB 0

	DB 14+128	; -- ABORT
	DB 'C'-40H	
	DB 0
	DB 0

	DB 15+128	; -- SHIFT CASE
	DB 'S'-40H	
	DB 0
	DB 0

	DB 16+128	; -- REFORMAT
	DB 'F'-40H	
	DB 0
	DB 0

	DB 17+128	; -- TAG
	DB 'T'-40H	
	DB 0
	DB 0

	DB 18+128	; -- DELETE WORD FORWARD
	DB 'W'-40H	
	DB 0
	DB 0

	DB 19+128	; -- DELETE WORD BACKWARD
	DB 'Q'-40H	
	DB 0
	DB 0

	DB 20+128	; -- POP GARBAGE STACK
	DB 'R'-40H	
	DB 0
	DB 0

	DB 21+128	; -- GO TO COMMAND MODE
	DB 'X'-40H	
	DB 0
	DB 0

	DB 22+128	; -- GO TO OVERTYPE MODE
	DB 'V'-40H	
	DB 0
	DB 0

	DB 23+128	; -- INSERT LINE
	DB 'L'-40H	
	DB 0
	DB 0

	DB 28+128	; -- MOVE BLOCK
	DB 'E'-40H
	DB 0
	DB 0

	DB 29+128	; -- GET BLOCK
	DB 'Z'-40H
	DB 0
	DB 0


	DB 64+128	;FIRST USER COMMAND
	DB ']'-40H
	DB '1'
	DB 0

	DB 65+128	;SECOND USER COMMAND
	DB ']'-40H
	DB '2'
	DB 0

	DB 0FFH		;END OF TABLE



;END OF EDITOR
EDEND:	DB 0

	END
     