 TITLE	'system boot strap program  5 1/4" drives'
;
;	Rev. 0.0
;	last update 06/30/83
;	Copyright (C) 1982 Jonos Ltd.
;	for 1 meg 5 1/4 drive
;	This program is located on track 0 sector 1(first sector)
;	and is loaded by the disk boot program in Eprom and run.
;	It then loads CP/M to it's address for that memory size
;	then runs it.

dboot	equ	2800h		;base address of boot
;5 1/4" drive i/o ports
dmacm5	equ	0d8h	;DMAC mode/staus port 5 1/4" drive
dma0ad5	equ	0d0h	;DMAC dma address port 5 1/4" drive
dma0tc5	equ	0d1h	;DMAC terminal count port 5 1/4" drive
fdcd5	equ	0c1h	;FDC data port 5 1/4" drive
fdcsr5	equ	0c0h	;FDC status register port 5 1/4" drive
intsp5	equ	0c2h	;FDC interrupt/motor port 5 1/4" drive
;
	org	dboot	;
;
	lxi	sp,stktop	;load stack pointer
;
boot5:	call	spec5	;
	xra	a	;zero a reg
	sta	hstdsk	;disk 0
	sta	hsttrk	;track 0
	sta	hstsec	;set sector
	lxi	h,4000h-1024	;set dma adress ccp
	shld	dmaad	;set 
rdtrk5:	call	readhst	;read track 5 1/4"
	lda	erflag	;get error status
	ora	a	;see if error
	jnz	boot5	;try again
	mvi	a,04h	;
	sta	hstsec	;
	lhld	dmaad	;
	lxi	d,1024*4
	dad	d	;
	shld	dmaad	;
	call	readhst	;read track 5 1/4"
	lda	erflag	;get error status
	ora	a	;see if error
	jnz	boot5	;try again
	mvi	a,01	;
	sta	hsttrk	;
	xra	a	;sector 1
	sta	hstsec	;
	lhld	dmaad	;
	lxi	d,1024*4
	dad	d	;
	shld	dmaad	;
	call	readhst	;read track 5 1/4"
	lda	erflag	;get error status
	ora	a	;see if error
	jnz	boot5	;try again
	mvi	a,04h	;
	sta	hstsec	;
	lhld	dmaad	;
	lxi	d,1024*4
	dad	d	;
	shld	dmaad	;
	call	readhst	;read track 5 1/4"
	lda	erflag	;get error status
	ora	a	;see if error
	jnz	boot5	;try again
	jmp	4000h	;go to cpmldr
;
;
;
;actual i/o 5 1/4" drive

readhst:
	;perform read operation 
	call	seekcl5	;seek track
	lxi	h,04fffh;set read 4K bytes
	shld	dmaset	;store dma count
	lxi	h,comtb	;point to command table
	mvi	m,0c6h	;load read command mfm mode
	jmp	waitio5	;to perform the actual i/o
;
writehst:
	;perform a write operation
	call	seekcl5	;seek track
	lxi	h,09fffh;set write 8K bytes
	shld	dmaset	;store dma count
	lxi	h,comtb	;point to command table
	mvi	m,0c5h	;load write command
;
;enter here from read or write to perform the actual i/o 
;for 5" drive
;			the disk number in 'hstdsk' (0,1)
;			the track number in 'hsttrk' (0-80)
;			the sector number in 'hstsec' (0-3)
;			the dma address in 'hstbuf' (0-65535)
waitio5:
	inx	h	;point to next location in memory
	lda 	hstsec	;get sector #
	cpi	04h	;see if side #1
	lda	hstdsk	;get drive #
	jc	side0	;jump if side #0
	ori	04h	;side side #1 bit
side0:	mov	m,a	;store command in table
	inx	h	;next command word storage
	lda	hsttrk	;get track #
	mov	m,a	;store in table
	inx	h	;next
	mvi	b,00h	;load b zero for head 0
	lda	hstsec	;get sector # to read or write
	cpi	04h	;see if side #1
	jc	nots1	;jump if side #0
	sui	04h	;get sector # for side 2
	inr	b	;see for haed #1
nots1:	mov	m,b	;store in command table
	inx	h	;point to next command byte
	mov	m,a	;store in command table
	inx	h	;next
	mvi	m,03h	;set n=3 for 1024 bytes
	inx	h	;next	
	mvi	m,04h	;8 secotrs per track
	inx	h	;next
	mvi	m,80h	;gap =53
	inx	h	;next
	mvi	m,0ffh	;DTL
	mvi	a,10	;store retry count
	sta	retry	;store
erloop5:	;loop to here if to try again
	lhld	dmaset	;get dma count
	mov	a,l	;get lsb
	out	dma0tc5	;output terminal count
	mov	a,h	;get msb
	out	dma0tc5	;output terminal count
	lhld	dmaad	;get dma address
	mov	a,l	;get lsb
	out	dma0ad5	;output to dma contoller
	mov	a,h	;get msb
	out	dma0ad5	;output to dma controller
	mvi	a,41h	;enable dma controller
	out	dmacm5	;output
	lxi	h,comtb	;point to command table
	mvi	c,9	;load byte count for command write
	call	wfdcc5	;write command
	call	polli5	;poll interrupt status till done
	call 	result5 	;read result
	lda	rbuf	;get status byte #0
	ani	0d8h	;mask bits
	jnz	rty5	;retry i f error
	lda	rbuf+1	;get status byte #1
	ani	7fh	;mask status bytes
	jz	dtest5	;return no errors
rty5:	lda	rbuf+2	;get status byte
	ani	10h	;see if seek error
	jz	sectry	;return with error if not seek
	lda	seeker	;see if second time 
	ora	a	;set flags
	jnz	sectry	;set error and retrun
	mvi	a,0ffh	;set flag
	sta	seeker	;
	lda	comtb	;get command type
	sta	temp	;store temp
	call	home15	;home disk
	lda	temp	;get command type
	cpi	0c5h	;see if write
	jz	writehst;try 10 more times
	jmp	readhst	;try 10 more times
sectry:	lda	retry	;get retry count
	dcr	a	;-1
	sta	retry	;stroe for retry
	jnz	erloop5	;loop till no error or 5 trys
	xra	a	;zero a register
	sta	seeker	;reset seek error stat
	mvi	a,01h	;load error code
	sta	erflag	;
	ret
;
;if command was write delay for tunnel erase	
dtest5:	xra	a	;zero a reg
	sta	seeker	;reset error flag
	sta	erflag	;
	mov	b,a	;zero b for error status 
	lda	comtb	;load frist byte command table
	cpi	0c5h	;see if write command
	mov	a,b	;get error status
	rnz		;return if not write
	mvi	a,0b0h	;get delay count
delay5:	dcr	a	;bump count
	jnz	delay5	;
	xra	a	;get status
	sta	erflag	;
	ret
;
;
spec5:		;set head unload time, head load
			;time, step rate
	lxi	h,spctb5;load pointer to command table
	mvi	c,03h	;load byte count
	call	wfdcc5	;write command to controller
	ret		;return
spctb5:			;specify prams. table
	db	03h	;command
	db	0efh	;step rate 3ms, head unload 240ms
	db	0ch	;head load time 50ms,dma mode
;
home15:			;home disk drive in hstdsk
	lxi	h,comtb+1	;load pointer command table
	lda	hstdsk	;get disk to home
	mov	m,a	;put in table
	dcx	h	;point to next buffer location
	mvi	m,07h	;load recalibrate command
	mvi	c,2	;load byte count for command write
	call	wfdcc5	;write command
	call	polli5	;poll interrupt status
	call	sic5	;call sense interrupt command
	ret		;return when have good home
;
seekcl5:		;seek the track in track loc.
	lda	hsttrk	;get trak to seek
	ora	a	;see if track 0
	jz	home15	;home if track 0
	lxi	h,comtb+2	;point to command table
	mov	m,a	;store track to seek
	dcx	h	;point next location
	lda	hstdsk	;get disk #
	mov	m,a	;store command in table
	dcx	h	;point next location
	mvi	m,0fh	;load seek command
	mvi	c,3	;set byte count for command write
	call	wfdcc5	;write command
	call	polli5	;wait till done
	call	sic5	;sense interrupt status command
	ret
;
sic5:			;sense interrupt command
	lxi	h,sictb5;load pointer command table
	mvi	c,1	;load byte count
	call	wfdcc5	;write command to FDC
	lxi	h,rbuf	;load pointer result storage
	mvi	c,2	;load byte count for result read
	call	rest15	;read result in to buufer
	ret		;return	
sictb5:			;sense interrupt command table
	db	08h	;command
;
;
polli5:			;poll interrupt pin FDC
	in	intsp5	;input status 
	ral		;test bit 7
	jnc	polli5	;loop till interrupt pin true
	ret		;return when true
;
result5:			;read result phase FDC
	lxi	h,rbuf	;load pointer Result BUFfer
	mvi	c,7	;load byte count for read/write 
	call	rest15	;read result
	ret		;return
rest15:	
	in	fdcsr5	;input FDC status reg.
	ral		;test bit 7
	jnc	rest15	;loop till ready
	in	fdcd5	;input result read data
	mov	m,a	;put in buffer
	inx	h	;bump pointer
	dcr	c	;dec byte count
	rz		;return if done
	jmp	rest15	;loop till all bytes read
;
wfdcc5:			;write command to FDC
	in	fdcsr5	;input status
	ral		;test bit 7
	jnc	wfdcc5	;loop till ready
	mov	a,m	;get command byte
	out	fdcd5	;output to FDC
	inx	h	;bump command pointer
	dcr	c	;dec byte counter
	rz		;return when done
 	jmp	wfdcc5	;loop till all bytes output
	ret
;
;
;	
;
;	scratch ram area
;	
worksp:	org	$
;
comtb:	ds	9	;command table storage
retry:	ds	1	;retry count
rbuf:	ds	7	;result buffer
dmaad:	ds	2	;dma address 
seeker:	ds	1	;seek error try flag
temp:	ds	1	;temp storage
dmaset:	ds	2	;dma address for 5 1/4" drive
erflag:	ds	1	;error reporting
;
;
hstdsk:	ds	1	;5 1/4" disk number
hsttrk:	ds	2	;5 1/4" track number
hstsec:	ds	1	;5 1/4" sector number
;
stack:	ds	64	;room for stack
stktop	equ	$	;top of stack
	end
 