


*****************************************************************
*								* 
*    MORROW 68K SYSTEM MEMORY TEST REV 0.			* 
*								*
*    initial coding:  5/3/84 -bjg-				*
*      								* 
*****************************************************************

ioaddr	=	$ff0000			* compupro i/o address space


*  Compupro interfacer IV equates

sio	=	ioaddr+$10		* interfacer base address
siostat	=	sio+$1			* uart status
siodat  =	sio			* uart data 
select	=	sio+$7			* group select port
console =	7			* interface left port

*   mult i/o equates

base	=	ioaddr+$48		* standard base address
grpctl	=	base+$7			* select port
dll	=	base			* divisor latch lsb
dlm	=	base+$1			* divisor latch msb
ier	=	base+$1			* interrupt enable register
lcr	=	base+$3			* line control register
mcr	=	base+$4			* modem control register
lsr	=	base+$5			* line status register 
rbr	=	base			* receive buffer register
thr	=	base			* trasnmitter holding register

dlab	=	$80			* divisor latch access bit
thre	=	$20			* transmitter hold reg empty status
dr	=	$1			* received data ready status



*  miscellaneous equates

alf	=	$a			* ascii line feed
acr	=	$d			* ascii carriage return
asp	=	$20			* ascii space
acs	=	$1a			* ascii clear for ADM31
qpat	=	$AA55			* initial ram test pattern
spat	=	$00ff	 		* marching pattern
stop	=	$F0000			* end of 2 Meg ramtest area
page	=	1024			* 2K X 8 ram chips
image	=	0

* 	PRINT SIGNON

init:	move.l	#$500,a7		* set up stack pointer
	bsr	acrlf
	move.w	#$09,d0
	move.l	#signon,d1
	trap	#$2
	bsr	acrlf
	bsr	acrlf
	bsr	clear
	jmp	scan

clear:  move.l	#image,a0		* beginning of image
	move.l	#1024+image,d0		* image ram count
	move.b	#'-',d1			* no ram initial value
clear1:	move.b	d1,(a0)+		* initialize and increment
	cmp.l	a0,d0
	bne	clear1
	move.b  #'P',image		* first 2K for program
	rts

*  QUICK CHECK OF RAM WITH 'AA' PATTERN

scan:   move.l	#$800,a0		* ram start address
	move.l	#image+1,a1		* beginning of result map
	move.l	#stop,a2		* stop address
	move.w	#qpat,d0		* quick pattern
	move.w	#page,d7		* resolution of 1K word increments

qloop:	move.w	d0,(a0) 		* write pattern to ram
	cmp.w	(a0)+,d0		* read back and increment
	bne	qerror			* leave on error

cont1: 	subq.w	#1,d7			* keep track of 2 k boundary
	bne	cont3
	move.b	#'G',d2			* mark it good
	move.b	d2,(a1)+
cont2:	move.w	#page,d7		* initialize page counter
cont3:	cmpa.l	a2,a0			* check for last memory location
	bne	qloop			* loop till done
	bsr	prnmap			* print results
	jmp	minit			* go to marching ones

qerror:	addq.l	#1,a1			*increment image map
	move.l	a0,d6
	andi.l	#$fffff800,d6		* page mask
	move.l	d6,a0
	add.l	#2048,a0		* point to next page
	jmp	cont2			* continue on to next page


*    MARCHING BIT PATTERN test

minit:	move.w	#spat,d4		*  pattern
	move.w  d4,d4save		* save it for readback

* come here after completing the readback check

minit1:	move.l	#$800,a0		* ram start address
	move.l	#image+1,a1		* beginning of result map
	move.l	#stop,a2		* stop address

* enter here for each writing of 2048 bytes

check:	move    d4save,d4		* get pattern
	move	#page,d7		* init page counter
	cmpi.b	#'G',(a1)		* check for ram present
	beq	march
	addq.l	#1,a1			*increment image map
	move.l	a0,d6
	andi.l	#$fffff800,d6		* page mask
	move.l	d6,a0
	add.l	#2048,a0		* point to next page	
	cmpa.l	a0,a2
	bge	read0

* come here to write each word

march:  rol.w	#1,d4			* march the pattern...shift 
	move.w	d4,(a0)+ 		* write pattern to ram

march1: subq.w	#1,d7			* keep track of 1K word boundary
	bne	march3
	addq.l	#1,a1			* increment the image counter
	jmp	check

march3:	cmpa.l	a2,a0			* check for last memory location
	bne	march			* loop till done writing



* enter here each time a write pass completed

	bsr	crlf
	bsr	crlf
	bsr	crlf
	bsr	crlf
	


read0:	move.w  d4save,d4		* retrieve pattern
	move.l	#$800,a0		* ram start address
	move.l	#image+1,a1		* beginning of result map
	move.l	#stop,a2		* stop address

* enter here every 2048 bytes

read1:	move.w	#page,d7		* set the page counter
	move.w	d4save,d4		* get the start pattern
	cmpi.b	#'G',(a1)		* check for ram present
	beq	read2
	addq.l	#1,a1			*increment image map
	move.l	a0,d6
	andi.l	#$fffff800,d6		* page mask
	move.l	d6,a0
	add.l	#2048,a0		* point to next page	
	cmpa.l	a0,a2
	bge	read6


* read 2048 bytes worth of data

read2:  rol.w	#1,d4			* march the pattern...shift 
	cmp	(a0)+,d4 		* read pattern from ram
	bne	merror
	
read3:  subq.w	#1,d7			* keep track of 1K word boundary
	bne	read5
	add.l	#1,a1
	jmp 	read1

* check for top of memory

read5:	cmpa.l	a2,a0			* check for last memory location
	bne	read2			* loop till done

read6:	bsr	prnmap		        * pass finished, print results
	move.w	d4save,d4		* get old pattern
	jmp	minit1			* do it all again

* come here on marching bit readback errors

merror:	move.b	#'?',(a1)+		* mark with good now bad flag	
	move.l	a0,d6
	andi.l	#$fffff800,d6		* page mask
	move.l	d6,a0
	add.l	#2048,a0		* point to next page
	cmpa.l	a2,a0			* check for top of ram
	bne	erret
	jmp	read6
erret:	jmp	read1			* continue on to next page



*  PRINT A CARRIAGE RETURN / LINE FEED through CP/M

acrlf:	move.w	#$02,d0
	move.w	#acr,d1			
	trap	#$2			* call bdos
	move.w	#$02,d0
	move.w	#alf,d1
	trap	#$2			* call bdos	
	rts


* PRINT A CARRIAGE RETURN / LINE FEED through direct I/O

crlf:	move.b	#acr,d1
	bsr	conout
	move.b	#alf,d1
	bsr	conout
	rts


*  PRINT A SPACE through CP/M

aspace: move.w	#$02,d0
	move.w	#asp,d1
	trap	#$2			* call bdos
	rts


*  PRINT A SPACE through direct I/O

space:  move.b	#asp,d1
	bsr	conout
	rts

* print the map (a0,d0-d4 corrupted)

prnmap: move.l	#image,a0		* beginning of image
	move.l	#1024+image,d2		* image ram count
	move.b	#8,d3			* groups of  8
	move.b	#$40,d4			* 64 characters per line
pmap1:	move.b	(a0)+,d1		* get test results 
	bsr	conout			* print it
	sub.b	#1,d3			* check for 4 printed
	bne	pmap2			* if so print a space
	bsr	space
	move.b	#8,d3			* start count over
pmap2:	sub.b	#1,d4			* check for end of line
	bne	pmap3			* if so, print a crlf 
	bsr	crlf
	move.b	#$40,d4
pmap3:	cmp.l	a0,d2			* check for end
	bne	pmap1			* loop till done
	bsr	crlf
	bsr	crlf
	rts

constat:
	move.b	#console,select		* select uart
	move.b	siostat,d0		* get status
	andi.w	#2,d0			* check for data available
	bne	conin			* branch if data available
	moveq	#0,d0			* else set result false
	rts

* return with character in the d0 register

conin:  move.b 	#console,select		* select uart
	move.b	siostat,d0		* read status
	andi.w	#2,d0			* check for data available
	beq	conin			* loop till key pressed
	move.b	siodat,d0			* get the character
	and.l	#$7f,d0			* strip bit 7
	rts			


* print character in the d1 register

conout: move.b	#console,select		* select uart
	move.b	siostat,d0		* read status
	and.b	#$1,d0			* check for tbe flag true
	beq	conout			* loop till true
	move.b	d1,siodat		* send the data
	rts





signon:	.dc.b	'Morrow 68k system memory test Version 0 $'


d4save	.dc.w	$00ff
	
ecode:	.ds.l	$
	.end
