	page
	If	C8080
;	MOVDTA	- Move data in memory.
;
;	ENTRY	C = number of bytes to move
;		DE = destination address.
;		HL = source address.

MOVDTA:
	MOV	A,M		;Source character
	STAX	D		;to destination
	INX	H
	INX	D
	DCR	C		;loop 128 times
	JNZ	MOVDTA		;If transfer not complete
	RET
	ENDIF
	space	4,10
;	Check blocked disk transfer.
;
;	EXIT	Cbit set, unblocked device.
;		Cbit clear, blocked device.

CHKBKD:
	XRA	A
	STA	ERFLAG		;Clear error flag
	LDA	SEKTYP
	CPI	DSKD1
	JC	CBKD2		;If not blocked device
	CPI	MAXFTP+1
	JNC	CBKD1		;If hard disk
	LHLD	SEKTRK
	MOV	A,H
	ORA	L
	MVI	A,DSKS1		;A = Single density
	JZ	CBKD2		;If zero force non-blocked

CBKD1:	LDA	SAVSEC
	STA	SEKSEC
	XRA	A		;Clear carry flag
	RET

SETACT:	LDA	SEKTYP
CBKD2:	STA	ACTTYP		;Set actual disk type
	LHLD	DMAADR
	SHLD	BUFADR
	LDA	DMAADE
	STA	BUFADE

	LDA	SEKDSK
	STA	ACTDSK
	LHLD	SEKTRK
	SHLD	ACTTRK
	LDA	SAVSEC
	STA	ACTSEC
	STC			;Set carry flag
	RET
	space	4,10
;	Delay	Delay the millisecond count contained in BC.
;
;	Destroys  A and flags.

DELAY:	MVI	A,DELCNT/26
DLAY1:	DCX	B
	INX	B
	DCR	A
	JNZ	DLAY1		;If not 1 millisecond
	DCX	B
	MOV	A,C
	ORA	B
	JNZ	DELAY		;If not desired count
	RET
	space	4,10
;	Print message terminated by zero byte.
;
;	ENTRY	HL -> message buffer, terminated by zero.
;
;	EXIT	HL -> zero byte + 1.
;		A = 0.
;		Z bit set.
;
;	Destroys only HL, Flags, and A registers.

PRINT:	MOV	A,M		;Get a character
	ORA	A
	INX	H
	RZ			;If zero the terminate
	PUSH	B
	MOV	C,A
	CALL	J.COUT		;Output to the console
	POP	B
	JMP	PRINT
