
		org	00100h

dog:		lxi	h,0
		call	rand
		rst	7
		jmp	dog

;
;	RAND - Psuedo random number generator
;
;	usage:	call	rand
;
;	entry:	hl has new seed or 0 to use last random
;		number generated as the seed
;
;	exit:	hl has random number
;
;	zaps:	a,bc,de,hl
;

PRIME1		equ	5
PRIME2		equ	3

rand:
		mov	a,h
		ora	l
		jnz	rand1
		lhld	seed
rand1:
		mov	a,h
		ora	l
		jnz	rand2
		inx	h
rand2:
		xchg
		lxi	b,PRIME1
		call	mpy
		lxi	d,PRIME2
		dad	d
		shld	seed
		ret

seed:		dw	1237


;
;	MPY - Multiply bc by de results in hl
;

mpy:
		ora	a
		lxi	h,0
mpy1:
		mov	a,b		; bc >>= 1
		rar
		mov	b,a
		mov	a,c
		rar
		mov	c,a
		jnc	mpy2
		dad	d
mpy2:
		xchg
		dad	h
		xchg
		mov	a,b
		ora	c
		jnz	mpy1
mpy3:
		ret


;
;	DIV - Divide N (de) by D (bc) result in hl
;

div:
		mov	a,b		; negate D
		cma
		mov	b,a
		mov	a,c
		cma
		mov	c,a
		inx	b

		lxi	h,0		; clear remainder
		mvi	a,16		; bit count
div1:
		dad	h		; shift R
		xchg
		dad	h		; shift N
		xchg
		jnc	div2		; propagate bit to R
		inx	h
div2:
		push	h		; save current R
		dad	b		; try to subtract D from R
		jnc	div3		; jump if subtract failed 
		xthl			; else save new R
		inx	d		; increment Q
div3:
		pop	h		; restore R
		dcr	a
		jnz	div1
		xchg			; R to de, Q to hl
		ret


;
;	MODULO - Mod N (de) by D (bc) result in hl
;

modulo:
		call	div
		xchg
		ret


