0 'save "GETCLOCK.BAS",A	'11/01/84

 
10 '	Here are some sub-routines written in MicroSoft Basic
11 '	to access the Godbout/CompuPro System Support 1 Clock.
12 '	An example is shown using the sub-routines.  A typical
13 '	routine to set the clock through basic is also included.
14 '
15 '	In the clock set sub-routine you must furnish the digit
16 '	address you wish to set as DIGIT.ADDRESS% and the value
17 '	you wish to set to as INFO%.
18 '
19 '	The variables REED%, WRIT%, and HOLD% have been defined
20 '	external to the Sub-Routines.
21 '
22 '	Questions may be addressed to:
23 '
24 '		Keith W. Antcliff
25 '		P.O. Box 906
26 '		Mead, WA 99021
27 '		(509) 466-5187
99 '

	< Define Some Variables >

 
100 REED% = &H10		' Read bits  = 0001 0000
110 WRIT% = &H20		' Write bits = 0010 0000
120 HOLD% = &H40		' Hold bits  = 0100 0000
999 '

	< Main Module >

 
1000 GOSUB 5000			' Returns Day Of Week in WEEK.DAY$
1010 GOSUB 3000			' Returns Date as MM/DY/YR in DATE$
1020 GOSUB 4000			' Returns Time as HR:MN:SE in TIME$
1030 PRINT WEEK.DAY$;"...";DATE$;"..."TIME$
1040 END
1999 '

	<Register Correspondence With Date>

 
2000 '                   M M / D D / Y Y
2010 '                   | |   | |   | |
2020 '    &HA------------+ |   | |   | +-----------&HB
2030 '    &H9--------------+   | |   +-------------&HC
2040 '  # &H8------------------+ +-----------------&H7
2050 '
2060 '  # 3 2 1 0 (Bits of Lower Nibble)
2070 '
2080 '    Bit 2 = Leap Year Bit
2090 '    Bit 3 = 1 then February will have 29 days
2100 '
2110 '    Day of Week = &H6
2120 '                   H R / M N / S E
2130 '                   | |   | |   | |
2140 '  * &H5------------+ |   | |   | +-----------&H0
2150 '    &H4--------------+   | |   +-------------&H1
2160 '    &H3------------------+ +-----------------&H2
2170 '
2180 '  * 3 2 1 0 (bits of lower nibble)
2190 '
2200 '    Bit 3 = "0" for 12 Hour Format, "1" for 24 Hour Format
2210 '    Bit 2 = "0" for AM, "1" for PM (in 12 Hour Format)
2220 '    Bit 1 = Always zero in 12 Hour Format, else MSB of Digit
2230 '    Bit 0 = LSB of digit in either Format
2240 '
2250 '    These Special Bits Require Masking When Reading
2999 '

	<Get The Date From The System Support 1 Board>

 
3000 CMND%=&H5A: DTA%=&H5B
3010 OUT CMND%,REED% + &HA: DATE$=CHR$(INP(DTA%)+48)
3020 OUT CMND%,REED% + &H9: DATE$=DATE$+CHR$(INP(DTA%)+48)+"/"
3030 OUT CMND%,REED% + &H8: DATE$=DATE$+CHR$((INP(DTA%) AND 3)+48)
3040 OUT CMND%,REED% + &H7: DATE$=DATE$+CHR$(INP(DTA%)+48)+"/"
3050 OUT CMND%,REED% + &HC: DATE$=DATE$+CHR$(INP(DTA%)+48)
3060 OUT CMND%,REED% + &HB: DATE$=DATE$+CHR$(INP(DTA%)+48)
3070 RETURN
3999 '

	<Get The Time From The System Support 1 Board>

 
4000 CMND%=&H5A: DTA%=&H5B
4010 OUT CMND%,REED% + &H5: TIME$=CHR$((INP(DTA%) AND 3)+48)
4020 OUT CMND%,REED% + &H4: TIME$=TIME$+CHR$(INP(DTA%)+48)+":"
4030 OUT CMND%,REED% + &H3: TIME$=TIME$+CHR$(INP(DTA%)+48)
4040 OUT CMND%,REED% + &H2: TIME$=TIME$+CHR$(INP(DTA%)+48)+":"
4050 OUT CMND%,REED% + &H1: TIME$=TIME$+CHR$(INP(DTA%)+48)
4060 OUT CMND%,REED% + &H0: TIME$=TIME$+CHR$(INP(DTA%)+48)
4070 RETURN
4999 '

	<Use This If You Want Day Of Week>

 
5000 CMND%=&H5A: DTA%=&H5B
5010 DATA Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday
5020 DIM DAY$(6): FOR I%=0 TO 6: READ DAY$(I%): NEXT I%
5030 OUT CMND%,REED% + &H6: D%=INP(DTA%): WEEK.DAY$=DAY$(D%)
5040 RETURN
5999 '

	< Typical Routine To WRITE The Clock >

 
6000 CMND%=&H5A: DTA%=&H5B
6010 OUT CMND%,HOLD%
6020 OUT CMND%,HOLD% + DIGIT.ADDRESS%
6030 OUT DTA%,INFO%
6040 OUT CMND%,HOLD% + WRIT% + DIGIT.ADDRESS%
6050 OUT CMND%,HOLD% + DIGIT.ADDRESS%
6060 OUT CMND%,0
6070 RETURN
A%,