-ARCHIVE- \checkfd.c 259
/*	check a file descriptor and return control block address
*/

#include "fileio.h"

_checkfd(fildes)
unsigned fildes;
{
  struct bufstr *buf;

  if(fildes<MAXFILES && (buf=_opentab[fildes]))return buf;
  bdos(9,"BAD FILE$");
  _exit(0x8001);
}
-ARCHIVE- \fmtin.c 5299
/*	format data into memory - used by scanf et al
*/

/*	remove the definition EXTENDED to remove extended features
*/

#define EXTENDED

#include "stdio.h"

union ptr_union{
  char *scp;
  unsigned char *ucp;
  int *sip;
  unsigned *uip;
  long *slp;
  unsigned long *ulp;
  float *sfp;
  double *sdp;
};

/*	read the next character for _fmtin
*/

static int ic;			/* the current character */
static unsigned char *rnc_arg;
static unsigned rnc_code;

static rnc()
{

  ic=0;
  if(rnc_code){if(!(ic=*rnc_arg++))ic=EOF;}
  else if(read(rnc_arg-0x8000,&ic,1)!=1)ic=EOF;
}

/*	unget the current character
*/

static ugc()
{

  if(rnc_code)--rnc_arg;
  else ungetc(ic,rnc_arg);
}

/*	makes it shorter
*/

static iswhite(cc)
int cc;
{

  return (cc==' ' || cc=='\t' || cc=='\n' || cc=='\r');
}

/*	format a string
*/

_fmtin(code,funarg,format,argp)
int code;			/* function to get a character */
unsigned funarg;		/* an argument for the function */
unsigned char *format;		/* the format control string */
union ptr_union *argp;		/* our argument list */
{
  int count=0;			/* number of items done */
  int base;			/* conversion base */
  long val;			/* an integer value */
  double dval;			/* the same for double */
  double power;			/* for exponent conversion */
  int sign;			/* sign flag */
  int do_assgn;			/* assignment suppression flag */
  unsigned width;		/* width of field */
  int widflag;			/* width was specified */
  int longflag;			/* true if long */
  int sav_ic;
  int sav_arg;
  int sav_cod;
  int fflag;
  int dataflag;			/* true if we have seen some data */

  sav_ic=ic;
  sav_arg=rnc_arg;
  sav_cod=rnc_code;
  rnc_arg=funarg;
  rnc_code=code;
  rnc();			/* read the next character */
  while(1){
    while(iswhite(*format))++format;	/* skip whitespace */
    if(!*format)goto all_done;		/* end of format */
    if(ic<0)goto quit;			/* seen an error */
    if(*format!='%'){
litmatch:
      while(iswhite(ic))rnc();
      if(ic!=*format)goto all_done;
      ++format;
      rnc();
      ++count;
      continue;
    }
    ++format;
    do_assgn=1;
    if(*format=='*'){++format;do_assgn=0;}
    if(isdigit(*format)){
      widflag=1;
      for(width=0;isdigit(*format);)width=width*10+*format++-'0';
    } else widflag=0;		/* no width spec */
    if(longflag=(tolower(*format)=='l'))++format;
#ifdef EXTENDED
    else if(*format=='h')++format;
#endif
    if(*format!='c')while(iswhite(ic))rnc();
    dataflag=0;				/* not seen nothing yet */
    switch(*format){
      case 'B':
	longflag=1;
      case 'b':
	base=2;
	goto decimal;
      case 'O':
	longflag=1;
      case 'o':
	base=8;
	goto decimal;
      case 'D':
	longflag=1;
      case 'd':
	base=10;
	goto decimal;
      case 'X':
	longflag=1;
      case 'x':
	base=16;
	if(((!widflag) || width>=2) && ic=='0'){
	  dataflag=1;
	  --width;
	  rnc();
	  if(tolower(ic)=='x'){
	    --width;
	    rnc();
	  }
	}
decimal:
	val=0;				/* our result value */
	sign=0;				/* assume positive */
	if(!widflag)width=0xffff;	/* very wide */
	if(width && ic=='-'){
	  sign=1;
	  rnc();
	}
	while(width--){
	  if(isdigit(ic) && ic-'0'<base)ic-='0';
	  else if(base==16 && tolower(ic)>='a' && tolower(ic)<='f')
	    ic=tolower(ic)-87;
	  else break;
	  val=val*base+ic;
	  rnc();
	  dataflag=1;
	}
	if(do_assgn){
	  if(sign)val=-val;
	  if(longflag)*(argp++)->ulp=val;
	  else *(argp++)->uip=val;
	}
	if(dataflag)++count;
	else goto all_done;
	break;
      case 'c':
	if(!widflag)width=1;
	while(width-- && ic>=0){
	  if(do_assgn)*(argp++)->ucp++=ic;
	  rnc();
	  dataflag=1;
	}
	if(dataflag)++count;
	break;
      case 's':
	if(!widflag)width=0xffff;
	while(width-- && !iswhite(ic) && ic>0){
	  if(do_assgn)*argp->ucp++=ic;
	  rnc();
	  dataflag=1;
	}
	if(do_assgn)*(argp++)->ucp=0;	/* terminate the string */
	if(dataflag)++count;
	else goto all_done;
	break;
      case 'E':
      case 'F':
	longflag=1;
      case 'e':
      case 'f':
	if(!widflag)width=0xffff;
	dval=0.0;
	if(width && ic=='-'){
	  --width;
	  sign=1;
	  rnc();
	  dataflag=1;
	} else sign=0;
	if(!width)goto store_fe;
	base=0;
	fflag=1;
	while(width--){
	  if(isdigit(ic))dval=dval*10.0+(ic-'0');
	  else if(ic=='.' && fflag)fflag=base=0;
	  else break;
	  dataflag=1;
	  --base;
	  rnc();
	}
	if(fflag)base=0; else ++base;
	if(sign)dval=-dval;
	if(tolower(ic)=='e' && width){
	  rnc();
	  if(!--width)goto store_fe;
	  if(!width)goto store_fe;
	  if(ic=='-'){fflag=1;--width;rnc();}
	  else {fflag=0;if(ic=='+'){--width;rnc();}}
	  for(val=0;width && isdigit(ic);--width){val=val*10+(ic-'0');rnc();}
	  if(fflag)base=base-val;
	  else base=base+val;
	}
	sign=1;
	if(base<0)base=-base; else sign=0;
	for(power=10;base;base>>=1){
	  if(base&1)
	    if(sign)dval=dval/power;
	    else dval=dval*power;
	  power=power*power;
	}
store_fe:
	if(do_assgn)
	  if(longflag)*(argp++)->sdp=dval;
	  else *(argp++)->sfp=dval;
	if(dataflag)++count;
	else goto all_done;
	break;
    }
    ++format;
  }
all_done:
  if(ic>=0)ugc();			/* restore the character */
quit:
  ic=sav_ic;
  rnc_arg=sav_arg;
  rnc_code=sav_cod;
  return count;
}
-ARCHIVE- \fmtout.c 6447
/*	format data under control of a format string
*/

/*	to remove the floating point code, comment out
	the definition of FLOATS
*/

#define FLOATS

/*	to remove the extensions added to K&R, comment out
	the definition of EXTENDED
*/

#define EXTENDED

/*	increased accuracy power of ten table
*/

static unsigned int pgiten[]={
	0X0000,0X0000,0X0000,0X4024,		/* 1e1 */
	0X0000,0X0000,0X0000,0X4059,		/* 1e2 */
	0X0000,0X0000,0X8800,0X40C3,		/* 1e4 */
	0X0000,0X0000,0XD784,0X4197,		/* 1e8 */
	0X8000,0X37E0,0XC379,0X4341,		/* 1e16 */
	0X6E17,0XB505,0XB8B5,0X4693,		/* 1e32 */
	0XF9F6,0XE93F,0X4F03,0X4D38,		/* 1e64 */
	0X1D33,0XF930,0X7748,0X5A82,		/* 1e128 */
	0XBF3F,0X7F73,0X4FDD,0X7515		/* 1e256 */
};
static double *pgten=pgiten;

static unsigned int pliten[]={
	0X999A,0X9999,0X9999,0X3FB9,		/* 1e-1 */
	0X147B,0X47AE,0X7AE1,0X3F84,		/* 1e-2 */
	0X432D,0XEB1C,0X36E2,0X3F1A,		/* 1e-4 */
	0X8C3A,0XE230,0X798E,0X3E45,		/* 1e-8 */
	0X89BC,0X97D8,0XD2B2,0X3C9C,		/* 1e-16 */
	0XA732,0XD5A8,0XF623,0X3949,		/* 1e-32 */
	0XA73C,0X44F4,0X0FFD,0X32A5,		/* 1e-64 */
	0X979A,0XCF8C,0XBA08,0X255B,		/* 1e-128 */
	0X6F40,0X64AC,0X0628,0X0AC8		/* 1e-256 */
};
static double *plten=pliten;

static dscale(valp,round)
double *valp;				/* value to scale */
int round;
{
  int pow=0,sign=1,j,*ps,*pd;
  double val,roundval;

  if((val=*valp)<0.0)val=-val; else sign=0;
  if(val==0.0)return 0;
  if(round<0)return 0;
  if(round){
    if(round>14)round=14;
    for(roundval=5;--round;)roundval*=1.0e-1;
    val+=roundval;
  }
  if(val>=10){
    for(j=9;j--;){
      pow<<=1;
      if(val>=pgten[j]){
	val*=plten[j];
	pow+=1;
      }
    }
  } else if(val<1){
    for(j=9;j--;){
      pow<<=1;
      if(val<plten[j]){
	val*=pgten[j];
	pow-=1;
      }
    }
    if(val<1){
      val*=10;
      --pow;
    }
  }
  roundval=0;
  pd=&roundval;
  ps=&val;
  pd[3]=(ps[3]&0x7ff0)-(52<<4);
  val+=roundval;
  if(val>=10 || val<1)pow+=dscale(&val,0);
  if(sign)val=-val;
  *valp=val;
  return pow;
}

static dtos(val,string,iplace,fplace)
double val;			/* the value to convert */
unsigned char *string;
int iplace;			/* number of integer places */
int fplace;			/* the number of fractional places */
{
  unsigned char *cp;
  int j;

  cp=string;
  if(val<0.0){
    val=-val;
    *cp++='-';
  }
  if(iplace<1){
    *cp++='0';
    *cp++='.';
    fplace+=iplace;
    if(fplace<0){iplace-=fplace;fplace=0;}
    while(iplace++<0)*cp++='0';
  } else {
    do {
      j=val;
      *cp++=j+'0';
      val=(val-j)*10.0;
    } while(--iplace);
    if(fplace)*cp++='.';
  }
  while(fplace--){
    j=val;			/* get the integer part */
    *cp++=j+'0';
    val=(val-j)*10.0;
  }
  *cp=0;
  return cp-string;
}

_fmtout(func,funarg,string,ip)
int (*func)();
unsigned funarg;
unsigned char *string;
int *ip;
{
  char tbuff[128],*cp;
  int base;
  unsigned leftadj,padchar,width,precflg,precisn,longflg,length;
  long *lp;
  union {long tlong;unsigned long tulong;}lw;
#ifdef FLOATS
  double *dp,dw;
#endif
#ifdef EXTENDED
  int is_number;
#endif

  while(*string){
    if(*string=='%'){
#ifdef EXTENDED
      is_number=1;
#endif
      if(leftadj=(*++string=='-'))++string;
      padchar=*string;
      if(padchar!='0')padchar=' ';
#ifdef EXTENDED
      if(*string=='*'){
	width=*ip++;			/* width is an argument */
	++string;
      } else
#endif
      for(width=0;isdigit(*string);)width=width*10+(*string++-'0');
      if(precflg=(*string=='.')){
	++string;
#ifdef EXTENDED
	if(*string=='*'){
	  precisn=*ip++;		/* precisn is an argument */
	  ++string;
	} else
#endif
	for(precisn=0;isdigit(*string);)precisn=precisn*10+(*string++-'0');
      } else precisn=0;
      if(longflg=(tolower(*string)=='l'))++string;
      switch(*string){
#ifdef FLOATS
	case 'g':
	case 'e':		/* exponential format */
	  if(!precflg)precisn=6;	/* default precision */
	  dp=ip;
	  dw=*dp++;
	  ip=dp;
	  base=dscale(&dw,0);
	  if(*string=='g' &&  base<5 && base>-5)goto use_float;
	  base+=dscale(&dw,precisn+2);
	  cp=tbuff+dtos(dw,tbuff,1,precisn);
	  *cp++='E';
	  if(base<0){
	    *cp++='-';
	    base=-base;
	  } else *cp++='+';
#ifdef EXTENDED
	  sprintf(cp,"%03d",base);
#else
	  sprintf(cp,"%02d",base);
#endif
	  length=strlen(tbuff);
	  cp=tbuff;
	  break;
	case 'f':
	  if(!precflg)precisn=6;
	  dp=ip;
	  dw=*dp++;
	  ip=dp;
	  base=dscale(&dw,0);
use_float:
	  base+=dscale(&dw,precisn+base+2);
	  cp=tbuff+dtos(dw,tbuff,base+1,precisn);
	  if(*string=='g'){
	    while(*--cp=='0')*cp=0;		/* remove trailing zeros */
	    if(*cp=='.')*cp=0;
	  }
	  length=strlen(tbuff);
	  cp=tbuff;
	  break;
#endif
	case 'B':
	  longflg=1;
	case 'b':
	  base=2;
	  goto nosign;
	case 'O':
	  longflg=1;
	case 'o':
	  base=8;
	  goto nosign;
	case 'U':
	  longflg=1;
	case 'u':
	  base=10;
	  goto nosign;
	case 'X':
	  longflg=1;
	case 'x':
	  base=16;
	  goto nosign;
	case 'D':
	  longflg=1;
	case 'd':
	  base=-10;
nosign:
	  if(longflg){lp=ip;lw.tlong=*lp++;ip=lp;}
	  else if(base<0)lw.tlong=(long)(*ip++);
	  else lw.tulong=(unsigned long)(*ip++);
	  ltos(lw.tlong,tbuff,base);
#ifdef EXTENDED
	  if(precflg){
	    cp=tbuff;
	    if(lw.tlong<0)++cp;
	    length=strlen(cp);
	    if(precisn && length<precisn+1){
	      movmem(cp,cp+precisn+1-length,length+1);
	      setmem(cp,precisn+1-length,'0');
	      length=precisn+1;
	    }
	    movmem(cp+length-precisn,cp+length-precisn+1,precisn+1);
	    cp[length-precisn]='.';
	  }
#endif
	  cp=tbuff;
	  length=strlen(cp);
	  break;
	case 's':
	  cp=*ip++;
	  length=strlen(cp);
	  if(precflg && precisn<length)length=precisn;
	  is_number=0;			/* leave minus signs alone */
	  break;
	case 'c':
	  cp=ip++;
	  length=1;
	  is_number=0;
	  break;
	default:
	  cp=string;
	  length=1;
	  is_number=0;
	  break;
      }
      if(!leftadj && width>length){
#ifdef EXTENDED
	if(is_number && *cp=='-' && padchar=='0'){
	  (*func)(funarg,cp++,1);
	  --length;
	  --width;
	}
#endif
	while(width-- >length) (*func)(funarg,&padchar,1);
      }
      if(width>length)width-=length; else width=0;
      (*func)(funarg,cp,length);
      if(leftadj && width)
	while(width--) (*func)(funarg,&padchar,1);
      ++string;
    }
    else (*func)(funarg,string++,1);
  }
}
-ARCHIVE- \main.c 1401
/*	C level interface to user program
*/

#include "stdio.h"
#define MAXARG 20

_main()
{
  unsigned char *cp,*stdinf,*stdoutf,*stderrf,*argv[MAXARG];
  int j,argc;

  cp=0x80;			/* get address of input command line */

/*	convert the input line to lower case
*/

  for(j=*cp++;j--;++cp){
    if(*cp==' ' || *cp=='\t')*cp=0;	/* set spaces and tabs to null */
    else if(*cp>='A' && *cp<='Z')*cp+=0x20;	/* to lower case */
  }
  *cp=0;				/* a final terminator */

/*	set up for standard files
*/

  stdinf=stdoutf=stderrf="con:";		/* all have same name */

/*	build the arg lists and do redirection
*/

  cp=0x80;
  argc=1;
  for(j=*cp++ + 1;j--;++cp){
    if(!*cp)continue;			/* skip leading nulls */
    if(*cp=='<')stdinf=cp+1;		/* redirect stdin */
    else if(*cp=='>')stdoutf=cp+1;	/* redirect stdout */
    else argv[argc++]=cp;		/* grab the argument */
    if(argc>=MAXARG){
      bdos(9,"\nTOO MANY ARGS$");
      _exit(0x8002);
    }
    while(*cp){++cp;--j;}		/* and skip the data */
  }
  cp="w";
  if(*stdoutf=='>'){++stdoutf;cp="a";}	/* set up for append if required */
  if(fopen(stdinf,"r")!=stdin
	|| fopen(stdoutf,cp)!=stdout
	|| fopen(stderrf,"w")!=stderr){
    bdos(9,"\nREDIRECTION ERROR$");
    _exit(0x8003);
  }

/*	now execute the program
*/

  argv[0]="c";				/* don't know program name */
  exit(main(argc,argv));
}
-ARCHIVE- \open.c 2141
/*	common open routine
*/

#include "fileio.h"

unsigned char *_opentab[MAXFILES];

struct cdvent
{
  unsigned char cdvnam[4];
  unsigned char cdvmode;
  unsigned char cdvfcb;
};

#define CDVMAX 5

static struct cdvent cdvtab[CDVMAX]={
{"CON",1,1},
{"CON",2,2},
{"RDR",1,3},
{"PUN",2,4},
{"PRN",2,5}
};

_open(filename,mode,new)
char *filename;
unsigned mode,new;
{
  int j,k,fd;
  struct bufstr *buf=0;

  for(fd=0;fd<MAXFILES;++fd)if(!_opentab[fd])break;
  if(fd==MAXFILES)goto err;		/* all possable files open */
  buf=calloc(sizeof(struct bufstr),1);	/* get our fcb */
  if(!buf)goto err;			/* no buffer yet */
  buf->buf_flag=(~++mode)&7;		/* set read/write permissions */

/*	see if a character device */

  if(strlen(filename)>3 && filename[3]==':'){		/* could be */
    for(k=0;k<CDVMAX;++k){
      for(j=0;j<3 && toupper(filename[j])==cdvtab[k].cdvnam[j];++j);
      if(j==3 && cdvtab[k].cdvmode==(mode&3)){
	buf->buf_flag|=BF_CDEV;
	buf->buf_fcb=cdvtab[k].cdvfcb;
	if((buf->buf_flag&7)==(BF_ASCII+BF_WRITE)){
	  if(buf->buf_fcb==1)buf->buf_size=136;
	  else buf->buf_size=2;
	}
	else buf->buf_size=1;
	break;
      }
    }
  }
  if(~buf->buf_flag&BF_CDEV){
    if(!(buf->buf_fcb=makefcb(filename)))goto err;	/* bad file name */
    if(new)bdos(0x13,buf->buf_fcb);	/* delete the file if it exists */
    if((bdos(0x0f+new,buf->buf_fcb)&0xff)>3)goto err;	/* open/create */
    buf->buf_size=SECSIZE*NUMBSEC;
  }
  if(buf->buf_data=malloc(buf->buf_size)){	/* get the buffer */
setmem(buf->buf_data,buf->buf_size,0xff);/* TEMPORARY FIX */
    _opentab[fd]=buf;
    if(~buf->buf_flag&BF_CDEV && !new){
      bdos(35,buf->buf_fcb);			/* get the file size */
      buf->buf_flen=buf->buf_fcb->fcb_rr<<SECPOWER;	/* in bytes */
      if(buf->buf_flag&BF_ASCII && buf->buf_flen){
	--buf->buf_fcb->fcb_rr;
	bdos(26,buf->buf_data);
	bdos(33,buf->buf_fcb);
	for(j=0;j<SECSIZE;++j)if(buf->buf_data[j]==26)break;
	buf->buf_flen+=j-SECSIZE;
      }
    }
    return fd;
  }
err:
  if(buf){
    if(buf->buf_fcb)free(buf->buf_fcb);
    free(buf);
  }
  return -1;
}
-ARCHIVE- \osread.c 1452
/*	read characters from the operating system
*/

#include "fileio.h"

_osread(buf)
struct bufstr *buf;
{
  int j,k,status;

  if(buf->buf_flag&BF_CDEV){
    if(buf->buf_flag&BF_ASCII && buf->buf_fcb==1){	/* console special */
      buf->buf_data[0]=132;
      bdos(10,buf->buf_data);			/* read the line */
      bdos(2,'\n');
      buf->buf_next=2;				/* first data char */
      buf->buf_fill=buf->buf_data[1]+3;
      buf->buf_data[buf->buf_fill-1]='\n';
    } else {
      buf->buf_data[0]=bdos(buf->buf_fcb);		/* get a character */
      if(buf->buf_flag&BF_ASCII && buf->buf_data[0]=='\r'){
        buf->buf_data[1]='\n';		/* add a line feed */
        buf->buf_fill=2;
      } else buf->buf_fill=1;
    }
    return;
  }

/* its a disk read */

  k=buf->buf_off>>SECPOWER;
  for(status=j=0;j<NUMBSEC;++j){
    if(buf->buf_off+(j*SECSIZE)<buf->buf_flen){
      bdos(0x1a,buf->buf_data+(j*SECSIZE));	/* set transfer address */
      buf->buf_fcb->fcb_rr=k+j;		/* set sector number */
      status=bdos(0x21,buf->buf_fcb)&0xff;	/* do the read */
      if(status==1 || status==4){		/* unwritten data */
	setmem(buf->buf_data+(j*SECSIZE),SECSIZE,0);	/* set it to zero */
	status=0;
      } else if(status)break;
    } else break;
  }
  if(status)buf->buf_flag|=BF_ERROR;		/* eof */
  buf->buf_fill=j*SECSIZE;
  if(buf->buf_fill>buf->buf_flen-buf->buf_off)
    buf->buf_fill=buf->buf_flen-buf->buf_off;
}
-ARCHIVE- \oswrite.c 653
/*	write characters to a disk file (not used for char devices)
*/

#include "fileio.h"

_oswrite(buf)
struct bufstr *buf;
{
  int j;

  if(buf->buf_flag&BF_DIRTY){
    if(buf->buf_fill<buf->buf_size)buf->buf_data[buf->buf_fill]=26; /*eof*/
    if(buf->buf_flen<buf->buf_off+buf->buf_fill)
      buf->buf_flen=buf->buf_off+buf->buf_fill;
    for(j=0;j*SECSIZE<buf->buf_fill;++j){
      bdos(0x1a,buf->buf_data+(j*SECSIZE));	/* set transfer address */
      buf->buf_fcb->fcb_rr=(buf->buf_off>>SECPOWER)+j;	/* set sector num */
      if(bdos(0x22,buf->buf_fcb)&0xff)buf->buf_flag|=BF_ERROR;
    }
    buf->buf_flag&=~BF_DIRTY;
  }
}
-ARCHIVE- abort.c 253
/*	print a message and abort
*/

#include "stdio.h"

abort(string,arg1)
unsigned char *string,arg1;
{
  int write();

  fprintf(stderr,"\nABORT:- ");
  _fmtout(&write,stderr-0x8000,string,&arg1);
  fprintf(stderr,"\n");
  exit(0x7fff);
}
-ARCHIVE- alloc.c 217
/*	allocate memory, zero it, and abort if none
*/

alloc(size)
unsigned size;
{
  char *cp;

  if(cp=malloc(size))setmem(cp,size,0);
  else {
    bdos(9,"ALLOC$");
    _exit(0x8007);
  }
  return cp;
}
-ARCHIVE- assemble.h 285
;	CONSTANTS REQUIRED FOR PSUEDO RELOCATABLE ASSEMBLY UNDER CPM-86

DEFCGBL	equ	0c1h		;define a global in code segment
DEFDGBL equ	0c2h		;define a global in data segment
RELCGBL	equ	0c3h		;relative address of global in code
ABSCGBL equ	0c4h		;absolute reference to global in code
-ARCHIVE- atof.c 160
/*	convert ascii to floating
*/

double atof(string)
unsigned char *string;
{
  double val;

  val=0.0;
  sscanf(string,"%F",&val);
  return val;
}
-ARCHIVE- atoi.c 329
/*	convert ascii to integer (or long)
*/

long atoi(s)
char *s;
{
  long j;
  int sign;

  while(*s==' ' || *s=='\t')++s;	/* skip white space */
  sign=0;
  if(*s=='-')sign=1;
  else if(*s!='+')--s;
  ++s;						/* skip sign data */
  for(j=0;*s>='0' && *s<='9';)j=j*10+(*s++-'0');
  if(sign)j=-j;
  return j;
}
-ARCHIVE- basicget.c 943
/*	read line written by basic and split into fields
*/

#include "stdio.h"

basicget(stream,buff,bufflen,fieldptr,fieldcnt)
FILE *stream;			/* where to read it */
unsigned char *buff;		/* where to put it */
int bufflen;			/* max amount to put */
unsigned char *fieldptr[];	/* field pointers */
int fieldcnt;			/* number of fields in line */
{
  unsigned char *cp;
  int j,termchar;

  for(j=0;j<fieldcnt;)fieldptr[j++]=0;		/* clear them all */
  if(!fgets(buff,bufflen-2,stream))return -1;	/* seen end of file */
  if(buff[strlen(buff)-1]!='\n')return -2;	/* short record */
  buff[strlen(buff)-1]=0;			/* get rid of \n */
  cp=buff;
  for(j=0;j<fieldcnt;){
    if(*cp=='"'){
      ++cp;
      termchar='"';
    } else termchar=',';
    fieldptr[j++]=cp;
    cp=index(cp,termchar);
    if(!cp)return j;
    if(termchar=='"')*cp++=0;
    *cp++=0;				/* kill the separator */
  }
  return 0;				/* an error */
}
-ARCHIVE- calloc.c 210
/*	allocate memory and clear it
*/

calloc(nelem,elsize)
unsigned nelem,elsize;
{
  unsigned char *cp;
  unsigned size;

  size=nelem*elsize;
  if(cp=malloc(size))setmem(cp,size,0);
  return cp;
}
-ARCHIVE- clearerr.c 223
/*	reset the error indication for a file
*/

#include "stdio.h"
#include "fileio.h"

clearerr(stream)
FILE *stream;
{
  struct bufstr *buf;

  buf=_checkfd(stream-0x8000);
  if(buf)buf->buf_flag&=~BF_ERROR;
}
-ARCHIVE- close.c 334
/*	close a file
*/

#include "fileio.h"

close(fd)
unsigned fd;
{
  unsigned status;
  struct bufstr *buf;

  if(fflush(fd+0x8000))return -1;		/* some error */
  buf=_checkfd(fd);
  if(~buf->buf_flag & BF_CDEV)free(buf->buf_fcb);
  if(buf->buf_data)free(buf->buf_data);
  free(buf);
  _opentab[fd]=0;
  return 0;
}
-ARCHIVE- coreleft.c 179
/*	return the number of bytes left on the stack
*/

extern unsigned _sysvals[2];

coreleft()
{
  unsigned j;

  j=&j;
  return j-_sysvals[1];	/* approx core left */
}
-ARCHIVE- creat.c 189
/*	create a new file, deleting any existing file
*/

creat(filename,mode)
char *filename;
unsigned mode;
{

  return _open(filename,mode,7);	/* do common open for a new file */
}
-ARCHIVE- execv.c 498
/*	execute a program using a list
*/

/*	NOTE THIS FUNCTION NEEDS CPM-86 V1.1 AND PATCHES TO WORK
*/

main()
{

  execl("CC1.CMD\0",0,"-t","-q",0);
  printf("got to here");
}

execl(name,arg0)
unsigned char *name,*arg0;
{

  execv(name,&arg0);
}

execv(name,argv)
unsigned char *name,*argv[];
{

  strcpy(0x80,name);
  while(*++argv){
    strcat(0x80," ");
    strcat(0x80,*argv);
  }
  bdos(26,0x80);		/* set dma address */
  bdos(47,0);			/* chain to program */
}
-ARCHIVE- exit.c 197
/*	do exit processing for a c program
*/

#include "fileio.h"

exit(val)
int val;
{
  int j;

  for(j=0;j<MAXFILES;++j)if(_opentab[j])close(j);
  _exit(val);			/* thats all folks */
}
-ARCHIVE- fclose.c 123
/*	close a buffered file and free storage
*/

fclose(stream)
unsigned stream;
{

  return close(stream-0x8000);
}
-ARCHIVE- ferror.c 248
/*	return non zero if error has occurred on file
*/

#include "stdio.h"
#include "fileio.h"

ferror(stream)
FILE *stream;
{
  struct bufstr *buf;

  buf=_checkfd(stream-0x8000);
  if(~buf->buf_flag&BF_ERROR)return 0;
  return EOF;
}
-ARCHIVE- fflush.c 419
/*	flush a file, updating all data on disk
*/

#include "fileio.h"

fflush(stream)
unsigned stream;
{
  struct bufstr *buf;

  buf=_checkfd(stream-0x8000);			/* get the buffer address */
  if(buf->buf_flag&BF_CDEV)goto done;
  if(buf->buf_flag&BF_DIRTY)_oswrite(buf);	/* empty the buffer */
  if((bdos(0x10,buf->buf_fcb)&0xff)>3)buf->buf_flag|=BF_ERROR;
done:
  return (buf->buf_flag&BF_ERROR?-1:0);
}
-ARCHIVE- fgetc.c 233
/*	get a character from the file
*/

#define EOF (-1)

fgetc(stream)
unsigned stream;
{
  unsigned cc;

  cc=0;
  if(read(stream-0x8000,&cc,1)!=1)cc=EOF;	/* read 1 character */
  return cc;					/* return character */
}
-ARCHIVE- fgets.c 405
/*	get an input string from a file
*/

#include "fileio.h"

fgets(line,maxline,fd)
unsigned char *line;
int maxline;
unsigned fd;
{
  int j,cc,k;
  struct bufstr *buf;

  buf=_checkfd(fd-=0x8000);	/* convert from stream to fd */
  for(j=0;j<maxline-1;){
    cc=read(fd,line+j,1);
    if(cc<1)break;
    if(line[j++]=='\n')break;
  }
  line[j]=0;
  if(j)return line; else return 0;
}
-ARCHIVE- fileio.h 1844
/*	fileio.h	library i/o function header file
*/

/*	define the cp/m86 file control block
*/

struct cpmfcb{
  unsigned char fcb_dr;			/* drive specification */
  unsigned char fcb_fn[8];		/* the file name */
  unsigned char fcb_ft[3];		/* the file type */
#ifdef IBMPCDOS
  unsigned fcb_cb;			/* current block number */
  unsigned fcb_rs;			/* record size */
  unsigned long fcb_fs;			/* file size */
  unsigned fcb_fd;			/* file date */
  unsigned char fcb_dn[10];		/* ms-dos use */
#else
  unsigned char fcb_ex;			/* the current extent number */
  unsigned char fcb_s1;			/* cp/m use */
  unsigned char fcb_s2;			/* cp/m use */
  unsigned char fcb_rc;			/* record count */
  unsigned char fcb_dn[16];		/* cp/m use */
#endif
  unsigned char fcb_cr;			/* current record */
  unsigned long fcb_rr;			/* random record number */
};

struct bufstr{
  struct cpmfcb *buf_fcb;	/* pointer to cp/m fcb block */
  unsigned char *buf_data;	/* the data buffer */
  unsigned buf_flag;		/* control flags etc */
  unsigned char buf_uget;	/* unget character storage */
  int buf_size;			/* length of the buffer in bytes */
  int buf_next;			/* next character to be read/written */
  int buf_fill;			/* the number of characters in buffer */
  long buf_off;			/* address of first character in buffer */
  long buf_flen;		/* our idea of the file length in bytes */
};

#define BF_READ 1
#define BF_WRITE 2
#define BF_ASCII 4
#define BF_UNGET 8
#define BF_CDEV 0x10
#define BF_DIRTY 0x20
#define BF_ERROR 0x40

#define SECPOWER 7		/* size of sector as power of 2 */
#define SECSIZE (1<<SECPOWER)	/* size of cp/m sector */
#define NUMBSEC 8		/* number of sectors in buffer */

#define MAXFILES 16		/* maximum file number */

extern unsigned char *_opentab[MAXFILES];	/* file table */

/*	end of fileio.h
*/
-ARCHIVE- fopen.c 862
/*	open a file
*/

#include "stdio.h"

fopen(filename,fomode)
unsigned char *filename,*fomode;
{
  int first=0,comode=AREAD-1,rwmode=0,fd;

  while(*fomode){
    switch(*fomode++){
      case 'b':
	comode=BREAD-1;
	continue;
      case 'r':
	if(!first)first=1;		/* open not create */
	rwmode|=1;
	continue;
      case 'w':
	if(!first)first=2;		/* create the file */
      case 'a':
	if(!first)first=3;		/* open at end, create if reqd */
	rwmode|=2;
	continue;
    }
    goto err;
  }

  switch(first){
    case 1:
    case 3:
      fd=_open(filename,comode+rwmode,0);
      if(fd!=-1 || first==1)break;
    case 2:
      fd=_open(filename,comode+rwmode,7);
      break;
    default:
      goto err;
  }
  if(first==3 && fd!=-1)lseek(fd,0L,2);	/* get to end of file */
  if(fd!=-1)return 0x8000|fd;
err:
  return 0;
}
-ARCHIVE- fprintf.c 262
/*	print to standard output
*/

#include "stdio.h"

fprintf(stream,control,args)
FILE *stream;
unsigned char *control;		/* the format control string */
unsigned args;
{
  extern int write();

  return _fmtout(&write,stream-0x8000,control,&args);
}
-ARCHIVE- fputc.c 156
/*	put a character to a file
*/

#define EOF (-1)

fputc(c,stream)
unsigned c,stream;
{

  if(write(stream-0x8000,&c,1)!=1)c=EOF;
  return c;
}
-ARCHIVE- fputs.c 208
/*	output a string to a stream
*/

fputs(line,stream)
unsigned char *line;
unsigned stream;
{
  int leng;

  leng=strlen(line);
  if(leng!=write(stream-0x8000,line,leng))return -1;
  return 0;
}
-ARCHIVE- fread.c 429
/*	read from a file
*/

#include "stdio.h"

fread(where,size,nitems,stream)
unsigned char *where;			/* where to put data */
unsigned size;				/* size of one item in bytes */
unsigned nitems;			/* number of items to read */
FILE *stream;				/* where to get it */
{
  unsigned count;

  for(count=0;count<nitems;++count){
    if(size!=read(stream-0x8000,where,size))break;
    where+=size;
  }
  return count;
}
-ARCHIVE- free.c 1101
/*	return a free block to the heap
	modified to reset sbrk if block abuts the sbrk address
*/

extern unsigned _sysvals[2];		/* created by $main */

struct header{
  unsigned char *addr;
  unsigned hsize;
};

extern struct header _allocb;		/* base block for control purposes */

free(fp)
unsigned char *fp;
{
  unsigned char *cp,*cpp;

  fp-=sizeof(struct header);
  if(fp!=fp->addr){
    bdos(9,"FREE$");
    _exit(0x8008);
  }
  for(cp=&_allocb;cp->addr && cp->addr<fp;cp=(cpp=cp)->addr);
  fp->addr=cp->addr;			/* put block into free list */
  cp->addr=fp;
  if(fp==cp+cp->hsize+sizeof(struct header)){	/* concatinate with prev */
    cp->hsize+=(fp->hsize+sizeof(struct header));
    cp->addr=fp->addr;
  } else cpp=cp,cp=fp;
  fp=fp->addr;
  if(fp==cp+cp->hsize+sizeof(struct header)){	/* concatinate with next */
    cp->hsize+=(fp->hsize+sizeof(struct header));
    cp->addr=fp->addr;
  }
  if(cp+cp->hsize+sizeof(struct header)==_sysvals[1]-_sysvals[0]){
    _sysvals[1]-=cp->hsize+sizeof(struct header); /* reset sbrk if poss */
    cpp->addr=0;
  }
}
-ARCHIVE- fscanf.c 211
/*	read input from a file under format conversion
*/

#include "stdio.h"

fscanf(stream,format,args)
FILE *stream;
unsigned char *format;
unsigned args;
{

  return _fmtin(0,stream,format,&args);
}
-ARCHIVE- fseek.c 275
/*	do a seek on a file
*/

#include "stdio.h"

long fseek(stream,offset,base)
FILE *stream;			/* the file to seek */
long offset;			/* how far to move */
int base;			/* base to move from */
{
  extern long lseek();

  return lseek(stream-0x8000,offset,base);
}
-ARCHIVE- ftell.c 188
/*	get the current position in a file
*/

#include "stdio.h"

long ftell(stream)
FILE *stream;			/* the file */
{
  extern long lseek();

  return lseek(stream-0x8000,0L,1);
}
-ARCHIVE- ftoa.c 213
/*	convert double to ascii
*/

ftoa(d,string,iplace,fplace)
double d;
unsigned char *string;
unsigned iplace,fplace;
{

  sprintf(string,"%*.*e",iplace+fplace+5,fplace,d);
  return strlen(string);
}

-ARCHIVE- fwrite.c 431
/*	write to a file
*/

#include "stdio.h"

fwrite(where,size,nitems,stream)
unsigned char *where;			/* where to get data */
unsigned size;				/* size of one item in bytes */
unsigned nitems;			/* number of items to write */
FILE *stream;				/* where to put it */
{
  unsigned count;

  for(count=0;count<nitems;++count){
    if(size!=write(stream-0x8000,where,size))break;
    where+=size;
  }
  return count;
}
-ARCHIVE- gets.c 333
/*	get an input string from stdin, dropping the newline
*/

#include "stdio.h"

fgets(line,maxline)
unsigned char *line;
int maxline;
{
  int j,cc;

  for(j=0;j<maxline-1;){
    cc=read(stdin-0x8000,line+j,1);
    if(cc<1)break;
    if(line[j++]=='\n')break;
  }
  if(!j)return 0;
  line[j-1]=0;
  return line;
}
-ARCHIVE- getw.c 175
/*	get a word from a file
*/

#define EOF (-1)

getw(stream)
unsigned stream;
{
  unsigned cc;

  cc=0;
  if(read(stream-0x8000,&cc,2)!=2)cc=EOF;
  return cc;
}
-ARCHIVE- index.c 147
/*	return cpoiner to first occurrence of character
*/

index(s,c)
unsigned char *s,c;
{

  while(*s)if(*s++==c)return --s;
  return 0;
}
-ARCHIVE- intrinit.c 1390
/*	initialise for interrupt processing
*/

/*
	needs function intrserv.a86
	the stack check code in $entry0, $entry1 and $entry2
	must be disabled to use this function
*/

struct intrcode
{
  unsigned char farcall;	/* contains far call opcode */
  unsigned farip;		/* ip value for far call */
  unsigned farcs;		/* cs value for far call */
  unsigned char fariret;	/* iret instruction */
  unsigned farfunc;		/* function to be executed */
};

#define SIZE_IC 8

intrinit(func,stack,vecno)
int (*func)();			/* function which will process interrupt */
unsigned stack;			/* # of bytes of stack needed by function */
unsigned vecno;			/* # of vector for interrupt trap */
{
  unsigned char *ustack;
  unsigned *wp;			/* for funny things */
  struct intrcode *icp;
  extern intrserv();		/* our sarvice function */

  ustack=alloc(stack+SIZE_IC);	/* this is where interrupt begins */
  icp=ustack+stack;
  icp->farcall=0x9a;		/* direct intersegment call */
  icp->farip=intrserv;		/* address of interrupt service routine */
  wp=3;				/* byte 3 of data seg */
  icp->farcs=*wp;		/* get cs value */
  icp->fariret=0xcf;		/* an iret instruction */
  icp->farfunc=func;		/* the function we want to execute */
  wp=9;				/* byte 9 of data segment */
  pokew(vecno*4,0,icp);		/* set up the interrupt vector */
  pokew(vecno*4+2,0,*wp);	/* that does it */
}

-ARCHIVE- isalnum.c 180
/*	return true if input character is alphabetic or a digit
*/

isalnum(c)
unsigned char c;
{

  return (('A'<=c && c<='Z') || ('a'<=c && c<='z') || ('0'<=c && c<='9'));
}
-ARCHIVE- isalpha.c 147
/*	return true if input character is alphabetic
*/

isalpha(c)
unsigned char c;
{

  return (('A'<=c && c<='Z') || ('a'<=c && c<='z'));
}
-ARCHIVE- isascii.c 117
/*	return true if input character is less than 0x80
*/

isascii(c)
unsigned char c;
{

  return (c<0x80);
}
-ARCHIVE- iscntrl.c 134
/*	return true if input character is a a control character
*/

iscntrl(c)
unsigned char c;
{

  return (0177==c || c<037);
}
-ARCHIVE- isdigit.c 120
/*	return true if input character is a digit
*/

isdigit(c)
unsigned char c;
{

  return ('0'<=c && c<='9');
}
-ARCHIVE- islower.c 134
/*	return true if input character is lower case alphabetic
*/

islower(c)
unsigned char c;
{

  return ('a'<=c && c<='z');
}
-ARCHIVE- isprint.c 123
/*	return true if input character is printable
*/

isprint(c)
unsigned char c;
{

  return (040<=c && c<=0176);
}
-ARCHIVE- ispunct.c 219
/*	return true if input character is not control or alphanumeric
*/

ispunct(c)
unsigned char c;
{

  return ((040<=c && c<=057)
	|| (072<=c && c<=0100)
	|| (0133<=c && c<=0140)
	|| (0173<=c && c<=0176));
}
-ARCHIVE- isspace.c 139
/*	returns true if chararcter is a blank,tab or newline
*/

isspace(cc)
char cc;
{

  return (cc==' ' || cc=='\t' || cc=='\n');
}
-ARCHIVE- isupper.c 134
/*	return true if input character is upper case alphabetic
*/

isupper(c)
unsigned char c;
{

  return ('A'<=c && c<='Z');
}
-ARCHIVE- iswap.c 134
/*	swap two integers
*/

iswap(a,b)
int *a,*b;		/* address of integers is input */
{
  int j;

  j=*a;
  *a=*b;
  *b=j;
}
-ARCHIVE- itoa.c 120
/*	integer to ascii
*/

itoa(n,cp)
int n;
unsigned char *cp;
{

  sprintf(cp,"%d",n);
  return strlen(cp);
}
-ARCHIVE- itoh.c 134
/*	integer to hex conversion
*/

itoh(n,cp)
unsigned n;
unsigned char *cp;
{

  sprintf(cp,"%x",n);
  return strlen(cp);
}
-ARCHIVE- lseek.c 1187
/*	do a seek using a long byte address
*/

#include "fileio.h"

unsigned long
lseek(fd,posn,offset)
unsigned fd;
long posn;
unsigned offset;
{
  long reqdposn;
  struct bufstr *buf;

  buf=_checkfd(fd);
  if(buf->buf_flag&BF_CDEV)return -1;	/* no seek character device */

  buf->buf_flag&=~BF_UNGET;		/* clear push back */

  switch(offset){
    case 1:					/* seek rel to current pos */
      reqdposn=buf->buf_off+posn+buf->buf_next;
      break;
    case 0:					/* absolute seek */
      reqdposn=posn;
      break;
    case 2:
      if(buf->buf_flen<buf->buf_off+buf->buf_fill)
	buf->buf_flen=buf->buf_off+buf->buf_fill;
      reqdposn=buf->buf_flen+posn;
      break;
    default:
      return -1;				/* not supported */
  }

  if(!buf->buf_fill 
    || reqdposn<buf->buf_off || reqdposn>=buf->buf_off+buf->buf_fill){
    if(buf->buf_flag&BF_DIRTY)_oswrite(buf);
    buf->buf_off=reqdposn&~(NUMBSEC*SECSIZE-1);
    buf->buf_fill=0;				/* say no data in buffer */
    _osread(buf);				/* read the buffer in */
  }
  buf->buf_next=reqdposn-buf->buf_off;
  if(buf->buf_next>buf->buf_fill)buf->buf_fill=buf->buf_next;
  return reqdposn;
}
-ARCHIVE- ltell.c 184
/*	return the current file position as a long
*/

#include "fileio.h"

long ltell(fd)
unsigned fd;
{
  long lseek();

  return lseek(fd,0L,1);		/* dont need ltell now */
}
-ARCHIVE- ltoa.c 118
/*	long to ascii
*/

ltoa(n,cp)
long n;
unsigned char *cp;
{

  sprintf(cp,"%D",n);
  return strlen(cp);
}
-ARCHIVE- ltoh.c 144
/*	long integer to hex conversion
*/

ltoh(n,cp)
unsigned long n;
unsigned char *cp;
{

  sprintf(cp,"%X",n);
  return strlen(cp);
}
-ARCHIVE- ltos.c 689
/*	long to string
*/

ltos(val,cp,base)
long val;			/* the number to convert */
unsigned char *cp;		/* the address of the string */
int base;			/* the conversion base */
{
  unsigned char tempc[34],*tcp;
  int n=0;			/* number of characters in result */
  unsigned long uval;		/* unsigned value */
  static unsigned char dig[]={"0123456789ABCDEF"};

  *(tcp=tempc+33)=0;
  if(base<0){			/* needs signed conversion */
    if(val<0)n=1;
    else val=-val;
    do {*--tcp=dig[-(val%base)];} while((val/=-base));
  } else {
    uval=val;
    do {*--tcp=dig[uval%base];} while(uval/=base);
  }
  if(n)*--tcp='-';
  n=tempc+33-tcp;
  movmem(tcp,cp,n+1);
  return n;
}
-ARCHIVE- makefcb.c 1050
/*	make a cp/m file control block
*/

#include "fileio.h"

makefcb(filename)
unsigned char *filename;
{
  int u;
  struct cpmfcb *fcb;

  if(!(fcb=calloc(sizeof(struct cpmfcb),1)))goto err01;	/* heap full */
  if(filename[1]==':'){
    u=toupper(*filename);
    if(u>='A' && u<='P')fcb->fcb_dr=u-('A'-1);	/* set drive number */
    else goto error;
    filename+=2;
  }
  setmem(fcb->fcb_fn,11,' ');			/* space fill fn and ft */
  if(_makefcb(fcb->fcb_fn,8,&filename)||_makefcb(fcb->fcb_ft,3,&filename))
    goto error;
  return fcb;					/* all ok */

error:
  free(fcb);
err01:
  return 0;
}

/*	a service routine for makefcb
*/

_makefcb(outstr,outlen,filename)
unsigned char *outstr,**filename;
int outlen;
{
  unsigned char *cp;
  int u;

  for(cp=*filename;*cp;){		/* do file name */
    u=toupper(*cp++)&0x7f;
    if(u=='.')break;			/* that part done */
    if(u<0x21)return 1;			/* some protection */
    if(outlen){
      --outlen;
      *outstr++=u;
    }
  }
  *filename=cp;
  return 0;
}
-ARCHIVE- makefnam.c 886
/*	split up a file name (subroutine for makefnam)
*/

static _makefn(source,dest)
unsigned char *source;
unsigned char *dest;
{
  int j;

  setmem(dest,17,0);		/* clear result field */
  if(strlen(source)>1 && source[1]==':')for(j=0;j<2;)dest[j++]=*source++;
  for(j=3;*source && *source!='.';++source)if(j<11)dest[j++]=*source;
  for(j=12;*source;++source)if(j<16)dest[j++]=*source;
}
/*	make a file name using a template
*/

makefnam(rawfn,template,result)
unsigned char *rawfn;			/* the original file name */
unsigned char *template;		/* the template data */
unsigned char *result;			/* where to place the result */
{
  unsigned char et[17],er[17];

  _makefn(template,et);
  _makefn(rawfn,er);
  *result=0;			/* assure no data */
  strcat(result,er[0]?er:et);
  strcat(result,er[3]?er+3:et+3);
  strcat(result,er[12]?er+12:et+12);
  return result;
}
-ARCHIVE- malloc.c 792
/*	memory allocator
*/

struct header{
  unsigned char *addr;
  unsigned hsize;
};

struct header _allocb;		/* base block for control purposes */
char _allocd;			/* dummy so above wont be last entry */

malloc(size)
unsigned size;
{
  char *pp,*cp,*np;

  size=(size+1)&0xfffe;			/* force size even for 8086 */
  for(pp=&_allocb;cp=pp->addr;pp=cp){
    if(cp->hsize>=size){
      if(cp->hsize>=size+sizeof(struct header)){
	np=cp+size+sizeof(struct header);
	np->addr=cp->addr;
	np->hsize=cp->hsize-size-sizeof(struct header);
	cp->addr=np;
      } else size=cp->hsize;
      pp->addr=cp->addr;
      break;
    }
  }
  if(cp || (cp=sbrk(size+sizeof(struct header)))){
    cp->hsize=size;
    cp->addr=cp;
    cp+=sizeof(struct header);
  }
  return cp;
}
-ARCHIVE- open.c 167
/*	open an existing file
*/

open(filename,mode)
char *filename;
unsigned mode;
{

  return _open(filename,mode,0);	/* do common open for existing file */
}
-ARCHIVE- overlay.c 917
/*	load an overlay
*/

#include "stdio.h"

overlay(name,codeaddr,dataaddr)
unsigned char *name;		/* name of file to load */
int *codeaddr;			/* return where code was loaded */
int *dataaddr;			/* return where data was loaded */
{
  unsigned codelen,datalen,j,k;
  FILE *olyfile;
  extern long fseek();
  struct {int cs,ss,ds,es;} segregs;

  olyfile=fopen(name,"rb");
  if(!olyfile)return 1;			/* cant open */
  *codeaddr=getw(olyfile);
  codelen=getw(olyfile);
  *dataaddr=getw(olyfile);
  datalen=getw(olyfile);
  fseek(olyfile,16L,0);
  segread(&segregs);
  for(j=0;j<codelen;++j){
    k=getc(olyfile);
    pokeb(*codeaddr+j,segregs.cs,k);
  }
  while(fseek(olyfile,0L,1)&0xf)getc(olyfile);	/* mod 16 */
  for(j=0;j<datalen;++j){
    k=getc(olyfile);
    pokeb(*dataaddr+j,segregs.ds,k);
  }
  j=ferror(olyfile);
  fclose(olyfile);
  return j;		/* return non zero if error */
}
-ARCHIVE- printf.c 239
/*	print to standard output
*/

#include "stdio.h"

printf(control,args)
unsigned char *control;		/* the format control string */
unsigned args;
{
  extern int write();

  return _fmtout(&write,stdout-0x8000,control,&args);
}
-ARCHIVE- puts.c 267
/*	output a string to stdout adding a newline
*/

#include "stdio.h"

puts(line)
unsigned char *line;
{
  int leng;

  leng=strlen(line);
  if(leng!=write(stdout-0x8000,line,leng))return -1;
  if(1!=write(stdout-0x8000,"\n",1))return -1;
  return 0;
}
-ARCHIVE- putw.c 150
/*	put a word to a file
*/

#define EOF (-1)

putw(w,stream)
unsigned w,stream;
{

  if(write(stream-0x8000,&w,2)!=2)w=EOF;
  return w;
}
-ARCHIVE- qsort.c 1351
/*	Hores quicksort algorithm
*/

#define DEPTH 20		/* should be adequate for most sorts */

static swapbyte(a,b,count)
unsigned char *a,*b;
unsigned count;
{
  int temp;

  while(count--){
    temp=*a;
    *a++=*b;
    *b++=temp;
  }
}

qsort(base,n,width,cmpf)
unsigned char *base;		/* base of data */
unsigned int n;			/* number of items to sort */
unsigned width;			/* width of an element */
int (*cmpf)();			/* key comparison function */
{
  unsigned j,k,pivot,count,low[DEPTH],high[DEPTH];

  if(n<2)return;		/* already sorted */
  count=1;			/* do initialisation */
  low[0]=0;
  high[0]=n-1;
  while(count--){
    pivot=low[count];
    j=pivot+1;
    n=k=high[count];
    while(j<k){
      while(j<k && (*cmpf)(base+j*width,base+pivot*width)<1)++j;
      while(j<=k && (*cmpf)(base+pivot*width,base+k*width)<1)--k;
      if(j<k)swapbyte(base+(j++*width),base+(k--*width),width);
    }
    if((*cmpf)(base+pivot*width,base+k*width)>0)
	swapbyte(base+pivot*width,base+k*width,width);
    if(k>pivot)--k;
    if(k>pivot && n>j && (k-pivot < n-j)){
      swapbyte(&k,&n,2);
      swapbyte(&pivot,&j,2);
    }
    if(k>pivot){
      low[count]=pivot;
      high[count++]=k;
    }
    if(n>j){
      low[count]=j;
      high[count++]=n;
    }
    if(count>=DEPTH)abort("qsort failure");
  }
}
-ARCHIVE- read.c 1529
/*	read characters from the file
*/

#include "fileio.h"

read(fd,buffer,count)
unsigned fd;
char *buffer;
unsigned count;
{
  int retval,retcc;
  struct bufstr *buf;

  buf=_checkfd(fd);
  if(buf->buf_flag&BF_READ){
    bdos(9,"READ$");
    exit(0x8002);
  }

  for(retval=0;retval<count;){
    if((retcc=_read(buf))<0)break;
    *buffer++=retcc;
    ++retval;				/* count the character */
    if(buf->buf_flag&BF_ASCII){
      if(retcc==26){
	--buf->buf_next;
	--retval;			/* uncount the character */
	break;
      }
      if(retcc=='\r'){
	if((retcc=_read(buf))<0)break;
	if(retcc=='\n'){
	  *(buffer-1)='\n';
	  break;			/* dont return past new line */
	}
	buf->buf_uget=retcc;
	buf->buf_flag|=BF_UNGET;
      } else if(retcc=='\n')break;
    }
  }
  return ((buf->buf_flag&BF_ERROR)?-1:retval);
}

/*	support routine for read
*/

_read(buf)
struct bufstr *buf;
{

  if(buf->buf_flag&BF_UNGET){
    buf->buf_flag&=~BF_UNGET;
    return buf->buf_uget;
  }

  if(buf->buf_next>=buf->buf_fill){		/* no data in buffer */
    if(buf->buf_flag&BF_DIRTY)_oswrite(buf);	/* get out your dirty buff */
    if(buf->buf_flag&BF_CDEV)goto do_read;
    if(buf->buf_fill==buf->buf_size){
      buf->buf_off+=buf->buf_size;
      buf->buf_fill=0;
    }
    if(!buf->buf_fill){
do_read:
      buf->buf_next=0;
      _osread(buf);				/* fill the buffer */
    }
  }
  if(buf->buf_next>=buf->buf_fill)return -1;	/* end of file */
  return buf->buf_data[buf->buf_next++];
}
-ARCHIVE- realloc.c 745
/*	reallocate a block of memory
*/

struct header{
  unsigned char *addr;
  unsigned hsize;
};

extern struct header _allocb;	/* defined in malloc.c */

realloc(cp,size)
unsigned char *cp;
unsigned size;
{
  unsigned char *rp;
  unsigned oldsize;

  oldsize=(cp-sizeof(struct header))->hsize;
  free(cp);				/* free the old block */
  cp-=sizeof(struct header);		/* point to beginning of block */
  for(rp=&_allocb;rp && rp<cp && rp->addr<=cp;rp=rp->addr);
  if(rp && rp!=cp){
    movmem(cp+sizeof(struct header),rp+sizeof(struct header),oldsize);
    cp=rp;
  }
  if(rp=malloc(size)){			/* get the new block */
    if(oldsize>size)oldsize=size;
    movmem(cp+sizeof(struct header),rp,oldsize);
  }
  return rp;
}
-ARCHIVE- rename.c 430
/*	rename a file
*/

rename(filefrom,fileto)
unsigned char *filefrom,*fileto;
{
  unsigned char *fcbfrom,*fcbto;
  unsigned status;

  if(!(fcbfrom=makefcb(filefrom)))return -1;
  if(!(fcbto=makefcb(fileto))){
    free(fcbfrom);
    return -1;
  }
  movmem(fcbto,fcbfrom+16,16);		/* build composite fcb */
  status=bdos(0x17,fcbfrom)&0xff;
  free(fcbfrom);
  free(fcbto);
  if(status)return -1;
  return 0;
}
-ARCHIVE- rindex.c 187
/*	return a pointer to the last occurrence of char
*/

rindex(s,c)
unsigned char *s,c;
{
  unsigned char *cp;

  for(cp=s+strlen(s);--cp>=s;)if(*cp==c)return cp;
  return 0;
}
-ARCHIVE- sbrk.c 333
/*	get some memory from the system
*/

extern unsigned _sysvals[2];		/* created by $main */

sbrk(size)
unsigned size;
{
  unsigned j;

  if(size>=((char)&size)-_sysvals[1])return 0;	/* wont fit, too large */
  j=_sysvals[1]-_sysvals[0];		/* address to return */
  _sysvals[1]+=size;			/* its used up */
  return j;
}
-ARCHIVE- scanf.c 183
/*	read input under format control from stdin
*/

#include "stdio.h"

scanf(format,args)
unsigned char *format;
unsigned args;
{

  return _fmtin(0,stdin,format,&args);
}
-ARCHIVE- sprintf.c 369
/*	format data to a memory string
*/

static store(to,from,leng)
unsigned char **to;
unsigned char *from;
unsigned leng;
{

  movmem(from,*to,leng);
  *to+=leng;
  **to=0;		/* terminate for safety */
}

sprintf(string,control,args)
unsigned char *string;
unsigned char *control;
unsigned args;
{

  return _fmtout(&store,&string,control,&args);
}
-ARCHIVE- sscanf.c 434
/*	format a string in memory
*/

#include "stdio.h"

union ptr_union{
  char *scp;
  unsigned char *ucp;
  int *sip;
  unsigned *uip;
  long *slp;
  unsigned long *ulp;
  float *sfp;
  double *sdp;
};

sscanf(string,format,arg)
unsigned char *string;		/* source of data */
unsigned char *format;		/* control string */
union ptr_union arg;		/* our conversion args */
{

  return _fmtin(1,string,format,&arg);
}
-ARCHIVE- strcat.c 221
/*	concatinate string t to string s
*/

strcat(s,t)
unsigned char *s,*t;
{
  unsigned char *cp;

  for(cp=s;*cp++;);			/* find end of string */
  for(--cp;*cp++=*t++;);		/* do the concatinate */
  return s;
}
-ARCHIVE- strcmp.c 191
/*	string compare (remove the "unsigned" for signed collating set)
*/

strcmp(s,t)
unsigned char *s,*t;
{

  for(;*s==*t;t++)if(!*s++)return 0;
  if(*s<*t)return -1;
  return 1;
}
-ARCHIVE- strcpy.c 139
/*	string copy
*/

strcpy(to,from)
unsigned char *to,*from;
{
  unsigned char *cp;

  for(cp=to;*to++=*from++;);
  return to;
}
-ARCHIVE- strlen.c 159
/*	return the length of a string
*/

strlen(string)
unsigned char *string;
{
  unsigned char *cp;

  for(cp=string++;*cp++;);
  return cp-string;
}
-ARCHIVE- strncat.c 286
/*	concatinate string t to string s, max n characters
*/

strncat(s,t,n)
unsigned char *s,*t;
unsigned n;
{
  unsigned char *cp;

  for(cp=s;*cp++;);			/* find end of string */
  for(--cp;n-- && (*cp++=*t++););	/* do the concatinate */
  if(n==0xffff)*cp=0;
  return s;
}
-ARCHIVE- strncmp.c 263
/*	string compare up to n characters
	(remove the "unsigned" for signed collating set)
*/

strncmp(s,t,n)
unsigned char *s,*t;
unsigned n;
{

  for(;n-- && (*s==*t);t++)if(!*s++)return 0;
  if(n==0xffff)return 0;
  if(*s<*t)return -1;
  return 1;
}
-ARCHIVE- strncpy.c 206
/*	string copy up to n characters
*/

strncpy(to,from,n)
unsigned char *to,*from;
unsigned n;
{
  unsigned char *cp;

  for(cp=to;n-- && (*cp++=*from++););
  if(n==0xffff)*cp=0;
  return to;
}
-ARCHIVE- tolower.c 133
/*	convert character to lowercase if upper case */

tolower(c)
char c;
{

  if('A'<=c && c<='Z')c+=('a'-'A');
  return c;
}
-ARCHIVE- toupper.c 133
/*	convert character to uppercase if lower case */

toupper(c)
char c;
{

  if('a'<=c && c<='z')c+=('A'-'a');
  return c;
}
-ARCHIVE- ungetc.c 245
/*	ungetc a char from an input file
*/

#include "fileio.h"

ungetc(cc,fd)
unsigned cc,fd;
{
  struct bufstr *buf;

  if(buf=_checkfd(fd-0x8000)){
    buf->buf_flag|=BF_UNGET;
    buf->buf_uget=cc;
  } else cc=-1;
  return cc;
}
-ARCHIVE- unlink.c 273
/*	unlink (delete) a disk file
*/

unlink(filename)
unsigned char *filename;
{
  unsigned char *fcb;
  unsigned status;

  if(!(fcb=makefcb(filename)))return -1;
  status=bdos(0x13,fcb)&0xff;
  free(fcb);
  if(status)return -1;
  return 0;				/* all ok */
}
-ARCHIVE- utoa.c 144
/*	unsigned integer to ascii
*/

utoa(val,str)
unsigned val;
unsigned char *str;
{

  sprintf(str,"%u",val);
  return strlen(str);
}
-ARCHIVE- wqsort.c 1091
/*	Hores quicksort algorithm
*/

#define DEPTH 20		/* should be adequate for most sorts */

wqsort(n,cmpf,xchgf,base)
unsigned int n;			/* number of items to sort */
int (*cmpf)();			/* key comparison function */
int (*xchgf)();			/* record exchange function */
unsigned char *base;		/* base of data */
{
  unsigned j,k,pivot,count,low[DEPTH],high[DEPTH];

  if(n<2)return;		/* already sorted */
  count=1;			/* do initialisation */
  low[0]=0;
  high[0]=n-1;
  while(count--){
    pivot=low[count];
    j=pivot+1;
    n=k=high[count];
    while(j<k){
      while(j<k && (*cmpf)(j,pivot,&base)<1)++j;
      while(j<=k && (*cmpf)(pivot,k,&base)<1)--k;
      if(j<k)(*xchgf)(j++,k--,&base);
    }
    if((*cmpf)(pivot,k,&base)>0)(*xchgf)(pivot,k,&base);
    if(k>pivot)--k;
    if(k>pivot && n>j && (k-pivot < n-j)){
      iswap(&k,&n);
      iswap(&pivot,&j);
    }
    if(k>pivot){
      low[count]=pivot;
      high[count++]=k;
    }
    if(n>j){
      low[count]=j;
      high[count++]=n;
    }
    if(count>=DEPTH)abort("wqsort failure");
  }
}
-ARCHIVE- write.c 1425
/*	write characters to a file
*/

#include "fileio.h"


write(fd,buffer,count)
unsigned fd,count;
char *buffer;
{
  int retval;
  struct bufstr *buf;

  buf=_checkfd(fd);
  if(buf->buf_flag&BF_WRITE){		/* not open for writing */
    bdos(9,"WRITE$");
    _exit(0x800e);
  }

/*	do character output in line - its faster
*/
  if(buf->buf_flag&BF_CDEV){
    for(retval=0;retval<count;++retval){
      if(*buffer=='\n' && buf->buf_flag&BF_ASCII)bdos(buf->buf_fcb,'\r');
      bdos(buf->buf_fcb,*buffer++);
    }
    goto done;
  }

/*	disk files only
*/
  for(retval=0;retval<count;++retval){
    if(*buffer=='\n' && buf->buf_flag&BF_ASCII)_write('\r',buf);
    _write(*buffer++,buf);
  }
  if(buf->buf_next>buf->buf_fill)buf->buf_fill=buf->buf_next;
done:
  return (buf->buf_flag&BF_ERROR?-1:retval);
}

/*	service routine for write
*/

_write(cc,buf)
unsigned cc;
struct bufstr *buf;
{

  if(buf->buf_next>=buf->buf_size){
    buf->buf_fill=buf->buf_size;
    _oswrite(buf);				/* empty the buffer */
    buf->buf_off+=buf->buf_size;
    buf->buf_fill=buf->buf_next=0;		/* buffer is empty */
  }
  if(!buf->buf_fill && ~buf->buf_flag&BF_READ){
    buf->buf_next=0;
    _osread(buf);
    if(!buf->buf_fill)buf->buf_fill=1;		/* so we don't read again */
  }
  buf->buf_flag|=BF_DIRTY;			/* say dirty */
  buf->buf_data[buf->buf_next++]=cc;		/* put the character */
}
;++retval){
      if(*buffer=='\n'                                                                                                                                 