// Konfiguration für lesen.c

#ifndef CONFIG_H
#define CONFIG_H

// Optionale Eigenschaften können deaktiviert werden, indem man // davor setzt

#define VERZEICHNIS "/usr/local/share/lesen"

// Das Webverzeichnis wird vom CGI ignoriert
#define WEBVERZEICHNIS "web"

#define INDEX "Bücher"
#define INHALTSVERZEICHNIS "Inhaltsverzeichnis"
#define TEXTVERSION "Diese Seite als reiner Text"  // optional
#define TEXTDATEI "Ganzes Buch als Textdatei"
#define XHTMLDATEI "Ganzes Buch als XHTML-Datei"
//#define ALTERNATIVEXHTML "Ganzes Buch als XHTML-Datei"

#define FEHLEREINLEITUNG "Tut mir leid, aber "  // optional
#define FALSCHES_BUCH "ich habe dieses Buch nicht gefunden."
#define FALSCHES_KAPITEL "dieses Kapitel existiert nicht."
#define VERSCHWUNDEN "dieses Buch ist hier nicht mehr vefügbar."
#define GESPERRT "dieses Buch ist derzeit leider gesperrt."
#define ADRESSFEHLER "die Adresse ist fehlerhaft."
#define UNUNTERSTUETZT "diese Methode wird nicht unterstützt."
#define SERVERFEHLER "es liegt ein Fehler auf dem Server vor."
//#define FEHLERANHANG "//Tut mir echt leid!"  // optional

#define DIREKTAUFRUF "das Programm muss von einem Webserver via CGI/1.1 aufgerufen werden."

// Code-Generierung (mit Vorsicht zu ändern)
#define TYP "application/xhtml+xml"
#define ALTERNATIVTEXTANFANG "<i>"
#define ALTERNATIVTEXTENDE "</i>"
#define EXTERNER_LINK  "rel=\"external\" target=\"_top\""
#define ALTERNATIVER_LINK "rel=\"alternate\""
#undef CSS
#undef GESAMTCSS


// Sprachcode nach ISO-639-1
// nur angeben, wenn es eindeutig ist
#define SPRACHE "de"  // optional

// wie lange eine Seite im Zwischenspeicher als aktuell gilt
// Makros: SEKUNDEN(), MINUTEN(), STUNDEN(), TAGE(), WOCHEN(), MONATE()
#define BUCHHALTBARKEIT  MONATE(3)  // optional
#define INDEXHALTBARKEIT STUNDEN(12)  // optional

// Alternative zu denselben Büchern (URL mit / am Ende)
//#define ALTERNATIVE "Fraktur"  // optional
//#define ALTERNATIVEURL "/cgi-bin/fraktur/"  // optional

// andere Bücher
//#define ANDERE "English Books"  // optional
//#define ANDEREURL "/cgi-bin/english/index"  // optional

#define HOMEPAGE "Startseite"  // optional
#define HOMEPAGEURL "/"  // optional
//#define IMPRESSUM "Kontakt"  // optional
//#define IMPRESSUMURL "/kontakt.html"  // optional
#define CSSURL "/lesen.css"  // optional
#define SOFTWARE "Programm-Quelltext"  // optional
// optional
#define SOFTWAREURL "https://akfoerster.de/p/lesen/"

// Das lange s (ſ) herausfiltern? (UTF-8)
#define FILTER_S  // optional

// Resolver für urn:nbn: Bezeichner (national bibliography numbers)
#define NBN_RESOLVER "http://nbn-resolving.org/"  // optional

// zusätzliche Metadaten
// optional
#define METADATEN "<meta name=\"viewport\" " \
	"content=\"width=device-width\" />" NL \
	"<meta name=\"referrer\" content=\"same-origin\" />"

#define METADATEN_FEHLERSEITE  METADATEN  // optional

#endif
