// configuration for lesen.c

#ifndef CONFIG_H
#define CONFIG_H

// Optional features can be deactivated by putting // in front of them.

// subdirectory for textfiles
#define VERZEICHNIS "/usr/local/share/lesen"

// The Webdirectory will be ignored by the CGI
#define WEBVERZEICHNIS "web"

#define INDEX "Books"
#define INHALTSVERZEICHNIS "Table of contents"
#define TEXTVERSION "this page as plain text"  // optional
#define TEXTDATEI "the whole book as text file"
#define XHTMLDATEI "the whole book as XHTML file"
//#define ALTERNATIVEXHTML "the whole book as XHTML file"

#define FEHLEREINLEITUNG "Sorry, but "  // optional
#define FALSCHES_BUCH "I cannot find this book."
#define FALSCHES_KAPITEL "this chapter doesn't exist."
#define VERSCHWUNDEN "this book is no longer available here."
#define GESPERRT "this book is currently not accessible."
#define ADRESSFEHLER "this address is invalid."
#define UNUNTERSTUETZT "this method is not supported."
#define SERVERFEHLER "there is an error at the server."
//#define FEHLERANHANG "//I am really sorry!"  // optional

#define DIREKTAUFRUF "it must be called by a webserver via CGI/1.1."

// code generation (change with care)
#define TYP "application/xhtml+xml"
#define ALTERNATIVTEXTANFANG "<i>"
#define ALTERNATIVTEXTENDE "</i>"
#define EXTERNER_LINK  "rel=\"external\" target=\"_top\""
#define ALTERNATIVER_LINK "rel=\"alternate\""
#undef CSS
#undef GESAMTCSS


// language code according to ISO-639-1
// use it only if everything is in the same language
#define SPRACHE "en"  // optional

// define how long a page in a cache is considered fresh
// Macros: SEKUNDEN(), MINUTEN(), STUNDEN(), TAGE(), WOCHEN(), MONATE()
#define BUCHHALTBARKEIT  MONATE(3)  // optional
#define INDEXHALTBARKEIT STUNDEN(12)  // optional

// alternative for the same books (URL with / at the end)
//#define ALTERNATIVE "Fraktur"  // optional
//#define ALTERNATIVEURL "/cgi-bin/fraktur/"  // optional

// other books
//#define ANDERE "Deutsche Bücher"  // optional
//#define ANDEREURL "/cgi-bin/deutsch/"  // optional

#define HOMEPAGE "homepage"  // optional
#define HOMEPAGEURL "/"  // optional
#define IMPRESSUM "contact"  // optional
#define IMPRESSUMURL "/contact.html"  // optional
#define CSSURL "/lesen.css"  // optional
#define SOFTWARE "software source code"  // optional
// optional
#define SOFTWAREURL "https://akfoerster.de/p/lesen/"

// filter out the long s (ſ)? (UTF-8)
//#define FILTER_S  // optional

// resolver for urn:nbn: names (national bibliography numbers)
//#define NBN_RESOLVER "http://nbn-resolving.org/"  // optional

// additional metadata
// optional
#define METADATEN "<meta name=\"viewport\" " \
	"content=\"width=device-width\" />" NL \
	"<meta name=\"referrer\" content=\"same-origin\" />"

// optional
#define METADATEN_FEHLERSEITE  METADATEN

#endif
