/*
 * Copyright © 2015 Andreas K. Förster
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Methoden.h"
#include "string.h"

const char *const Methodenname[METHODENANZAHL] = {
  [unbekannte_Methode] = NULL,
  [GET] = "GET",
  [HEAD] = "HEAD",
  [OPTIONS] = "OPTIONS",
  [TRACE] = "TRACE",
  [POST] = "POST",
  [PUT] = "PUT",
  [PATCH] = "PATCH",
  [DELETE] = "DELETE",
  [CONNECT] = "CONNECT"
};

enum Anfragemethoden
Methodentyp (const char *m)
{
  int i;

  if (m)
    for (i = 1; i < METHODENANZAHL; ++i)
      if (!strcmp (Methodenname[i], m))
	return (enum Anfragemethoden) i;

  return unbekannte_Methode;
}
