/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015,2016,2018,2019 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"
#include <string.h>

extern void
akfnetz_xml_Textvariable (struct akfnetz_Text *t, const char *s)
{
  if (!t || !s)
    return;

  for (; *s; ++s)
    {
      switch (*s)
	{
	case '<':
	  akfnetz_hinzufuegen (t, "&#60;", 5);
	  break;

	case '>':
	  akfnetz_hinzufuegen (t, "&#62;", 5);
	  break;

	case '&':
	  akfnetz_hinzufuegen (t, "&#38;", 5);
	  break;

	case '\'':
	  akfnetz_hinzufuegen (t, "&#39;", 5);
	  break;

	case '"':
	  akfnetz_hinzufuegen (t, "&#34;", 5);
	  break;

	case '\t':
	case '\n':
	case '\v':
	case '\r':
	  akfnetz_hinzufuegen (t, s, 1);
	  break;

	case '\x7F':
	  break;

	default:
	  if ((unsigned char) *s >= ' ')
	    akfnetz_hinzufuegen (t, s, 1);
	  break;
	}
    }
}
