/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2016-2019,2024,2025 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <string.h>
#include "akfnetz.h"

extern void
akfnetz_xml_Text (FILE * d, const char *s)
{
  if (!s)
    return;

  flockfile (d);

  while (*s)
    {
      size_t l = strcspn (s, "\"'<>&");

      if (!l)
        akfnetz_xml_Zeichen (d, *s++);
      else
        {
          // Steuerzeichen werden hier nicht herausgefiltert
          fwrite (s, l, 1, d);
          s += l;
        }
    }

  funlockfile (d);
}


extern void
akfnetz_xml_Zeichen (FILE * d, char c)
{
  switch (c)
    {
    case '<':
      fputs ("&#60;", d);
      break;

    case '>':
      fputs ("&#62;", d);
      break;

    case '&':
      fputs ("&#38;", d);
      break;

    case '\'':
      fputs ("&#39;", d);
      break;

    case '"':
      fputs ("&#34;", d);
      break;

    case '\t':
    case '\n':
    case '\v':
    case '\r':
      putc (c, d);
      break;

    case '\x7F':
      break;

    default:
      if ((unsigned char) c >= ' ')
	putc (c, d);
      break;
    }
}
