/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2016,2018,2024,2025 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "akfnetz.h"
#include <errno.h>

// stellt Verbindung zu dem Server in der URL her
// der Pfad und Zugangsdaten werden ignoriert
extern int
akfnetz_URL_Verbindung (const char *URL, int af)
{
  char Host[256], Portpuffer[8], *Port;

  if (!URL || !akfnetz_URL_Hostname (Host, sizeof (Host), URL))
    {
      errno = EADDRNOTAVAIL;
      return -1;
    }

  Port = akfnetz_URL_Port (Portpuffer, sizeof (Portpuffer), URL);
  if (!Port)
    Port = akfnetz_Standardport (URL);

  return akfnetz_Serververbindung (Host, Port, af);
}
