/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2016 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"
#include <ctype.h>
#include <string.h>

static inline char
Hexziffer (unsigned char c)
{
  return (char) ((c < 10) ? '0' + c : ('A' - 10) + c);
}

void
akfnetz_urlkodiert_Text (struct akfnetz_Text *t, const char *s)
{
  if (!t || !s)
    return;

  while (*s)
    {
      if (isalnum (*s) || strchr ("-_.~()", *s))
	akfnetz_hinzufuegen (t, s, 1);
      else
	{
	  char z[3];
	  register unsigned char c;

	  c = (unsigned char) *s;

	  z[0] = '%';
	  z[1] = Hexziffer (c >> 4);
	  z[2] = Hexziffer (c & 0x0F);

	  akfnetz_hinzufuegen (t, z, 3);
	}

      ++s;
    }
}
