/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2024 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#define _POSIX_C_SOURCE 200112L
#define _XOPEN_SOURCE 500

#include "akfnetz.h"
#include <ctype.h>
#include <string.h>


static inline char
Hexziffer (unsigned char c)
{
  return ((c < 10) ? '0' + c : ('A' - 10) + c);
}


extern char *
akfnetz_urlkodiert_puf (const char *s, const char *erlaubt)
{
  if (!s)
    return NULL;

  // auf schlimmsten Fall vorbereiten
  char Puffer[(3 * strlen (s)) + 1];
  char *p = Puffer;

  while (*s)
    {
      if (isalnum (*s) || strchr ("-_.~", *s)
	  || (erlaubt && strchr (erlaubt, *s)))
	*p++ = *s;
      else			// Prozentkodierung
	{
	  *p++ = '%';
	  *p++ = Hexziffer ((*s >> 4) & 0x0F);
	  *p++ = Hexziffer (*s & 0x0F);
	}

      ++s;
    }

  *p = '\0';

  return strdup (Puffer);
}
