/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015,2017,2024 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#define _POSIX_C_SOURCE 200112L

#include "akfnetz.h"
#include <stdio.h>
#include <ctype.h>
#include <string.h>

extern void
akfnetz_urlkodiert (FILE * d, const char *s, const char *erlaubt)
{
  if (!s)
    return;

  flockfile (d);

  while (*s)
    {
      if (isalnum (*s) || strchr ("-_.~", *s)
	  || (erlaubt && strchr (erlaubt, *s)))
	putc_unlocked (*s, d);
      else
	fprintf (d, "%%%02X", (unsigned char) *s);

      ++s;
    }

  funlockfile (d);
}
