/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015-2017 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"

// gibt Wert von hexadezimaler Ziffer aus (ungeprueft, ASCII)
static inline unsigned char
Hexwert (char ch)
{
  register unsigned char c;

  c = (unsigned char) ch;
  return (c >= 'A') ? (c & 0xDF) - ('A' - 10) : c ^ 0x30;
}


char *
akfnetz_url_dekodieren (char *s)
{
  char *q, *z;
  // q: Quelle, z: Ziel

  for (q = z = s; *q; ++q, ++z)
    {
      if ('+' == *q)
	*z = ' ';
      else if ('%' == *q)
	{
	  *z = (char) ((Hexwert (q[1]) << 4) | Hexwert (q[2]));
	  q += 2;
	}
      else if (z != q)
	*z = *q;
    }

  *z = '\0';

  return s;
}
