#!/usr/bin/awk -f

# Convert textfile into C-code (new awk)
#
# Example-Usage:
# awk -f text2c.awk README > readme.h
# awk -f text2c.awk -v name=info_txt -v mode=crlf README > readme.h
#
# Copyright (c) 2009,2012,2025 Andreas K. Foerster
# Copying and distribution of this file, with or without modification,
# are permitted in any medium without royalty provided the copyright
# notice and this notice are preserved.  This file is offered as-is,
# without any warranty.

BEGIN {
  NL = (mode == "crlf") ? "\\r\\n" : "\\n"

  # get name from the argument
  if (name == "") name = ARGV[1]

  if (name == "") name = "text"

  # replace inacceptable characters with "_"
  gsub (/[^A-Za-z0-9_]/, "_", name)

  # name must not start with a digit
  if (name ~ /^[0-9]/) name = "_" name

  print "static const char " name "[] ="
}

{
  # mask backslashes - must be first
  gsub (/\\/, "\\\\")

  # mask quotation marks
  gsub (/"/, "\\\"")

  # mask
  gsub (/\a/, "\\a")
  gsub (/\b/, "\\b")
  gsub (/\t/, "\\t")
  gsub (/\v/, "\\v")
  gsub (/\f/, "\\f")

  # remove \r
  gsub (/\r/, "")

  # print with quotation marks and NL at the end
  print "\"" $0 NL "\""
}

END { print ";" }
