/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2016 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"

static int Textteil (void *, size_t, void *);


struct akfnetz_Text *
akfnetz_gestueckelt_Text (FILE *d, struct akfnetz_Text *t)
{
  if (akfnetz_Texterstellung (t, 4096))
    {
      if (akfnetz_gestueckelt (d, &Textteil, t) == 0)
	{
	  akfnetz_Textfreigabe (t);
	  return NULL;
	}
    }

  return t;
}


static int
Textteil (void *p, size_t l, void *d)
{
  akfnetz_hinzufuegen (d, p, l);
  return 0;
}
