/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2024-2025 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <strings.h>
#include "akfnetz.h"

#define Praefix(s,c) (strncasecmp (s, "" c "", sizeof(c)-1) == 0)

extern char *
akfnetz_Standardport (const char *u)
{
  char *e = NULL;

  // Naja, aber besser, als die ganze /etc/services abzuklappern
  // Sortiert nach Wahrscheinlichkeit in AKFNetz umgesetzt zu werden
  if (Praefix (u, "http:"))
    e = "80";
  else if (Praefix (u, "socks"))	// socks4:, socks4a:, socks5:
    e = "1080";
  else if (Praefix (u, "gopher:"))
    e = "70";
  else if (Praefix (u, "finger:"))
    e = "79";
  else				// nicht implementiert
  if (Praefix (u, "cso:"))
    e = "105";
  else if (Praefix (u, "ftp:"))
    e = "21";
  else if (Praefix (u, "telnet:") || Praefix (u, "tn3270:"))
    e = "23";
  else				// verschluesselt
  if (Praefix (u, "gemini:"))
    e = "1965";
  else if (Praefix (u, "ssh:"))
    e = "22";
  else if (Praefix (u, "https:"))
    e = "443";
  else if (Praefix (u, "ftps:"))
    e = "990";
  else if (Praefix (u, "telnets:"))
    e = "992";

  return e;
}
