/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2025 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include "akfnetz.h"


extern int
akfnetz_Socketport (int sock)
{
  struct sockaddr_storage a;
  socklen_t sl = sizeof (a);
  int Port = -1;

  if (!getsockname (sock, (struct sockaddr *) &a, &sl))
    {
      switch (a.ss_family)
	{
	case AF_INET:
	  Port = (int) ntohs (((struct sockaddr_in *) &a)->sin_port);
	  break;

	case AF_INET6:
	  Port = (int) ntohs (((struct sockaddr_in6 *) &a)->sin6_port);
	  break;

	default:
	  errno = EAFNOSUPPORT;
	  Port = -1;
	  break;
	}
    }

  return Port;
}
