/*
Endungen muessen in alphabetischer Reihefolge kleingeschrieben sein!
Es werden bis zu 8 Bytes der Endung beruecksichtigt,
sie duerfen aber laenger sein.

Allgemeine Typen: TEXT, BIN, VERBOTEN
*/

{"3g2",		"video/3gpp2"},
{"3gp",		"video/3gpp"},
{"7z",		"application/x-7z-compressed"},
{"a", 		BIN},
{"aac",		"audio/aac"},
{"abw",		"application/x-abiword"},
{"ada",		TEXT},  // Ada
{"adb",		TEXT},  // Ada Body
{"adc",		TEXT},  // Ada configuration
{"adoc",	"text/asciidoc"},
{"ads",		TEXT},  // Ada Spec
{"ai",		"application/postscript"},
{"aif",		"audio/x-aiff"},
{"aifc",	"audio/x-aiff"},
{"aiff",	"audio/x-aiff"},
{"apk",		"application/vnd.android.package-archive"},
{"apng",	"image/apng"},
{"asc",		TEXT},
{"ascii",	TEXT},
{"asciidoc",	"text/asciidoc"},
{"asf",		"application/vnd.ms-asf"},
{"asm",		TEXT},  // Assembler
{"asx",		"video/x-ms-asf"},
{"atom",	"application/atom+xml"},
{"au",		"audio/basic"},
{"avi",		"video/x-msvideo"},
{"avif",	"image/avif"},
{"avifs",	"image/avif-sequence"},
{"awk",		TEXT},
{"azw",		"application/vnd.amazon.ebook"},
{"bak",		VERBOTEN},
{"bas",		TEXT},  // BASIC
{"bat",		TEXT},
{"bin",		BIN},
{"bmp",		"image/bmp"},
{"bz",		"application/x-bzip"},
{"bz2",		"application/x-bzip"},
{"c",		TEXT},  // text/x-csrc; C-Quelltext
{"c++",		TEXT},  // text/x-c++src; C++-Quelltext
{"cab",		"application/x-cab"},
{"caf",		"audio/x-caf"},
{"cb7",		"application/x-cb7"},
{"cba",		"application/x-cba"},
{"cbl",		TEXT},  // Cobol-Quelltext
{"cbr",		"application/x-cbr"},
{"cbt",		"application/x-cbt"},
{"cbz",		"application/x-cbz"},
{"cc",		TEXT},  // text/x-c++src; C++-Quelltext
{"cda",		"application/x-ms-shortcut"},
{"cgi",		VERBOTEN},
{"class",	"application/java-vm"},
{"cmd",		TEXT},  // Windows Batch-Datei
{"cob",		TEXT},  // Cobol-Quelltext
{"com",		"application/x-msdos-program"},
{"conf",	TEXT},
{"config",	TEXT},
{"core",	VERBOTEN},
{"cp",		TEXT},  // text/x-c++src; C++-Quelltext
{"cpio",	"application/x-cpio"},
{"cpp",		TEXT},  // text/x-c++src; C++-Quelltext
{"crdownlo",	VERBOTEN},  // Chrome download
{"crt",		"application/x-x509-ca-cert"},
{"cs",		TEXT},  // C#-Quelltext
{"csh",		TEXT},  // text/x-csh
{"css",		"text/css"},
{"csv",		"text/csv; charset=" TEXTKODIERUNG},
{"cur",		"image/x-icon"},
{"cxx",		TEXT},  // text/x-c++src; C++-Quelltext
{"d",		TEXT},  // text/x-dsrc; D-Quelltext
{"dcm",		"application/dicom"},  // Digital Imaging and Communications in Medicine
{"dd",		TEXT},  // D Documentation Code
{"deb",		"application/vnd.debian.binary-package"},
{"der",		"application/x-x509-ca-cert"},
{"descript",	TEXT},  // .description
{"dfxp",	"application/ttml+xml"},
{"di",		TEXT},  // D Interface File
{"dib",		"image/bmp"},
{"dicom",	"application/dicom"},  // Digital Imaging and Communications in Medicine
{"diff",	"text/x-diff"},
{"diz",		TEXT},  // FILE_ID.DIZ
{"djv",		"image/vnd.djvu"},
{"djvu",	"image/vnd.djvu"},
{"dl",		BIN},
{"dll",		"application/x-msdos-program"},
{"dmg",		"application/x-apple-diskimage"},
{"doc",		"application/msword"},
{"docx",	"application/vnd.openxmlformats-officedocument.wordprocessingml.document"},
{"dot",		"application/msword"},
{"dotx",	"application/vnd.openxmlformats-officedocument.wordprocessingml.template"},
{"dvi",		"application/x-dvi"},
{"ear",		"application/java-archive"},
{"efi",		BIN},
{"emf",		"image/emf"},
{"emz",		"image/emf"},
{"eot",		"application/vnd.ms-fontobject"},
{"eps",		"application/postscript"},
{"epub",	"application/epub+zip"},
{"es",		"application/ecmascript"},
{"exe",		"application/x-msdos-program"},
{"exr",		"image/x-exr"},
{"f",		TEXT},  // Fortran
{"f03",		TEXT},  // Fortran
{"f08",		TEXT},  // Fortran
{"f90",		TEXT},  // Fortran
{"f95",		TEXT},  // Fortran
{"fla",		"audio/flac"},
{"flac",	"audio/flac"},
{"flv",		"video/x-flv"},
{"fodb",	"application/vnd.oasis.opendocument.database"},
{"fodc",	"application/vnd.oasis.opendocument.chart"},
{"fodf",	"application/vnd.oasis.opendocument.formula"},
{"fodg",	"application/vnd.oasis.opendocument.graphics"},
{"fodi",	"application/vnd.oasis.opendocument.image"},
{"fodm",	"application/vnd.oasis.opendocument.text-master"},
{"fodp",	"application/vnd.oasis.opendocument.presentation"},
{"fods",	"application/vnd.oasis.opendocument.spreadsheet"},
{"fodt",	"application/vnd.oasis.opendocument.text"},
{"for",		TEXT},  // Fortran
{"fpp",		TEXT},  // Fortran
{"ftn",		TEXT},  // Fortran
{"gemini",	"text/gemini"},	// Gemini gemtext
{"gif",		"image/gif"},
{"gmi",		"text/gemini"},	// Gemini gemtext
{"gmni",	"text/gemini"},	// Gemini gemtext
{"go",		TEXT},
{"gpg",		"application/pgp-encrypted"},
{"gpr",		TEXT},  // GNAT project
{"gz",		"application/gzip"},
{"h",		TEXT},  // text/x-chdr; C-Header
{"h++",		TEXT},  // text/x-c++hdr; C++-Header
{"heic",	"image/heic"},
{"heics",	"image/heic-sequence"},
{"heif",	"image/heif"},
{"heifs",	"image/heif-sequence"},
{"hh",		TEXT},  // text/x-c++hdr; C++-Header
{"hp",		TEXT},  // text/x-c++hdr; C++-Header
{"hpp",		TEXT},  // text/x-c++hdr; C++-Header
{"hqx",		"application/binhex"},  // BinHex (Macintosh)
{"htm",		"text/html; charset=UTF-8"},
{"html",	"text/html; charset=UTF-8"},
{"hxx",		TEXT},  // text/x-c++hdr; C++-Header
{"ical",	"text/calendar"},
{"icalenda",	"text/calendar"}, // .icalendar
{"ico",		"image/x-icon"},
{"ics",		"text/calendar"},
{"ifb",		"text/calendar"},
{"ifbf",	"text/calendar"},
{"image",	BIN},
{"img",		BIN},
{"in",		TEXT},
{"inf",		TEXT},
{"info",	TEXT},
{"ini",		TEXT},
{"iso",		"application/x-iso9660-image"},
{"j2k",		"image/jp2"},
{"jar",		"application/java-archive"},
{"java",	TEXT},  // text/x-java; Java-Quelltext
{"jfif",	"image/jpeg"},
{"jp2",		"image/jp2"},
{"jpe",		"image/jpeg"},
{"jpeg",	"image/jpeg"},
{"jpf",		"image/jpx"},
{"jpg",		"image/jpeg"},
{"jpg2",	"image/jp2"},
{"jpx",		"image/jpx"},
{"js",		"application/javascript"},
{"jsm",		"application/javascript"},
{"json",	"application/json"},
{"jsonld",	"application/ld+json"},
{"jsonp",	"application/json-p"},
{"jxl",		"image/jxl"},
{"k8",		"text/plain; charset=KOI8-R"},
{"kar",		"audio/midi"},
{"key",		"application/pgp-keys"},
{"koi8",	"text/plain; charset=KOI8-R"},
{"l1",		"text/plain; charset=ISO-8859-1"},
{"lha",		"application/x-lzh-compressed"},
{"lib",		BIN},
{"lnk",		"application/x-ms-shortcut"},
{"log",		TEXT},
{"lsm",		TEXT},
{"lua",		TEXT},
{"lwf",		"image/x-wavelet"},
{"lzh",		"application/x-lzh-compressed"},
{"lzs",		"application/x-lzh-compressed"},
{"m",		TEXT},  // ObjC
{"m3u",		"audio/mpegurl"},
{"m4",		TEXT},
{"m4a",		"audio/mp4"},
{"m4b",		"audio/mp4"},
{"m4r",		"audio/mp4"},
{"m4v",		"video/mp4"},
{"man",		TEXT},
{"markdown",	"text/markdown; charset=" TEXTKODIERUNG},  // Markdown, RFC 7763
{"mbox",	"application/mbox"},
{"md",		"text/markdown; charset=" TEXTKODIERUNG},  // Markdown, RFC 7763
{"md5",		TEXT},
{"meta4",	"application/metalink4+xml"},
{"metalink",	"application/metalink+xml"},
{"mid",		"audio/midi"},
{"midi",	"audio/midi"},
{"mjs",		"application/javascript"},
{"mka",		"audio/x-matroska"},
{"mkv",		"video/x-matroska"},
{"mm",		TEXT}, // Obj-C++
{"mml",		"text/mathml"},
{"mng",		"video/x-mng"},
{"mov",		"video/quicktime"},
{"mp1",		"audio/mpeg"},
{"mp2",		"audio/mpeg"},
{"mp3",		"audio/mpeg"},
{"mp4",		"video/mp4"},
{"mpe",		"video/mpeg"},
{"mpeg",	"video/mpeg"},
{"mpega",	"audio/mpeg"},
{"mpg",		"video/mpeg"},
{"mpga",	"audio/mpeg"},
{"mpkg",	"application/vnd.apple.installer+xml"},
{"mpv",		"video/x-matroska"},
{"msi",		"application/x-ole-storage"},
{"msp",		"application/x-ole-storage"},
{"ncx",		"application/x-dtbncx+xml"},
{"nfo",		"text/plain; charset=IBM437"},
{"o",		BIN},
{"obj",		BIN},
{"odb",		"application/vnd.oasis.opendocument.database"},
{"odc",		"application/vnd.oasis.opendocument.chart"},
{"odf",		"application/vnd.oasis.opendocument.formula"},
{"odg",		"application/vnd.oasis.opendocument.graphics"},
{"odi",		"application/vnd.oasis.opendocument.image"},
{"odm",		"application/vnd.oasis.opendocument.text-master"},
{"odp",		"application/vnd.oasis.opendocument.presentation"},
{"ods",		"application/vnd.oasis.opendocument.spreadsheet"},
{"odt",		"application/vnd.oasis.opendocument.text"},
{"oga",		"audio/ogg"},
{"ogg",		"audio/ogg"},
{"ogv",		"video/ogg"},
{"ogx",		"application/ogg"},
{"old",		VERBOTEN},
{"opf",		"application/oebps-package+xml"},
{"opus",	"audio/ogg; codecs=opus"},
{"otf",		"font/otf"},
{"otg",		"application/vnd.oasis.opendocument.graphics-template"},
{"oth",		"application/vnd.oasis.opendocument.text-web"},
{"otp",		"application/vnd.oasis.opendocument.presentation-template"},
{"ots",		"application/vnd.oasis.opendocument.spreadsheet-template"},
{"ott",		"application/vnd.oasis.opendocument.text-template"},
{"p",		TEXT},  // text/x-pascal; Pascal-Quelltext
{"pac",		"application/x-ns-proxy-autoconfig"},
{"part",	VERBOTEN},
{"pas",		TEXT},  // text/x-pascal; Pascal-Quelltext
{"patch",	"text/x-diff"},
{"pdf",		"application/pdf"},
{"pem",		"application/x-x509-ca-cert"},
{"pgp",		"application/pgp-encrypted"},
{"php",		VERBOTEN},
{"php3",	VERBOTEN},
{"php4",	VERBOTEN},
{"php5",	VERBOTEN},
{"php7",	VERBOTEN},
{"phps",	VERBOTEN},
{"phtml",	VERBOTEN},
{"pjp",		"image/jpeg"},
{"pjpeg",	"image/jpeg"},
{"pl",		TEXT},  // text/x-perl; Perl
{"pls",		"audio/x-scpls"},
{"pm",		TEXT},  // text/x-perl; Perl-Modul
{"png",		"image/png"},
{"po",		TEXT},
{"potx",	"application/vnd.openxmlformats-officedocument.presentationml.template"},
{"pp",		TEXT},  // text/x-pascal; Pascal-Quelltext
{"pps",		"application/vnd.ms-powerpoint"},
{"ppsx",	"application/vnd.openxmlformats-officedocument.presentationml.slideshow"},
{"ppt",		"application/vnd.ms-powerpoint"},
{"pptx",	"application/vnd.openxmlformats-officedocument.presentationml.presentation"},
{"ps",		"application/postscript"},
{"ps1",		TEXT},  // PowerShell
{"ps1xml",	TEXT},  // PowerShell
{"psc1",	TEXT},  // PowerShell
{"psd1",	TEXT},  // PowerShell
{"psm1",	TEXT},  // PowerShell
{"py",		TEXT},  // text/x-python; Python
{"qoi",		"image/qoi"},
{"qt",		"video/quicktime"},
{"ra",		"audio/x-pn-realaudio"},
{"ram",		"audio/x-pn-realaudio"},
{"rar",		"application/rar"},
{"rc",		TEXT},
{"rdf",		"application/rdf+xml"},
{"rm",		"audio/x-pn-realaudio"},
{"rpm",		"application/x-redhat-package-manager"},
{"rs",		TEXT},	// Rust-Source
{"rss",		"application/rss+xml"},
{"rst",		"text/x-rst"},	// reStructuredText
{"rtf",		"application/rtf"},
{"s",		TEXT},  // Assembler
{"save",	VERBOTEN},
{"scr",		"application/x-msdos-program"},
{"sh",		TEXT},  // text/x-sh; Shell
{"sha1",	TEXT},
{"shtml",	"text/html; charset=UTF-8"},
{"sig",		"application/pgp-signature"},
{"sldx",	"application/vnd.openxmlformats-officedocument.presentationml.slide"},
{"smi",		"application/smil+xml"},
{"smil",	"application/smil+xml"},
{"snd",		"audio/basic"},
{"spx",		"audio/ogg"},
{"srt",		"application/x-subrip"},
{"sum",		TEXT},  // Pruefsummen
{"svg",		"image/svg+xml"},
{"svgz",	"image/svg+xml"},
{"swf",		"application/x-shockwave-flash"},
{"swfl",	"application/x-shockwave-flash"},
{"sx",		TEXT},  // Assembler
{"sys",		BIN},
{"tar",		"application/x-tar"},
{"tcl",		TEXT},  // text/x-tcl
{"temp",	VERBOTEN},
{"text",	TEXT},
{"textile",	TEXT},	// Textile Auszeichnungssprache
{"tif",		"image/tiff"},
{"tiff",	"image/tiff"},
{"tk",		TEXT},  // text/x-tcl
{"tmp",		VERBOTEN},
{"tor",		"application/x-bittorrent"},
{"torrent",	"application/x-bittorrent"},
{"ts",		"video/mp2t"},
{"tsv",		"text/tab-separated-values; charset=" TEXTKODIERUNG},
{"ttc",		"font/collection"},
{"ttf",		"font/ttf"},
{"ttml",	"application/ttml+xml"},
{"txt",		TEXT},
{"u8",		"text/plain; charset=UTF-8"},
{"udeb",	"application/vnd.debian.binary-package"},
{"url",		"application/x-ms-shortcut"},
{"utf8",	"text/plain; charset=UTF-8"},
{"var",		VERBOTEN}, // reserviert fuer Type Maps
{"vcard",	"text/vcard"},
{"vcf",		"text/vcard"},
{"vtt",		"text/vtt"},
{"war",		"application/java-archive"},
{"wasm",	"application/wasm"},  // WebAssembly
{"wat",		TEXT},  // WebAssembly text format
{"wav",		"audio/wav"},
{"wave",	"audio/wav"},
{"wbmp",	"image/vnd.wap.wbmp"},
{"weba",	"audio/webm"},
{"webm",	"video/webm"},
{"webp",	"image/webp"},
{"wma",		"audio/x-ms-wma"},
{"wmf",		"image/wmf"},
{"wml",		"text/vnd.wap.wml"},
{"wmv",		"video/x-ms-wmv"},
{"wmz",		"image/wmf"},
{"woff",	"font/woff"},
{"woff2",	"font/woff2"},
{"xbm",		"image/x-xbitmap"},
{"xht",		"application/xhtml+xml; charset=UTF-8"},
{"xhtml",	"application/xhtml+xml; charset=UTF-8"},
{"xlb",		"application/vnd.ms-excel"},
{"xls",		"application/vnd.ms-excel"},
{"xlsx",	"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"xlt",		"application/vnd.ms-excel"},
{"xltx",	"application/vnd.openxmlformats-officedocument.spreadsheetml.template"},
{"xml",		"application/xml"},
{"xpi",		"application/x-xpinstall"},
{"xpm",		"image/x-xpixmap"},
{"xsl",		"application/xslt+xml"},
{"xslt",	"application/xslt+xml"},
{"xspf",	"application/xspf+xml"},
{"xz",		"application/x-xz"},
{"z",		"application/x-compress"},
{"zip",		"application/zip"},
{"zst",		"application/zstd"},
{"zstd",	"application/zstd"}

/*
Diese Liste ist keineswegs vollstaendig, und kann gerne
noch erweitert oder auch gekuerzt werden.

Die mehrfach auftretenden Typen werden von den meisten
Compilern nur einmal gespeichert. Man sollte nur darauf
achten, die wirklich immer gleich zu schreiben.
*/
