/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2018-2020 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <arpa/inet.h>
#include <errno.h>
#include <string.h>
#include "akfnetz.h"

extern int
akfnetz_Lokalbindung (int Lauscher, const char *Name)
{
  int r;
  mode_t m;
  size_t l;
  struct sockaddr_un a = {.sun_family = AF_UNIX };

  if (!Name || !*Name)
    {
      errno = EDESTADDRREQ;
      return -1;
    }

  l = strlen (Name);
  if (l >= sizeof (a.sun_path))
    {
      errno = ENAMETOOLONG;
      return -1;
    }

  memcpy (a.sun_path, Name, l + 1);

  m = umask (0111);		// fuer alle erlauben
  r = bind (Lauscher, (struct sockaddr *) &a, sizeof (a));
  umask (m);			// umask wiederherstellen
  // umask setzt nicht errno

  return r;
}
