/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2024 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <unistd.h>
#include <errno.h>
#include "akfnetz.h"


static ssize_t
lies (int d, void *p, size_t l)
{
  ssize_t r;

  do
    r = read (d, p, l);
  while (r < 0 && errno == EINTR);

  return r;
}


// schreibt Daten voll gepuffert
extern int
akfnetz_kopiere (int Eingabe, int Ausgabe)
{
  ssize_t r;
  size_t Platz;
  char *p, Puffer[8192];

  p = Puffer;
  Platz = sizeof (Puffer);

  while ((r = lies (Eingabe, p, Platz)) > 0)
    {
      Platz -= r;
      p += r;

      // Puffer voll => Puffer schreiben & wiederverwenden
      if (!Platz)
	{
	  if (akfnetz_Ausgabe (Ausgabe, Puffer, sizeof (Puffer)) < 0)
	    return -1;

	  p = Puffer;
	  Platz = sizeof (Puffer);
	}
    }

  if (r < 0)
    return -1;

  // schreibe Rest
  if (Platz < sizeof (Puffer))
    if (akfnetz_Ausgabe (Ausgabe, Puffer, sizeof (Puffer) - Platz) < 0)
      return -1;

  return 0;
}
