/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2018 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <errno.h>
#include <string.h>
#include "akfnetz.h"

extern int
akfnetz_IPv6_Bindung (int Lauscher, const char *Adr, int Port)
{
  struct sockaddr_in6 a = {
    .sin6_family = AF_INET6,
    .sin6_port = htons ((unsigned short) Port),
    .sin6_addr = IN6ADDR_ANY_INIT
  };

  if (Adr && *Adr && inet_pton (AF_INET6, Adr, &a.sin6_addr.s6_addr) < 1)
    {
      errno = EFAULT;
      return -1;
    }

  if (bind (Lauscher, (struct sockaddr *) &a, sizeof (a)) < 0)
    return -1;

  return 0;
}
