/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * akfnetz-Client
 * Copyright (c) 2015-2025 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

// ACHTUNG: Diese Schnittstelle ist noch eine unfertige Baustelle!

#ifndef AKFNETZCLIENT_H
#define AKFNETZCLIENT_H

#include <stdbool.h>

#ifndef Fehlermeldung
#define Fehlermeldung  strerror
#endif

enum akfnetz_Proxyart
{ Proxy_kein, Proxy_http, Proxy_socks4, Proxy_socks4a, Proxy_socks5 };


struct akfnetz_Clientdaten
{
  char *Adresse, *HTTP_Proxy, *Ausgabename, *Agent, *Mail, *Referrer;
  char *Zugang, **Kopf;
  char *Socketpfad;
  intmax_t Laenge;
  enum akfnetz_Anfragemethoden Methode;
  enum akfnetz_Proxyart Proxyart;
  int Adressfamilie;
  bool still, nicht_interaktiv, nicht_umleiten, aktualisiere;
  bool ungefiltert, Links, gzip;
};

extern bool deutsch;

void akfnetz_Clientinitialisierung (struct akfnetz_Clientdaten *);
int akfnetz_Netzaufruf (struct akfnetz_Clientdaten *, char **, int);
int akfnetz_neue_Adresse (struct akfnetz_Clientdaten *, const char *);

#endif
